/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifiable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWModifier;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueStatePropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;

final class ModifierComponentGroup {
    private ApplicationContext context;
    Verifier verifier;
    private PropertyValueModel modifierHolder;
    private ValueModel allowedModifiersHolder;
    private PropertyValueModel accessLevelHolder;
    private JPanel accessModifierPanel;
    JRadioButton publicAccessRadioButton;
    JRadioButton protectedAccessRadioButton;
    JRadioButton defaultAccessRadioButton;
    JRadioButton privateAccessRadioButton;
    private JPanel otherModifiersPanel;
    JCheckBox abstractCheckBox;
    JCheckBox finalCheckBox;
    JCheckBox nativeCheckBox;
    JCheckBox staticCheckBox;
    JCheckBox synchronizedCheckBox;
    JCheckBox transientCheckBox;
    JCheckBox volatileCheckBox;

    ModifierComponentGroup(Verifier verifier, ValueModel valueModel, ApplicationContext applicationContext) {
        this.context = applicationContext;
        this.verifier = verifier;
        this.modifierHolder = this.buildModifierAdapter(valueModel);
        this.allowedModifiersHolder = this.buildAllowedModifiersAdapter();
        this.accessLevelHolder = this.buildAccessLevelAdapter();
    }

    protected PropertyValueModel buildModifierAdapter(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel){

            protected Object getValueFromSubject() {
                return ((MWModifiable)this.subject).getModifier();
            }

            public String toString() {
                return "ModifierComponentGroup.buildModifierAdapter(ValueModel)";
            }
        };
    }

    private PropertyValueModel buildAllowedModifiersAdapter() {
        return new ValueStatePropertyValueModelAdapter(this.modifierHolder);
    }

    private PropertyValueModel buildAccessLevelAdapter() {
        return new PropertyAspectAdapter(this.modifierHolder, "accessLevel"){

            protected Object getValueFromSubject() {
                return ((MWModifier)this.subject).getAccessLevel();
            }

            protected void setValueOnSubject(Object object) {
                ((MWModifier)this.subject).setAccessLevel((String)object);
            }

            public String toString() {
                return "ModifierComponentGroup.buildAccessLevelAdapter()";
            }
        };
    }

    JPanel getAccessModifiersPanel() {
        if (this.accessModifierPanel == null) {
            this.accessModifierPanel = this.buildAccessModifiersPanel();
        }
        return this.accessModifierPanel;
    }

    private JPanel buildAccessModifiersPanel() {
        TitledPanel titledPanel = new TitledPanel(this.resourceRepository().getString("accessModifiers"));
        titledPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("accessModifiers")), BorderFactory.createEmptyBorder(0, 0, 5, 5)));
        return titledPanel;
    }

    private ButtonModel buildAccessLevelRadioButtonModelAdapter(String string) {
        return new RadioButtonModelAdapter(this.accessLevelHolder, string);
    }

    JRadioButton getPublicAccessRadioButton() {
        if (this.publicAccessRadioButton == null) {
            this.publicAccessRadioButton = this.buildPublicAccessRadioButton();
            this.allowedModifiersHolder.addPropertyChangeListener("value", this.buildModifierPublicListener());
        }
        return this.publicAccessRadioButton;
    }

    private JRadioButton buildPublicAccessRadioButton() {
        JRadioButton jRadioButton = SwingComponentFactory.buildRadioButton("PUBLIC_ACCESS_MODIFIER", this.buildAccessLevelRadioButtonModelAdapter("public"), this.resourceRepository());
        jRadioButton.setEnabled(this.publicShouldBeEnabled());
        return jRadioButton;
    }

    private PropertyChangeListener buildModifierPublicListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModifierComponentGroup.this.publicAccessRadioButton.setEnabled(ModifierComponentGroup.this.publicShouldBeEnabled());
            }

            public String toString() {
                return "ModifierComponentGroup.buildModifierPublicListener()";
            }
        };
    }

    boolean publicShouldBeEnabled() {
        return this.modifier() != null && this.modifier().canBeSetPublic();
    }

    JRadioButton getProtectedAccessRadioButton() {
        if (this.protectedAccessRadioButton == null) {
            this.protectedAccessRadioButton = this.buildProtectedAccessRadioButton();
            this.allowedModifiersHolder.addPropertyChangeListener("value", this.buildModifierProtectedListener());
        }
        return this.protectedAccessRadioButton;
    }

    private JRadioButton buildProtectedAccessRadioButton() {
        JRadioButton jRadioButton = SwingComponentFactory.buildRadioButton("PROTECTED_ACCESS_MODIFIER", this.buildAccessLevelRadioButtonModelAdapter("protected"), this.resourceRepository());
        jRadioButton.setEnabled(this.protectedShouldBeEnabled());
        return jRadioButton;
    }

    private PropertyChangeListener buildModifierProtectedListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModifierComponentGroup.this.protectedAccessRadioButton.setEnabled(ModifierComponentGroup.this.protectedShouldBeEnabled());
            }

            public String toString() {
                return "ModifierComponentGroup.buildModifierProtectedListener()";
            }
        };
    }

    boolean protectedShouldBeEnabled() {
        return this.modifier() != null && this.modifier().canBeSetProtected();
    }

    JRadioButton getDefaultAccessRadioButton() {
        if (this.defaultAccessRadioButton == null) {
            this.defaultAccessRadioButton = this.buildDefaultAccessRadioButton();
            this.allowedModifiersHolder.addPropertyChangeListener("value", this.buildModifierDefaultListener());
        }
        return this.defaultAccessRadioButton;
    }

    private JRadioButton buildDefaultAccessRadioButton() {
        JRadioButton jRadioButton = SwingComponentFactory.buildRadioButton("DEFAULT_ACCESS_MODIFIER", this.buildAccessLevelRadioButtonModelAdapter("package"), this.resourceRepository());
        jRadioButton.setEnabled(this.defaultShouldBeEnabled());
        return jRadioButton;
    }

    private PropertyChangeListener buildModifierDefaultListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModifierComponentGroup.this.defaultAccessRadioButton.setEnabled(ModifierComponentGroup.this.defaultShouldBeEnabled());
            }

            public String toString() {
                return "ModifierComponentGroup.buildModifierDefaultListener()";
            }
        };
    }

    boolean defaultShouldBeEnabled() {
        return this.modifier() != null && this.modifier().canBeSetPackage();
    }

    JRadioButton getPrivateAccessRadioButton() {
        if (this.privateAccessRadioButton == null) {
            this.privateAccessRadioButton = this.buildPrivateAccessRadioButton();
            this.allowedModifiersHolder.addPropertyChangeListener("value", this.buildModifierPrivateListener());
        }
        return this.privateAccessRadioButton;
    }

    private JRadioButton buildPrivateAccessRadioButton() {
        JRadioButton jRadioButton = SwingComponentFactory.buildRadioButton("PRIVATE_ACCESS_MODIFIER", this.buildAccessLevelRadioButtonModelAdapter("private"), this.resourceRepository());
        jRadioButton.setEnabled(this.privateShouldBeEnabled());
        return jRadioButton;
    }

    private PropertyChangeListener buildModifierPrivateListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModifierComponentGroup.this.privateAccessRadioButton.setEnabled(ModifierComponentGroup.this.privateShouldBeEnabled());
            }

            public String toString() {
                return "ModifierComponentGroup.buildModifierPrivateListener()";
            }
        };
    }

    boolean privateShouldBeEnabled() {
        return this.modifier() != null && this.modifier().canBeSetPrivate();
    }

    JPanel getOtherModifiersPanel() {
        if (this.otherModifiersPanel == null) {
            this.otherModifiersPanel = this.buildOtherModifiersPanel();
        }
        return this.otherModifiersPanel;
    }

    private JPanel buildOtherModifiersPanel() {
        TitledPanel titledPanel = new TitledPanel(this.resourceRepository().getString("otherModifiers"));
        titledPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(this.resourceRepository().getString("otherModifiers")), BorderFactory.createEmptyBorder(0, 0, 5, 5)));
        return titledPanel;
    }

    JCheckBox getAbstractCheckBox() {
        if (this.abstractCheckBox == null) {
            this.abstractCheckBox = this.buildAbstractCheckBox();
            this.allowedModifiersHolder.addPropertyChangeListener("value", this.buildModifierAbstractListener());
        }
        return this.abstractCheckBox;
    }

    private JCheckBox buildAbstractCheckBox() {
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("ABSTRACT_MODIFIER", new CheckBoxModelAdapter(this.buildAbstractAdapter()), this.resourceRepository());
        jCheckBox.setEnabled(this.abstractShouldBeEnabled());
        return jCheckBox;
    }

    private PropertyValueModel buildAbstractAdapter() {
        return new PropertyAspectAdapter(this.modifierHolder, "code"){

            protected Object getValueFromSubject() {
                return ((MWModifier)this.subject).isAbstract();
            }

            protected void setValueOnSubject(Object object) {
                ((MWModifier)this.subject).setAbstract(((Boolean)object).booleanValue());
            }

            public String toString() {
                return "ModifierComponentGroup.buildAbstractAdapter()";
            }
        };
    }

    private PropertyChangeListener buildModifierAbstractListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModifierComponentGroup.this.abstractCheckBox.setEnabled(ModifierComponentGroup.this.abstractShouldBeEnabled());
            }

            public String toString() {
                return "ModifierComponentGroup.buildModifierAbstractListener()";
            }
        };
    }

    boolean abstractShouldBeEnabled() {
        return this.modifier() != null && this.modifier().canBeSetAbstract();
    }

    JCheckBox getFinalCheckBox() {
        if (this.finalCheckBox == null) {
            this.finalCheckBox = this.buildFinalCheckBox();
            this.allowedModifiersHolder.addPropertyChangeListener("value", this.buildModifierFinalListener());
        }
        return this.finalCheckBox;
    }

    private JCheckBox buildFinalCheckBox() {
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("FINAL_MODIFIER", new CheckBoxModelAdapter(this.buildFinalAdapter()), this.resourceRepository());
        jCheckBox.setEnabled(this.finalShouldBeEnabled());
        return jCheckBox;
    }

    private PropertyValueModel buildFinalAdapter() {
        return new PropertyAspectAdapter(this.modifierHolder, "code"){

            protected Object getValueFromSubject() {
                return ((MWModifier)this.subject).isFinal();
            }

            protected void setValueOnSubject(Object object) {
                boolean bl = (Boolean)object;
                if (ModifierComponentGroup.this.verifier.verifyFinalChange(bl)) {
                    ((MWModifier)this.subject).setFinal(bl);
                } else {
                    ModifierComponentGroup.this.getFinalCheckBox().setSelected(!bl);
                }
            }

            public String toString() {
                return "ModifierComponentGroup.buildFinalAdapter()";
            }
        };
    }

    private PropertyChangeListener buildModifierFinalListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModifierComponentGroup.this.finalCheckBox.setEnabled(ModifierComponentGroup.this.finalShouldBeEnabled());
            }

            public String toString() {
                return "ModifierComponentGroup.buildModifierFinalListener()";
            }
        };
    }

    boolean finalShouldBeEnabled() {
        return this.modifier() != null && this.modifier().canBeSetFinal();
    }

    JCheckBox getNativeCheckBox() {
        if (this.nativeCheckBox == null) {
            this.nativeCheckBox = this.buildNativeCheckBox();
            this.allowedModifiersHolder.addPropertyChangeListener("value", this.buildModifierNativeListener());
        }
        return this.nativeCheckBox;
    }

    private JCheckBox buildNativeCheckBox() {
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("NATIVE_MODIFIER", new CheckBoxModelAdapter(this.buildNativeAdapter()), this.resourceRepository());
        jCheckBox.setEnabled(this.nativeShouldBeEnabled());
        return jCheckBox;
    }

    private PropertyValueModel buildNativeAdapter() {
        return new PropertyAspectAdapter(this.modifierHolder, "code"){

            protected Object getValueFromSubject() {
                return ((MWModifier)this.subject).isNative();
            }

            protected void setValueOnSubject(Object object) {
                ((MWModifier)this.subject).setNative(((Boolean)object).booleanValue());
            }

            public String toString() {
                return "ModifierComponentGroup.buildNativeAdapter()";
            }
        };
    }

    private PropertyChangeListener buildModifierNativeListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModifierComponentGroup.this.nativeCheckBox.setEnabled(ModifierComponentGroup.this.nativeShouldBeEnabled());
            }

            public String toString() {
                return "ModifierComponentGroup.buildModifierNativeListener()";
            }
        };
    }

    boolean nativeShouldBeEnabled() {
        return this.modifier() != null && this.modifier().canBeSetNative();
    }

    JCheckBox getStaticCheckBox() {
        if (this.staticCheckBox == null) {
            this.staticCheckBox = this.buildStaticCheckBox();
            this.allowedModifiersHolder.addPropertyChangeListener("value", this.buildModifierStaticListener());
        }
        return this.staticCheckBox;
    }

    private JCheckBox buildStaticCheckBox() {
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("STATIC_MODIFIER", new CheckBoxModelAdapter(this.buildStaticAdapter()), this.resourceRepository());
        jCheckBox.setEnabled(this.staticShouldBeEnabled());
        return jCheckBox;
    }

    private PropertyValueModel buildStaticAdapter() {
        return new PropertyAspectAdapter(this.modifierHolder, "code"){

            protected Object getValueFromSubject() {
                return ((MWModifier)this.subject).isStatic();
            }

            protected void setValueOnSubject(Object object) {
                boolean bl = (Boolean)object;
                if (ModifierComponentGroup.this.verifier.verifyStaticChange(bl)) {
                    ((MWModifier)this.subject).setStatic(bl);
                } else {
                    ModifierComponentGroup.this.getStaticCheckBox().setSelected(!bl);
                }
            }

            public String toString() {
                return "ModifierComponentGroup.buildStaticAdapter()";
            }
        };
    }

    private PropertyChangeListener buildModifierStaticListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModifierComponentGroup.this.staticCheckBox.setEnabled(ModifierComponentGroup.this.staticShouldBeEnabled());
            }

            public String toString() {
                return "ModifierComponentGroup.buildModifierStaticListener()";
            }
        };
    }

    boolean staticShouldBeEnabled() {
        return this.modifier() != null && this.modifier().canBeSetStatic();
    }

    JCheckBox getSynchronizedCheckBox() {
        if (this.synchronizedCheckBox == null) {
            this.synchronizedCheckBox = this.buildSynchronizedCheckBox();
            this.allowedModifiersHolder.addPropertyChangeListener("value", this.buildModifierSynchronizedListener());
        }
        return this.synchronizedCheckBox;
    }

    private JCheckBox buildSynchronizedCheckBox() {
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("SYNCHRONIZED_MODIFIER", new CheckBoxModelAdapter(this.buildSynchronizedAdapter()), this.resourceRepository());
        jCheckBox.setEnabled(this.synchronizedShouldBeEnabled());
        return jCheckBox;
    }

    private PropertyValueModel buildSynchronizedAdapter() {
        return new PropertyAspectAdapter(this.modifierHolder, "code"){

            protected Object getValueFromSubject() {
                return ((MWModifier)this.subject).isSynchronized();
            }

            protected void setValueOnSubject(Object object) {
                ((MWModifier)this.subject).setSynchronized(((Boolean)object).booleanValue());
            }

            public String toString() {
                return "ModifierComponentGroup.buildSynchronizedAdapter()";
            }
        };
    }

    private PropertyChangeListener buildModifierSynchronizedListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModifierComponentGroup.this.synchronizedCheckBox.setEnabled(ModifierComponentGroup.this.synchronizedShouldBeEnabled());
            }

            public String toString() {
                return "ModifierComponentGroup.buildModifierSynchronizedListener()";
            }
        };
    }

    boolean synchronizedShouldBeEnabled() {
        return this.modifier() != null && this.modifier().canBeSetSynchronized();
    }

    JCheckBox getTransientCheckBox() {
        if (this.transientCheckBox == null) {
            this.transientCheckBox = this.buildTransientCheckBox();
            this.allowedModifiersHolder.addPropertyChangeListener("value", this.buildModifierTransientListener());
        }
        return this.transientCheckBox;
    }

    private JCheckBox buildTransientCheckBox() {
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("TRANSIENT_MODIFIER", new CheckBoxModelAdapter(this.buildTransientAdapter()), this.resourceRepository());
        jCheckBox.setEnabled(this.transientShouldBeEnabled());
        return jCheckBox;
    }

    private PropertyValueModel buildTransientAdapter() {
        return new PropertyAspectAdapter(this.modifierHolder, "code"){

            protected Object getValueFromSubject() {
                return ((MWModifier)this.subject).isTransient();
            }

            protected void setValueOnSubject(Object object) {
                ((MWModifier)this.subject).setTransient(((Boolean)object).booleanValue());
            }

            public String toString() {
                return "ModifierComponentGroup.buildTransientAdapter()";
            }
        };
    }

    private PropertyChangeListener buildModifierTransientListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModifierComponentGroup.this.transientCheckBox.setEnabled(ModifierComponentGroup.this.transientShouldBeEnabled());
            }

            public String toString() {
                return "ModifierComponentGroup.buildModifierTransientListener()";
            }
        };
    }

    boolean transientShouldBeEnabled() {
        return this.modifier() != null && this.modifier().canBeSetTransient();
    }

    JCheckBox getVolatileCheckBox() {
        if (this.volatileCheckBox == null) {
            this.volatileCheckBox = this.buildVolatileCheckBox();
            this.allowedModifiersHolder.addPropertyChangeListener("value", this.buildModifierVolatileListener());
        }
        return this.volatileCheckBox;
    }

    private JCheckBox buildVolatileCheckBox() {
        JCheckBox jCheckBox = SwingComponentFactory.buildCheckBox("VOLATILE_MODIFIER", new CheckBoxModelAdapter(this.buildVolatileAdapter()), this.resourceRepository());
        jCheckBox.setEnabled(this.volatileShouldBeEnabled());
        return jCheckBox;
    }

    private PropertyValueModel buildVolatileAdapter() {
        return new PropertyAspectAdapter(this.modifierHolder, "code"){

            protected Object getValueFromSubject() {
                return ((MWModifier)this.subject).isVolatile();
            }

            protected void setValueOnSubject(Object object) {
                ((MWModifier)this.subject).setVolatile(((Boolean)object).booleanValue());
            }

            public String toString() {
                return "ModifierComponentGroup.buildVolatileAdapter()";
            }
        };
    }

    private PropertyChangeListener buildModifierVolatileListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                ModifierComponentGroup.this.volatileCheckBox.setEnabled(ModifierComponentGroup.this.volatileShouldBeEnabled());
            }

            public String toString() {
                return "ModifierComponentGroup.buildModifierVolatileListener()";
            }
        };
    }

    boolean volatileShouldBeEnabled() {
        return this.modifier() != null && this.modifier().canBeSetVolatile();
    }

    private ResourceRepository resourceRepository() {
        return this.context.getResourceRepository();
    }

    private MWModifier modifier() {
        return (MWModifier)this.modifierHolder.getValue();
    }

    private class TitledPanel
    extends JPanel {
        private final String title;

        TitledPanel(String string) {
            this.title = string;
        }

        public Dimension getPreferredSize() {
            Dimension dimension = super.getPreferredSize();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(this.title);
            Dimension dimension2 = titledBorder.getMinimumSize(this);
            dimension.width = Math.max(dimension.width, dimension2.width + 5);
            dimension.height = Math.max(dimension.height, dimension2.height);
            return dimension;
        }
    }

    static interface Verifier {
        public static final Verifier NULL_INSTANCE = new Verifier(){

            public boolean verifyFinalChange(boolean bl) {
                return true;
            }

            public boolean verifyStaticChange(boolean bl) {
                return true;
            }
        };

        public boolean verifyFinalChange(boolean var1);

        public boolean verifyStaticChange(boolean var1);
    }
}

