/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor;

import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.descriptor.RefreshCachePolicyPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;

public class TransactionalDescriptorComponentFactory
extends SwingComponentFactory {
    public static JCheckBox buildReadOnlyCheckBox(ValueModel valueModel, ApplicationContext applicationContext) {
        JCheckBox jCheckBox = TransactionalDescriptorComponentFactory.buildCheckBox("READ_ONLY_CHECKBOX_TEXT", TransactionalDescriptorComponentFactory.buildReadOnlyCheckBoxModel(valueModel), applicationContext.getResourceRepository());
        applicationContext.getHelpManager().addTopicID(jCheckBox, "descriptor.transactional.readOnly");
        return jCheckBox;
    }

    private static ButtonModel buildReadOnlyCheckBoxModel(ValueModel valueModel) {
        return new CheckBoxModelAdapter(TransactionalDescriptorComponentFactory.buildReadOnlyAdapter(valueModel));
    }

    private static PropertyValueModel buildReadOnlyAdapter(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel, "readOnly"){

            protected Object getValueFromSubject() {
                return ((MWTransactionalDescriptor)this.subject).getTransactionalPolicy().isReadOnly();
            }

            protected void setValueOnSubject(Object object) {
                ((MWTransactionalDescriptor)this.subject).getTransactionalPolicy().setReadOnly(((Boolean)object).booleanValue());
            }
        };
    }

    public static JCheckBox buildConformResultsInUnitOfWorkCheckBox(PropertyValueModel propertyValueModel, ApplicationContext applicationContext) {
        JCheckBox jCheckBox = TransactionalDescriptorComponentFactory.buildCheckBox("CONFORM_RESULTS_CHECKBOX_TEXT", TransactionalDescriptorComponentFactory.buildConformResultsInUnitOfWorkCheckBoxModel(propertyValueModel), applicationContext.getResourceRepository());
        applicationContext.getHelpManager().addTopicID(jCheckBox, "descriptor.transactional.conform");
        return jCheckBox;
    }

    private static ButtonModel buildConformResultsInUnitOfWorkCheckBoxModel(PropertyValueModel propertyValueModel) {
        return new CheckBoxModelAdapter(TransactionalDescriptorComponentFactory.buildConformResultsInUnitOfWorkAdapter(propertyValueModel));
    }

    private static PropertyValueModel buildConformResultsInUnitOfWorkAdapter(PropertyValueModel propertyValueModel) {
        return new PropertyAspectAdapter((ValueModel)propertyValueModel, "conformResultsInUnitOfWork"){

            protected Object getValueFromSubject() {
                return ((MWTransactionalDescriptor)this.subject).getTransactionalPolicy().isConformResultsInUnitOfWork();
            }

            protected void setValueOnSubject(Object object) {
                ((MWTransactionalDescriptor)this.subject).getTransactionalPolicy().setConformResultsInUnitOfWork(((Boolean)object).booleanValue());
            }
        };
    }

    public static RefreshCachePolicyPanel buildRefreshCachePolicyPanel(PropertyValueModel propertyValueModel, ApplicationContext applicationContext) {
        return new RefreshCachePolicyPanel(applicationContext, TransactionalDescriptorComponentFactory.buildRefreshCachePolicyHolder(propertyValueModel));
    }

    private static PropertyValueModel buildRefreshCachePolicyHolder(PropertyValueModel propertyValueModel) {
        return new PropertyAspectAdapter(propertyValueModel){

            protected Object getValueFromSubject() {
                return ((MWTransactionalDescriptor)this.subject).getTransactionalPolicy().getRefreshCachePolicy();
            }
        };
    }

    public static Document buildDescriptorAliasDocumentAdapter(ValueModel valueModel) {
        return new DocumentAdapter(TransactionalDescriptorComponentFactory.buildDescriptorAliasHolder(valueModel));
    }

    private static PropertyValueModel buildDescriptorAliasHolder(ValueModel valueModel) {
        return new PropertyAspectAdapter((ValueModel)TransactionalDescriptorComponentFactory.buildTransactionalPolicyHolder(valueModel), "descriptorAlias"){

            protected Object getValueFromSubject() {
                return ((MWTransactionalPolicy)this.subject).getDescriptorAlias();
            }

            protected void setValueOnSubject(Object object) {
                ((MWTransactionalPolicy)this.subject).setDescriptorAlias((String)object);
            }
        };
    }

    private static PropertyValueModel buildTransactionalPolicyHolder(ValueModel valueModel) {
        return new PropertyAspectAdapter(valueModel){

            protected Object getValueFromSubject() {
                return ((MWMappingDescriptor)this.subject).getTransactionalPolicy();
            }
        };
    }
}

