/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.ScrollablePropertiesPage;
import org.eclipse.persistence.tools.workbench.framework.uitools.CheckList;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProject;
import org.eclipse.persistence.tools.workbench.mappingsmodel.project.MWProjectDefaultsPolicy;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.project.FieldAccessingPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ReadOnlyListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ListModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.AbstractCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.TransformationIterator;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

class ProjectDefaultsPropertiesPage
extends ScrollablePropertiesPage {
    private ObjectListSelectionModel advancedPoliciesSelectionModel;
    private List policyHolders;

    ProjectDefaultsPropertiesPage(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    private Comparator buildAdvancedPolicyComparator() {
        return new Comparator(){

            public int compare(Object object, Object object2) {
                return Collator.getInstance().compare(((UIAdvancedPolicyHolder)object).displayString(), ((UIAdvancedPolicyHolder)object2).displayString());
            }
        };
    }

    private Component buildAdvancedPolicyDefaultsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("PROJECT_DEFAULTS_POLICY_DESCRIPTOR_ADVANCED_PROPERTIES"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add(this.buildAdvancedPropertiesDefaultsChooser(), gridBagConstraints);
        this.addHelpTopicId(jPanel, this.helpTopicId() + ".descriptorAdvancedProperties");
        return jPanel;
    }

    private CellRendererAdapter buildAdvancedPropertiesCellRenderer() {
        return new AbstractCellRendererAdapter(){

            public String buildText(Object object) {
                return ((UIAdvancedPolicyHolder)object).displayString();
            }
        };
    }

    private ListValueModel buildAdvancedPropertiesCollectionModel(List list) {
        return new SortedListValueModelAdapter(new ReadOnlyListValueModel(list), this.buildAdvancedPolicyComparator());
    }

    protected Component buildAdvancedPropertiesDefaultsChooser() {
        this.policyHolders = this.buildAdvancedPropertyHolders();
        ListValueModel listValueModel = this.buildAdvancedPropertiesCollectionModel(this.policyHolders);
        this.advancedPoliciesSelectionModel = new ObjectListSelectionModel(new ListModelAdapter(listValueModel));
        CheckList checkList = new CheckList(listValueModel, (ListSelectionModel)this.advancedPoliciesSelectionModel, this.buildAdvancedPropertiesCellRenderer());
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(this.buildStandardEmptyBorder());
        jPanel.add(checkList);
        this.getSelectionHolder().addPropertyChangeListener("value", new ProjectValueChangeListener());
        this.advancedPoliciesSelectionModel.addListSelectionListener(new AdvancedPolicyDataListener(this.policyHolders, this.advancedPoliciesSelectionModel));
        if (this.selection() != null) {
            this.advancedPoliciesSelectionModel.setSelectedValues(this.holderIterator(((MWProject)this.selection()).getDefaultsPolicy().defaultPolicies()));
        }
        return jPanel;
    }

    protected List buildAdvancedPropertyHolders() {
        ArrayList<UIAdvancedPolicyHolder> arrayList = new ArrayList<UIAdvancedPolicyHolder>();
        arrayList.add(new UIAdvancedPolicyHolder("After Load", "PROJECT_DEFAULTS_POLICY_AFTER_LOADING_POLICY"));
        arrayList.add(new UIAdvancedPolicyHolder("Copy Policy", "PROJECT_DEFAULTS_POLICY_COPYING_POLICY"));
        arrayList.add(new UIAdvancedPolicyHolder("Inheritance", "PROJECT_DEFAULTS_POLICY_INHERITANCE_POLICY"));
        arrayList.add(new UIAdvancedPolicyHolder("Instantiation", "PROJECT_DEFAULTS_POLICY_INSTANTIATION_POLICY"));
        return arrayList;
    }

    protected Component buildCachingDefaultsPanel() {
        return new JPanel();
    }

    private Component buildCreationDefaultsPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createCompoundBorder(this.buildTitledBorder("PROJECT_DEFAULTS_POLICY_CREATION"), BorderFactory.createEmptyBorder(0, 5, 5, 5)));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add(this.buildAdvancedPolicyDefaultsPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add(this.buildFieldAccessingPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.buildNamedQueriesPanel(), gridBagConstraints);
        return jPanel;
    }

    private Component buildFieldAccessingPanel() {
        FieldAccessingPanel fieldAccessingPanel = new FieldAccessingPanel((ValueModel)this.getSelectionHolder(), this.getApplicationContext());
        this.addHelpTopicId(fieldAccessingPanel, this.helpTopicId() + ".fieldAccessing");
        return fieldAccessingPanel;
    }

    protected JPanel buildNamedQueriesPanel() {
        return new JPanel();
    }

    protected Component buildPage() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add(this.buildCreationDefaultsPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add(this.buildCachingDefaultsPanel(), gridBagConstraints);
        this.addHelpTopicId(jPanel, this.helpTopicId());
        return jPanel;
    }

    protected PropertyValueModel buildSelectionHolder() {
        return new TransformationPropertyValueModel(super.buildSelectionHolder()){

            protected Object transform(Object object) {
                if (object == null) {
                    return null;
                }
                return ((MWProject)object).getDefaultsPolicy();
            }
        };
    }

    private UIAdvancedPolicyHolder getPolicyHolderFor(String string) {
        for (UIAdvancedPolicyHolder uIAdvancedPolicyHolder : this.policyHolders) {
            if (!uIAdvancedPolicyHolder.isOfType(string)) continue;
            return uIAdvancedPolicyHolder;
        }
        return null;
    }

    protected String helpTopicId() {
        return "project.defaults";
    }

    private Iterator holderIterator(Iterator iterator) {
        return new TransformationIterator(iterator){

            protected Object transform(Object object) {
                return ProjectDefaultsPropertiesPage.this.getPolicyHolderFor((String)object);
            }
        };
    }

    protected MWProjectDefaultsPolicy projectDefaults() {
        return (MWProjectDefaultsPolicy)this.selection();
    }

    public class UIAdvancedPolicyHolder {
        private String policyId;
        private String resourceKey;

        public UIAdvancedPolicyHolder(String string, String string2) {
            this.policyId = string;
            this.resourceKey = string2;
        }

        public void addPolicyDefault() {
            if (!ProjectDefaultsPropertiesPage.this.projectDefaults().containsAdvancePolicyDefault(this.policyId)) {
                ProjectDefaultsPropertiesPage.this.projectDefaults().addAdvancedPolicyDefault(this.policyId);
            }
        }

        public String displayString() {
            try {
                return ProjectDefaultsPropertiesPage.this.resourceRepository().getString(this.resourceKey);
            }
            catch (NullPointerException nullPointerException) {
                return this.resourceKey;
            }
        }

        public boolean isOfType(String string) {
            return this.policyId == string;
        }

        public void removePolicyDefault() {
            if (ProjectDefaultsPropertiesPage.this.projectDefaults().containsAdvancePolicyDefault(this.policyId)) {
                ProjectDefaultsPropertiesPage.this.projectDefaults().removeAdvancedPolicyDefault(this.policyId);
            }
        }

        public String toString() {
            return StringTools.buildToStringFor((Object)this);
        }
    }

    private class ProjectValueChangeListener
    implements PropertyChangeListener {
        private ProjectValueChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (ProjectDefaultsPropertiesPage.this.selection() != null) {
                MWProject mWProject = ProjectDefaultsPropertiesPage.this.projectDefaults().getProject();
                Iterator iterator = mWProject.getDefaultsPolicy().defaultPolicies();
                ProjectDefaultsPropertiesPage.this.advancedPoliciesSelectionModel.setSelectedValues(ProjectDefaultsPropertiesPage.this.holderIterator(iterator));
            }
        }
    }

    private class AdvancedPolicyDataListener
    implements ListSelectionListener {
        private List allPolicyHolders;
        private ObjectListSelectionModel selectionModel;

        private AdvancedPolicyDataListener(List list, ObjectListSelectionModel objectListSelectionModel) {
            this.allPolicyHolders = list;
            this.selectionModel = objectListSelectionModel;
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            Object[] objectArray = this.selectionModel.getSelectedValues();
            ArrayList arrayList = new ArrayList(this.allPolicyHolders);
            CollectionTools.removeAll(arrayList, (Object[])objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                UIAdvancedPolicyHolder uIAdvancedPolicyHolder = (UIAdvancedPolicyHolder)objectArray[i];
                uIAdvancedPolicyHolder.addPolicyDefault();
            }
            for (UIAdvancedPolicyHolder uIAdvancedPolicyHolder : arrayList) {
                uIAdvancedPolicyHolder.removePolicyDefault();
            }
        }
    }
}

