/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Insets;
import java.util.Iterator;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemoveTablePanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWClass;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWAbstractQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQueryParameter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryParameterDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValuePropertyPropertyValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.uitools.cell.SimpleTableCellRenderer;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.NameTools;

public final class QueryParametersPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private AddRemoveTablePanel paramatersPanel;

    public QueryParametersPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.queryHolder = propertyValueModel;
        this.initializeLayout();
    }

    private String helpTopicId() {
        return "descriptor.queryManager.general.parameters";
    }

    protected void initializeLayout() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.paramatersPanel = this.buildQueryParametersTable();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 5, 5, 5);
        this.add((Component)this.paramatersPanel, gridBagConstraints);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridLayout(1, 2, 5, 0));
        jPanel.setBorder(BorderFactory.createEmptyBorder());
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 22;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jPanel, gridBagConstraints);
        this.addHelpTopicId(this, this.helpTopicId());
    }

    private AddRemoveTablePanel buildQueryParametersTable() {
        AddRemoveTablePanel addRemoveTablePanel = new AddRemoveTablePanel(this.getApplicationContext(), this.buildParametersPanelAdapter(), this.buildParametersNameAdapter(), this.buildQueryParametersTableColumnAdapter(), 3){

            protected void updateOptionalButton(JButton jButton) {
                boolean bl = this.getSelectionModel().getSelectedValuesSize() == 1;
                this.updateButton(jButton, bl);
            }

            protected void updateRemoveButton(JButton jButton) {
                boolean bl = this.getSelectionModel().getSelectedValue() != null;
                this.updateButton(jButton, bl);
            }

            protected void updateAddButton(JButton jButton) {
            }

            protected String removeButtonKey() {
                return "REMOVE_PARAMETER_BUTTON";
            }

            protected String addButtonKey() {
                return "ADD_PARAMETER_BUTTON";
            }

            private void updateButton(JButton jButton, boolean bl) {
                boolean bl2 = true;
                jButton.setEnabled(bl && bl2);
            }
        };
        JTable jTable = (JTable)addRemoveTablePanel.getComponent();
        jTable.getColumnModel().getColumn(0).setCellRenderer(this.buildTypeRenderer());
        return addRemoveTablePanel;
    }

    protected TableCellRenderer buildTypeRenderer() {
        return new SimpleTableCellRenderer(){

            protected String buildText(Object object) {
                return object == null ? null : ((MWClass)object).getName();
            }
        };
    }

    private AddRemovePanel.UpDownOptionAdapter buildParametersPanelAdapter() {
        return new AddRemovePanel.UpDownOptionAdapter(){

            public void moveItemsDown(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    QueryParametersPanel.this.getQuery().moveParameterDown((MWQueryParameter)objectArray[i]);
                }
            }

            public void moveItemsUp(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    QueryParametersPanel.this.getQuery().moveParameterUp((MWQueryParameter)objectArray[i]);
                }
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                QueryParametersPanel.this.removeSelectedQueryParameters(objectListSelectionModel);
            }

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                QueryParametersPanel.this.addQueryParameter();
            }

            public void optionOnSelection(ObjectListSelectionModel objectListSelectionModel) {
                QueryParametersPanel.this.editSelectedQueryParameter((MWQueryParameter)objectListSelectionModel.getSelectedValue());
            }

            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel objectListSelectionModel) {
                return objectListSelectionModel.getSelectedValuesSize() == 1;
            }

            public String optionalButtonKey() {
                return "EDIT_PARAMETER_BUTTON";
            }
        };
    }

    private ListValueModel buildParametersNameAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildQueryParametersHolder(), "name");
    }

    private ListValueModel buildQueryParametersHolder() {
        return new ListAspectAdapter(this.queryHolder, "parameters"){

            protected ListIterator getValueFromSubject() {
                return ((MWAbstractQuery)this.subject).parameters();
            }

            protected int sizeFromSubject() {
                return ((MWAbstractQuery)this.subject).parametersSize();
            }
        };
    }

    private ColumnAdapter buildQueryParametersTableColumnAdapter() {
        return new QueryParametersColumnAdapter(this.resourceRepository());
    }

    protected void removeSelectedQueryParameters(ObjectListSelectionModel objectListSelectionModel) {
        this.getQuery().removeParameters(CollectionTools.iterator((Object[])objectListSelectionModel.getSelectedValues()));
    }

    void addQueryParameter() {
        String string = NameTools.uniqueNameFor((String)"arg", (Iterator)this.getQuery().parameterNames());
        QueryParameterDialog queryParameterDialog = new QueryParameterDialog((MWQuery)this.getQuery(), this.getQuery().typeFor(String.class), string, this.getWorkbenchContext(), this.resourceRepository().getString("QUERY_PARAMETER_DIALOG.title"));
        queryParameterDialog.show();
        if (queryParameterDialog.wasConfirmed()) {
            MWClass mWClass = queryParameterDialog.getParameterType();
            String string2 = queryParameterDialog.getParameterName();
            MWQueryParameter mWQueryParameter = this.getQuery().addParameter(mWClass, string2);
            this.selectParameter(mWQueryParameter);
        }
    }

    void editSelectedQueryParameter(MWQueryParameter mWQueryParameter) {
        QueryParameterDialog queryParameterDialog = new QueryParameterDialog((MWQuery)this.getQuery(), mWQueryParameter.getType(), mWQueryParameter.getName(), this.getWorkbenchContext(), this.resourceRepository().getString("QUERY_PARAMETER_DIALOG_EDIT.title"));
        queryParameterDialog.show();
        if (queryParameterDialog.wasConfirmed()) {
            mWQueryParameter.setType(queryParameterDialog.getParameterType());
            mWQueryParameter.setName(queryParameterDialog.getParameterName());
        }
    }

    MWAbstractQuery getQuery() {
        return (MWAbstractQuery)this.queryHolder.getValue();
    }

    public void selectParameter(MWQueryParameter mWQueryParameter) {
        this.paramatersPanel.setSelectedValue(mWQueryParameter, true);
    }

    public static class QueryParametersColumnAdapter
    implements ColumnAdapter {
        private ResourceRepository resourceRepository;
        public static final int COLUMN_COUNT = 2;
        public static final int TYPE_COLUMN = 0;
        public static final int NAME_COLUMN = 1;
        private static final String[] COLUMN_NAME_KEYS = new String[]{"TYPE_COLUMN_HEADER", "NAME_COLUMN_HEADER"};

        protected QueryParametersColumnAdapter(ResourceRepository resourceRepository) {
            this.resourceRepository = resourceRepository;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return this.resourceRepository.getString(COLUMN_NAME_KEYS[n]);
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: {
                    return Object.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public boolean isColumnEditable(int n) {
            return false;
        }

        public PropertyValueModel[] cellModels(Object object) {
            MWQueryParameter mWQueryParameter = (MWQueryParameter)object;
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildTypeAdapter(mWQueryParameter), this.buildNameAdapter(mWQueryParameter)};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildTypeAdapter(MWQueryParameter mWQueryParameter) {
            PropertyAspectAdapter propertyAspectAdapter = new PropertyAspectAdapter("type", (Model)mWQueryParameter){

                protected Object getValueFromSubject() {
                    return ((MWQueryParameter)this.subject).getType();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWQueryParameter)this.subject).setType((MWClass)object);
                }
            };
            return new ValuePropertyPropertyValueModelAdapter((PropertyValueModel)propertyAspectAdapter, "name");
        }

        private PropertyValueModel buildNameAdapter(MWQueryParameter mWQueryParameter) {
            return new PropertyAspectAdapter("name", (Model)mWQueryParameter){

                protected Object getValueFromSubject() {
                    return ((MWQueryParameter)this.subject).getName();
                }

                protected void setValueOnSubject(Object object) {
                    ((MWQueryParameter)this.subject).setName((String)object);
                }
            };
        }
    }
}

