/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.AddRemovePanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWGroupingItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryFormat;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWReportQuery;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AbstractAttributeItemsPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;

final class GroupingAttributesPanel
extends AbstractAttributeItemsPanel {
    GroupingAttributesPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(propertyValueModel, workbenchContextHolder);
    }

    String listTitleKey() {
        return "REPORT_QUERY_GROUPING_ATTRIBUTES_LIST";
    }

    protected String helpTopicId() {
        return "query.report.groupings";
    }

    AddRemovePanel.UpDownOptionAdapter buildAttributesPanelAdapter() {
        return new AddRemovePanel.UpDownOptionAdapter(){

            public String optionalButtonKey() {
                return "REPORT_QUERY_GROUPING_ATTRIBUTES_LIST_EDIT_BUTTON";
            }

            public void optionOnSelection(ObjectListSelectionModel objectListSelectionModel) {
                GroupingAttributesPanel.this.editSelectedAttribute((MWAttributeItem)((MWGroupingItem)objectListSelectionModel.getSelectedValue()));
            }

            public boolean enableOptionOnSelectionChange(ObjectListSelectionModel objectListSelectionModel) {
                return objectListSelectionModel.getSelectedValuesSize() == 1;
            }

            public void addNewItem(ObjectListSelectionModel objectListSelectionModel) {
                GroupingAttributesPanel.this.addGroupingAttribute();
            }

            public void removeSelectedItems(ObjectListSelectionModel objectListSelectionModel) {
                Object[] objectArray = objectListSelectionModel.getSelectedValues();
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWReportQuery)GroupingAttributesPanel.this.getQuery()).removeGroupingItem((MWGroupingItem)objectArray[i]);
                }
            }

            public void moveItemsDown(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWReportQuery)GroupingAttributesPanel.this.getQuery()).moveGroupingItemDown((MWGroupingItem)objectArray[i]);
                }
            }

            public void moveItemsUp(Object[] objectArray) {
                for (int i = 0; i < objectArray.length; ++i) {
                    ((MWReportQuery)GroupingAttributesPanel.this.getQuery()).moveGroupingItemUp((MWGroupingItem)objectArray[i]);
                }
            }
        };
    }

    protected ListValueModel buildAttributesHolder() {
        return new ListAspectAdapter(this.getQueryHolder(), "groupingItems"){

            protected ListIterator getValueFromSubject() {
                return ((MWReportQuery)this.subject).groupingItems();
            }

            protected int sizeFromSubject() {
                return ((MWReportQuery)this.subject).groupingItemsSize();
            }
        };
    }

    protected boolean panelEnabled(MWQueryFormat mWQueryFormat) {
        return mWQueryFormat.groupingAtributesAllowed();
    }

    private void addGroupingAttribute() {
        this.editSelectedAttribute(null);
    }

    AttributeItemDialog buildAttributeItemDialog(MWAttributeItem mWAttributeItem) {
        AttributeItemDialog attributeItemDialog = new AttributeItemDialog(this.getQuery(), mWAttributeItem, this.getWorkbenchContext()){

            protected String titleKey() {
                return "GROUPING_ATTRIBUTES_DIALOG_TITLE";
            }

            protected String editTitleKey() {
                return "GROUPING_ATTRIBUTES_EDIT_DIALOG_TITLE";
            }

            protected String helpTopicId() {
                return "dialog.groupingAttribute";
            }

            protected int attributeItemsSize() {
                return ((MWReportQuery)this.getQuery()).groupingItemsSize();
            }

            protected int indexOfAttributeItem(MWAttributeItem mWAttributeItem) {
                return ((MWReportQuery)this.getQuery()).indexOfGroupingItem((MWGroupingItem)mWAttributeItem);
            }

            protected void removeAttributeItem(int n) {
                ((MWReportQuery)this.getQuery()).removeGroupingItem(n);
            }

            protected void addAttributeItem(int n, Iterator iterator, Iterator iterator2) {
                ((MWReportQuery)this.getQuery()).addGroupingItem(n, iterator, iterator2);
            }
        };
        return attributeItemDialog;
    }
}

