/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.text.PlainDocument;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.uitools.RegexpDocument;
import org.eclipse.persistence.tools.workbench.mappingsmodel.meta.MWTypeDeclaration;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWLiteralArgument;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.common.cell.TypeDeclarationCellRendererAdapter;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.ArgumentPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.FilteringPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ComboBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.DocumentAdapter;
import org.eclipse.persistence.tools.workbench.uitools.cell.AdaptableListCellRenderer;

final class LiteralArgumentPanel
extends ArgumentPanel {
    private JTextField literalTextField;
    private PropertyValueModel typeHolder;

    LiteralArgumentPanel(PropertyValueModel propertyValueModel, WorkbenchContextHolder workbenchContextHolder, Collection collection) {
        super(propertyValueModel, workbenchContextHolder);
        this.initialize(collection);
    }

    private void initialize(Collection collection) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel(this.resourceRepository().getString("TYPE_LABEL:"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("TYPE_LABEL:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jLabel, gridBagConstraints);
        collection.add(jLabel);
        JComboBox jComboBox = this.buildTypeChooser();
        jLabel.setLabelFor(jComboBox);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 23;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jComboBox, gridBagConstraints);
        collection.add(jComboBox);
        JLabel jLabel2 = new JLabel(this.resourceRepository().getString("VALUE_LABEL:"));
        jLabel2.setDisplayedMnemonic(this.resourceRepository().getMnemonic("VALUE_LABEL:"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.add((Component)jLabel2, gridBagConstraints);
        collection.add(jLabel2);
        this.literalTextField = this.buildLiteralTextField();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jLabel2.setLabelFor(this.literalTextField);
        this.add((Component)this.literalTextField, gridBagConstraints);
        collection.add(this.literalTextField);
    }

    private JComboBox buildTypeChooser() {
        JComboBox<Object> jComboBox = new JComboBox<Object>(this.buildAttributeTypeComboBoxModel());
        jComboBox.setRenderer(new AdaptableListCellRenderer(new TypeDeclarationCellRendererAdapter(this.resourceRepository())));
        return jComboBox;
    }

    private ComboBoxModel buildAttributeTypeComboBoxModel() {
        this.typeHolder = this.buildTypeHolder();
        return new ComboBoxModelAdapter(this.buildTypesCollectionHolder(), this.typeHolder);
    }

    private CollectionValueModel buildTypesCollectionHolder() {
        return new CollectionAspectAdapter(this.getArgumentHolder()){

            protected Iterator getValueFromSubject() {
                return ((MWLiteralArgument)this.subject).buildBasicTypes().iterator();
            }
        };
    }

    private PropertyValueModel buildTypeHolder() {
        return new PropertyAspectAdapter(this.getArgumentHolder(), "type"){

            protected Object getValueFromSubject() {
                return ((MWLiteralArgument)this.subject).getLiteralType();
            }

            protected void setValueOnSubject(Object object) {
                ((MWLiteralArgument)this.subject).setType((MWTypeDeclaration)object);
            }
        };
    }

    private JTextField buildLiteralTextField() {
        JTextField jTextField = new JTextField(0);
        final PropertyValueModel propertyValueModel = this.buildLiteralHolder();
        jTextField.setDocument(new DocumentAdapter(propertyValueModel));
        this.typeHolder.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                MWTypeDeclaration mWTypeDeclaration = (MWTypeDeclaration)propertyChangeEvent.getNewValue();
                if (mWTypeDeclaration != null) {
                    if (mWTypeDeclaration.getType() == LiteralArgumentPanel.this.getArgument().typeFor(Integer.class) || mWTypeDeclaration.getType() == LiteralArgumentPanel.this.getArgument().typeFor(BigInteger.class) || mWTypeDeclaration.getType() == LiteralArgumentPanel.this.getArgument().typeFor(Long.class) || mWTypeDeclaration.getType() == LiteralArgumentPanel.this.getArgument().typeFor(Short.class)) {
                        LiteralArgumentPanel.this.literalTextField.setDocument(new DocumentAdapter(propertyValueModel, new RegexpDocument(7)));
                    } else if (mWTypeDeclaration.getType() == LiteralArgumentPanel.this.getArgument().typeFor(BigDecimal.class) || mWTypeDeclaration.getType() == LiteralArgumentPanel.this.getArgument().typeFor(Double.class) || mWTypeDeclaration.getType() == LiteralArgumentPanel.this.getArgument().typeFor(Float.class)) {
                        LiteralArgumentPanel.this.literalTextField.setDocument(new DocumentAdapter(propertyValueModel, new RegexpDocument(10)));
                    } else {
                        LiteralArgumentPanel.this.literalTextField.setDocument(new DocumentAdapter(propertyValueModel, new PlainDocument()));
                    }
                }
            }
        });
        return jTextField;
    }

    private PropertyValueModel buildLiteralHolder() {
        return new PropertyAspectAdapter(this.getArgumentHolder(), "value"){

            protected Object getValueFromSubject() {
                return ((MWLiteralArgument)this.subject).getValue();
            }

            protected void setValueOnSubject(Object object) {
                ((MWLiteralArgument)this.subject).setValue((String)object);
            }
        };
    }

    protected PropertyValueModel buildQueryArgumentHolder(PropertyValueModel propertyValueModel) {
        return new FilteringPropertyValueModel(propertyValueModel){

            protected boolean accept(Object object) {
                return object instanceof MWLiteralArgument;
            }
        };
    }
}

