/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.MWQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWAttributeItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWOrderableQuery;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.Ordering;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.AttributeItemDialog;
import org.eclipse.persistence.tools.workbench.utility.filters.Filter;

class OrderingAttributeDialog
extends AttributeItemDialog {
    private JComboBox orderComboBox;

    OrderingAttributeDialog(MWOrderableQuery mWOrderableQuery, Ordering ordering, Filter filter, Filter filter2, WorkbenchContext workbenchContext) {
        super((MWQuery)mWOrderableQuery, (MWAttributeItem)ordering, filter, filter2, workbenchContext);
    }

    protected String titleKey() {
        return "ORDERING_ATTRIBUTES_DIALOG_TITLE";
    }

    protected String editTitleKey() {
        return "ORDERING_ATTRIBUTES_EDIT_DIALOG_TITLE";
    }

    protected String helpTopicId() {
        return "descriptor.queryManager.query.orderingAttributes";
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        JScrollPane jScrollPane = new JScrollPane(this.buildQueryableTree());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jScrollPane, gridBagConstraints);
        JComboBox jComboBox = this.buildOrderComboBox();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jComboBox, gridBagConstraints);
        return jPanel;
    }

    protected void initializeEditMode(MWAttributeItem mWAttributeItem) {
        super.initializeEditMode(mWAttributeItem);
        this.initializeOrderComboBox(mWAttributeItem);
    }

    protected void initializeOrderComboBox(MWAttributeItem mWAttributeItem) {
        if (((Ordering)mWAttributeItem).isAscending()) {
            this.orderComboBox.setSelectedItem(this.resourceRepository().getString("ASCENDING_CHOICE"));
        } else {
            this.orderComboBox.setSelectedItem(this.resourceRepository().getString("DESCENDING_CHOICE"));
        }
    }

    protected JComboBox buildOrderComboBox() {
        this.orderComboBox = new JComboBox();
        this.orderComboBox.addItem(this.resourceRepository().getString("ASCENDING_CHOICE"));
        this.orderComboBox.addItem(this.resourceRepository().getString("DESCENDING_CHOICE"));
        return this.orderComboBox;
    }

    boolean isAscending() {
        return this.orderComboBox.getSelectedItem().equals(this.resourceRepository().getString("ASCENDING_CHOICE"));
    }

    protected int attributeItemsSize() {
        return ((MWOrderableQuery)this.getQuery()).orderingItemsSize();
    }

    protected int indexOfAttributeItem(MWAttributeItem mWAttributeItem) {
        return ((MWOrderableQuery)this.getQuery()).indexOfOrderingItem((Ordering)mWAttributeItem);
    }

    protected void removeAttributeItem(int n) {
        ((MWOrderableQuery)this.getQuery()).removeOrderingItem(n);
    }

    protected void addAttributeItem(int n, Iterator iterator, Iterator iterator2) {
        Ordering ordering = ((MWOrderableQuery)this.getQuery()).addOrderingItem(n, iterator, iterator2);
        ordering.setAscending(this.isAscending());
    }
}

