/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import javax.swing.JTabbedPane;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWJoinedItem;
import org.eclipse.persistence.tools.workbench.mappingsmodel.query.relational.MWQueryItem;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryGeneralPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QueryQuickViewItem;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.QuickViewPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.JoinedAttributesPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.QuerySelectionCriteriaPanel;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.query.relational.RelationalQueryOptionsPanel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;

final class RelationalReadObjectQueryPanel
extends AbstractPanel {
    private PropertyValueModel queryHolder;
    private JTabbedPane queryPropertiesPane;
    private JoinedAttributesPanel joinedAttributesPanel;
    private QueryGeneralPanel queryGeneralPanel;

    RelationalReadObjectQueryPanel(PropertyValueModel propertyValueModel, ObjectListSelectionModel objectListSelectionModel, WorkbenchContextHolder workbenchContextHolder) {
        super(workbenchContextHolder);
        this.queryHolder = propertyValueModel;
        this.initializeLayout(objectListSelectionModel);
    }

    private void initializeLayout(ObjectListSelectionModel objectListSelectionModel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.queryPropertiesPane = new JTabbedPane();
        this.queryGeneralPanel = new QueryGeneralPanel(this.queryHolder, objectListSelectionModel, this.getWorkbenchContextHolder());
        QuerySelectionCriteriaPanel querySelectionCriteriaPanel = new QuerySelectionCriteriaPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.joinedAttributesPanel = new JoinedAttributesPanel(this.queryHolder, this.getWorkbenchContextHolder());
        RelationalQueryOptionsPanel relationalQueryOptionsPanel = new RelationalQueryOptionsPanel(this.queryHolder, this.getWorkbenchContextHolder());
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("GENERAL_TAB"), this.queryGeneralPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("FORMAT_TAB"), querySelectionCriteriaPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("OPTIMIZATION_TAB"), this.joinedAttributesPanel);
        this.queryPropertiesPane.addTab(this.resourceRepository().getString("OPTIONS_TAB"), relationalQueryOptionsPanel);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)this.queryPropertiesPane, gridBagConstraints);
    }

    protected void selectQueryOptimizationTab() {
        this.queryPropertiesPane.setSelectedComponent(this.joinedAttributesPanel);
    }

    protected QueryGeneralPanel getQueryGeneralPanel() {
        return this.queryGeneralPanel;
    }

    protected JTabbedPane getQueryTabbedPane() {
        return this.queryPropertiesPane;
    }

    protected QuickViewPanel.QuickViewItem buildJoinedAttributeQuickViewItem(MWJoinedItem mWJoinedItem) {
        return new QueryQuickViewItem((MWQueryItem)mWJoinedItem){

            public void select() {
                RelationalReadObjectQueryPanel.this.queryPropertiesPane.setSelectedComponent(RelationalReadObjectQueryPanel.this.joinedAttributesPanel);
                RelationalReadObjectQueryPanel.this.joinedAttributesPanel.select((MWQueryItem)this.getValue());
            }
        };
    }
}

