/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ListIterator;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.JTableHeader;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.ui.view.AbstractPanel;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentDetail;
import org.eclipse.persistence.tools.workbench.mappingsplugin.ui.schema.SchemaComponentNode;
import org.eclipse.persistence.tools.workbench.uitools.app.AbstractReadOnlyPropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ListAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ColumnAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.TableModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.Model;

final class SchemaComponentDetailsPanel
extends AbstractPanel {
    private PropertyValueModel schemaComponentNodeHolder;

    SchemaComponentDetailsPanel(ApplicationContext applicationContext, PropertyValueModel propertyValueModel) {
        super((LayoutManager)new BorderLayout(), applicationContext);
        this.initialize(propertyValueModel);
        this.initializeLayout();
    }

    private void initialize(PropertyValueModel propertyValueModel) {
        this.schemaComponentNodeHolder = propertyValueModel;
    }

    private void initializeLayout() {
        JLabel jLabel = this.buildDetailsLabel();
        JTable jTable = this.buildDetailsTable();
        jLabel.setLabelFor(jTable);
        this.add((Component)jLabel, "First");
        this.add((Component)jTable, "Center");
    }

    private JLabel buildDetailsLabel() {
        JLabel jLabel = new JLabel(this.resourceRepository().getString("DETAILS_TABLE_LABEL"));
        jLabel.setDisplayedMnemonic(this.resourceRepository().getMnemonic("DETAILS_TABLE_LABEL"));
        Color color = jLabel.getBackground() != null ? jLabel.getBackground() : UIManager.getColor("Panel.background");
        jLabel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, color.darker()), BorderFactory.createEmptyBorder(2, 4, 2, 2)));
        JTableHeader jTableHeader = new JTableHeader();
        jLabel.setBackground(jTableHeader.getBackground());
        jLabel.setForeground(jTableHeader.getForeground());
        jLabel.setFont(jTableHeader.getFont());
        return jLabel;
    }

    private JTable buildDetailsTable() {
        JTable jTable = SwingComponentFactory.buildTable(this.buildDetailsTableModel());
        jTable.setBorder(BorderFactory.createEmptyBorder());
        jTable.setPreferredSize(new Dimension(200, 300));
        return jTable;
    }

    private TableModelAdapter buildDetailsTableModel() {
        return new TableModelAdapter(this.buildDetailsAdapter(), this.buildDetailsTableColumnModelAdapter());
    }

    private ListValueModel buildDetailsAdapter() {
        return new ListAspectAdapter(this.schemaComponentNodeHolder){

            protected ListIterator getValueFromSubject() {
                return ((SchemaComponentNode)this.subject).details();
            }
        };
    }

    private ColumnAdapter buildDetailsTableColumnModelAdapter() {
        return new DetailsColumnAdapter();
    }

    private static class DetailsColumnAdapter
    implements ColumnAdapter {
        private static final int COLUMN_COUNT = 2;
        private static final int DETAIL_NAME_COLUMN = 0;
        private static final int DETAIL_VALUE_COLUMN = 1;

        private DetailsColumnAdapter() {
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            return "";
        }

        public Class getColumnClass(int n) {
            return String.class;
        }

        public boolean isColumnEditable(int n) {
            return false;
        }

        public PropertyValueModel[] cellModels(Object object) {
            SchemaComponentDetail schemaComponentDetail = (SchemaComponentDetail)((Object)object);
            PropertyValueModel[] propertyValueModelArray = new PropertyValueModel[]{this.buildDetailNameAdapter(schemaComponentDetail), this.buildDetailValueAdapter(schemaComponentDetail)};
            return propertyValueModelArray;
        }

        private PropertyValueModel buildDetailNameAdapter(final SchemaComponentDetail schemaComponentDetail) {
            return new AbstractReadOnlyPropertyValueModel(){

                public Object getValue() {
                    return schemaComponentDetail.getName();
                }
            };
        }

        private PropertyValueModel buildDetailValueAdapter(SchemaComponentDetail schemaComponentDetail) {
            return new PropertyAspectAdapter("value", (Model)schemaComponentDetail){

                protected Object getValueFromSubject() {
                    return ((SchemaComponentDetail)((Object)this.subject)).getValue();
                }
            };
        }
    }
}

