/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.platformsplugin.ui;

import java.awt.Cursor;
import org.eclipse.persistence.tools.workbench.framework.action.AbstractFrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ApplicationNode;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.platformsmodel.DatabasePlatformRepository;
import org.eclipse.persistence.tools.workbench.platformsplugin.ui.PlatformsPlugin;

final class NewDatabasePlatformRepositoryAction
extends AbstractFrameworkAction {
    private PlatformsPlugin plugin;
    private NewNameDialog.Builder dialogBuilder;

    NewDatabasePlatformRepositoryAction(PlatformsPlugin platformsPlugin, WorkbenchContext workbenchContext) {
        super(workbenchContext);
        this.plugin = platformsPlugin;
    }

    protected void initialize() {
        this.initializeTextAndMnemonic("NEW_DATABASE_PLATFORM_REPOSITORY");
        this.initializeIcon("NEW_DATABASE_PLATFORM_REPOSITORY");
        this.initializeToolTipText("NEW_DATABASE_PLATFORM_REPOSITORY.TOOL_TIP");
    }

    private NewNameDialog.Builder getDialogBuilder() {
        if (this.dialogBuilder == null) {
            this.dialogBuilder = this.buildDialogBuilder();
        }
        return this.dialogBuilder;
    }

    private NewNameDialog.Builder buildDialogBuilder() {
        NewNameDialog.Builder builder = new NewNameDialog.Builder();
        builder.setTitle(this.resourceRepository().getString("NEW_DATABASE_PLATFORM_REPOSITORY.DIALOG.TITLE"));
        builder.setTextFieldDescription(this.resourceRepository().getString("NEW_DATABASE_PLATFORM_REPOSITORY.DIALOG.TEXT_FIELD_DESCRIPTION"));
        builder.setOriginalName(this.resourceRepository().getString("NEW_DATABASE_PLATFORM_REPOSITORY.DIALOG.ORIGINAL_NAME"));
        builder.setHelpTopicId("platforms.new.name");
        return builder;
    }

    protected void execute() {
        NewNameDialog newNameDialog = this.getDialogBuilder().buildDialog(this.getWorkbenchContext());
        newNameDialog.show();
        if (newNameDialog.wasCanceled()) {
            return;
        }
        this.currentWindow().setCursor(Cursor.getPredefinedCursor(3));
        this.navigatorSelectionModel().pushExpansionState();
        ApplicationNode applicationNode = this.plugin.buildRepositoryNode(new DatabasePlatformRepository(newNameDialog.getNewName()), this.getWorkbenchContext());
        this.nodeManager().addProjectNode(applicationNode);
        this.navigatorSelectionModel().setSelectedNode(applicationNode);
        this.navigatorSelectionModel().popAndRestoreExpansionState();
        this.currentWindow().setCursor(Cursor.getDefaultCursor());
    }
}

