/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.model.adapter;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionBrokerConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.SessionConfig;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SCAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerPlatform;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.SessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.TopLinkSessionsAdapter;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

public final class SessionBrokerAdapter
extends SessionAdapter {
    public static final String SESSIONS_COLLECTION = "sessions";

    SessionBrokerAdapter(SCAdapter sCAdapter, SessionBrokerConfig sessionBrokerConfig) {
        super(sCAdapter, (SessionConfig)sessionBrokerConfig);
    }

    protected SessionBrokerAdapter(SCAdapter sCAdapter, String string, ServerPlatform serverPlatform) {
        super(sCAdapter, string);
        this.initializeServerPlatform(serverPlatform);
    }

    protected Object buildModel() {
        return new SessionBrokerConfig();
    }

    private final SessionBrokerConfig sessionBroker() {
        return (SessionBrokerConfig)this.getModel();
    }

    private TopLinkSessionsAdapter topLinkSessions() {
        return (TopLinkSessionsAdapter)this.getParent();
    }

    public boolean isBroker() {
        return true;
    }

    public SessionAdapter sessionNamed(String string) {
        return this.topLinkSessions().managedSessionNamed(string);
    }

    public Iterator sessions() {
        return this.topLinkSessions().managedSessions(this);
    }

    public int sessionsSize() {
        return this.getSessionNameConfigs().size();
    }

    Iterator sessionNames() {
        return this.getSessionNameConfigs().iterator();
    }

    private Collection getSessionNameConfigs() {
        return this.sessionBroker().getSessionNames();
    }

    public DatabaseSessionAdapter manage(String string) {
        DatabaseSessionAdapter databaseSessionAdapter = this.topLinkSessions().addManagedSessionNamed(string);
        databaseSessionAdapter.setBroker(this);
        this.getSessionNameConfigs().add(string);
        this.fireItemAdded(SESSIONS_COLLECTION, databaseSessionAdapter);
        return databaseSessionAdapter;
    }

    void internalAddSessionNamed(String string) {
        DatabaseSessionAdapter databaseSessionAdapter = this.topLinkSessions().addManagedSessionNamed(string);
        databaseSessionAdapter.setBroker(this);
    }

    public DatabaseSessionAdapter unManage(String string) {
        DatabaseSessionAdapter databaseSessionAdapter = this.topLinkSessions().removeManagedSessionNamed(string);
        databaseSessionAdapter.setBroker(null);
        this.getSessionNameConfigs().remove(string);
        this.fireCollectionChanged(SESSIONS_COLLECTION);
        return databaseSessionAdapter;
    }

    public Collection unManage(Collection collection) {
        Collection collection2 = this.topLinkSessions().removeManagedSessions(collection);
        Object object = collection2.iterator();
        while (object.hasNext()) {
            ((DatabaseSessionAdapter)object.next()).setBroker(null);
        }
        object = this.topLinkSessions().getSessionsNames(collection2.iterator());
        this.getSessionNameConfigs().removeAll((Collection<?>)object);
        this.fireCollectionChanged(SESSIONS_COLLECTION);
        return collection2;
    }

    void externalTransactionControllerClassChanged() {
        Iterator iterator = this.sessions();
        while (iterator.hasNext()) {
            DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)iterator.next();
            databaseSessionAdapter.externalTransactionControllerClassChanged();
        }
    }

    protected void setManaged(boolean bl) {
        throw new IllegalStateException();
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        CollectionTools.addAll((Collection)list, (Iterator)this.sessions());
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.verifyProblemSessionCount(list);
    }

    private void verifyProblemSessionCount(List list) {
        if (this.sessionsSize() == 0) {
            list.add(this.buildProblem("0804", this.displayString()));
        }
    }

    void sessionRenamed(String string, String string2) {
        this.getSessionNameConfigs().remove(string);
        this.getSessionNameConfigs().add(string2);
    }
}

