/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.tools.workbench.framework.action.FrameworkAction;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ComponentGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.GroupContainerDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.MenuGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.RootMenuDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarButtonGroupDescription;
import org.eclipse.persistence.tools.workbench.framework.app.ToolBarDescription;
import org.eclipse.persistence.tools.workbench.framework.context.ApplicationContext;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.scplugin.SCPlugin;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ReadConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ServerSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.WriteConnectionPoolAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.AddNewNamedPoolAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.AddReadPoolAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.AddSequencePoolAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.AddWritePoolAction;
import org.eclipse.persistence.tools.workbench.scplugin.ui.pool.PoolNode;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.DatabaseSessionNode;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemPropertyListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.SortedListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TransformationListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.TreeNodeValueModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.NullIterator;

public class ServerSessionNode
extends DatabaseSessionNode {
    private ListValueModel childrenModel;

    public ServerSessionNode(ServerSessionAdapter serverSessionAdapter, TreeNodeValueModel treeNodeValueModel, SCPlugin sCPlugin, ApplicationContext applicationContext) {
        super(serverSessionAdapter, treeNodeValueModel, sCPlugin, applicationContext);
    }

    protected void initialize() {
        super.initialize();
        this.childrenModel = this.buildChildrenModel();
    }

    public GroupContainerDescription buildMenuDescription(WorkbenchContext workbenchContext) {
        ComponentContainerDescription componentContainerDescription;
        WorkbenchContext workbenchContext2 = this.buildLocalWorkbenchContext(workbenchContext);
        RootMenuDescription rootMenuDescription = new RootMenuDescription();
        if (!this.serverSession().platformIsXml()) {
            componentContainerDescription = new MenuDescription(this.resourceRepository().getString("NEW_MENU"), this.resourceRepository().getString("NEW_MENU"), this.resourceRepository().getMnemonic("NEW_MENU"), EMPTY_ICON);
            MenuGroupDescription menuGroupDescription = new MenuGroupDescription();
            menuGroupDescription.add(this.getAddNamedPoolAction(workbenchContext2));
            menuGroupDescription.add(this.getAddSequencePoolAction(workbenchContext2));
            menuGroupDescription.add(this.getAddWritePoolAction(workbenchContext2));
            menuGroupDescription.add(this.getAddReadPoolAction(workbenchContext2));
            ((RootMenuDescription)componentContainerDescription).add(menuGroupDescription);
            MenuGroupDescription menuGroupDescription2 = new MenuGroupDescription();
            menuGroupDescription2.add((ComponentDescription)((Object)componentContainerDescription));
            rootMenuDescription.add(menuGroupDescription2);
        }
        componentContainerDescription = new MenuGroupDescription();
        ((MenuGroupDescription)componentContainerDescription).add(this.getRenameNodeAction(workbenchContext2));
        ((MenuGroupDescription)componentContainerDescription).add(this.getDeleteNodeAction(workbenchContext2));
        rootMenuDescription.add((ComponentGroupDescription)componentContainerDescription);
        rootMenuDescription.add(this.buildHelpMenuGroup(workbenchContext2));
        return rootMenuDescription;
    }

    public GroupContainerDescription buildToolBarDescription(WorkbenchContext workbenchContext) {
        WorkbenchContext workbenchContext2 = this.buildLocalWorkbenchContext(workbenchContext);
        ToolBarDescription toolBarDescription = new ToolBarDescription();
        if (!this.serverSession().platformIsXml()) {
            ToolBarButtonGroupDescription toolBarButtonGroupDescription = new ToolBarButtonGroupDescription();
            toolBarButtonGroupDescription.add(this.getAddNamedPoolAction(workbenchContext2));
            toolBarButtonGroupDescription.add(this.getAddSequencePoolAction(workbenchContext2));
            toolBarButtonGroupDescription.add(this.getAddWritePoolAction(workbenchContext2));
            toolBarButtonGroupDescription.add(this.getAddReadPoolAction(workbenchContext2));
            toolBarDescription.add(toolBarButtonGroupDescription);
        }
        return toolBarDescription;
    }

    protected ListValueModel buildChildrenModel() {
        return new SortedListValueModelAdapter(this.buildDisplayStringAdapter());
    }

    protected ListValueModel buildDisplayStringAdapter() {
        return new ItemPropertyListValueModelAdapter(this.buildChildrenNodeWrapper(), "displayString");
    }

    protected ListValueModel buildChildrenNodeWrapper() {
        return new TransformationListValueModelAdapter(this.buildChildrenAspectAdapter()){

            protected Object transformItem(Object object) {
                return ServerSessionNode.this.buildChildNode((ConnectionPoolAdapter)object);
            }
        };
    }

    protected PoolNode buildChildNode(ConnectionPoolAdapter connectionPoolAdapter) {
        if (connectionPoolAdapter instanceof ReadConnectionPoolAdapter) {
            return this.buildReadConnectionPoolNode();
        }
        if (connectionPoolAdapter instanceof WriteConnectionPoolAdapter) {
            return this.buildWriteConnectionPoolNode();
        }
        return new PoolNode(connectionPoolAdapter, (TreeNodeValueModel)this, this.getSCPlugin(), this.getApplicationContext());
    }

    protected CollectionValueModel buildChildrenAspectAdapter() {
        return new CollectionAspectAdapter(this, "pools"){

            protected Iterator getValueFromSubject() {
                ServerSessionAdapter serverSessionAdapter = (ServerSessionAdapter)this.subject;
                if (serverSessionAdapter.platformIsXml()) {
                    return NullIterator.instance();
                }
                Collection collection = CollectionTools.collection((Iterator)((ServerSessionAdapter)this.subject).pools());
                if (serverSessionAdapter.hasReadPool()) {
                    collection.add(serverSessionAdapter.getReadConnectionPool());
                }
                if (serverSessionAdapter.hasWritePool()) {
                    collection.add(serverSessionAdapter.getWriteConnectionPool());
                }
                if (serverSessionAdapter.hasSequencePool()) {
                    collection.add(serverSessionAdapter.getSequenceConnectionPool());
                }
                return collection.iterator();
            }

            protected int sizeFromSubject() {
                int n = ((ServerSessionAdapter)this.subject).hasReadPool() ? 1 : 0;
                int n2 = ((ServerSessionAdapter)this.subject).hasWritePool() ? 1 : 0;
                int n3 = ((ServerSessionAdapter)this.subject).hasSequencePool() ? 1 : 0;
                return ((ServerSessionAdapter)this.subject).poolsSize() + n + n2 + n3;
            }
        };
    }

    protected PoolNode buildReadConnectionPoolNode() {
        return new PoolNode(((ServerSessionAdapter)this.session()).getReadConnectionPool(), (TreeNodeValueModel)this, this.getSCPlugin(), this.getApplicationContext());
    }

    protected PoolNode buildWriteConnectionPoolNode() {
        return new PoolNode(((ServerSessionAdapter)this.session()).getWriteConnectionPool(), (TreeNodeValueModel)this, this.getSCPlugin(), this.getApplicationContext());
    }

    private FrameworkAction getAddNamedPoolAction(WorkbenchContext workbenchContext) {
        return new AddNewNamedPoolAction(workbenchContext);
    }

    private FrameworkAction getAddSequencePoolAction(WorkbenchContext workbenchContext) {
        return new AddSequencePoolAction(workbenchContext);
    }

    private FrameworkAction getAddWritePoolAction(WorkbenchContext workbenchContext) {
        return new AddWritePoolAction(workbenchContext);
    }

    private FrameworkAction getAddReadPoolAction(WorkbenchContext workbenchContext) {
        return new AddReadPoolAction(workbenchContext);
    }

    protected List buildDisplayStringPropertyNamesList() {
        List list = super.buildDisplayStringPropertyNamesList();
        list.add("name");
        return list;
    }

    public ListValueModel getChildrenModel() {
        return this.childrenModel;
    }

    public String helpTopicID() {
        return "navigator.session.server";
    }

    private ServerSessionAdapter serverSession() {
        return (ServerSessionAdapter)this.session();
    }
}

