/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic;

import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContextHolder;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.DatabaseSessionAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.model.adapter.ProjectAdapter;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.AbstractSessionMultipleProjectsPane;
import org.eclipse.persistence.tools.workbench.scplugin.ui.session.basic.ProjectTypeEditDialog;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.ObjectListSelectionModel;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;

final class SessionMultipleProjectsPane
extends AbstractSessionMultipleProjectsPane {
    SessionMultipleProjectsPane(ValueModel valueModel, WorkbenchContextHolder workbenchContextHolder) {
        super(valueModel, workbenchContextHolder);
    }

    protected void addProject(ObjectListSelectionModel objectListSelectionModel) {
        DatabaseSessionAdapter databaseSessionAdapter = (DatabaseSessionAdapter)this.subject();
        ProjectType projectType = new ProjectType(databaseSessionAdapter, objectListSelectionModel);
        ProjectTypeEditDialog projectTypeEditDialog = new ProjectTypeEditDialog(this.getWorkbenchContext(), this.resourceRepository().getString("PROJECT_TYPE_EDIT_DIALOG_TITLE_ADD"), databaseSessionAdapter, projectType, "session.project.advanced");
        projectTypeEditDialog.setVisible(true);
    }

    private class ProjectType
    extends AbstractModel
    implements ProjectTypeEditDialog.ProjectTypeUpdater {
        private DatabaseSessionAdapter databaseSession;
        private String projectName;
        private final ObjectListSelectionModel selectionModel;
        public static final String PROJECT_CLASS_PROPERTY = "projectClass";
        public static final String PROJECT_XML_PROPERTY = "projectXml";
        public static final String PROJECT_TYPE_XML_PROPERTY = "projectTypeXml";

        public ProjectType(DatabaseSessionAdapter databaseSessionAdapter, ObjectListSelectionModel objectListSelectionModel) {
            this.selectionModel = objectListSelectionModel;
            this.databaseSession = databaseSessionAdapter;
        }

        public void apply(boolean bl, String string) {
            if (string == null) {
                ProjectAdapter projectAdapter = (ProjectAdapter)((Object)this.selectionModel.getSelectedValue());
                this.databaseSession.removeProject(projectAdapter);
            } else if (bl) {
                if (CollectionTools.contains((Iterator)this.databaseSession.additionalProjectNames(), (Object)string)) {
                    ProjectAdapter projectAdapter = this.databaseSession.projectNamed(string);
                    this.selectionModel.setSelectedValue((Object)projectAdapter);
                } else {
                    this.databaseSession.addProjectXmlNamed(string);
                }
            } else {
                this.databaseSession.addProjectClassNamed(string);
            }
        }

        public String getProjectName() {
            return this.projectName;
        }

        public boolean isProjectXml() {
            return true;
        }
    }
}

