/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.scplugin.ui.session.login;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.text.Document;
import org.eclipse.persistence.tools.workbench.framework.context.WorkbenchContext;
import org.eclipse.persistence.tools.workbench.framework.resources.ResourceRepository;
import org.eclipse.persistence.tools.workbench.framework.ui.dialog.NewNameDialog;
import org.eclipse.persistence.tools.workbench.framework.uitools.SwingComponentFactory;
import org.eclipse.persistence.tools.workbench.scplugin.model.SequenceType;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyAspectAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.CheckBoxModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.swing.RadioButtonModelAdapter;
import org.eclipse.persistence.tools.workbench.utility.node.Problem;

final class NewSequenceDialog
extends NewNameDialog {
    private JCheckBox defaultSequenceCheckBox;
    private PropertyValueModel sequenceTypeHolder;
    private NewNameDialog.Builder builder;

    private NewSequenceDialog(WorkbenchContext workbenchContext, NewNameDialog.Builder builder) {
        super(workbenchContext, builder);
        this.builder = builder;
    }

    public static Insets groupBoxMargin() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder("m");
        Insets insets = titledBorder.getBorderInsets(new JPanel());
        insets.left += 5;
        insets.right += 5;
        insets.bottom += 5;
        return insets;
    }

    protected Component buildMainPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        JLabel jLabel = new JLabel(this.resourceRepository().getString("NEW_SEQUENCE_DIALOG_DESCRIPTION"));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        JComponent jComponent = this.buildNewNameWidgets();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)jComponent, gridBagConstraints);
        Component component = this.buildCustomPane();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add(component, gridBagConstraints);
        return jPanel;
    }

    protected JComponent buildNewNameWidgets() {
        Document document = this.buildDocumentWithStateObject();
        document.addDocumentListener(this.buildDocumentListener());
        this.textField = new JTextField(20);
        JComponent jComponent = this.buildLabeledTextField("NEW_SEQUENCE_DIALOG_NAME_LABEL", document, this.textField);
        jComponent.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        return jComponent;
    }

    protected void editName() {
        String string = this.textField.getText();
        if (this.builder.emptyNameIsIllegal() && string.length() == 0) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.EMPTY_VALUE");
            return;
        }
        boolean bl = this.namesMatch(string, this.builder.getOriginalName());
        if (this.builder.originalNameIsIllegal() && bl) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.ORIGINAL_VALUE");
            return;
        }
        if (this.nameIsAlreadyTaken(string, bl)) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.DUPLICATE_VALUE");
            return;
        }
        if (this.nameIsIllegal(string)) {
            this.setErrorMessageKey("NEW_NAME_DIALOG.ILLEGAL_VALUE");
            return;
        }
        this.clearErrorMessage();
    }

    protected Component buildCustomPane() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        Insets insets = NewSequenceDialog.groupBoxMargin();
        this.sequenceTypeHolder = this.buildSequenceTypeHolder();
        this.defaultSequenceCheckBox = SwingComponentFactory.buildCheckBox("NEW_SEQUENCE_DIALOG_DEFAULT_SEQUENCE_CHECK_BOX", this.buildDefaultSequenceCheckBoxModel(), this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, insets.left, 0, insets.right);
        jPanel.add((Component)this.defaultSequenceCheckBox, gridBagConstraints);
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.setBorder(SwingComponentFactory.buildPaneTitledBorder("NEW_SEQUENCE_DIALOG_SEQUENCE_TYPE_GROUP_BOX", this.resourceRepository()));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 19;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        JRadioButton jRadioButton = SwingComponentFactory.buildRadioButton("NEW_SEQUENCE_DIALOG_DEFAULT_RADIO_BUTTON", this.buildDefaultRadioButtonModel(this.sequenceTypeHolder), this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel2.add((Component)jRadioButton, gridBagConstraints);
        JRadioButton jRadioButton2 = SwingComponentFactory.buildRadioButton("NEW_SEQUENCE_DIALOG_NATIVE_RADIO_BUTTON", this.buildNativeRadioButtonModel(this.sequenceTypeHolder), this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel2.add((Component)jRadioButton2, gridBagConstraints);
        JRadioButton jRadioButton3 = SwingComponentFactory.buildRadioButton("NEW_SEQUENCE_DIALOG_TABLE_RADIO_BUTTON", this.buildTableRadioButtonModel(this.sequenceTypeHolder), this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel2.add((Component)jRadioButton3, gridBagConstraints);
        JRadioButton jRadioButton4 = SwingComponentFactory.buildRadioButton("NEW_SEQUENCE_DIALOG_UNARY_TABLE_RADIO_BUTTON", this.buildUnaryTableRadioButtonModel(this.sequenceTypeHolder), this.resourceRepository());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 21;
        gridBagConstraints.insets = new Insets(0, 0, 0, 20);
        jPanel2.add((Component)jRadioButton4, gridBagConstraints);
        return jPanel;
    }

    private ButtonModel buildDefaultRadioButtonModel(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, (Object)SequenceType.DEFAULT);
    }

    private ButtonModel buildDefaultSequenceCheckBoxModel() {
        return new CheckBoxModelAdapter(this.buildDefaultSequenceHolder());
    }

    private PropertyValueModel buildDefaultSequenceHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "defaultSequence"){

            protected Object getValueFromSubject() {
                SequenceStateObject sequenceStateObject = (SequenceStateObject)((Object)this.subject);
                return sequenceStateObject.isDefaultSequence();
            }

            protected void setValueOnSubject(Object object) {
                SequenceStateObject sequenceStateObject = (SequenceStateObject)((Object)this.subject);
                sequenceStateObject.setDefaultSequence((Boolean)object);
            }
        };
    }

    private ButtonModel buildNativeRadioButtonModel(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, (Object)SequenceType.NATIVE);
    }

    private PropertyValueModel buildSequenceTypeHolder() {
        return new PropertyAspectAdapter(this.getSubjectHolder(), "sequenceType"){

            protected Object getValueFromSubject() {
                SequenceStateObject sequenceStateObject = (SequenceStateObject)((Object)this.subject);
                return sequenceStateObject.getSequenceType();
            }

            protected void setValueOnSubject(Object object) {
                SequenceStateObject sequenceStateObject = (SequenceStateObject)((Object)this.subject);
                sequenceStateObject.setSequenceType((SequenceType)((Object)object));
            }
        };
    }

    private ButtonModel buildTableRadioButtonModel(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, (Object)SequenceType.TABLE);
    }

    private ButtonModel buildUnaryTableRadioButtonModel(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, (Object)SequenceType.UNARY_TABLE);
    }

    private ButtonModel buildXMLFileRadioButtonModel(PropertyValueModel propertyValueModel) {
        return new RadioButtonModelAdapter(propertyValueModel, (Object)SequenceType.XML_FILE);
    }

    protected String helpTopicId() {
        return "dialog.newSequence";
    }

    protected void initialize() {
        super.initialize();
        this.setResizable(false);
    }

    protected void prepareToShow() {
        super.prepareToShow();
        this.getOKAction().setEnabled(false);
    }

    protected NewNameDialog.StateObject buildStateObject() {
        return new SequenceStateObject(this.getBuilder());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class SequenceStateObject
    extends NewNameDialog.StateObject {
        private boolean defaultSequence;
        private SequenceType sequenceType;
        static final String DEFAULT_SEQUENCE_PROPERTY = "defaultSequence";
        static final String SEQUENCE_TYPE_PROPERTY = "sequenceType";

        SequenceStateObject(NewNameDialog.Builder builder) {
            super(builder);
        }

        @Override
        protected void editName(List<Problem> list) {
            if (!this.defaultSequence) {
                super.editName(list);
            }
        }

        SequenceType getSequenceType() {
            return this.sequenceType;
        }

        protected void initialize() {
            super.initialize();
            this.sequenceType = SequenceType.DEFAULT;
        }

        boolean isDefaultSequence() {
            return this.defaultSequence;
        }

        void setDefaultSequence(boolean bl) {
            boolean bl2 = this.defaultSequence;
            this.defaultSequence = bl;
            this.firePropertyChanged(DEFAULT_SEQUENCE_PROPERTY, bl2, bl);
        }

        void setSequenceType(SequenceType sequenceType) {
            SequenceType sequenceType2 = this.sequenceType;
            this.sequenceType = sequenceType;
            this.firePropertyChanged(SEQUENCE_TYPE_PROPERTY, (Object)sequenceType2, (Object)sequenceType);
        }
    }

    static final class NewSequenceBuilder
    extends NewNameDialog.Builder {
        NewSequenceBuilder(ResourceRepository resourceRepository) {
            this.setTitle(resourceRepository.getString("NEW_SEQUENCE_DIALOG_TITLE"));
            this.setTextFieldDescription(resourceRepository.getString("NEW_SEQUENCE_DIALOG_DESCRIPTION"));
        }

        public NewSequenceDialog buildDialog(WorkbenchContext workbenchContext) {
            return (NewSequenceDialog)super.buildDialog(workbenchContext);
        }

        protected NewSequenceDialog buildDialog(WorkbenchContext workbenchContext, NewNameDialog.Builder builder) {
            return new NewSequenceDialog(workbenchContext, builder);
        }
    }
}

