/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ValueModelChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.AbstractModel;
import org.eclipse.persistence.tools.workbench.utility.events.ChangeSupport;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.CollectionChangeListener;

public abstract class CollectionValueModelWrapper
extends AbstractModel
implements CollectionValueModel {
    protected CollectionValueModel collectionHolder;
    protected CollectionChangeListener collectionChangeListener;

    protected CollectionValueModelWrapper(CollectionValueModel collectionValueModel) {
        this.collectionHolder = collectionValueModel;
    }

    protected void initialize() {
        super.initialize();
        this.collectionChangeListener = this.buildCollectionChangeListener();
    }

    protected ChangeSupport buildDefaultChangeSupport() {
        return new ValueModelChangeSupport(this);
    }

    protected CollectionChangeListener buildCollectionChangeListener() {
        return new CollectionChangeListener(){

            public void itemsAdded(CollectionChangeEvent collectionChangeEvent) {
                CollectionValueModelWrapper.this.itemsAdded(collectionChangeEvent);
            }

            public void itemsRemoved(CollectionChangeEvent collectionChangeEvent) {
                CollectionValueModelWrapper.this.itemsRemoved(collectionChangeEvent);
            }

            public void collectionChanged(CollectionChangeEvent collectionChangeEvent) {
                CollectionValueModelWrapper.this.collectionChanged(collectionChangeEvent);
            }

            public String toString() {
                return "collection change listener";
            }
        };
    }

    public synchronized void addCollectionChangeListener(CollectionChangeListener collectionChangeListener) {
        if (this.hasNoCollectionChangeListeners("value")) {
            this.engageModel();
        }
        super.addCollectionChangeListener(collectionChangeListener);
    }

    public synchronized void addCollectionChangeListener(String string, CollectionChangeListener collectionChangeListener) {
        if (string == "value" && this.hasNoCollectionChangeListeners("value")) {
            this.engageModel();
        }
        super.addCollectionChangeListener(string, collectionChangeListener);
    }

    public synchronized void removeCollectionChangeListener(CollectionChangeListener collectionChangeListener) {
        super.removeCollectionChangeListener(collectionChangeListener);
        if (this.hasNoCollectionChangeListeners("value")) {
            this.disengageModel();
        }
    }

    public synchronized void removeCollectionChangeListener(String string, CollectionChangeListener collectionChangeListener) {
        super.removeCollectionChangeListener(string, collectionChangeListener);
        if (string == "value" && this.hasNoCollectionChangeListeners("value")) {
            this.disengageModel();
        }
    }

    public void addItem(Object object) {
        throw new UnsupportedOperationException();
    }

    public void addItems(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addItem(iterator.next());
        }
    }

    public void removeItem(Object object) {
        throw new UnsupportedOperationException();
    }

    public void removeItems(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.removeItem(iterator.next());
        }
    }

    protected void engageModel() {
        this.collectionHolder.addCollectionChangeListener("value", this.collectionChangeListener);
    }

    protected void disengageModel() {
        this.collectionHolder.removeCollectionChangeListener("value", this.collectionChangeListener);
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.collectionHolder);
    }

    protected abstract void itemsAdded(CollectionChangeEvent var1);

    protected abstract void itemsRemoved(CollectionChangeEvent var1);

    protected abstract void collectionChanged(CollectionChangeEvent var1);
}

