/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app;

import java.util.Arrays;
import java.util.EventObject;
import org.eclipse.persistence.tools.workbench.uitools.app.CollectionValueModel;
import org.eclipse.persistence.tools.workbench.uitools.app.ItemAspectListValueModelAdapter;
import org.eclipse.persistence.tools.workbench.uitools.app.ListValueModel;
import org.eclipse.persistence.tools.workbench.utility.Model;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeEvent;
import org.eclipse.persistence.tools.workbench.utility.events.ListChangeListener;

public class ItemListListValueModelAdapter
extends ItemAspectListValueModelAdapter {
    protected final String[] listNames;
    protected ListChangeListener itemListListener;

    public ItemListListValueModelAdapter(ListValueModel listValueModel, String string) {
        this(listValueModel, new String[]{string});
    }

    public ItemListListValueModelAdapter(ListValueModel listValueModel, String string, String string2) {
        this(listValueModel, new String[]{string, string2});
    }

    public ItemListListValueModelAdapter(ListValueModel listValueModel, String string, String string2, String string3) {
        this(listValueModel, new String[]{string, string2, string3});
    }

    public ItemListListValueModelAdapter(ListValueModel listValueModel, String[] stringArray) {
        super(listValueModel);
        this.listNames = stringArray;
    }

    public ItemListListValueModelAdapter(CollectionValueModel collectionValueModel, String string) {
        this(collectionValueModel, new String[]{string});
    }

    public ItemListListValueModelAdapter(CollectionValueModel collectionValueModel, String string, String string2) {
        this(collectionValueModel, new String[]{string, string2});
    }

    public ItemListListValueModelAdapter(CollectionValueModel collectionValueModel, String string, String string2, String string3) {
        this(collectionValueModel, new String[]{string, string2, string3});
    }

    public ItemListListValueModelAdapter(CollectionValueModel collectionValueModel, String[] stringArray) {
        super(collectionValueModel);
        this.listNames = stringArray;
    }

    protected void initialize() {
        super.initialize();
        this.itemListListener = this.buildItemListListener();
    }

    protected ListChangeListener buildItemListListener() {
        return new ListChangeListener(){

            public void itemsAdded(ListChangeEvent listChangeEvent) {
                ItemListListValueModelAdapter.this.itemAspectChanged((EventObject)listChangeEvent);
            }

            public void itemsRemoved(ListChangeEvent listChangeEvent) {
                ItemListListValueModelAdapter.this.itemAspectChanged((EventObject)listChangeEvent);
            }

            public void itemsReplaced(ListChangeEvent listChangeEvent) {
                ItemListListValueModelAdapter.this.itemAspectChanged((EventObject)listChangeEvent);
            }

            public void listChanged(ListChangeEvent listChangeEvent) {
                ItemListListValueModelAdapter.this.itemAspectChanged((EventObject)listChangeEvent);
            }

            public String toString() {
                return "item list listener: " + Arrays.asList(ItemListListValueModelAdapter.this.listNames);
            }
        };
    }

    protected void startListeningToItem(Model model) {
        int n = this.listNames.length;
        while (n-- > 0) {
            model.addListChangeListener(this.listNames[n], this.itemListListener);
        }
    }

    protected void stopListeningToItem(Model model) {
        int n = this.listNames.length;
        while (n-- > 0) {
            model.removeListChangeListener(this.listNames[n], this.itemListListener);
        }
    }
}

