/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.app.swing;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractSpinnerModel;
import javax.swing.SpinnerModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.eclipse.persistence.tools.workbench.uitools.app.PropertyValueModel;
import org.eclipse.persistence.tools.workbench.utility.string.StringTools;

public class SpinnerModelAdapter
extends AbstractSpinnerModel {
    protected SpinnerModel delegate;
    protected ChangeListener delegateListener;
    protected PropertyValueModel valueHolder;
    protected PropertyChangeListener valueListener;

    private SpinnerModelAdapter() {
        this.initialize();
    }

    public SpinnerModelAdapter(PropertyValueModel propertyValueModel, SpinnerModel spinnerModel) {
        this();
        if (propertyValueModel == null || spinnerModel == null) {
            throw new NullPointerException();
        }
        this.valueHolder = propertyValueModel;
        this.delegate = spinnerModel;
    }

    public SpinnerModelAdapter(PropertyValueModel propertyValueModel) {
        this(propertyValueModel, new SpinnerNumberModel());
    }

    protected void initialize() {
        this.valueListener = this.buildValueListener();
        this.delegateListener = this.buildDelegateListener();
    }

    protected PropertyChangeListener buildValueListener() {
        return new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SpinnerModelAdapter.this.valueChanged(propertyChangeEvent);
            }

            public String toString() {
                return "value listener";
            }
        };
    }

    protected void fireStateChanged() {
        super.fireStateChanged();
    }

    protected ChangeListener buildDelegateListener() {
        return new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SpinnerModelAdapter.this.fireStateChanged();
            }

            public String toString() {
                return "delegate listener";
            }
        };
    }

    public Object getValue() {
        return this.delegate.getValue();
    }

    public void setValue(Object object) {
        this.delegate.setValue(object);
        this.valueHolder.setValue(object);
    }

    public Object getNextValue() {
        return this.delegate.getNextValue();
    }

    public Object getPreviousValue() {
        return this.delegate.getPreviousValue();
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.listenerList.getListenerCount(ChangeListener.class) == 0) {
            this.delegate.addChangeListener(this.delegateListener);
            this.engageValueHolder();
        }
        super.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        super.removeChangeListener(changeListener);
        if (this.listenerList.getListenerCount(ChangeListener.class) == 0) {
            this.disengageValueHolder();
            this.delegate.removeChangeListener(this.delegateListener);
        }
    }

    protected void valueChanged(PropertyChangeEvent propertyChangeEvent) {
        this.synchronizeDelegate(propertyChangeEvent.getNewValue());
    }

    protected void synchronizeDelegate(Object object) {
        if (!this.delegate.getValue().equals(object)) {
            this.delegate.setValue(object);
        }
    }

    protected void engageValueHolder() {
        this.valueHolder.addPropertyChangeListener("value", this.valueListener);
        this.synchronizeDelegate(this.valueHolder.getValue());
    }

    protected void disengageValueHolder() {
        this.valueHolder.removePropertyChangeListener("value", this.valueListener);
    }

    public String toString() {
        return StringTools.buildToStringFor((Object)this, (Object)this.valueHolder);
    }
}

