/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.uitools.swing;

import java.awt.Component;
import java.awt.Dimension;
import javax.accessibility.AccessibleContext;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.basic.ComboPopup;
import org.eclipse.persistence.tools.workbench.uitools.cell.CellRendererAdapter;
import org.eclipse.persistence.tools.workbench.uitools.swing.ComboCellRenderer;
import org.eclipse.persistence.tools.workbench.uitools.swing.EmptyIcon;

public class Combo
extends JComboBox {
    private CellRendererAdapter cellRendererAdapter;
    public static final Component PROTOTYPE_DISPLAY_VALUE = Combo.buildPrototypeDisplayValue();

    public Combo() {
    }

    public Combo(ComboBoxModel comboBoxModel) {
        super(comboBoxModel);
    }

    private static Component buildPrototypeDisplayValue() {
        String string = "item";
        JComboBox<String> jComboBox = new JComboBox<String>();
        jComboBox.addItem(string);
        ComboPopup comboPopup = (ComboPopup)((Object)jComboBox.getUI().getAccessibleChild(jComboBox, 0));
        ListCellRenderer<String> listCellRenderer = jComboBox.getRenderer();
        JLabel jLabel = (JLabel)listCellRenderer.getListCellRendererComponent(comboPopup.getList(), string, 0, true, true);
        jLabel.setIcon(EmptyIcon.SMALL_ICON);
        return jLabel;
    }

    private ListCellRenderer buildCellRenderer(CellRendererAdapter cellRendererAdapter) {
        return new ComboCellRenderer(this.getRenderer(), cellRendererAdapter, PROTOTYPE_DISPLAY_VALUE);
    }

    public void configureEditor(ComboBoxEditor comboBoxEditor, Object object) {
    }

    public final void fixSize() {
        Object e = this.getPrototypeDisplayValue();
        this.setPrototypeDisplayValue(null);
        Dimension dimension = this.getPreferredSize();
        dimension.width = Math.max(dimension.width + 20, 100);
        this.setPreferredSize(dimension);
        this.setPrototypeDisplayValue(e);
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleCombo();
        }
        return this.accessibleContext;
    }

    final JList popupList() {
        ComboPopup comboPopup = (ComboPopup)((Object)this.getAccessibleContext().getAccessibleChild(0));
        return comboPopup.getList();
    }

    public void setEnabled(boolean bl) {
        this.popupList().setEnabled(bl);
        super.setEnabled(bl);
    }

    public final void setRendererAdapter(CellRendererAdapter cellRendererAdapter) {
        if (this.cellRendererAdapter != cellRendererAdapter) {
            this.cellRendererAdapter = cellRendererAdapter;
            this.setPrototypeDisplayValue(PROTOTYPE_DISPLAY_VALUE);
            this.setRenderer(this.buildCellRenderer(cellRendererAdapter));
            if (this.isPreferredSizeSet()) {
                this.fixSize();
            }
        }
    }

    public void updateUI() {
        super.updateUI();
        if (this.cellRendererAdapter != null) {
            this.setRenderer(this.buildCellRenderer(this.cellRendererAdapter));
        }
    }

    protected class AccessibleCombo
    extends JComboBox.AccessibleJComboBox {
        protected AccessibleCombo() {
            super(Combo.this);
        }
    }
}

