/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.classes;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Iterator;
import javax.persistence.Basic;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import javax.persistence.Version;
import org.eclipse.persistence.annotations.BasicCollection;
import org.eclipse.persistence.annotations.BasicMap;
import org.eclipse.persistence.annotations.ChangeTracking;
import org.eclipse.persistence.annotations.CloneCopyPolicy;
import org.eclipse.persistence.annotations.CopyPolicy;
import org.eclipse.persistence.annotations.Customizer;
import org.eclipse.persistence.annotations.InstantiationCopyPolicy;
import org.eclipse.persistence.annotations.Properties;
import org.eclipse.persistence.annotations.Property;
import org.eclipse.persistence.annotations.Transformation;
import org.eclipse.persistence.annotations.VariableOneToOne;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.MetadataProject;
import org.eclipse.persistence.internal.jpa.metadata.ORMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.MetadataAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.PropertyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.XMLAttributes;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicCollectionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.BasicMapAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.EmbeddedIdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.IdAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ManyToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.ManyToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MappingAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.OneToManyAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.OneToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.TransformationAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.VariableOneToOneAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.VersionAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAnnotatedElement;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataClass;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataField;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataMethod;
import org.eclipse.persistence.internal.jpa.metadata.changetracking.ChangeTrackingMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CloneCopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.CustomCopyPolicyMetadata;
import org.eclipse.persistence.internal.jpa.metadata.copypolicy.InstantiationCopyPolicyMetadata;

public abstract class ClassAccessor
extends MetadataAccessor {
    private Boolean m_excludeDefaultMappings;
    private Boolean m_metadataComplete;
    private ChangeTrackingMetadata m_changeTracking;
    private Class m_customizerClass;
    private CloneCopyPolicyMetadata m_cloneCopyPolicy;
    private CustomCopyPolicyMetadata m_customCopyPolicy;
    private InstantiationCopyPolicyMetadata m_instantiationCopyPolicy;
    private String m_className;
    private String m_customizerClassName;
    private String m_description;
    private XMLAttributes m_attributes;

    protected ClassAccessor(String string) {
        super(string);
    }

    public ClassAccessor(Annotation annotation, Class clazz, MetadataProject metadataProject) {
        super(annotation, new MetadataClass(clazz), new MetadataDescriptor(clazz), metadataProject);
        this.getDescriptor().setClassAccessor(this);
    }

    protected ClassAccessor(Annotation annotation, Class clazz, MetadataDescriptor metadataDescriptor) {
        super(annotation, new MetadataClass(clazz), metadataDescriptor, metadataDescriptor.getProject());
    }

    public void addAccessors() {
        if (this.m_attributes != null) {
            for (MappingAccessor mappingAccessor : this.m_attributes.getAccessors()) {
                Object object;
                Object object2;
                Object object3 = null;
                mappingAccessor.initXMLMappingAccessor(this);
                if (mappingAccessor.usesPropertyAccess(this.getDescriptor())) {
                    if (mappingAccessor.getAccessMethods() != null) {
                        object2 = mappingAccessor.getAccessMethods().getGetMethodName();
                        object = MetadataHelper.getMethod((String)object2, this.getJavaClass(), new Class[0]);
                        String string = mappingAccessor.getAccessMethods().getSetMethodName();
                        Method method = MetadataHelper.getMethod(string, this.getJavaClass(), new Class[]{((Method)object).getReturnType()});
                        object3 = new MetadataMethod((Method)object, method, mappingAccessor.getName(), this.getEntityMappings());
                    } else {
                        object2 = MetadataHelper.getMethodForPropertyName(mappingAccessor.getName(), this.getJavaClass());
                        if (object2 == null) {
                            throw ValidationException.invalidPropertyForClass((String)mappingAccessor.getName(), (Class)this.getJavaClass());
                        }
                        object = new MetadataMethod((Method)object2, this.getEntityMappings());
                        if (mappingAccessor.isTransient() || ((MetadataMethod)object).isValidPersistenceMethod(this.getDescriptor(), true)) {
                            object3 = object;
                        }
                    }
                } else {
                    object2 = MetadataHelper.getFieldForName(mappingAccessor.getName(), this.getJavaClass());
                    if (object2 == null) {
                        throw ValidationException.invalidFieldForClass((String)mappingAccessor.getName(), (Class)this.getJavaClass());
                    }
                    object = new MetadataField((Field)object2, this.getEntityMappings());
                    if (mappingAccessor.isTransient() || ((MetadataField)object).isValidPersistenceField(this.getDescriptor(), true)) {
                        object3 = object;
                    }
                }
                mappingAccessor.initXMLObject((MetadataAccessibleObject)object3);
                mappingAccessor.initAccess();
                this.getDescriptor().addAccessor(mappingAccessor);
            }
        }
        if (this.usesPropertyAccess()) {
            this.processAccessorMethods(false);
        } else {
            this.processAccessorFields(false);
        }
    }

    protected MappingAccessor buildAccessor(MetadataAnnotatedElement metadataAnnotatedElement) {
        if (metadataAnnotatedElement.isBasicCollection(this.getDescriptor())) {
            return new BasicCollectionAccessor((Annotation)metadataAnnotatedElement.getAnnotation(BasicCollection.class), metadataAnnotatedElement, this);
        }
        if (metadataAnnotatedElement.isBasicMap(this.getDescriptor())) {
            return new BasicMapAccessor((Annotation)metadataAnnotatedElement.getAnnotation(BasicMap.class), metadataAnnotatedElement, this);
        }
        if (metadataAnnotatedElement.isId(this.getDescriptor())) {
            return new IdAccessor((Annotation)metadataAnnotatedElement.getAnnotation(Id.class), metadataAnnotatedElement, this);
        }
        if (metadataAnnotatedElement.isVersion(this.getDescriptor())) {
            return new VersionAccessor((Annotation)metadataAnnotatedElement.getAnnotation(Version.class), metadataAnnotatedElement, this);
        }
        if (metadataAnnotatedElement.isBasic(this.getDescriptor())) {
            return new BasicAccessor((Annotation)metadataAnnotatedElement.getAnnotation(Basic.class), metadataAnnotatedElement, this);
        }
        if (metadataAnnotatedElement.isEmbedded(this.getDescriptor())) {
            return new EmbeddedAccessor((Annotation)metadataAnnotatedElement.getAnnotation(Embedded.class), metadataAnnotatedElement, this);
        }
        if (metadataAnnotatedElement.isEmbeddedId(this.getDescriptor())) {
            return new EmbeddedIdAccessor((Annotation)metadataAnnotatedElement.getAnnotation(EmbeddedId.class), metadataAnnotatedElement, this);
        }
        if (metadataAnnotatedElement.isTransformation(this.getDescriptor())) {
            return new TransformationAccessor((Annotation)metadataAnnotatedElement.getAnnotation(Transformation.class), metadataAnnotatedElement, this);
        }
        if (metadataAnnotatedElement.isManyToMany(this.getDescriptor())) {
            return new ManyToManyAccessor((Annotation)metadataAnnotatedElement.getAnnotation(ManyToMany.class), metadataAnnotatedElement, this);
        }
        if (metadataAnnotatedElement.isManyToOne(this.getDescriptor())) {
            return new ManyToOneAccessor((Annotation)metadataAnnotatedElement.getAnnotation(ManyToOne.class), metadataAnnotatedElement, this);
        }
        if (metadataAnnotatedElement.isOneToMany(this.getDescriptor())) {
            return new OneToManyAccessor((Annotation)metadataAnnotatedElement.getAnnotation(OneToMany.class), metadataAnnotatedElement, this);
        }
        if (metadataAnnotatedElement.isOneToOne(this.getDescriptor())) {
            return new OneToOneAccessor((Annotation)metadataAnnotatedElement.getAnnotation(OneToOne.class), metadataAnnotatedElement, this);
        }
        if (metadataAnnotatedElement.isVariableOneToOne(this.getDescriptor())) {
            return new VariableOneToOneAccessor((Annotation)metadataAnnotatedElement.getAnnotation(VariableOneToOne.class), metadataAnnotatedElement, this);
        }
        if (this.getDescriptor().ignoreDefaultMappings()) {
            return null;
        }
        return new BasicAccessor((Annotation)metadataAnnotatedElement.getAnnotation(Basic.class), metadataAnnotatedElement, this);
    }

    public boolean excludeDefaultMappings() {
        return this.m_excludeDefaultMappings != null && this.m_excludeDefaultMappings != false;
    }

    public String getAccessType() {
        if (this.hasAccess()) {
            return super.getAccess();
        }
        return this.getDescriptor().getDefaultAccess();
    }

    public XMLAttributes getAttributes() {
        return this.m_attributes;
    }

    public ChangeTrackingMetadata getChangeTracking() {
        return this.m_changeTracking;
    }

    public String getClassName() {
        return this.m_className;
    }

    public CopyPolicyMetadata getCopyPolicy() {
        if (this.m_cloneCopyPolicy != null) {
            return this.m_cloneCopyPolicy;
        }
        if (this.m_instantiationCopyPolicy != null) {
            return this.m_instantiationCopyPolicy;
        }
        return this.m_customCopyPolicy;
    }

    public CloneCopyPolicyMetadata getCloneCopyPolicy() {
        return this.m_cloneCopyPolicy;
    }

    public CustomCopyPolicyMetadata getCustomCopyPolicy() {
        return this.m_customCopyPolicy;
    }

    public Class getCustomizerClass() {
        return this.m_customizerClass;
    }

    public String getCustomizerClassName() {
        return this.m_customizerClassName;
    }

    public String getDescription() {
        return this.m_description;
    }

    public Boolean getExcludeDefaultMappings() {
        return this.m_excludeDefaultMappings;
    }

    public String getIdentifier() {
        return this.getJavaClassName();
    }

    public InstantiationCopyPolicyMetadata getInstantiationCopyPolicy() {
        return this.m_instantiationCopyPolicy;
    }

    public Class getJavaClass() {
        return (Class)this.getAnnotatedElement();
    }

    public String getJavaClassName() {
        return this.getJavaClass().getName();
    }

    public Boolean getMetadataComplete() {
        return this.m_metadataComplete;
    }

    public boolean isMetadataComplete() {
        return this.m_metadataComplete != null && this.m_metadataComplete != false;
    }

    protected boolean havePersistenceAnnotationsDefined(Field[] fieldArray) {
        for (Field field : fieldArray) {
            MetadataField metadataField = new MetadataField(field, this.getLogger());
            if (!metadataField.hasDeclaredAnnotations(this.getDescriptor())) continue;
            return true;
        }
        return false;
    }

    protected boolean havePersistenceAnnotationsDefined(Method[] methodArray) {
        for (Method method : methodArray) {
            MetadataMethod metadataMethod = new MetadataMethod(method, this.getLogger());
            if (!metadataMethod.hasDeclaredAnnotations(this.getDescriptor())) continue;
            return true;
        }
        return false;
    }

    public void initXMLClassAccessor(MetadataAccessibleObject metadataAccessibleObject, MetadataDescriptor metadataDescriptor, MetadataProject metadataProject) {
        this.initXMLAccessor(metadataDescriptor, metadataProject);
        this.initXMLObject(metadataAccessibleObject);
        this.initAccess();
    }

    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObject(this.m_changeTracking, metadataAccessibleObject);
        this.initXMLObject(this.m_cloneCopyPolicy, metadataAccessibleObject);
        this.initXMLObject(this.m_customCopyPolicy, metadataAccessibleObject);
        this.initXMLObject(this.m_instantiationCopyPolicy, metadataAccessibleObject);
        this.initXMLObject(this.m_attributes, metadataAccessibleObject);
        this.m_customizerClass = this.initXMLClassName(this.m_customizerClassName);
    }

    public boolean isClassAccessor() {
        return true;
    }

    public void merge(ORMetadata oRMetadata) {
        super.merge(oRMetadata);
        ClassAccessor classAccessor = (ClassAccessor)oRMetadata;
        this.m_customizerClass = (Class)this.mergeSimpleObjects(this.m_customizerClass, classAccessor.getCustomizerClass(), classAccessor.getAccessibleObject(), "<customizer>");
        this.m_description = (String)this.mergeSimpleObjects(this.m_description, classAccessor.getDescription(), classAccessor.getAccessibleObject(), "<description>");
        this.m_metadataComplete = (Boolean)this.mergeSimpleObjects(this.m_metadataComplete, classAccessor.getMetadataComplete(), classAccessor.getAccessibleObject(), "@metadata-complete");
        this.m_excludeDefaultMappings = (Boolean)this.mergeSimpleObjects(this.m_excludeDefaultMappings, classAccessor.getExcludeDefaultMappings(), classAccessor.getAccessibleObject(), "@exclude-default-mappings");
        this.m_cloneCopyPolicy = (CloneCopyPolicyMetadata)this.mergeORObjects(this.m_cloneCopyPolicy, classAccessor.getCloneCopyPolicy());
        this.m_customCopyPolicy = (CustomCopyPolicyMetadata)this.mergeORObjects(this.m_customCopyPolicy, classAccessor.getCustomCopyPolicy());
        this.m_instantiationCopyPolicy = (InstantiationCopyPolicyMetadata)this.mergeORObjects(this.m_instantiationCopyPolicy, classAccessor.getInstantiationCopyPolicy());
        this.m_changeTracking = (ChangeTrackingMetadata)this.mergeORObjects(this.m_changeTracking, classAccessor.getChangeTracking());
        if (this.m_attributes == null) {
            this.m_attributes = classAccessor.getAttributes();
        } else {
            this.m_attributes.merge(classAccessor.getAttributes());
        }
    }

    public abstract void process();

    protected void processAccessorFields(boolean bl) {
        for (Field field : MetadataHelper.getFields(this.getJavaClass())) {
            MetadataField metadataField = new MetadataField(field, this.getLogger());
            if (metadataField.isAnnotationPresent(Transient.class)) {
                if (!metadataField.hasMoreThanOneDeclaredAnnotation(this.getDescriptor())) continue;
                throw ValidationException.mappingAnnotationsAppliedToTransientAttribute((Object)field);
            }
            if (!metadataField.isValidPersistenceField(bl, this.getDescriptor()) || this.getDescriptor().hasAccessorFor(metadataField.getAttributeName()) && (!this.getDescriptor().hasAccessorFor(metadataField.getAttributeName()) || !bl)) continue;
            this.getDescriptor().addAccessor(this.buildAccessor(metadataField));
        }
        if (this.hasAccess() && !bl) {
            this.processAccessorMethods(true);
        }
    }

    protected void processAccessorMethods(boolean bl) {
        for (Method method : MetadataHelper.getDeclaredMethods(this.getJavaClass())) {
            MetadataMethod metadataMethod = new MetadataMethod(method, this.getLogger());
            if (metadataMethod.isAnnotationPresent(Transient.class)) {
                if (!metadataMethod.hasMoreThanOneDeclaredAnnotation(this.getDescriptor())) continue;
                throw ValidationException.mappingAnnotationsAppliedToTransientAttribute((Object)method);
            }
            if (!metadataMethod.isValidPersistenceMethod(bl, this.getDescriptor()) || this.getDescriptor().hasAccessorFor(metadataMethod.getAttributeName()) && (!this.getDescriptor().hasAccessorFor(metadataMethod.getAttributeName()) || !bl)) continue;
            this.getDescriptor().addAccessor(this.buildAccessor(metadataMethod));
        }
        if (this.hasAccess() && !bl) {
            this.processAccessorFields(true);
        }
    }

    protected void processAccessors() {
        this.addAccessors();
        this.getDescriptor().processAccessors(this.getOwningDescriptor());
    }

    protected void processChangeTracking() {
        Object t = this.getAnnotation(ChangeTracking.class);
        if (this.m_changeTracking != null || t != null) {
            if (this.getDescriptor().hasChangeTracking()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_change_tracking", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else if (this.m_changeTracking == null) {
                new ChangeTrackingMetadata((Annotation)t, this.getAccessibleObject()).process(this.getDescriptor());
            } else {
                if (t != null) {
                    this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", t, this.getJavaClassName(), this.getLocation());
                }
                this.m_changeTracking.process(this.getDescriptor());
            }
        }
    }

    protected void processCopyPolicy() {
        Object t = this.getAnnotation(CopyPolicy.class);
        Object t2 = this.getAnnotation(InstantiationCopyPolicy.class);
        Object t3 = this.getAnnotation(CloneCopyPolicy.class);
        if (this.getCopyPolicy() != null || t != null || t2 != null || t3 != null) {
            if (this.getDescriptor().hasCopyPolicy()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_copy_policy", this.getDescriptor().getJavaClass(), this.getJavaClass());
            }
            if (this.getCopyPolicy() == null) {
                if (t != null) {
                    if (t2 != null || t3 != null) {
                        throw ValidationException.multipleCopyPolicyAnnotationsOnSameClass((String)this.getJavaClassName());
                    }
                    new CustomCopyPolicyMetadata((Annotation)t, this.getAccessibleObject()).process(this.getDescriptor());
                }
                if (t2 != null) {
                    if (t3 != null) {
                        throw ValidationException.multipleCopyPolicyAnnotationsOnSameClass((String)this.getJavaClassName());
                    }
                    new InstantiationCopyPolicyMetadata((Annotation)t2, this.getAccessibleObject()).process(this.getDescriptor());
                }
                if (t3 != null) {
                    new CloneCopyPolicyMetadata((Annotation)t3, this.getAccessibleObject()).process(this.getDescriptor());
                }
            } else {
                if (t != null) {
                    this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", t, this.getJavaClassName(), this.getLocation());
                }
                if (t2 != null) {
                    this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", t2, this.getJavaClassName(), this.getLocation());
                }
                if (t3 != null) {
                    this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", t3, this.getJavaClassName(), this.getLocation());
                }
                this.getCopyPolicy().process(this.getDescriptor());
            }
        }
    }

    protected void processCustomizer() {
        Object t = this.getAnnotation(Customizer.class);
        if (this.m_customizerClass != null && !this.m_customizerClass.equals(Void.TYPE) || t != null) {
            if (this.getDescriptor().hasCustomizer()) {
                this.getLogger().logWarningMessage("metadata_warning_ignore_mapped_superclass_customizer", this.getDescriptor().getJavaClass(), this.getJavaClass());
            } else {
                if (this.m_customizerClass == null || this.m_customizerClass.equals(Void.TYPE)) {
                    this.m_customizerClass = (Class)MetadataHelper.invokeMethod("value", t);
                } else if (t != null) {
                    this.getLogger().logWarningMessage("metadata_warning_override_annotation_with_xml", t, this.getJavaClassName(), this.getLocation());
                }
                this.getProject().addAccessorWithCustomizer(this);
            }
        }
    }

    protected void processProperties() {
        Object t;
        for (PropertyMetadata annotationArray2 : this.getProperties()) {
            this.getDescriptor().addProperty(annotationArray2);
        }
        Iterator<PropertyMetadata> iterator = this.getAnnotation(Properties.class);
        if (iterator != null) {
            for (Annotation annotation : (Annotation[])MetadataHelper.invokeMethod("value", iterator)) {
                this.getDescriptor().addProperty(new PropertyMetadata(annotation, this.getAccessibleObject()));
            }
        }
        if ((t = this.getAnnotation(Property.class)) != null) {
            this.getDescriptor().addProperty(new PropertyMetadata((Annotation)t, this.getAccessibleObject()));
        }
    }

    public void setAttributes(XMLAttributes xMLAttributes) {
        this.m_attributes = xMLAttributes;
    }

    public void setChangeTracking(ChangeTrackingMetadata changeTrackingMetadata) {
        this.m_changeTracking = changeTrackingMetadata;
    }

    public void setClassName(String string) {
        this.m_className = string;
    }

    public void setCloneCopyPolicy(CloneCopyPolicyMetadata cloneCopyPolicyMetadata) {
        this.m_cloneCopyPolicy = cloneCopyPolicyMetadata;
    }

    public void setCustomCopyPolicy(CustomCopyPolicyMetadata customCopyPolicyMetadata) {
        this.m_customCopyPolicy = customCopyPolicyMetadata;
    }

    public void setCustomizerClassName(String string) {
        this.m_customizerClassName = string;
    }

    public void setDescription(String string) {
        this.m_description = string;
    }

    public void setExcludeDefaultMappings(Boolean bl) {
        this.m_excludeDefaultMappings = bl;
    }

    public void setInstantiationCopyPolicy(InstantiationCopyPolicyMetadata instantiationCopyPolicyMetadata) {
        this.m_instantiationCopyPolicy = instantiationCopyPolicyMetadata;
    }

    public void setJavaClass(Class clazz) {
        this.getAccessibleObject().setAnnotatedElement(clazz);
        this.getDescriptor().setJavaClass(clazz);
    }

    public void setMetadataComplete(Boolean bl) {
        this.m_metadataComplete = bl;
    }

    public boolean usesPropertyAccess() {
        return this.getAccessType().equals("PROPERTY");
    }
}

