/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.accessors.mappings;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.FetchType;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.indirection.IndirectionPolicy;
import org.eclipse.persistence.internal.indirection.WeavedObjectBasicIndirectionPolicy;
import org.eclipse.persistence.internal.jpa.metadata.MetadataDescriptor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.classes.ClassAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.MetadataHelper;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.RelationshipAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.columns.JoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnMetadata;
import org.eclipse.persistence.internal.jpa.metadata.columns.PrimaryKeyJoinColumnsMetadata;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.ForeignReferenceMapping;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;
import org.eclipse.persistence.mappings.OneToOneMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ObjectAccessor
extends RelationshipAccessor {
    private Boolean m_isOptional;
    private List<PrimaryKeyJoinColumnMetadata> m_primaryKeyJoinColumns = new ArrayList<PrimaryKeyJoinColumnMetadata>();

    protected ObjectAccessor(String string) {
        super(string);
    }

    protected ObjectAccessor(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject, ClassAccessor classAccessor) {
        super(annotation, metadataAccessibleObject, classAccessor);
        Object object;
        this.m_isOptional = annotation == null ? true : (Boolean)MetadataHelper.invokeMethod("optional", annotation);
        Object t = this.getAnnotation(PrimaryKeyJoinColumns.class);
        if (t != null) {
            object = (Annotation[])MetadataHelper.invokeMethod("value", t);
            int n = ((T)object).length;
            for (int i = 0; i < n; ++i) {
                Object t2 = object[i];
                this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata((Annotation)t2, metadataAccessibleObject));
            }
        }
        if ((object = this.getAnnotation(PrimaryKeyJoinColumn.class)) != null) {
            this.m_primaryKeyJoinColumns.add(new PrimaryKeyJoinColumnMetadata((Annotation)object, metadataAccessibleObject));
        }
    }

    @Override
    public Enum getDefaultFetchType() {
        return FetchType.valueOf((String)"EAGER");
    }

    public Boolean getOptional() {
        return this.m_isOptional;
    }

    public List<PrimaryKeyJoinColumnMetadata> getPrimaryKeyJoinColumns() {
        return this.m_primaryKeyJoinColumns;
    }

    @Override
    public Class getReferenceClass() {
        if (this.m_referenceClass == null) {
            this.m_referenceClass = this.getTargetEntity();
            if (this.m_referenceClass == Void.TYPE) {
                this.m_referenceClass = super.getReferenceClass();
                this.getLogger().logConfigMessage(this.getLoggingContext(), this.getAnnotatedElement(), (Object)this.m_referenceClass);
            }
        }
        return this.m_referenceClass;
    }

    protected OneToOneMapping initOneToOneMapping() {
        OneToOneMapping oneToOneMapping = new OneToOneMapping();
        oneToOneMapping.setIsReadOnly(false);
        oneToOneMapping.setIsPrivateOwned(this.isPrivateOwned());
        oneToOneMapping.setJoinFetch(this.getMappingJoinFetchType(this.getJoinFetch()));
        oneToOneMapping.setIsOptional(this.isOptional());
        oneToOneMapping.setAttributeName(this.getAttributeName());
        oneToOneMapping.setReferenceClassName(this.getReferenceClassName());
        this.processIndirection((ObjectReferenceMapping)oneToOneMapping);
        this.setAccessorMethods((DatabaseMapping)oneToOneMapping);
        this.processCascadeTypes((ForeignReferenceMapping)oneToOneMapping);
        this.processReturnInsertAndUpdate();
        return oneToOneMapping;
    }

    @Override
    public void initXMLObject(MetadataAccessibleObject metadataAccessibleObject) {
        super.initXMLObject(metadataAccessibleObject);
        this.initXMLObjects(this.m_primaryKeyJoinColumns, metadataAccessibleObject);
    }

    public boolean isOneToOnePrimaryKeyRelationship() {
        return this.isOneToOne() && !this.m_primaryKeyJoinColumns.isEmpty();
    }

    public boolean isOptional() {
        if (this.m_isOptional == null) {
            return true;
        }
        return this.m_isOptional;
    }

    protected void processIndirection(ObjectReferenceMapping objectReferenceMapping) {
        boolean bl = this.usesIndirection();
        if (bl && !this.getProject().isWeavingEnabled() && !ClassConstants.PersistenceWeavedLazy_Class.isAssignableFrom(this.getDescriptor().getJavaClass())) {
            bl = false;
        }
        if (bl && this.usesPropertyAccess(this.getDescriptor())) {
            objectReferenceMapping.setIndirectionPolicy((IndirectionPolicy)new WeavedObjectBasicIndirectionPolicy(this.getSetMethodName()));
        } else {
            objectReferenceMapping.setUsesIndirection(bl);
        }
        objectReferenceMapping.setIsLazy(this.isLazy());
    }

    protected void processOneToOneForeignKeyRelationship(OneToOneMapping oneToOneMapping) {
        String string = this.getReferenceDescriptor().getPrimaryKeyFieldName();
        String string2 = this.getUpperCaseAttributeName() + "_" + string;
        for (JoinColumnMetadata joinColumnMetadata : this.processJoinColumns()) {
            DatabaseField databaseField = joinColumnMetadata.getPrimaryKeyField();
            databaseField.setName(this.getName(databaseField, string, "metadata_default_pk_column"));
            databaseField.setTable(this.getReferenceDescriptor().getPrimaryKeyTable());
            DatabaseField databaseField2 = joinColumnMetadata.getForeignKeyField();
            databaseField2.setName(this.getName(databaseField2, string2, "metadata_default_fk_column"));
            if (databaseField2.getTableName().equals("")) {
                databaseField2.setTable(this.getDescriptor().getPrimaryTable());
            }
            oneToOneMapping.addForeignKeyField(databaseField2, databaseField);
            if (!databaseField2.isReadOnly()) continue;
            oneToOneMapping.setIsReadOnly(true);
        }
    }

    protected void processOneToOnePrimaryKeyRelationship(OneToOneMapping oneToOneMapping) {
        MetadataDescriptor metadataDescriptor = this.getReferenceDescriptor();
        List<PrimaryKeyJoinColumnMetadata> list = this.processPrimaryKeyJoinColumns(new PrimaryKeyJoinColumnsMetadata(this.getPrimaryKeyJoinColumns()));
        for (PrimaryKeyJoinColumnMetadata primaryKeyJoinColumnMetadata : list) {
            DatabaseField databaseField = primaryKeyJoinColumnMetadata.getPrimaryKeyField();
            databaseField.setName(this.getName(databaseField, metadataDescriptor.getPrimaryKeyFieldName(), "metadata_default_pk_column"));
            databaseField.setTable(metadataDescriptor.getPrimaryTable());
            DatabaseField databaseField2 = primaryKeyJoinColumnMetadata.getForeignKeyField();
            databaseField2.setName(this.getName(databaseField2, this.getDescriptor().getPrimaryKeyFieldName(), "metadata_default_fk_column"));
            databaseField2.setTable(this.getDescriptor().getPrimaryTable());
            oneToOneMapping.addForeignKeyField(databaseField2, databaseField);
            oneToOneMapping.setIsReadOnly(true);
        }
    }

    protected void processOwningMappingKeys(OneToOneMapping oneToOneMapping) {
        if (this.isOneToOnePrimaryKeyRelationship()) {
            this.processOneToOnePrimaryKeyRelationship(oneToOneMapping);
        } else {
            this.processOneToOneForeignKeyRelationship(oneToOneMapping);
        }
    }

    public void setOptional(Boolean bl) {
        this.m_isOptional = bl;
    }

    public void setPrimaryKeyJoinColumns(List<PrimaryKeyJoinColumnMetadata> list) {
        this.m_primaryKeyJoinColumns = list;
    }
}

