/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.metadata.converters;

import java.lang.annotation.Annotation;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.jpa.metadata.accessors.mappings.DirectAccessor;
import org.eclipse.persistence.internal.jpa.metadata.accessors.objects.MetadataAccessibleObject;
import org.eclipse.persistence.internal.jpa.metadata.converters.AbstractConverterMetadata;
import org.eclipse.persistence.internal.jpa.metadata.converters.MetadataHelper;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;

public class StructConverterMetadata
extends AbstractConverterMetadata {
    private String m_converter;

    public StructConverterMetadata() {
        super("<struct-converter>");
    }

    public StructConverterMetadata(Annotation annotation, MetadataAccessibleObject metadataAccessibleObject) {
        super(annotation, metadataAccessibleObject);
        this.setConverter((String)MetadataHelper.invokeMethod("converter", annotation));
    }

    public boolean equals(Object object) {
        if (object instanceof StructConverterMetadata) {
            StructConverterMetadata structConverterMetadata = (StructConverterMetadata)object;
            if (!this.valuesMatch(this.getName(), structConverterMetadata.getName())) {
                return false;
            }
            return this.valuesMatch(this.m_converter, structConverterMetadata.getConverter());
        }
        return false;
    }

    public String getConverter() {
        return this.m_converter;
    }

    public String getConverterClassName() {
        if (this.getConverter().equals("JGEOMETRY")) {
            return "org.eclipse.persistence.platform.database.oracle.converters.JGeometryConverter";
        }
        return this.getConverter();
    }

    public boolean isStructConverter() {
        return true;
    }

    public void process(DatabaseMapping databaseMapping, DirectAccessor directAccessor) {
        if (databaseMapping.isAbstractDirectMapping()) {
            AbstractDirectMapping abstractDirectMapping = (AbstractDirectMapping)databaseMapping;
            abstractDirectMapping.setFieldType(2002);
            abstractDirectMapping.setConverter(null);
            abstractDirectMapping.setConverterClassName(null);
        } else if (!databaseMapping.isDirectCollectionMapping() && !databaseMapping.isDirectMapMapping()) {
            throw ValidationException.invalidMappingForStructConverter((String)this.getName(), (DatabaseMapping)databaseMapping);
        }
    }

    public void setConverter(String string) {
        this.m_converter = string;
    }
}

