/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jaxb;

import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.oxm.XMLRoot;

public class JAXBElementAttributeAccessor
extends AttributeAccessor {
    private AttributeAccessor nestedAccessor;
    private ContainerPolicy containerPolicy;
    private boolean isContainer;

    public JAXBElementAttributeAccessor(AttributeAccessor attributeAccessor) {
        this.nestedAccessor = attributeAccessor;
        this.isContainer = false;
    }

    public JAXBElementAttributeAccessor(AttributeAccessor attributeAccessor, ContainerPolicy containerPolicy) {
        this.nestedAccessor = attributeAccessor;
        this.containerPolicy = containerPolicy;
        this.isContainer = true;
    }

    public Object getAttributeValueFromObject(Object object) {
        Object object2 = this.nestedAccessor.getAttributeValueFromObject(object);
        if (this.isContainer) {
            Object object3 = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(object2));
            Object object4 = this.containerPolicy.iteratorFor(object2);
            while (this.containerPolicy.hasNext(object4)) {
                Object object5 = this.containerPolicy.next(object4, null);
                if (object5 instanceof JAXBElement) {
                    JAXBElement jAXBElement = (JAXBElement)object5;
                    XMLRoot xMLRoot = new XMLRoot();
                    xMLRoot.setLocalName(jAXBElement.getName().getLocalPart());
                    xMLRoot.setNamespaceURI(jAXBElement.getName().getNamespaceURI());
                    xMLRoot.setObject(jAXBElement.getValue());
                    this.containerPolicy.addInto((Object)xMLRoot, object3, null);
                    continue;
                }
                this.containerPolicy.addInto(object5, object3, null);
            }
            object2 = object3;
        } else if (object2 instanceof JAXBElement) {
            JAXBElement jAXBElement = (JAXBElement)object2;
            XMLRoot xMLRoot = new XMLRoot();
            xMLRoot.setLocalName(jAXBElement.getName().getLocalPart());
            xMLRoot.setNamespaceURI(jAXBElement.getName().getNamespaceURI());
            xMLRoot.setObject(jAXBElement.getValue());
            object2 = xMLRoot;
        }
        return object2;
    }

    public void setAttributeValueInObject(Object object, Object object2) {
        Object object3 = object2;
        if (this.isContainer) {
            Object object4 = this.containerPolicy.containerInstance(this.containerPolicy.sizeFor(object3));
            Object object5 = this.containerPolicy.iteratorFor(object3);
            while (this.containerPolicy.hasNext(object5)) {
                Object object6 = this.containerPolicy.next(object5, null);
                if (object6 instanceof XMLRoot) {
                    XMLRoot xMLRoot = (XMLRoot)object6;
                    QName qName = new QName(xMLRoot.getNamespaceURI(), xMLRoot.getLocalName());
                    JAXBElement jAXBElement = new JAXBElement(qName, xMLRoot.getObject().getClass(), xMLRoot.getObject());
                    this.containerPolicy.addInto((Object)jAXBElement, object4, null);
                    continue;
                }
                this.containerPolicy.addInto(object6, object4, null);
            }
            object3 = object4;
        } else if (object3 instanceof XMLRoot) {
            XMLRoot xMLRoot = (XMLRoot)object3;
            QName qName = new QName(xMLRoot.getNamespaceURI(), xMLRoot.getLocalName());
            JAXBElement jAXBElement = new JAXBElement(qName, xMLRoot.getObject().getClass(), xMLRoot.getObject());
            object3 = jAXBElement;
        }
        this.nestedAccessor.setAttributeValueInObject(object, object3);
    }

    public void initializeAttributes(Class clazz) throws DescriptorException {
        this.nestedAccessor.initializeAttributes(clazz);
    }
}

