/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.compiler;

import java.beans.Introspector;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAnyAttribute;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlIDREF;
import javax.xml.bind.annotation.XmlInlineBinaryData;
import javax.xml.bind.annotation.XmlList;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSchemaType;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.namespace.QName;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.jaxb.DomHandlerConverter;
import org.eclipse.persistence.internal.jaxb.JAXBElementAttributeAccessor;
import org.eclipse.persistence.internal.jaxb.JaxbClassLoader;
import org.eclipse.persistence.internal.jaxb.WrappedValue;
import org.eclipse.persistence.internal.jaxb.XMLJavaTypeConverter;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.CodeVisitor;
import org.eclipse.persistence.internal.libraries.asm.Type;
import org.eclipse.persistence.jaxb.JAXBEnumTypeConverter;
import org.eclipse.persistence.jaxb.compiler.AnyProperty;
import org.eclipse.persistence.jaxb.compiler.ChoiceProperty;
import org.eclipse.persistence.jaxb.compiler.ElementDeclaration;
import org.eclipse.persistence.jaxb.compiler.EnumTypeInfo;
import org.eclipse.persistence.jaxb.compiler.NamespaceInfo;
import org.eclipse.persistence.jaxb.compiler.Property;
import org.eclipse.persistence.jaxb.compiler.ReferenceProperty;
import org.eclipse.persistence.jaxb.compiler.TypeInfo;
import org.eclipse.persistence.jaxb.javamodel.Helper;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.oxm.NamespaceResolver;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLField;
import org.eclipse.persistence.oxm.annotations.XmlContainerProperty;
import org.eclipse.persistence.oxm.mappings.FixedMimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.MimeTypePolicy;
import org.eclipse.persistence.oxm.mappings.UnmarshalKeepAsElementPolicy;
import org.eclipse.persistence.oxm.mappings.XMLAnyAttributeMapping;
import org.eclipse.persistence.oxm.mappings.XMLAnyCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLBinaryDataMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLChoiceObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLCollectionReferenceMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeDirectCollectionMapping;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.oxm.mappings.XMLMapping;
import org.eclipse.persistence.oxm.mappings.XMLObjectReferenceMapping;
import org.eclipse.persistence.oxm.mappings.converters.XMLConverter;
import org.eclipse.persistence.oxm.mappings.converters.XMLRootConverter;
import org.eclipse.persistence.sessions.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingsGenerator {
    private static String WRAPPER_CLASS = "org.eclipse.persistence.jaxb.generated";
    private static int wrapperCounter = 0;
    String outputDir = ".";
    private int nextNamespaceNumber = 0;
    private HashMap userDefinedSchemaTypes;
    private Helper helper;
    private JavaClass jotArrayList;
    private JavaClass jotHashSet;
    private HashMap<String, NamespaceInfo> packageToNamespaceMappings;
    private HashMap<String, TypeInfo> typeInfo;
    private HashMap<Class, QName> generatedClassesToQNames;
    private HashMap<QName, ElementDeclaration> globalElements;

    public MappingsGenerator(Helper helper) {
        this.helper = helper;
        this.jotArrayList = helper.getJavaClass(ArrayList.class);
        this.jotHashSet = helper.getJavaClass(HashSet.class);
        this.generatedClassesToQNames = new HashMap();
    }

    public Project generateProject(ArrayList<JavaClass> arrayList, HashMap<String, TypeInfo> hashMap, HashMap hashMap2, HashMap<String, NamespaceInfo> hashMap3, HashMap<QName, ElementDeclaration> hashMap4) throws Exception {
        this.typeInfo = hashMap;
        this.userDefinedSchemaTypes = hashMap2;
        this.packageToNamespaceMappings = hashMap3;
        this.globalElements = hashMap4;
        Project project = new Project();
        for (JavaClass javaClass : arrayList) {
            if (javaClass.isEnum()) continue;
            this.generateDescriptor(javaClass, project);
        }
        this.generateMappings();
        this.processGlobalElements(project);
        return project;
    }

    public void generateDescriptor(JavaClass javaClass, Project project) {
        String string;
        String string2;
        String string3 = javaClass.getQualifiedName();
        TypeInfo typeInfo = this.typeInfo.get(string3);
        NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackage().getQualifiedName());
        String string4 = namespaceInfo.getNamespace();
        XmlRootElement xmlRootElement = (XmlRootElement)this.helper.getAnnotation(javaClass, XmlRootElement.class);
        if (xmlRootElement == null) {
            string2 = Introspector.decapitalize(string3.substring(string3.lastIndexOf(".") + 1));
            string = string4;
        } else {
            string2 = xmlRootElement.name();
            if (string2.equals("##default")) {
                string2 = Introspector.decapitalize(string3.substring(string3.lastIndexOf(".") + 1));
            }
            string = xmlRootElement.namespace();
        }
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClassName(string3);
        if (string.equals("##default")) {
            string = namespaceInfo.getNamespace();
        }
        if (string.equals("")) {
            xMLDescriptor.setDefaultRootElement(string2);
        } else {
            String string5 = this.getPrefixForNamespace(string, namespaceInfo.getNamespaceResolver());
            xMLDescriptor.setDefaultRootElement(string5 + ":" + string2);
        }
        xMLDescriptor.setNamespaceResolver(namespaceInfo.getNamespaceResolver());
        project.addDescriptor((ClassDescriptor)xMLDescriptor);
        typeInfo.setDescriptor(xMLDescriptor);
    }

    public void generateMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        if (property.getAdapterClass() != null) {
            JavaClass javaClass = property.getAdapterClass();
            JavaClass javaClass2 = this.helper.getJavaClass(Object.class);
            for (JavaMethod javaMethod : new ArrayList(javaClass.getDeclaredMethods())) {
                JavaClass javaClass3;
                if (!javaMethod.getName().equals("marshal") || (javaClass3 = javaMethod.getReturnType()).getQualifiedName().equals(javaClass2.getQualifiedName())) continue;
                javaClass2 = javaClass3;
                break;
            }
            if (this.typeInfo.containsKey(javaClass2.getQualifiedName())) {
                if (this.isCollectionType(property)) {
                    this.generateCompositeCollectionMapping(property, xMLDescriptor, namespaceInfo, javaClass2).setConverter((Converter)new XMLJavaTypeConverter(javaClass.getQualifiedName()));
                } else {
                    this.generateCompositeObjectMapping(property, xMLDescriptor, namespaceInfo, javaClass2).setConverter((Converter)new XMLJavaTypeConverter(javaClass.getQualifiedName()));
                }
            } else if (this.isCollectionType(property)) {
                this.generateDirectCollectionMapping(property, xMLDescriptor, namespaceInfo).setValueConverter((Converter)new XMLJavaTypeConverter(javaClass.getQualifiedName()));
            } else if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                this.generateBinaryMapping(property, xMLDescriptor, namespaceInfo).setConverter((Converter)new XMLJavaTypeConverter(javaClass.getQualifiedName()));
            } else {
                this.generateDirectMapping(property, xMLDescriptor, namespaceInfo).setConverter((Converter)new XMLJavaTypeConverter(javaClass.getQualifiedName()));
            }
            return;
        }
        if (property.isChoice()) {
            if (this.isCollectionType(property)) {
                this.generateChoiceCollectionMapping(property, xMLDescriptor, namespaceInfo);
            } else {
                this.generateChoiceMapping(property, xMLDescriptor, namespaceInfo);
            }
        } else if (property.isAny()) {
            this.generateAnyCollectionMapping(property, xMLDescriptor, namespaceInfo);
        } else if (property.isReference()) {
            if (this.isCollectionType(property)) {
                this.generateCollectionMappingForReferenceProperty((ReferenceProperty)property, xMLDescriptor, namespaceInfo);
            } else {
                this.generateMappingForReferenceProperty((ReferenceProperty)property, xMLDescriptor, namespaceInfo);
            }
        } else if (this.isMapType(property) && this.helper.isAnnotationPresent(property.getElement(), XmlAnyAttribute.class)) {
            this.generateAnyAttributeMapping(property, xMLDescriptor, namespaceInfo);
        } else if (this.isCollectionType(property)) {
            this.generateCollectionMapping(property, xMLDescriptor, namespaceInfo);
        } else {
            JavaClass javaClass = property.getType();
            TypeInfo typeInfo = this.typeInfo.get(javaClass.getQualifiedName());
            if (typeInfo != null) {
                if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
                    this.generateXMLObjectReferenceMapping(property, xMLDescriptor, namespaceInfo, javaClass);
                } else if (typeInfo.isEnumerationType()) {
                    this.generateDirectEnumerationMapping(property, xMLDescriptor, namespaceInfo, (EnumTypeInfo)typeInfo);
                } else {
                    this.generateCompositeObjectMapping(property, xMLDescriptor, namespaceInfo, javaClass);
                }
            } else if (property.isSwaAttachmentRef() || property.isMtomAttachment()) {
                this.generateBinaryMapping(property, xMLDescriptor, namespaceInfo);
            } else {
                this.generateDirectMapping(property, xMLDescriptor, namespaceInfo);
            }
        }
    }

    public XMLChoiceObjectMapping generateChoiceMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        ChoiceProperty choiceProperty = (ChoiceProperty)property;
        XMLChoiceObjectMapping xMLChoiceObjectMapping = new XMLChoiceObjectMapping();
        xMLChoiceObjectMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            xMLChoiceObjectMapping.setGetMethodName(property.getGetMethodName());
            xMLChoiceObjectMapping.setSetMethodName(property.getSetMethodName());
        }
        Iterator<Property> iterator = choiceProperty.getChoiceProperties().iterator();
        while (iterator.hasNext()) {
            Property property2;
            JavaClass javaClass = (property2 = iterator.next()).getType();
            XMLField xMLField = this.getXPathForField(property2, namespaceInfo, !this.typeInfo.containsKey(javaClass.getQualifiedName()));
            xMLChoiceObjectMapping.addChoiceElement(xMLField.getName(), javaClass.getQualifiedName(), false);
        }
        xMLDescriptor.addMapping((DatabaseMapping)xMLChoiceObjectMapping);
        return xMLChoiceObjectMapping;
    }

    public XMLChoiceCollectionMapping generateChoiceCollectionMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        JavaClass javaClass;
        ChoiceProperty choiceProperty = (ChoiceProperty)property;
        XMLChoiceCollectionMapping xMLChoiceCollectionMapping = new XMLChoiceCollectionMapping();
        xMLChoiceCollectionMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            xMLChoiceCollectionMapping.setGetMethodName(property.getGetMethodName());
            xMLChoiceCollectionMapping.setSetMethodName(property.getSetMethodName());
        }
        if (this.areEquals(javaClass = property.getType(), Collection.class) || this.areEquals(javaClass, List.class)) {
            javaClass = this.jotArrayList;
        } else if (this.areEquals(javaClass, Set.class)) {
            javaClass = this.jotHashSet;
        }
        xMLChoiceCollectionMapping.useCollectionClassName(javaClass.getRawName());
        Iterator<Property> iterator = choiceProperty.getChoiceProperties().iterator();
        while (iterator.hasNext()) {
            Property property2;
            JavaClass javaClass2 = (property2 = iterator.next()).getType();
            XMLField xMLField = this.getXPathForField(property2, namespaceInfo, !this.typeInfo.containsKey(javaClass2.getQualifiedName()));
            xMLChoiceCollectionMapping.addChoiceElement(xMLField.getName(), javaClass2.getQualifiedName());
        }
        xMLDescriptor.addMapping((DatabaseMapping)xMLChoiceCollectionMapping);
        return xMLChoiceCollectionMapping;
    }

    public XMLMapping generateMappingForReferenceProperty(ReferenceProperty referenceProperty, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        XMLChoiceObjectMapping xMLChoiceObjectMapping = new XMLChoiceObjectMapping();
        xMLChoiceObjectMapping.setAttributeName(referenceProperty.getPropertyName());
        if (referenceProperty.isMethodProperty()) {
            xMLChoiceObjectMapping.setGetMethodName(referenceProperty.getGetMethodName());
            xMLChoiceObjectMapping.setSetMethodName(referenceProperty.getSetMethodName());
        }
        List<ElementDeclaration> list = referenceProperty.getReferencedElements();
        boolean bl = false;
        AttributeAccessor attributeAccessor = xMLChoiceObjectMapping.getAttributeAccessor();
        for (ElementDeclaration elementDeclaration : list) {
            QName qName = elementDeclaration.getElementName();
            XMLField xMLField = this.getXPathForElement("", qName, namespaceInfo, !this.typeInfo.containsKey(elementDeclaration.getJavaTypeName()));
            xMLChoiceObjectMapping.addChoiceElement(xMLField, elementDeclaration.getJavaTypeName());
            if (!elementDeclaration.isXmlRootElement()) {
                XMLRootConverter xMLRootConverter = new XMLRootConverter(xMLField);
                xMLChoiceObjectMapping.addConverter(xMLField, (Converter)xMLRootConverter);
            }
            if (!(bl = bl || !elementDeclaration.isXmlRootElement())) continue;
            xMLChoiceObjectMapping.setAttributeAccessor((AttributeAccessor)new JAXBElementAttributeAccessor(attributeAccessor));
        }
        xMLDescriptor.addMapping((DatabaseMapping)xMLChoiceObjectMapping);
        return xMLChoiceObjectMapping;
    }

    public XMLMapping generateCollectionMappingForReferenceProperty(ReferenceProperty referenceProperty, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        XMLChoiceCollectionMapping xMLChoiceCollectionMapping = new XMLChoiceCollectionMapping();
        xMLChoiceCollectionMapping.setAttributeName(referenceProperty.getPropertyName());
        if (referenceProperty.isMethodProperty()) {
            xMLChoiceCollectionMapping.setGetMethodName(referenceProperty.getGetMethodName());
            xMLChoiceCollectionMapping.setSetMethodName(referenceProperty.getSetMethodName());
        }
        List<ElementDeclaration> list = referenceProperty.getReferencedElements();
        boolean bl = false;
        AttributeAccessor attributeAccessor = xMLChoiceCollectionMapping.getAttributeAccessor();
        for (ElementDeclaration elementDeclaration : list) {
            QName qName = elementDeclaration.getElementName();
            XMLField xMLField = this.getXPathForElement("", qName, namespaceInfo, !this.typeInfo.containsKey(elementDeclaration.getJavaTypeName()));
            xMLChoiceCollectionMapping.addChoiceElement(xMLField, elementDeclaration.getJavaTypeName());
            if (!elementDeclaration.isXmlRootElement()) {
                XMLRootConverter xMLRootConverter = new XMLRootConverter(xMLField);
                xMLChoiceCollectionMapping.addConverter(xMLField, (Converter)xMLRootConverter);
            }
            bl = bl || !elementDeclaration.isXmlRootElement();
        }
        if (bl) {
            xMLChoiceCollectionMapping.setAttributeAccessor((AttributeAccessor)new JAXBElementAttributeAccessor(attributeAccessor, xMLChoiceCollectionMapping.getContainerPolicy()));
        }
        xMLDescriptor.addMapping((DatabaseMapping)xMLChoiceCollectionMapping);
        return xMLChoiceCollectionMapping;
    }

    public XMLAnyCollectionMapping generateAnyCollectionMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        AnyProperty anyProperty = (AnyProperty)property;
        XMLAnyCollectionMapping xMLAnyCollectionMapping = new XMLAnyCollectionMapping();
        xMLAnyCollectionMapping.setAttributeName(property.getPropertyName());
        if (anyProperty.isLax()) {
            xMLAnyCollectionMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_UNKNOWN_AS_ELEMENT);
        } else {
            xMLAnyCollectionMapping.setKeepAsElementPolicy(UnmarshalKeepAsElementPolicy.KEEP_ALL_AS_ELEMENT);
        }
        if (anyProperty.getDomHandlerClass() != null) {
            DomHandlerConverter domHandlerConverter = new DomHandlerConverter(anyProperty.getDomHandlerClass());
            xMLAnyCollectionMapping.setConverter((XMLConverter)domHandlerConverter);
        }
        xMLDescriptor.addMapping((DatabaseMapping)xMLAnyCollectionMapping);
        return xMLAnyCollectionMapping;
    }

    public XMLCompositeObjectMapping generateCompositeObjectMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo, JavaClass javaClass) {
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setReferenceClassName(javaClass.getQualifiedName());
        xMLCompositeObjectMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            xMLCompositeObjectMapping.setGetMethodName(property.getGetMethodName());
            xMLCompositeObjectMapping.setSetMethodName(property.getSetMethodName());
        }
        xMLCompositeObjectMapping.setXPath(this.getXPathForField(property, namespaceInfo, false).getXPath());
        if (this.helper.isAnnotationPresent(property.getElement(), XmlContainerProperty.class)) {
            XmlContainerProperty xmlContainerProperty = (XmlContainerProperty)this.helper.getAnnotation(property.getElement(), XmlContainerProperty.class);
            String string = xmlContainerProperty.value();
            xMLCompositeObjectMapping.setContainerAttributeName(string);
            if (!xmlContainerProperty.getMethodName().equals("") && !xmlContainerProperty.setMethodName().equals("")) {
                xMLCompositeObjectMapping.setContainerGetMethodName(xmlContainerProperty.getMethodName());
                xMLCompositeObjectMapping.setContainerSetMethodName(xmlContainerProperty.setMethodName());
            }
        }
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLCompositeObjectMapping;
    }

    public XMLDirectMapping generateDirectMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            xMLDirectMapping.setGetMethodName(property.getGetMethodName());
            xMLDirectMapping.setSetMethodName(property.getSetMethodName());
        }
        xMLDirectMapping.setField((DatabaseField)this.getXPathForField(property, namespaceInfo, true));
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        return xMLDirectMapping;
    }

    public XMLBinaryDataMapping generateBinaryMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        XMLBinaryDataMapping xMLBinaryDataMapping = new XMLBinaryDataMapping();
        xMLBinaryDataMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            xMLBinaryDataMapping.setGetMethodName(property.getGetMethodName());
            xMLBinaryDataMapping.setSetMethodName(property.getSetMethodName());
        }
        xMLBinaryDataMapping.setField((DatabaseField)this.getXPathForField(property, namespaceInfo, false));
        if (property.isSwaAttachmentRef()) {
            ((XMLField)xMLBinaryDataMapping.getField()).setSchemaType(XMLConstants.SWA_REF_QNAME);
            xMLBinaryDataMapping.setSwaRef(true);
        } else if (property.isMtomAttachment()) {
            ((XMLField)xMLBinaryDataMapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlInlineBinaryData.class)) {
            xMLBinaryDataMapping.setShouldInlineBinaryData(true);
        }
        xMLBinaryDataMapping.setMimeTypePolicy((MimeTypePolicy)new FixedMimeTypePolicy(property.getMimeType()));
        xMLDescriptor.addMapping((DatabaseMapping)xMLBinaryDataMapping);
        return xMLBinaryDataMapping;
    }

    public void generateDirectEnumerationMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo, EnumTypeInfo enumTypeInfo) {
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        JAXBEnumTypeConverter jAXBEnumTypeConverter = new JAXBEnumTypeConverter((DatabaseMapping)xMLDirectMapping, enumTypeInfo.getClassName(), false);
        xMLDirectMapping.setConverter((Converter)jAXBEnumTypeConverter);
        xMLDirectMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            xMLDirectMapping.setGetMethodName(property.getGetMethodName());
            xMLDirectMapping.setSetMethodName(property.getSetMethodName());
        }
        xMLDirectMapping.setField((DatabaseField)this.getXPathForField(property, namespaceInfo, true));
        HashMap<Object, String> hashMap = enumTypeInfo.getObjectValuesToFieldValues();
        for (Object object : hashMap.keySet()) {
            String string = hashMap.get(object);
            jAXBEnumTypeConverter.addConversionValue(string, object);
        }
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
    }

    public void generateCollectionMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        Object object;
        JavaClass javaClass = null;
        if (property.getGenericType() != null) {
            javaClass = property.getGenericType();
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlElement.class) && (object = (XmlElement)this.helper.getAnnotation(property.getElement(), XmlElement.class)).type() != XmlElement.DEFAULT.class) {
            javaClass = this.helper.getJavaClass(object.type());
        }
        if (javaClass != null && this.typeInfo.get(javaClass.getQualifiedName()) != null) {
            object = this.typeInfo.get(javaClass.getQualifiedName());
            if (((TypeInfo)object).isEnumerationType()) {
                this.generateEnumCollectionMapping(property, (EnumTypeInfo)object, xMLDescriptor, namespaceInfo);
            } else if (this.helper.isAnnotationPresent(property.getElement(), XmlIDREF.class)) {
                this.generateXMLCollectionReferenceMapping(property, xMLDescriptor, namespaceInfo, javaClass);
            } else {
                this.generateCompositeCollectionMapping(property, xMLDescriptor, namespaceInfo, javaClass);
            }
        } else {
            this.generateDirectCollectionMapping(property, xMLDescriptor, namespaceInfo);
        }
    }

    public void generateEnumCollectionMapping(Property property, EnumTypeInfo enumTypeInfo, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        Object object2;
        XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping = new XMLCompositeDirectCollectionMapping();
        xMLCompositeDirectCollectionMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            xMLCompositeDirectCollectionMapping.setGetMethodName(property.getGetMethodName());
            xMLCompositeDirectCollectionMapping.setSetMethodName(property.getSetMethodName());
        }
        JAXBEnumTypeConverter jAXBEnumTypeConverter = new JAXBEnumTypeConverter((DatabaseMapping)xMLCompositeDirectCollectionMapping, enumTypeInfo.getClassName(), false);
        HashMap<Object, String> hashMap = enumTypeInfo.getObjectValuesToFieldValues();
        for (Object object2 : hashMap.keySet()) {
            String string = hashMap.get(object2);
            jAXBEnumTypeConverter.addConversionValue(string, object2);
        }
        xMLCompositeDirectCollectionMapping.setValueConverter((Converter)jAXBEnumTypeConverter);
        Object object3 = property.getType();
        if (this.areEquals((JavaClass)object3, Collection.class) || this.areEquals((JavaClass)object3, List.class)) {
            object3 = this.jotArrayList;
        } else if (this.areEquals((JavaClass)object3, Set.class)) {
            object3 = this.jotHashSet;
        }
        xMLCompositeDirectCollectionMapping.useCollectionClassName(object3.getRawName());
        object2 = this.getXPathForField(property, namespaceInfo, true);
        xMLCompositeDirectCollectionMapping.setField((DatabaseField)object2);
        if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
            xMLCompositeDirectCollectionMapping.setUsesSingleNode(true);
        }
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeDirectCollectionMapping);
    }

    public void generateAnyAttributeMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        XMLAnyAttributeMapping xMLAnyAttributeMapping = new XMLAnyAttributeMapping();
        xMLAnyAttributeMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            xMLAnyAttributeMapping.setGetMethodName(property.getGetMethodName());
            xMLAnyAttributeMapping.setSetMethodName(property.getSetMethodName());
        }
        xMLDescriptor.addMapping((DatabaseMapping)xMLAnyAttributeMapping);
    }

    protected boolean areEquals(JavaClass javaClass, Class clazz) {
        if (javaClass == null || clazz == null) {
            return false;
        }
        return javaClass.getRawName().equals(clazz.getCanonicalName());
    }

    public XMLCompositeCollectionMapping generateCompositeCollectionMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo, JavaClass javaClass) {
        XMLCompositeCollectionMapping xMLCompositeCollectionMapping = new XMLCompositeCollectionMapping();
        xMLCompositeCollectionMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            xMLCompositeCollectionMapping.setGetMethodName(property.getGetMethodName());
            xMLCompositeCollectionMapping.setSetMethodName(property.getSetMethodName());
        }
        xMLCompositeCollectionMapping.setReferenceClassName(javaClass.getQualifiedName());
        JavaClass javaClass2 = property.getType();
        if (this.areEquals(javaClass2, Collection.class) || this.areEquals(javaClass2, List.class)) {
            javaClass2 = this.jotArrayList;
        } else if (this.areEquals(javaClass2, Set.class)) {
            javaClass2 = this.jotHashSet;
        }
        xMLCompositeCollectionMapping.useCollectionClassName(javaClass2.getRawName());
        XMLField xMLField = this.getXPathForField(property, namespaceInfo, false);
        xMLCompositeCollectionMapping.setXPath(xMLField.getXPath());
        if (this.helper.isAnnotationPresent(property.getElement(), XmlContainerProperty.class)) {
            XmlContainerProperty xmlContainerProperty = (XmlContainerProperty)this.helper.getAnnotation(property.getElement(), XmlContainerProperty.class);
            String string = xmlContainerProperty.value();
            xMLCompositeCollectionMapping.setContainerAttributeName(string);
            if (!xmlContainerProperty.getMethodName().equals("") && !xmlContainerProperty.setMethodName().equals("")) {
                xMLCompositeCollectionMapping.setContainerGetMethodName(xmlContainerProperty.getMethodName());
                xMLCompositeCollectionMapping.setContainerSetMethodName(xmlContainerProperty.setMethodName());
            }
        }
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeCollectionMapping);
        return xMLCompositeCollectionMapping;
    }

    public XMLCompositeDirectCollectionMapping generateDirectCollectionMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        JavaClass javaClass;
        XMLCompositeDirectCollectionMapping xMLCompositeDirectCollectionMapping = new XMLCompositeDirectCollectionMapping();
        xMLCompositeDirectCollectionMapping.setAttributeName(property.getPropertyName());
        if (property.isMethodProperty()) {
            xMLCompositeDirectCollectionMapping.setGetMethodName(property.getGetMethodName());
            xMLCompositeDirectCollectionMapping.setSetMethodName(property.getSetMethodName());
        }
        if (this.areEquals(javaClass = property.getType(), Collection.class) || this.areEquals(javaClass, List.class)) {
            javaClass = this.jotArrayList;
        } else if (this.areEquals(javaClass, Set.class)) {
            javaClass = this.jotHashSet;
        }
        xMLCompositeDirectCollectionMapping.useCollectionClassName(javaClass.getRawName());
        XMLField xMLField = this.getXPathForField(property, namespaceInfo, true);
        xMLCompositeDirectCollectionMapping.setField((DatabaseField)xMLField);
        if (this.helper.isAnnotationPresent(property.getElement(), XmlList.class)) {
            xMLCompositeDirectCollectionMapping.setUsesSingleNode(true);
        }
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeDirectCollectionMapping);
        return xMLCompositeDirectCollectionMapping;
    }

    public String getPrefixForNamespace(String string, NamespaceResolver namespaceResolver) {
        String string2;
        Enumeration enumeration = namespaceResolver.getPrefixes();
        while (enumeration.hasMoreElements()) {
            string2 = (String)enumeration.nextElement();
            String string3 = namespaceResolver.resolveNamespacePrefix(string2);
            if (!string3.equals(string)) continue;
            return string2;
        }
        string2 = "ns" + this.nextNamespaceNumber;
        ++this.nextNamespaceNumber;
        namespaceResolver.put(string2, string);
        return string2;
    }

    public boolean isCollectionType(Property property) {
        JavaClass javaClass = property.getType();
        return this.helper.getJavaClass(Collection.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(List.class).isAssignableFrom(javaClass) || this.helper.getJavaClass(Set.class).isAssignableFrom(javaClass);
    }

    public void generateMappings() {
        for (String string : this.typeInfo.keySet()) {
            JavaClass javaClass = this.helper.getJavaClass(string);
            TypeInfo typeInfo = this.typeInfo.get(string);
            NamespaceInfo namespaceInfo = this.packageToNamespaceMappings.get(javaClass.getPackageName());
            if (typeInfo.isEnumerationType()) continue;
            XMLDescriptor xMLDescriptor = typeInfo.getDescriptor();
            TypeInfo typeInfo2 = this.typeInfo.get(javaClass.getSuperclass().getQualifiedName());
            if (typeInfo2 != null) {
                this.generateMappings(typeInfo2, xMLDescriptor, namespaceInfo);
            }
            this.generateMappings(typeInfo, xMLDescriptor, namespaceInfo);
        }
    }

    public void generateMappings(TypeInfo typeInfo, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo) {
        String[] stringArray = typeInfo.getPropOrder();
        if (stringArray.length == 0 || stringArray[0].equals("")) {
            ArrayList<String> arrayList = typeInfo.getPropertyNames();
            for (int i = 0; i < arrayList.size(); ++i) {
                String string = arrayList.get(i);
                Property property = typeInfo.getProperties().get(string);
                this.generateMapping(property, xMLDescriptor, namespaceInfo);
            }
        } else {
            for (int i = 0; i < stringArray.length; ++i) {
                Property property = typeInfo.getProperties().get(stringArray[i]);
                if (property == null) continue;
                this.generateMapping(property, xMLDescriptor, namespaceInfo);
            }
        }
    }

    public void generateXMLCollectionReferenceMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo, JavaClass javaClass) {
        XMLField xMLField = this.getXPathForField(property, namespaceInfo, true);
        XMLCollectionReferenceMapping xMLCollectionReferenceMapping = new XMLCollectionReferenceMapping();
        xMLCollectionReferenceMapping.setAttributeName(property.getPropertyName());
        xMLCollectionReferenceMapping.setReferenceClassName(javaClass.getQualifiedName());
        JavaClass javaClass2 = property.getType();
        if (this.areEquals(javaClass2, Collection.class) || this.areEquals(javaClass2, List.class)) {
            javaClass2 = this.jotArrayList;
        } else if (this.areEquals(javaClass2, Set.class)) {
            javaClass2 = this.jotHashSet;
        }
        xMLCollectionReferenceMapping.useCollectionClassName(javaClass2.getRawName());
        TypeInfo typeInfo = this.typeInfo.get(javaClass.getQualifiedName());
        if (typeInfo.isIDSet()) {
            Property property2;
            XMLField xMLField2 = this.getXPathForField(property2, namespaceInfo, !this.helper.isAnnotationPresent((property2 = typeInfo.getIDProperty()).getElement(), XmlAttribute.class));
            xMLCollectionReferenceMapping.addSourceToTargetKeyFieldAssociation(xMLField.getXPath(), xMLField2.getXPath());
        }
        xMLDescriptor.addMapping((DatabaseMapping)xMLCollectionReferenceMapping);
    }

    public void generateXMLObjectReferenceMapping(Property property, XMLDescriptor xMLDescriptor, NamespaceInfo namespaceInfo, JavaClass javaClass) {
        XMLField xMLField = this.getXPathForField(property, namespaceInfo, true);
        XMLObjectReferenceMapping xMLObjectReferenceMapping = new XMLObjectReferenceMapping();
        xMLObjectReferenceMapping.setAttributeName(property.getPropertyName());
        xMLObjectReferenceMapping.setReferenceClassName(javaClass.getQualifiedName());
        TypeInfo typeInfo = this.typeInfo.get(javaClass.getQualifiedName());
        if (typeInfo.isIDSet()) {
            Property property2;
            XMLField xMLField2 = this.getXPathForField(property2, namespaceInfo, !this.helper.isAnnotationPresent((property2 = typeInfo.getIDProperty()).getElement(), XmlAttribute.class));
            xMLObjectReferenceMapping.addSourceToTargetKeyFieldAssociation(xMLField.getXPath(), xMLField2.getXPath());
        }
        xMLDescriptor.addMapping((DatabaseMapping)xMLObjectReferenceMapping);
    }

    public XMLField getXPathForField(Property property, NamespaceInfo namespaceInfo, boolean bl) {
        Object object;
        Object object2;
        String string = "";
        XMLField xMLField = null;
        if (this.helper.isAnnotationPresent(property.getElement(), XmlElementWrapper.class)) {
            object2 = (XmlElementWrapper)this.helper.getAnnotation(property.getElement(), XmlElementWrapper.class);
            object = object2.namespace();
            if (((String)object).equals("##default")) {
                object = namespaceInfo.isElementFormQualified() ? namespaceInfo.getNamespace() : "";
            }
            string = ((String)object).equals("") ? string + object2.name() + "/" : string + this.getPrefixForNamespace((String)object, namespaceInfo.getNamespaceResolver()) + ":" + object2.name() + "/";
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlAttribute.class)) {
            Object object3;
            object2 = property.getSchemaName();
            object = "";
            if (namespaceInfo.isAttributeFormQualified()) {
                object = namespaceInfo.getNamespace();
            }
            if (!((QName)object2).getNamespaceURI().equals("")) {
                object = ((QName)object2).getNamespaceURI();
            }
            if (((String)object).equals("")) {
                string = string + "@" + ((QName)object2).getLocalPart();
            } else {
                object3 = this.getPrefixForNamespace((String)object, namespaceInfo.getNamespaceResolver());
                string = string + "@" + (String)object3 + ":" + ((QName)object2).getLocalPart();
            }
            object3 = (QName)this.userDefinedSchemaTypes.get(property.getClass());
            if (property.getSchemaType() != null) {
                object3 = property.getSchemaType();
            }
            if (object3 == null) {
                object3 = (QName)this.helper.getXMLToJavaTypeMap().get(property.getType().getRawName());
            }
            XMLField xMLField2 = new XMLField(string);
            xMLField2.setSchemaType((QName)object3);
            return xMLField2;
        }
        if (this.helper.isAnnotationPresent(property.getElement(), XmlValue.class)) {
            string = "text()";
            object2 = new XMLField(string);
            object = (QName)this.userDefinedSchemaTypes.get(property.getType());
            if (property.getSchemaType() != null) {
                object = property.getSchemaType();
            }
            if (object == null) {
                object = (QName)this.helper.getXMLToJavaTypeMap().get(property.getType());
            }
            object2.setSchemaType((QName)object);
            return object2;
        }
        object2 = property.getSchemaName();
        xMLField = this.getXPathForElement(string, (QName)object2, namespaceInfo, bl);
        object = (QName)this.userDefinedSchemaTypes.get(property.getType());
        if (property.getSchemaType() != null) {
            object = property.getSchemaType();
        }
        if (object == null) {
            object = (QName)this.helper.getXMLToJavaTypeMap().get(property.getType());
        }
        xMLField.setSchemaType((QName)object);
        return xMLField;
    }

    public XMLField getXPathForElement(String string, QName qName, NamespaceInfo namespaceInfo, boolean bl) {
        String string2;
        String string3 = "";
        if (namespaceInfo.isElementFormQualified()) {
            string3 = namespaceInfo.getNamespace();
        }
        if (!qName.getNamespaceURI().equals("")) {
            string3 = qName.getNamespaceURI();
        }
        if (string3.equals("")) {
            string = string + qName.getLocalPart();
            if (bl) {
                string = string + "/text()";
            }
        } else {
            string2 = this.getPrefixForNamespace(string3, namespaceInfo.getNamespaceResolver());
            string = string + string2 + ":" + qName.getLocalPart();
            if (bl) {
                string = string + "/text()";
            }
        }
        string2 = new XMLField(string);
        return string2;
    }

    public Property getXmlValueFieldForSimpleContent(ArrayList<Property> arrayList) {
        boolean bl = false;
        boolean bl2 = false;
        Property property = null;
        for (Property property2 : arrayList) {
            if (this.helper.isAnnotationPresent(property2.getElement(), XmlValue.class)) {
                bl = true;
                property = property2;
                continue;
            }
            if (this.helper.isAnnotationPresent(property2.getElement(), XmlAttribute.class) || this.helper.isAnnotationPresent(property2.getElement(), XmlTransient.class) || this.helper.isAnnotationPresent(property2.getElement(), XmlAnyAttribute.class)) continue;
            bl2 = true;
        }
        if (bl && !bl2) {
            return property;
        }
        return null;
    }

    public ArrayList<Property> getPropertiesForClass(JavaClass javaClass, TypeInfo typeInfo) {
        if (typeInfo.getAccessType() == XmlAccessType.FIELD) {
            return this.getFieldPropertiesForClass(javaClass, typeInfo, false);
        }
        if (typeInfo.getAccessType() == XmlAccessType.PROPERTY) {
            return this.getPropertyPropertiesForClass(javaClass, typeInfo, false);
        }
        if (typeInfo.getAccessType() == XmlAccessType.PUBLIC_MEMBER) {
            return this.getPublicMemberPropertiesForClass(javaClass, typeInfo);
        }
        return this.getNoAccessTypePropertiesForClass(javaClass, typeInfo);
    }

    public ArrayList<Property> getFieldPropertiesForClass(JavaClass javaClass, TypeInfo typeInfo, boolean bl) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        for (JavaField javaField : new ArrayList(javaClass.getDeclaredFields())) {
            if (this.helper.isAnnotationPresent(javaField, XmlTransient.class) || (!Modifier.isPublic(javaField.getModifiers()) || !bl) && bl) continue;
            Property property = new Property();
            property.setPropertyName(javaField.getName());
            property.setElement(javaField);
            property.setType(this.helper.getType(javaField));
            property.setGenericType(this.helper.getGenericType(javaField));
            arrayList.add(property);
        }
        return arrayList;
    }

    public ArrayList<Property> getPropertyPropertiesForClass(JavaClass javaClass, TypeInfo typeInfo, boolean bl) {
        ArrayList<Property> arrayList = new ArrayList<Property>();
        ArrayList<JavaMethod> arrayList2 = new ArrayList<JavaMethod>();
        for (JavaMethod javaMethod : new ArrayList(javaClass.getDeclaredMethods())) {
            if (!javaMethod.getName().startsWith("get") && (!this.areEquals(javaMethod.getReturnType(), Boolean.class) && !this.areEquals(javaMethod.getReturnType(), Boolean.TYPE) || !javaMethod.getName().startsWith("is")) || (!bl || !Modifier.isPublic(javaMethod.getModifiers())) && bl) continue;
            arrayList2.add(javaMethod);
        }
        for (JavaMethod javaMethod : new ArrayList(javaClass.getDeclaredMethods())) {
            String string = "";
            if (javaMethod.getName().startsWith("get")) {
                string = javaMethod.getName().substring(3);
            } else if (javaMethod.getName().startsWith("is")) {
                string = javaMethod.getName().substring(2);
            }
            string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
            Property property = new Property(this.helper);
            property.setPropertyName(string);
            property.setType(javaMethod.getReturnType());
            property.setGenericType(this.helper.getGenericReturnType(javaMethod));
            String string2 = "set" + Character.toUpperCase(string.charAt(0)) + string.substring(1);
            JavaClass[] javaClassArray = new JavaClass[]{javaMethod.getReturnType()};
            JavaMethod javaMethod2 = javaClass.getMethod(string2, javaClassArray);
            if (javaMethod2 != null && !javaMethod2.getAnnotations().isEmpty()) {
                property.setElement(javaMethod2);
            } else if (!this.helper.isAnnotationPresent(javaMethod, XmlTransient.class)) {
                property.setElement(javaMethod);
            }
            if (this.helper.isAnnotationPresent(property.getElement(), XmlTransient.class)) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public ArrayList getPublicMemberPropertiesForClass(JavaClass javaClass, TypeInfo typeInfo) {
        ArrayList<Property> arrayList = this.getFieldPropertiesForClass(javaClass, typeInfo, true);
        ArrayList<Property> arrayList2 = this.getPropertyPropertiesForClass(javaClass, typeInfo, true);
        if (arrayList.size() >= 0 && arrayList2.size() == 0) {
            return arrayList;
        }
        if (arrayList2.size() > 0 && arrayList.size() == 0) {
            return arrayList2;
        }
        HashMap hashMap = this.getPropertyMapFromArrayList(arrayList);
        for (int i = 0; i < arrayList2.size(); ++i) {
            Property property = arrayList2.get(i);
            if (hashMap.get(property.getPropertyName()) != null) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public HashMap getPropertyMapFromArrayList(ArrayList<Property> arrayList) {
        HashMap<String, Property> hashMap = new HashMap<String, Property>(arrayList.size());
        for (Property property : arrayList) {
            hashMap.put(property.getPropertyName(), property);
        }
        return hashMap;
    }

    public ArrayList getNoAccessTypePropertiesForClass(JavaClass javaClass, TypeInfo typeInfo) {
        JavaHasAnnotations javaHasAnnotations;
        Property property;
        int n;
        ArrayList<Property> arrayList = new ArrayList<Property>();
        ArrayList<Property> arrayList2 = this.getFieldPropertiesForClass(javaClass, typeInfo, false);
        ArrayList<Property> arrayList3 = this.getPropertyPropertiesForClass(javaClass, typeInfo, false);
        for (n = 0; n < arrayList2.size(); ++n) {
            property = arrayList2.get(n);
            javaHasAnnotations = property.getElement();
            if (!this.helper.isAnnotationPresent(javaHasAnnotations, XmlElement.class) && !this.helper.isAnnotationPresent(javaHasAnnotations, XmlAttribute.class) && !this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyAttribute.class) && !this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyElement.class) && !this.helper.isAnnotationPresent(javaHasAnnotations, XmlValue.class)) continue;
            arrayList.add(property);
        }
        for (n = 0; n < arrayList3.size(); ++n) {
            property = arrayList3.get(n);
            javaHasAnnotations = property.getElement();
            if (!this.helper.isAnnotationPresent(javaHasAnnotations, XmlElement.class) && !this.helper.isAnnotationPresent(javaHasAnnotations, XmlAttribute.class) && !this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyAttribute.class) && !this.helper.isAnnotationPresent(javaHasAnnotations, XmlAnyElement.class) && !this.helper.isAnnotationPresent(javaHasAnnotations, XmlValue.class)) continue;
            arrayList.add(property);
        }
        return arrayList;
    }

    public void processSchemaType(XmlSchemaType xmlSchemaType) {
        String string = xmlSchemaType.name();
        Class clazz = xmlSchemaType.type();
        if (clazz == null) {
            return;
        }
        QName qName = new QName("http://www.w3.org/2001/XMLSchema-instance", string);
        this.userDefinedSchemaTypes.put(clazz, qName);
    }

    public ArrayList getEnumerationFacetsFor(EnumTypeInfo enumTypeInfo) {
        Collection<String> collection = enumTypeInfo.getObjectValuesToFieldValues().values();
        return new ArrayList<String>(collection);
    }

    public String getSchemaTypeNameForClassName(String string) {
        String string2 = Introspector.decapitalize(string.substring(string.lastIndexOf(46) + 1));
        return string2;
    }

    public boolean isMapType(Property property) {
        JavaClass javaClass = this.helper.getJavaClass(Map.class);
        return javaClass.isAssignableFrom(property.getType());
    }

    public void processGlobalElements(Project project) {
        if (this.globalElements == null) {
            return;
        }
        for (QName qName : this.globalElements.keySet()) {
            String string;
            NamespaceResolver namespaceResolver;
            String string2;
            Object object;
            String string3;
            ElementDeclaration elementDeclaration = this.globalElements.get(qName);
            String string4 = elementDeclaration.getJavaTypeName();
            TypeInfo typeInfo = this.typeInfo.get(string4);
            if (typeInfo != null) {
                if (qName.getNamespaceURI() == null || qName.getNamespaceURI().equals("")) {
                    typeInfo.getDescriptor().addRootElement(qName.getLocalPart());
                    continue;
                }
                string3 = typeInfo.getDescriptor();
                object = qName.getNamespaceURI();
                string2 = string3.getNamespaceResolver().resolveNamespaceURI((String)object);
                if (string2 == null) {
                    string2 = string3.getNamespaceResolver().generatePrefix();
                    string3.getNamespaceResolver().put(string2, (String)object);
                }
                string3.addRootElement(string2 + ":" + qName.getLocalPart());
                continue;
            }
            if (!this.helper.isBuiltInJavaType(elementDeclaration.getJavaType())) continue;
            string3 = qName.getNamespaceURI();
            if (string3 == null || string3.equals("##default")) {
                string3 = "";
            }
            object = this.generateWrapperClass(WRAPPER_CLASS + wrapperCounter++, string4);
            this.generatedClassesToQNames.put((Class)object, qName);
            string2 = new XMLDescriptor();
            string2.setJavaClass((Class)object);
            XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
            xMLDirectMapping.setAttributeName("value");
            xMLDirectMapping.setXPath("text()");
            if (string4.equals("[B") || string4.equals("[Ljava.lang.Byte;")) {
                ((XMLField)xMLDirectMapping.getField()).setSchemaType(XMLConstants.BASE_64_BINARY_QNAME);
            }
            string2.addMapping((DatabaseMapping)xMLDirectMapping);
            NamespaceInfo namespaceInfo = this.getNamespaceInfoForURI(string3);
            if (namespaceInfo != null) {
                namespaceResolver = namespaceInfo.getNamespaceResolver();
                string = namespaceResolver.resolveNamespaceURI(string3);
                string2.setNamespaceResolver(namespaceResolver);
                string2.setDefaultRootElement(string + ":" + qName.getLocalPart());
            } else if (string3.equals("")) {
                string2.setDefaultRootElement(qName.getLocalPart());
            } else {
                namespaceResolver = new NamespaceResolver();
                string = namespaceResolver.generatePrefix();
                namespaceResolver.put(string, string3);
                string2.setNamespaceResolver(namespaceResolver);
                string2.setDefaultRootElement(string + ":" + qName.getLocalPart());
            }
            project.addDescriptor((ClassDescriptor)string2);
        }
    }

    private NamespaceInfo getNamespaceInfoForURI(String string) {
        for (NamespaceInfo namespaceInfo : this.packageToNamespaceMappings.values()) {
            if (!namespaceInfo.getNamespace().equals(string)) continue;
            return namespaceInfo;
        }
        return null;
    }

    private String getPackageNameForURI(String string) {
        for (String string2 : this.packageToNamespaceMappings.keySet()) {
            if (!this.packageToNamespaceMappings.get(string2).getNamespace().equals(string)) continue;
            return string2;
        }
        return null;
    }

    public HashMap<Class, QName> getGeneratedClassesToQName() {
        return this.generatedClassesToQNames;
    }

    public Class generateWrapperClass(String string, String string2) {
        ClassWriter classWriter = new ClassWriter(false);
        classWriter.visit(49, 1, string.replace(".", "/"), Type.getType(Object.class).getInternalName(), new String[]{Type.getType(WrappedValue.class).getInternalName()}, null);
        CodeVisitor codeVisitor = classWriter.visitMethod(1, "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]), null, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitMethodInsn(183, Type.getType(Object.class).getInternalName(), "<init>", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[0]));
        codeVisitor.visitInsn(177);
        codeVisitor.visitMaxs(1, 1);
        String string3 = string2.replace(".", "/");
        if (!string3.startsWith("[")) {
            string3 = "L" + string3 + ";";
        }
        classWriter.visitField(1, "value", string3, null, null);
        Type type = Type.getType(Object.class);
        codeVisitor = classWriter.visitMethod(1, "getWrappedValue", Type.getMethodDescriptor((Type)Type.getType(Object.class), (Type[])new Type[0]), null, null);
        codeVisitor.visitVarInsn(25, 0);
        codeVisitor.visitFieldInsn(180, string.replace(".", "/"), "value", string3);
        codeVisitor.visitInsn(Type.getType(Object.class).getOpcode(172));
        codeVisitor.visitMaxs(1 + type.getSize(), 1);
        classWriter.visitEnd();
        byte[] byArray = classWriter.toByteArray();
        JaxbClassLoader jaxbClassLoader = (JaxbClassLoader)this.helper.getClassLoader();
        Class clazz = jaxbClassLoader.generateClass(string, byArray);
        return clazz;
    }
}

