/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.jaxb.javamodel;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import javax.xml.namespace.QName;
import org.eclipse.persistence.jaxb.javamodel.JavaAnnotation;
import org.eclipse.persistence.jaxb.javamodel.JavaClass;
import org.eclipse.persistence.jaxb.javamodel.JavaField;
import org.eclipse.persistence.jaxb.javamodel.JavaHasAnnotations;
import org.eclipse.persistence.jaxb.javamodel.JavaMethod;
import org.eclipse.persistence.jaxb.javamodel.JavaModel;
import org.eclipse.persistence.oxm.XMLConstants;

public class Helper {
    protected ClassLoader loader;
    protected JavaModel jModel;
    private HashMap xmlToJavaTypeMap;
    public static final String APBYTE = "byte[]";
    public static final String BIGDECIMAL = "java.math.BigDecimal";
    public static final String BIGINTEGER = "java.math.BigInteger";
    public static final String PBOOLEAN = "boolean";
    public static final String PBYTE = "byte";
    public static final String CALENDAR = "java.util.Calendar";
    public static final String PDOUBLE = "double";
    public static final String PFLOAT = "float";
    public static final String PINT = "int";
    public static final String PLONG = "long";
    public static final String PSHORT = "short";
    public static final String QNAME_CLASS = "javax.xml.namespace.QName";
    public static final String STRING = "java.lang.String";
    public static final String ABYTE = "java.lang.Byte[]";
    public static final String BOOLEAN = "java.lang.Boolean";
    public static final String BYTE = "java.lang.Byte";
    public static final String GREGORIAN_CALENDAR = "java.util.GregorianCalendar";
    public static final String DOUBLE = "java.lang.Double";
    public static final String FLOAT = "java.lang.Float";
    public static final String INTEGER = "java.lang.Integer";
    public static final String LONG = "java.lang.Long";
    public static final String SHORT = "java.lang.Short";
    public static final String UTIL_DATE = "java.util.Date";

    public Helper(JavaModel javaModel) {
        this.buildXMLToJavaTypeMap();
        this.setJavaModel(javaModel);
        this.setClassLoader(javaModel.getClassLoader());
    }

    private HashMap buildXMLToJavaTypeMap() {
        HashMap<String, QName> hashMap = new HashMap<String, QName>();
        hashMap.put(APBYTE, XMLConstants.HEX_BINARY_QNAME);
        hashMap.put(BIGDECIMAL, XMLConstants.DECIMAL_QNAME);
        hashMap.put(BIGINTEGER, XMLConstants.INTEGER_QNAME);
        hashMap.put(PBOOLEAN, XMLConstants.BOOLEAN_QNAME);
        hashMap.put(PBYTE, XMLConstants.BYTE_QNAME);
        hashMap.put(CALENDAR, XMLConstants.DATE_TIME_QNAME);
        hashMap.put(PDOUBLE, XMLConstants.DOUBLE_QNAME);
        hashMap.put(PFLOAT, XMLConstants.FLOAT_QNAME);
        hashMap.put(PINT, XMLConstants.INT_QNAME);
        hashMap.put(PLONG, XMLConstants.LONG_QNAME);
        hashMap.put(PSHORT, XMLConstants.SHORT_QNAME);
        hashMap.put(QNAME_CLASS, XMLConstants.QNAME_QNAME);
        hashMap.put(STRING, XMLConstants.STRING_QNAME);
        hashMap.put(ABYTE, XMLConstants.HEX_BINARY_QNAME);
        hashMap.put(BOOLEAN, XMLConstants.BOOLEAN_QNAME);
        hashMap.put(BYTE, XMLConstants.BYTE_QNAME);
        hashMap.put(GREGORIAN_CALENDAR, XMLConstants.DATE_TIME_QNAME);
        hashMap.put(DOUBLE, XMLConstants.DOUBLE_QNAME);
        hashMap.put(FLOAT, XMLConstants.FLOAT_QNAME);
        hashMap.put(INTEGER, XMLConstants.INT_QNAME);
        hashMap.put(LONG, XMLConstants.LONG_QNAME);
        hashMap.put(SHORT, XMLConstants.SHORT_QNAME);
        hashMap.put(UTIL_DATE, XMLConstants.DATE_QNAME);
        return hashMap;
    }

    public JavaClass getGenericType(JavaField javaField) {
        JavaClass javaClass = javaField.getResolvedType();
        JavaClass javaClass2 = null;
        if (javaClass.hasActualTypeArguments()) {
            ArrayList arrayList = (ArrayList)javaClass.getActualTypeArguments();
            javaClass2 = (JavaClass)arrayList.get(0);
        }
        return javaClass2;
    }

    public JavaClass getGenericReturnType(JavaMethod javaMethod) {
        JavaClass javaClass = javaMethod.getReturnType();
        JavaClass javaClass2 = null;
        if (javaClass == null) {
            return null;
        }
        if (javaClass.hasActualTypeArguments()) {
            ArrayList arrayList = (ArrayList)javaClass.getActualTypeArguments();
            javaClass2 = (JavaClass)arrayList.get(0);
        }
        return javaClass2;
    }

    public JavaClass getJavaClass(Class clazz) {
        return this.jModel.getClass(clazz);
    }

    public JavaClass getJavaClass(String string) {
        return this.jModel.getClass(string);
    }

    public HashMap getXMLToJavaTypeMap() {
        if (this.xmlToJavaTypeMap == null) {
            this.xmlToJavaTypeMap = this.buildXMLToJavaTypeMap();
        }
        return this.xmlToJavaTypeMap;
    }

    public Annotation getAnnotation(JavaHasAnnotations javaHasAnnotations, Class clazz) {
        JavaAnnotation javaAnnotation = javaHasAnnotations.getAnnotation(this.jModel.getClass(clazz));
        if (javaAnnotation == null) {
            return null;
        }
        return this.jModel.getAnnotation(javaAnnotation, clazz);
    }

    public JavaClass getType(JavaField javaField) {
        JavaClass javaClass = javaField.getResolvedType();
        try {
            return this.jModel.getClass(javaClass.getRawName());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean isAnnotationPresent(JavaHasAnnotations javaHasAnnotations, Class clazz) {
        if (javaHasAnnotations == null || clazz == null) {
            return false;
        }
        return javaHasAnnotations.getAnnotation(this.jModel.getClass(clazz)) != null;
    }

    public boolean isBuiltInJavaType(JavaClass javaClass) {
        return this.getXMLToJavaTypeMap().containsKey(javaClass.getRawName());
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.loader = classLoader;
    }

    public void setJavaModel(JavaModel javaModel) {
        this.jModel = javaModel;
    }

    public ClassLoader getClassLoader() {
        return this.loader;
    }
}

