/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.descriptors;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.CMPPolicy;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.ClassExtractor;
import org.eclipse.persistence.descriptors.MethodClassExtractor;
import org.eclipse.persistence.descriptors.PessimisticLockingPolicy;
import org.eclipse.persistence.descriptors.ReturningPolicy;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.descriptors.OptimisticLockingPolicy;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.DatabaseTable;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.queries.ExpressionQueryMechanism;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.Association;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.TypedAssociation;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.ReadAllQuery;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.sessions.remote.DistributedSession;

public class InheritancePolicy
implements Serializable,
Cloneable {
    protected Class parentClass;
    protected String parentClassName;
    protected ClassDescriptor parentDescriptor;
    protected Vector childDescriptors;
    protected transient DatabaseField classIndicatorField;
    protected transient Map classIndicatorMapping = new HashMap(10);
    protected transient Map classNameIndicatorMapping = new HashMap(10);
    protected transient boolean shouldUseClassNameAsIndicator = false;
    protected transient Boolean shouldReadSubclasses;
    protected transient boolean hasMultipleTableChild;
    protected transient DatabaseTable readAllSubclassesView;
    protected transient Vector allChildClassIndicators = NonSynchronizedVector.newInstance();
    protected transient Expression onlyInstancesExpression;
    protected transient Expression withAllSubclassesExpression;
    protected transient Vector allTables;
    protected transient List childrenTables;
    protected transient Map childrenTablesJoinExpressions;
    protected transient Expression childrenJoinExpression;
    protected transient ClassExtractor classExtractor;
    protected ClassDescriptor descriptor;
    protected boolean shouldAlwaysUseOuterJoin = false;
    protected boolean useDescriptorsToValidateInheritedObjects = false;
    protected boolean shouldOuterJoinSubclasses = false;
    protected boolean isJoinedStrategy;
    protected ClassDescriptor rootParentDescriptor;
    protected boolean describesNonPersistentSubclasses = false;

    public InheritancePolicy() {
        this.childDescriptors = NonSynchronizedVector.newInstance(5);
        this.setJoinedStrategy();
    }

    public InheritancePolicy(ClassDescriptor classDescriptor) {
        this();
        this.descriptor = classDescriptor;
    }

    public void addChildDescriptor(ClassDescriptor classDescriptor) {
        this.getChildDescriptors().addElement(classDescriptor);
    }

    protected void addChildTableJoinExpression(DatabaseTable databaseTable, Expression expression) {
        if (this.childrenTablesJoinExpressions == null) {
            this.childrenTablesJoinExpressions = new HashMap();
            this.childrenTables = new ArrayList();
            this.allTables = new Vector<DatabaseTable>(this.getDescriptor().getTables());
        }
        this.childrenTables.add(databaseTable);
        this.allTables.add(databaseTable);
        this.childrenTablesJoinExpressions.put(databaseTable, expression);
        this.childrenJoinExpression = expression.and(this.childrenJoinExpression);
    }

    public void addChildTableJoinExpressionToAllParents(DatabaseTable databaseTable, Expression expression) {
        ClassDescriptor classDescriptor = this.getParentDescriptor();
        while (classDescriptor != null) {
            InheritancePolicy inheritancePolicy = classDescriptor.getInheritancePolicy();
            inheritancePolicy.addChildTableJoinExpression(databaseTable, expression);
            classDescriptor = inheritancePolicy.getParentDescriptor();
        }
    }

    public void addClassIndicator(Class clazz, Object object) {
        this.getClassIndicatorMapping().put(object, clazz);
        this.getClassIndicatorMapping().put(clazz, object);
    }

    public void addClassNameIndicator(String string, Object object) {
        this.getClassNameIndicatorMapping().put(string, object);
    }

    public void addClassIndicatorFieldToInsertRow(AbstractRecord abstractRecord) {
        if (this.hasClassExtractor()) {
            return;
        }
        DatabaseField databaseField = this.getClassIndicatorField();
        abstractRecord.put(databaseField, (Object)null);
    }

    public void addClassIndicatorFieldToRow(AbstractRecord abstractRecord) {
        if (this.hasClassExtractor()) {
            return;
        }
        DatabaseField databaseField = this.getClassIndicatorField();
        Object object = this.getClassIndicatorValue();
        abstractRecord.put(databaseField, object);
    }

    protected void addClassIndicatorTypeToParent(Object object) {
        ClassDescriptor classDescriptor = this.getDescriptor().getInheritancePolicy().getParentDescriptor();
        if (classDescriptor.getInheritancePolicy().isChildDescriptor()) {
            if (classDescriptor.getInheritancePolicy().shouldReadSubclasses()) {
                classDescriptor.getInheritancePolicy().getAllChildClassIndicators().addElement(object);
            }
            classDescriptor.getInheritancePolicy().addClassIndicatorTypeToParent(object);
        }
    }

    protected void addFieldsToParent(Vector vector) {
        if (this.isChildDescriptor()) {
            if (this.getParentDescriptor().isInvalid()) {
                return;
            }
            ClassDescriptor classDescriptor = this.getParentDescriptor();
            if (classDescriptor.getInheritancePolicy().shouldReadSubclasses()) {
                Helper.addAllUniqueToVector(classDescriptor.getAllFields(), vector);
            }
            classDescriptor.getInheritancePolicy().addFieldsToParent(vector);
        }
    }

    public SQLSelectStatement buildClassIndicatorSelectStatement(ObjectLevelReadQuery objectLevelReadQuery) {
        SQLSelectStatement sQLSelectStatement = new SQLSelectStatement();
        sQLSelectStatement.useDistinct();
        sQLSelectStatement.addTable(this.classIndicatorField.getTable());
        sQLSelectStatement.addField(this.getClassIndicatorField());
        IdentityHashMap identityHashMap = new IdentityHashMap();
        sQLSelectStatement.setWhereClause(((ExpressionQueryMechanism)objectLevelReadQuery.getQueryMechanism()).buildBaseSelectionCriteria(false, identityHashMap));
        this.appendWithAllSubclassesExpression(sQLSelectStatement);
        sQLSelectStatement.setTranslationRow(objectLevelReadQuery.getTranslationRow());
        if (objectLevelReadQuery.isReadAllQuery() && ((ReadAllQuery)objectLevelReadQuery).hasHierarchicalExpressions()) {
            ReadAllQuery readAllQuery = (ReadAllQuery)objectLevelReadQuery;
            sQLSelectStatement.setHierarchicalQueryExpressions(readAllQuery.getStartWithExpression(), readAllQuery.getConnectByExpression(), readAllQuery.getOrderSiblingsByExpressions());
        }
        sQLSelectStatement.setHintString(objectLevelReadQuery.getHintString());
        sQLSelectStatement.normalize(objectLevelReadQuery.getSession(), this.getDescriptor(), identityHashMap);
        return sQLSelectStatement;
    }

    public void appendWithAllSubclassesExpression(SQLSelectStatement sQLSelectStatement) {
        if (this.getWithAllSubclassesExpression() != null) {
            if (sQLSelectStatement.getWhereClause() == null) {
                sQLSelectStatement.setWhereClause((Expression)this.getWithAllSubclassesExpression().clone());
            } else {
                sQLSelectStatement.setWhereClause(sQLSelectStatement.getWhereClause().and(this.getWithAllSubclassesExpression()));
            }
        }
    }

    public SQLSelectStatement buildViewSelectStatement(ObjectLevelReadQuery objectLevelReadQuery) {
        Expression expression;
        IdentityHashMap identityHashMap = new IdentityHashMap();
        ExpressionQueryMechanism expressionQueryMechanism = (ExpressionQueryMechanism)objectLevelReadQuery.getQueryMechanism();
        SQLSelectStatement sQLSelectStatement = expressionQueryMechanism.buildBaseSelectStatement(false, identityHashMap);
        sQLSelectStatement.setTables(NonSynchronizedVector.newInstance(1));
        sQLSelectStatement.addTable(this.getReadAllSubclassesView());
        if (this.getWithAllSubclassesExpression() != null && (expression = (Expression)this.getWithAllSubclassesExpression().clone()) != null) {
            sQLSelectStatement.setWhereClause(expression.and(sQLSelectStatement.getWhereClause()));
        }
        sQLSelectStatement.setFields(expressionQueryMechanism.getSelectionFields(sQLSelectStatement, true));
        sQLSelectStatement.normalizeForView(objectLevelReadQuery.getSession(), this.getDescriptor(), identityHashMap);
        if (objectLevelReadQuery.hasJoining()) {
            objectLevelReadQuery.getJoinedAttributeManager().computeJoiningMappingIndexes(false, objectLevelReadQuery.getSession(), 0);
        }
        return sQLSelectStatement;
    }

    public Class classFromRow(AbstractRecord abstractRecord, AbstractSession abstractSession) throws DescriptorException {
        Class<?> clazz;
        if (this.hasClassExtractor()) {
            return this.getClassExtractor().extractClassFromRow(abstractRecord, abstractSession);
        }
        Object object = abstractSession.getDatasourcePlatform().getConversionManager().convertObject(abstractRecord.get(this.getClassIndicatorField()), this.getClassIndicatorField().getType());
        if (object == null) {
            throw DescriptorException.missingClassIndicatorField(abstractRecord, this.getDescriptor());
        }
        if (!this.shouldUseClassNameAsIndicator()) {
            clazz = (Class<?>)this.getClassIndicatorMapping().get(object);
            if (clazz == null) {
                throw DescriptorException.missingClassForIndicatorFieldValue(object, this.getDescriptor());
            }
        } else {
            try {
                String string = (String)object;
                clazz = this.getDescriptor().getJavaClass().getClassLoader().loadClass(string);
                if (clazz == null) {
                    throw DescriptorException.missingClassForIndicatorFieldValue(object, this.getDescriptor());
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw DescriptorException.missingClassForIndicatorFieldValue(object, this.getDescriptor());
            }
            catch (ClassCastException classCastException) {
                throw DescriptorException.missingClassForIndicatorFieldValue(object, this.getDescriptor());
            }
        }
        return clazz;
    }

    public Object clone() {
        InheritancePolicy inheritancePolicy = null;
        try {
            inheritancePolicy = (InheritancePolicy)super.clone();
            if (this.hasClassIndicator()) {
                inheritancePolicy.setClassIndicatorField((DatabaseField)inheritancePolicy.getClassIndicatorField().clone());
            }
        }
        catch (Exception exception) {
            throw new InternalError("clone failed");
        }
        return inheritancePolicy;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Object object;
        block13: {
            Iterator iterator = this.getClassNameIndicatorMapping().keySet().iterator();
            Iterator iterator2 = this.getClassNameIndicatorMapping().values().iterator();
            this.classIndicatorMapping = new HashMap();
            while (iterator.hasNext()) {
                Class clazz;
                Object v;
                block12: {
                    object = iterator.next();
                    v = iterator2.next();
                    clazz = null;
                    try {
                        if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                            try {
                                clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName((String)object, true, classLoader));
                                break block12;
                            }
                            catch (PrivilegedActionException privilegedActionException) {
                                throw ValidationException.classNotFoundWhileConvertingClassNames((String)object, (Exception)privilegedActionException.getCause());
                            }
                        }
                        clazz = PrivilegedAccessHelper.getClassForName((String)object, true, classLoader);
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames((String)object, classNotFoundException);
                    }
                }
                this.classIndicatorMapping.put(clazz, v);
                this.classIndicatorMapping.put(v, clazz);
            }
            if (this.getParentClassName() == null) {
                return;
            }
            object = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        object = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getParentClassName(), true, classLoader));
                        break block13;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getParentClassName(), privilegedActionException.getException());
                    }
                }
                object = PrivilegedAccessHelper.getClassForName(this.getParentClassName(), true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.parentClassName, classNotFoundException);
            }
        }
        this.setParentClass((Class)object);
    }

    public void dontReadSubclassesOnQueries() {
        this.setShouldReadSubclasses(false);
    }

    public void dontUseClassNameAsIndicator() {
        this.setShouldUseClassNameAsIndicator(false);
    }

    protected Vector getAllChildClassIndicators() {
        return this.allChildClassIndicators;
    }

    public Vector getAllChildDescriptors() {
        Vector vector = new Vector(this.getAllChildClassIndicators().size());
        return this.getAllChildDescriptors(vector);
    }

    protected Vector getAllChildDescriptors(Vector vector) {
        Enumeration enumeration = this.getChildDescriptors().elements();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)enumeration.nextElement();
            vector.addElement(classDescriptor);
            classDescriptor.getInheritancePolicyOrNull().getAllChildDescriptors(vector);
        }
        return vector;
    }

    public List getChildrenTables() {
        return this.childrenTables;
    }

    public Map getChildrenTablesJoinExpressions() {
        return this.childrenTablesJoinExpressions;
    }

    public Expression getChildrenJoinExpression() {
        return this.childrenJoinExpression;
    }

    public Vector getAllTables() {
        if (this.allTables == null) {
            return this.getDescriptor().getTables();
        }
        return this.allTables;
    }

    public Vector getChildDescriptors() {
        return this.childDescriptors;
    }

    protected Method getClassExtractionMethod() {
        if (this.classExtractor instanceof MethodClassExtractor) {
            return ((MethodClassExtractor)this.classExtractor).getClassExtractionMethod();
        }
        return null;
    }

    public String getClassExtractionMethodName() {
        if (this.classExtractor instanceof MethodClassExtractor) {
            return ((MethodClassExtractor)this.classExtractor).getClassExtractionMethodName();
        }
        return null;
    }

    public ClassExtractor getClassExtractor() {
        return this.classExtractor;
    }

    public void setClassExtractor(ClassExtractor classExtractor) {
        this.classExtractor = classExtractor;
    }

    public Vector getClassIndicatorAssociations() {
        Vector<TypedAssociation> vector = new Vector<TypedAssociation>(this.getClassNameIndicatorMapping().size() / 2);
        Iterator iterator = this.getClassNameIndicatorMapping().keySet().iterator();
        Iterator iterator2 = this.getClassNameIndicatorMapping().values().iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof Class) {
                object = ((Class)object).getName();
            }
            Object v = iterator2.next();
            vector.addElement(new TypedAssociation(object, v));
        }
        return vector;
    }

    public DatabaseField getClassIndicatorField() {
        return this.classIndicatorField;
    }

    public String getClassIndicatorFieldName() {
        if (this.getClassIndicatorField() == null) {
            return null;
        }
        return this.getClassIndicatorField().getQualifiedName();
    }

    public Map getClassIndicatorMapping() {
        return this.classIndicatorMapping;
    }

    public Map getClassNameIndicatorMapping() {
        if (this.classNameIndicatorMapping.isEmpty() && !this.classIndicatorMapping.isEmpty()) {
            Iterator iterator = this.classIndicatorMapping.keySet().iterator();
            Iterator iterator2 = this.classIndicatorMapping.values().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                Object v = iterator2.next();
                if (!(k instanceof Class)) continue;
                String string = ((Class)k).getName();
                this.classNameIndicatorMapping.put(string, v);
            }
        }
        return this.classNameIndicatorMapping;
    }

    protected Object getClassIndicatorValue() {
        return this.getClassIndicatorValue(this.getDescriptor().getJavaClass());
    }

    protected Object getClassIndicatorValue(Class clazz) {
        if (this.shouldUseClassNameAsIndicator()) {
            return clazz.getName();
        }
        return this.getClassIndicatorMapping().get(clazz);
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean getDescribesNonPersistentSubclasses() {
        return this.describesNonPersistentSubclasses;
    }

    public Expression getOnlyInstancesExpression() {
        return this.onlyInstancesExpression;
    }

    public Class getParentClass() {
        return this.parentClass;
    }

    public String getParentClassName() {
        if (this.parentClassName == null && this.parentClass != null) {
            this.parentClassName = this.parentClass.getName();
        }
        return this.parentClassName;
    }

    public ClassDescriptor getParentDescriptor() {
        return this.parentDescriptor;
    }

    public DatabaseTable getReadAllSubclassesView() {
        return this.readAllSubclassesView;
    }

    public String getReadAllSubclassesViewName() {
        if (this.getReadAllSubclassesView() == null) {
            return null;
        }
        return this.getReadAllSubclassesView().getName();
    }

    public ClassDescriptor getRootParentDescriptor() {
        if (this.rootParentDescriptor == null) {
            this.rootParentDescriptor = this.isRootParentDescriptor() ? this.getDescriptor() : this.getParentDescriptor().getInheritancePolicy().getRootParentDescriptor();
        }
        return this.rootParentDescriptor;
    }

    public ClassDescriptor getSubclassDescriptor(Class clazz) {
        if (this.hasChildren()) {
            for (ClassDescriptor classDescriptor : this.getChildDescriptors()) {
                if (classDescriptor.getJavaClass().equals(clazz)) {
                    return classDescriptor;
                }
                ClassDescriptor classDescriptor2 = classDescriptor.getInheritancePolicy().getSubclassDescriptor(clazz);
                if (classDescriptor2 == null) continue;
                return classDescriptor2;
            }
        }
        return null;
    }

    public ClassDescriptor getDescriptor(Class clazz) {
        if (this.getDescriptor().getJavaClass().equals(clazz)) {
            return this.getDescriptor();
        }
        return this.getSubclassDescriptor(clazz);
    }

    public boolean getUseDescriptorsToValidateInheritedObjects() {
        return this.useDescriptorsToValidateInheritedObjects;
    }

    public Expression getWithAllSubclassesExpression() {
        return this.withAllSubclassesExpression;
    }

    public boolean hasChildren() {
        return !this.getChildDescriptors().isEmpty();
    }

    public boolean hasClassExtractor() {
        return this.getClassExtractor() != null;
    }

    public boolean hasClassIndicator() {
        return this.getClassIndicatorField() != null;
    }

    public boolean hasMultipleTableChild() {
        return this.childrenTables != null;
    }

    public boolean hasView() {
        return this.getReadAllSubclassesView() != null;
    }

    public void initialize(AbstractSession abstractSession) {
        if (this.shouldReadSubclasses == null || this.shouldReadSubclasses()) {
            this.setShouldReadSubclasses(!this.getChildDescriptors().isEmpty());
        }
        if (this.isChildDescriptor()) {
            CMPPolicy cMPPolicy;
            this.getDescriptor().setMappings(Helper.concatenateVectors(this.getParentDescriptor().getMappings(), this.getDescriptor().getMappings()));
            this.getDescriptor().setQueryKeys(Helper.concatenateMaps(this.getParentDescriptor().getQueryKeys(), this.getDescriptor().getQueryKeys()));
            this.addFieldsToParent(this.getDescriptor().getFields());
            Vector vector = (Vector)this.getParentDescriptor().getFields().clone();
            Helper.addAllUniqueToVector(vector, this.getDescriptor().getFields());
            this.getDescriptor().setFields(vector);
            if (this.getClassIndicatorValue() != null) {
                if (this.shouldReadSubclasses()) {
                    this.getAllChildClassIndicators().addElement(this.getClassIndicatorValue());
                }
                this.addClassIndicatorTypeToParent(this.getClassIndicatorValue());
            }
            this.initializeOptimisticLocking();
            if (!this.getDescriptor().hasReturningPolicy() && this.getParentDescriptor().hasReturningPolicy()) {
                this.getDescriptor().setReturningPolicy(new ReturningPolicy());
            }
            if ((cMPPolicy = this.getDescriptor().getInheritancePolicy().getParentDescriptor().getCMPPolicy()) != null) {
                CMPPolicy cMPPolicy2 = this.getDescriptor().getCMPPolicy();
                if (cMPPolicy2 == null) {
                    cMPPolicy2 = new CMPPolicy();
                    this.getDescriptor().setCMPPolicy(cMPPolicy2);
                }
                if (cMPPolicy.hasPessimisticLockingPolicy() && !cMPPolicy2.hasPessimisticLockingPolicy()) {
                    cMPPolicy2.setPessimisticLockingPolicy((PessimisticLockingPolicy)cMPPolicy.getPessimisticLockingPolicy().clone());
                }
                if (cMPPolicy2.internalGetForceUpdate() == null) {
                    cMPPolicy2.internalSetForceUpdate(cMPPolicy.internalGetForceUpdate());
                }
                if (cMPPolicy2.internalGetUpdateAllFields() == null) {
                    cMPPolicy2.internalSetUpdateAllFields(cMPPolicy.internalGetUpdateAllFields());
                }
            }
            if (this.getParentDescriptor().isNativeConnectionRequired()) {
                this.getDescriptor().setIsNativeConnectionRequired(true);
            }
        }
        this.initializeOnlyInstancesExpression();
        this.initializeWithAllSubclassesExpression();
        if (this.hasView() && abstractSession.getDatasourcePlatform().getTableQualifier().length() != 0 && this.getReadAllSubclassesView().getTableQualifier().length() == 0) {
            this.getReadAllSubclassesView().setTableQualifier(abstractSession.getDatasourcePlatform().getTableQualifier());
        }
    }

    protected void initializeClassExtractor(AbstractSession abstractSession) throws DescriptorException {
        if (this.getClassExtractor() == null) {
            if (this.isChildDescriptor()) {
                this.setClassExtractor(this.getParentDescriptor().getInheritancePolicy().getClassExtractor());
            }
        } else {
            this.getClassExtractor().initialize(this.getDescriptor(), abstractSession);
        }
    }

    protected void initializeOnlyInstancesExpression() throws DescriptorException {
        if (this.getOnlyInstancesExpression() == null) {
            if (this.hasClassExtractor()) {
                return;
            }
            Object object = this.getClassIndicatorValue();
            if (object == null) {
                if (this.shouldReadSubclasses()) {
                    return;
                }
                throw DescriptorException.valueNotFoundInClassIndicatorMapping(this.getParentDescriptor(), this.getDescriptor());
            }
            DatabaseField databaseField = this.getClassIndicatorField();
            if (databaseField == null) {
                throw DescriptorException.classIndicatorFieldNotFound(this.getParentDescriptor(), this.getDescriptor());
            }
            if (this.shouldAlwaysUseOuterJoin()) {
                this.setOnlyInstancesExpression(new ExpressionBuilder().getField(databaseField).equalOuterJoin(object));
            } else {
                this.setOnlyInstancesExpression(new ExpressionBuilder().getField(databaseField).equal(object));
            }
        }
        if (!this.shouldReadSubclasses()) {
            this.getDescriptor().getQueryManager().setAdditionalJoinExpression(this.getOnlyInstancesExpression().and(this.getDescriptor().getQueryManager().getAdditionalJoinExpression()));
        }
    }

    protected void initializeOptimisticLocking() {
        if (!this.getDescriptor().usesOptimisticLocking() && this.getParentDescriptor().usesOptimisticLocking()) {
            this.getDescriptor().setOptimisticLockingPolicy((OptimisticLockingPolicy)this.getParentDescriptor().getOptimisticLockingPolicy().clone());
            this.getDescriptor().getOptimisticLockingPolicy().setDescriptor(this.getDescriptor());
        }
    }

    protected void initializeWithAllSubclassesExpression() throws DescriptorException {
        if (this.getWithAllSubclassesExpression() == null) {
            if (this.hasClassExtractor()) {
                return;
            }
            if (this.isChildDescriptor() && this.shouldReadSubclasses()) {
                this.setWithAllSubclassesExpression(new ExpressionBuilder().getField(this.getClassIndicatorField()).in(this.getAllChildClassIndicators()));
            }
        }
    }

    public boolean isChildDescriptor() {
        return this.getParentClassName() != null;
    }

    public boolean isJoinedStrategy() {
        return this.isJoinedStrategy;
    }

    public boolean isRootParentDescriptor() {
        return this.getParentDescriptor() == null;
    }

    public void postInitialize(AbstractSession abstractSession) {
    }

    public void preInitialize(AbstractSession abstractSession) throws DescriptorException {
        Vector vector;
        Object object;
        Serializable serializable;
        if (this.isChildDescriptor()) {
            serializable = this.getDescriptor().getTables();
            object = this.getParentDescriptor().getTables();
            vector = Helper.concatenateUniqueVectors(object, serializable);
            this.getDescriptor().setTables(vector);
            if (serializable.isEmpty()) {
                this.getDescriptor().setInternalDefaultTable();
            } else {
                this.getDescriptor().setInternalDefaultTable((DatabaseTable)vector.get(vector.indexOf(serializable.get(0))));
            }
            this.setClassIndicatorMapping(this.getParentDescriptor().getInheritancePolicy().getClassIndicatorMapping());
            this.setShouldUseClassNameAsIndicator(this.getParentDescriptor().getInheritancePolicy().shouldUseClassNameAsIndicator());
            this.getDescriptor().setPrimaryKeyFields(this.getParentDescriptor().getPrimaryKeyFields());
            this.getDescriptor().setAdditionalTablePrimaryKeyFields(Helper.concatenateMaps(this.getParentDescriptor().getAdditionalTablePrimaryKeyFields(), this.getDescriptor().getAdditionalTablePrimaryKeyFields()));
            Expression expression = this.getDescriptor().getQueryManager().getMultipleTableJoinExpression();
            Expression expression2 = this.getParentDescriptor().getQueryManager().getMultipleTableJoinExpression();
            if (expression != null) {
                this.getDescriptor().getQueryManager().setInternalMultipleTableJoinExpression(expression.and(expression2));
            } else if (expression2 != null) {
                this.getDescriptor().getQueryManager().setInternalMultipleTableJoinExpression(expression2);
            }
            Expression expression3 = this.getDescriptor().getQueryManager().getAdditionalJoinExpression();
            Expression expression4 = this.getParentDescriptor().getQueryManager().getAdditionalJoinExpression();
            if (expression3 != null) {
                this.getDescriptor().getQueryManager().setAdditionalJoinExpression(expression3.and(expression4));
            } else if (expression4 != null) {
                this.getDescriptor().getQueryManager().setAdditionalJoinExpression(expression4);
            }
            this.setClassIndicatorField(this.getParentDescriptor().getInheritancePolicy().getClassIndicatorField());
            if (!this.getDescriptor().usesSequenceNumbers()) {
                this.getDescriptor().setSequenceNumberField(this.getParentDescriptor().getSequenceNumberField());
                this.getDescriptor().setSequenceNumberName(this.getParentDescriptor().getSequenceNumberName());
            }
        } else {
            this.getDescriptor().setInternalDefaultTable();
        }
        this.initializeClassExtractor(abstractSession);
        if (!this.isChildDescriptor()) {
            if (this.getClassIndicatorField() == null && !this.hasClassExtractor()) {
                abstractSession.getIntegrityChecker().handleError(DescriptorException.classIndicatorFieldNotFound(this.getDescriptor(), this.getDescriptor()));
            }
            if (this.getClassIndicatorField() != null) {
                this.setClassIndicatorField(this.getDescriptor().buildField(this.getClassIndicatorField()));
                if (this.shouldUseClassNameAsIndicator()) {
                    this.getClassIndicatorField().setType(ClassConstants.STRING);
                } else if (!this.getClassIndicatorMapping().isEmpty()) {
                    serializable = null;
                    object = this.getClassIndicatorMapping().values().iterator();
                    while (object.hasNext() && serializable == null) {
                        vector = object.next();
                        if (vector.getClass() == this.getClass().getClass()) continue;
                        serializable = vector.getClass();
                    }
                    this.getClassIndicatorField().setType((Class)serializable);
                }
                this.getDescriptor().getFields().addElement(this.getClassIndicatorField());
            }
        }
    }

    public void readSubclassesOnQueries() {
        this.setShouldReadSubclasses(true);
    }

    public void remoteInitialization(DistributedSession distributedSession) {
        if (this.isChildDescriptor()) {
            if (distributedSession.hasCorrespondingDescriptor(this.getParentDescriptor())) {
                this.setParentDescriptor(distributedSession.getDescriptor(this.getParentClass()));
            } else {
                distributedSession.privilegedAddDescriptor(this.getParentDescriptor());
                this.getParentDescriptor().remoteInitialization(distributedSession);
            }
        }
        Vector<ClassDescriptor> vector = new Vector<ClassDescriptor>(this.getChildDescriptors().size());
        Enumeration enumeration = this.getChildDescriptors().elements();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor classDescriptor = (ClassDescriptor)enumeration.nextElement();
            if (distributedSession.hasCorrespondingDescriptor(classDescriptor)) {
                vector.addElement(distributedSession.getDescriptor(classDescriptor.getJavaClass()));
                continue;
            }
            distributedSession.privilegedAddDescriptor(classDescriptor);
            classDescriptor.remoteInitialization(distributedSession);
            vector.addElement(classDescriptor);
        }
        this.setChildDescriptors(vector);
    }

    public boolean requiresMultipleTableSubclassRead() {
        return this.hasMultipleTableChild() && this.shouldReadSubclasses();
    }

    protected Vector selectAllRowUsingCustomMultipleTableSubclassRead(ReadAllQuery readAllQuery) throws DatabaseException {
        Cloneable cloneable;
        Object object;
        Vector vector = new Vector();
        if (this.getOnlyInstancesExpression() != null || !this.shouldReadSubclasses()) {
            object = (ReadAllQuery)readAllQuery.clone();
            ((ObjectLevelReadQuery)object).setReferenceClass(this.getDescriptor().getJavaClass());
            ((ObjectLevelReadQuery)object).setDescriptor(this.getDescriptor());
            cloneable = ((ExpressionQueryMechanism)((DatabaseQuery)object).getQueryMechanism()).selectAllRowsFromConcreteTable();
            vector = Helper.concatenateVectors(vector, (Vector)cloneable);
        }
        object = this.getChildDescriptors().elements();
        while (object.hasMoreElements()) {
            cloneable = (ClassDescriptor)object.nextElement();
            Vector vector2 = cloneable.getInheritancePolicy().selectAllRowUsingCustomMultipleTableSubclassRead(readAllQuery);
            vector = Helper.concatenateVectors(vector, vector2);
        }
        return vector;
    }

    protected Vector selectAllRowUsingDefaultMultipleTableSubclassRead(ReadAllQuery readAllQuery) throws DatabaseException, QueryException {
        Object object;
        Map map;
        Vector vector = ((ExpressionQueryMechanism)readAllQuery.getQueryMechanism()).selectAllRowsFromTable();
        Vector<Object> vector2 = new Vector<Object>();
        Object object2 = vector.elements();
        while (object2.hasMoreElements()) {
            map = (AbstractRecord)object2.nextElement();
            object = this.classFromRow((AbstractRecord)map, readAllQuery.getSession());
            if (vector2.contains(object)) continue;
            vector2.addElement(object);
        }
        object2 = new Vector();
        map = null;
        if (readAllQuery.hasJoining()) {
            map = new HashMap();
        }
        object = vector2.elements();
        while (object.hasMoreElements()) {
            Class clazz = (Class)object.nextElement();
            ClassDescriptor classDescriptor = this.getDescriptor(clazz);
            if (classDescriptor == null) {
                throw QueryException.noDescriptorForClassFromInheritancePolicy(readAllQuery, clazz);
            }
            ReadAllQuery readAllQuery2 = (ReadAllQuery)readAllQuery.clone();
            readAllQuery2.setReferenceClass(clazz);
            readAllQuery2.setDescriptor(classDescriptor);
            Vector vector3 = ((ExpressionQueryMechanism)readAllQuery2.getQueryMechanism()).selectAllRowsFromConcreteTable();
            object2 = Helper.concatenateVectors((Vector)object2, vector3);
            if (map == null) continue;
            for (Map.Entry<DatabaseMapping, Object> entry : readAllQuery2.getJoinedAttributeManager().getJoinedMappingIndexes_().entrySet()) {
                HashMap<Class, Object> hashMap = (HashMap<Class, Object>)((HashMap)map).get(entry.getKey());
                if (hashMap == null) {
                    hashMap = new HashMap<Class, Object>(vector2.size());
                    ((HashMap)map).put(entry.getKey(), hashMap);
                }
                hashMap.put(clazz, entry.getValue());
            }
        }
        if (map != null) {
            readAllQuery.getJoinedAttributeManager().setJoinedMappingIndexes_(map);
        }
        return object2;
    }

    public Vector selectAllRowUsingMultipleTableSubclassRead(ReadAllQuery readAllQuery) throws DatabaseException {
        if (this.hasClassExtractor()) {
            return this.selectAllRowUsingCustomMultipleTableSubclassRead(readAllQuery);
        }
        return this.selectAllRowUsingDefaultMultipleTableSubclassRead(readAllQuery);
    }

    protected AbstractRecord selectOneRowUsingCustomMultipleTableSubclassRead(ReadObjectQuery readObjectQuery) throws DatabaseException {
        Cloneable cloneable;
        Object object;
        if (this.getOnlyInstancesExpression() != null || !this.shouldReadSubclasses()) {
            object = (ReadObjectQuery)readObjectQuery.clone();
            ((ObjectLevelReadQuery)object).setReferenceClass(this.getDescriptor().getJavaClass());
            ((ObjectLevelReadQuery)object).setDescriptor(this.getDescriptor());
            cloneable = ((ExpressionQueryMechanism)((DatabaseQuery)object).getQueryMechanism()).selectOneRowFromConcreteTable();
            if (cloneable != null) {
                return cloneable;
            }
        }
        object = this.getChildDescriptors().elements();
        while (object.hasMoreElements()) {
            cloneable = (ClassDescriptor)object.nextElement();
            AbstractRecord abstractRecord = cloneable.getInheritancePolicy().selectOneRowUsingCustomMultipleTableSubclassRead(readObjectQuery);
            if (abstractRecord == null) continue;
            return abstractRecord;
        }
        return null;
    }

    protected AbstractRecord selectOneRowUsingDefaultMultipleTableSubclassRead(ReadObjectQuery readObjectQuery) throws DatabaseException, QueryException {
        AbstractRecord abstractRecord = ((ExpressionQueryMechanism)readObjectQuery.getQueryMechanism()).selectOneRowFromTable();
        if (abstractRecord == null) {
            return null;
        }
        Class clazz = this.classFromRow(abstractRecord, readObjectQuery.getSession());
        ClassDescriptor classDescriptor = this.getDescriptor(clazz);
        if (classDescriptor == null) {
            throw QueryException.noDescriptorForClassFromInheritancePolicy(readObjectQuery, clazz);
        }
        ReadObjectQuery readObjectQuery2 = (ReadObjectQuery)readObjectQuery.clone();
        readObjectQuery2.setReferenceClass(clazz);
        readObjectQuery2.setDescriptor(classDescriptor);
        AbstractRecord abstractRecord2 = ((ExpressionQueryMechanism)readObjectQuery2.getQueryMechanism()).selectOneRowFromConcreteTable();
        return abstractRecord2;
    }

    public AbstractRecord selectOneRowUsingMultipleTableSubclassRead(ReadObjectQuery readObjectQuery) throws DatabaseException, QueryException {
        if (this.hasClassExtractor()) {
            return this.selectOneRowUsingCustomMultipleTableSubclassRead(readObjectQuery);
        }
        return this.selectOneRowUsingDefaultMultipleTableSubclassRead(readObjectQuery);
    }

    protected void setAllChildClassIndicators(Vector vector) {
        this.allChildClassIndicators = vector;
    }

    public void setChildDescriptors(Vector vector) {
        this.childDescriptors = vector;
    }

    public void setClassExtractionMethodName(String string) {
        if (string == null || string.length() == 0) {
            return;
        }
        if (!(this.getClassExtractor() instanceof MethodClassExtractor)) {
            this.setClassExtractor(new MethodClassExtractor());
        }
        ((MethodClassExtractor)this.getClassExtractor()).setClassExtractionMethodName(string);
    }

    public void setClassIndicatorAssociations(Vector vector) {
        this.setClassNameIndicatorMapping(new HashMap(vector.size() + 1));
        this.setClassIndicatorMapping(new HashMap(vector.size() * 2 + 1));
        for (Association association : vector) {
            Object object = association.getKey();
            if (object instanceof String) {
                object = ConversionManager.getDefaultManager().convertClassNameToClass((String)object);
            }
            this.addClassIndicator((Class)object, association.getValue());
        }
    }

    public void setClassIndicatorField(DatabaseField databaseField) {
        this.classIndicatorField = databaseField;
    }

    public void setClassIndicatorFieldName(String string) {
        if (string == null) {
            this.setClassIndicatorField(null);
        } else {
            this.setClassIndicatorField(new DatabaseField(string));
        }
    }

    public void setClassIndicatorMapping(Map map) {
        this.classIndicatorMapping = map;
    }

    public void setClassNameIndicatorMapping(Map map) {
        this.classNameIndicatorMapping = map;
    }

    public void setDescriptor(ClassDescriptor classDescriptor) {
        this.descriptor = classDescriptor;
    }

    public void setDescribesNonPersistentSubclasses(boolean bl) {
        this.describesNonPersistentSubclasses = bl;
    }

    public void setJoinedStrategy() {
        this.isJoinedStrategy = true;
    }

    public void setOnlyInstancesExpression(Expression expression) {
        this.onlyInstancesExpression = expression;
    }

    public void setParentClass(Class clazz) {
        this.parentClass = clazz;
        if (clazz != null) {
            this.setParentClassName(clazz.getName());
        }
    }

    public void setParentClassName(String string) {
        this.parentClassName = string;
    }

    public void setParentDescriptor(ClassDescriptor classDescriptor) {
        this.parentDescriptor = classDescriptor;
    }

    protected void setReadAllSubclassesView(DatabaseTable databaseTable) {
        this.readAllSubclassesView = databaseTable;
    }

    public void setReadAllSubclassesViewName(String string) {
        if (string == null) {
            this.setReadAllSubclassesView(null);
        } else {
            this.setReadAllSubclassesView(new DatabaseTable(string));
        }
    }

    public void setShouldReadSubclasses(Boolean bl) {
        this.shouldReadSubclasses = bl;
    }

    public void setShouldReadSubclasses(boolean bl) {
        this.shouldReadSubclasses = bl;
    }

    public void setShouldUseClassNameAsIndicator(boolean bl) {
        this.shouldUseClassNameAsIndicator = bl;
    }

    public void setAlwaysUseOuterJoinForClassType(boolean bl) {
        this.shouldAlwaysUseOuterJoin = bl;
    }

    public void setSingleTableStrategy() {
        this.isJoinedStrategy = false;
    }

    public void setUseDescriptorsToValidateInheritedObjects(boolean bl) {
        this.useDescriptorsToValidateInheritedObjects = bl;
    }

    public void setWithAllSubclassesExpression(Expression expression) {
        this.withAllSubclassesExpression = expression;
    }

    public boolean shouldReadSubclasses() {
        if (this.shouldReadSubclasses == null) {
            return true;
        }
        return this.shouldReadSubclasses;
    }

    public Boolean shouldReadSubclassesValue() {
        return this.shouldReadSubclasses;
    }

    public boolean shouldAlwaysUseOuterJoin() {
        return this.shouldAlwaysUseOuterJoin;
    }

    public boolean shouldOuterJoinSubclasses() {
        return this.shouldOuterJoinSubclasses;
    }

    public void setShouldOuterJoinSubclasses(boolean bl) {
        this.shouldOuterJoinSubclasses = bl;
    }

    public boolean shouldUseClassNameAsIndicator() {
        return this.shouldUseClassNameAsIndicator;
    }

    public String toString() {
        return Helper.getShortClassName(this.getClass()) + "(" + this.getDescriptor() + ")";
    }

    public void useClassNameAsIndicator() {
        this.setShouldUseClassNameAsIndicator(true);
    }
}

