/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.indirection;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.indirection.ValueHolder;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.helper.Helper;

public class IndirectMap
extends Hashtable
implements CollectionChangeTracker,
IndirectCollection {
    protected volatile Hashtable delegate;
    protected ValueHolderInterface valueHolder;
    private transient PropertyChangeListener changeListener;
    private transient String attributeName;
    protected int initialCapacity = 11;
    protected float loadFactor = 0.75f;

    public IndirectMap() {
        this(11);
    }

    public IndirectMap(int n) {
        this(n, 0.75f);
    }

    public IndirectMap(int n, float f) {
        super(0);
        this.initialize(n, f);
    }

    public IndirectMap(Map map) {
        super(0);
        this.initialize(map);
    }

    protected Hashtable buildDelegate() {
        return (Hashtable)this.getValueHolder().getValue();
    }

    public synchronized void clear() {
        if (this.hasTrackedPropertyChangeListener()) {
            Iterator iterator = this.keySet().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                iterator.remove();
                this.raiseRemoveChangeEvent(e, this.get(e));
            }
        } else {
            this.getDelegate().clear();
        }
    }

    public synchronized Object clone() {
        IndirectMap indirectMap = (IndirectMap)super.clone();
        indirectMap.delegate = (Hashtable)this.getDelegate().clone();
        indirectMap.attributeName = null;
        indirectMap.changeListener = null;
        return indirectMap;
    }

    public synchronized boolean contains(Object object) {
        return this.getDelegate().contains(object);
    }

    public synchronized boolean containsKey(Object object) {
        return this.getDelegate().containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this.getDelegate().containsValue(object);
    }

    public synchronized Enumeration elements() {
        return this.getDelegate().elements();
    }

    public Set entrySet() {
        return new Set(){
            Set delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().entrySet();
            }

            public int size() {
                return this.delegateSet.size();
            }

            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            public boolean contains(Object object) {
                return this.delegateSet.contains(object);
            }

            public Iterator iterator() {
                return new Iterator(){
                    Iterator delegateIterator;
                    Object currentObject;
                    {
                        this.delegateIterator = delegateSet.iterator();
                    }

                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    public void remove() {
                        IndirectMap.this.raiseRemoveChangeEvent(((Map.Entry)this.currentObject).getKey(), ((Map.Entry)this.currentObject).getValue());
                        this.delegateIterator.remove();
                    }
                };
            }

            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            public Object[] toArray(Object[] objectArray) {
                return this.delegateSet.toArray(objectArray);
            }

            public boolean add(Object object) {
                return this.delegateSet.add(object);
            }

            public boolean remove(Object object) {
                if (!(object instanceof Map.Entry)) {
                    return false;
                }
                return IndirectMap.this.remove(((Map.Entry)object).getKey()) != null;
            }

            public boolean containsAll(Collection collection) {
                return this.delegateSet.containsAll(collection);
            }

            public boolean addAll(Collection collection) {
                return this.delegateSet.addAll(collection);
            }

            public boolean retainAll(Collection collection) {
                boolean bl = false;
                Iterator iterator = this.delegateSet.iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (collection.contains(entry)) continue;
                    iterator.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                    bl = true;
                }
                return bl;
            }

            public boolean removeAll(Collection collection) {
                boolean bl = false;
                for (Object e : collection) {
                    Object object;
                    if (!(e instanceof Map.Entry) || (object = IndirectMap.this.remove(((Map.Entry)e).getKey())) == null) continue;
                    bl = true;
                }
                return bl;
            }

            public void clear() {
                IndirectMap.this.clear();
            }

            public boolean equals(Object object) {
                return ((Object)this.delegateSet).equals(object);
            }

            public int hashCode() {
                return ((Object)this.delegateSet).hashCode();
            }
        };
    }

    public synchronized boolean equals(Object object) {
        return this.getDelegate().equals(object);
    }

    public synchronized Object get(Object object) {
        return this.getDelegate().get(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Hashtable getDelegate() {
        if (this.delegate == null) {
            IndirectMap indirectMap = this;
            synchronized (indirectMap) {
                if (this.delegate == null) {
                    this.delegate = this.buildDelegate();
                }
            }
        }
        return this.delegate;
    }

    public Object getDelegateObject() {
        return this.getDelegate();
    }

    public String getTrackedAttributeName() {
        return this.attributeName;
    }

    public PropertyChangeListener _persistence_getPropertyChangeListener() {
        return this.changeListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueHolderInterface getValueHolder() {
        if (this.valueHolder == null) {
            IndirectMap indirectMap = this;
            synchronized (indirectMap) {
                if (this.valueHolder == null) {
                    this.valueHolder = new ValueHolder(new Hashtable(this.initialCapacity, this.loadFactor));
                }
            }
        }
        return this.valueHolder;
    }

    public synchronized int hashCode() {
        return this.getDelegate().hashCode();
    }

    public boolean hasTrackedPropertyChangeListener() {
        return this.changeListener != null;
    }

    protected void initialize(int n, float f) {
        this.delegate = null;
        this.loadFactor = f;
        this.initialCapacity = n;
        this.valueHolder = null;
    }

    protected void initialize(Map map) {
        this.delegate = null;
        Hashtable hashtable = new Hashtable(map);
        this.valueHolder = new ValueHolder(hashtable);
    }

    public boolean isEmpty() {
        return this.getDelegate().isEmpty();
    }

    public boolean isInstantiated() {
        return this.getValueHolder().isInstantiated();
    }

    public synchronized Enumeration keys() {
        return this.getDelegate().keys();
    }

    public Set keySet() {
        return new Set(){
            Set delegateSet;
            {
                this.delegateSet = IndirectMap.this.getDelegate().keySet();
            }

            public int size() {
                return this.delegateSet.size();
            }

            public boolean isEmpty() {
                return this.delegateSet.isEmpty();
            }

            public boolean contains(Object object) {
                return this.delegateSet.contains(object);
            }

            public Iterator iterator() {
                return new Iterator(){
                    Iterator delegateIterator;
                    Object currentObject;
                    {
                        this.delegateIterator = delegateSet.iterator();
                    }

                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    public void remove() {
                        IndirectMap.this.raiseRemoveChangeEvent(this.currentObject, IndirectMap.this.getDelegate().get(this.currentObject));
                        this.delegateIterator.remove();
                    }
                };
            }

            public Object[] toArray() {
                return this.delegateSet.toArray();
            }

            public Object[] toArray(Object[] objectArray) {
                return this.delegateSet.toArray(objectArray);
            }

            public boolean add(Object object) {
                return this.delegateSet.add(object);
            }

            public boolean remove(Object object) {
                return IndirectMap.this.remove(object) != null;
            }

            public boolean containsAll(Collection collection) {
                return this.delegateSet.containsAll(collection);
            }

            public boolean addAll(Collection collection) {
                return this.delegateSet.addAll(collection);
            }

            public boolean retainAll(Collection collection) {
                boolean bl = false;
                Iterator iterator = this.delegateSet.iterator();
                while (iterator.hasNext()) {
                    Object e = iterator.next();
                    if (collection.contains(e)) continue;
                    iterator.remove();
                    IndirectMap.this.raiseRemoveChangeEvent(e, IndirectMap.this.getDelegate().get(e));
                    bl = true;
                }
                return bl;
            }

            public boolean removeAll(Collection collection) {
                boolean bl = false;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    if (IndirectMap.this.remove(iterator.next()) == null) continue;
                    bl = true;
                }
                return bl;
            }

            public void clear() {
                IndirectMap.this.clear();
            }

            public boolean equals(Object object) {
                return ((Object)this.delegateSet).equals(object);
            }

            public int hashCode() {
                return ((Object)this.delegateSet).hashCode();
            }
        };
    }

    public synchronized Object put(Object object, Object object2) {
        Object object3 = this.getDelegate().put(object, object2);
        if (object3 != null) {
            this.raiseRemoveChangeEvent(object, object3);
        }
        this.raiseAddChangeEvent(object, object2);
        return object3;
    }

    public synchronized void putAll(Map map) {
        if (this.hasTrackedPropertyChangeListener()) {
            for (Object k : map.keySet()) {
                this.put(k, map.get(k));
            }
        } else {
            this.getDelegate().putAll(map);
        }
    }

    protected void rehash() {
        throw new InternalError("unsupported");
    }

    protected void raiseAddChangeEvent(Object object, Object object2) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new MapChangeEvent((Object)this, this.getTrackedAttributeName(), (Object)this, object, object2, CollectionChangeEvent.ADD));
        }
    }

    protected void raiseRemoveChangeEvent(Object object, Object object2) {
        if (this.hasTrackedPropertyChangeListener()) {
            this._persistence_getPropertyChangeListener().propertyChange(new MapChangeEvent((Object)this, this.getTrackedAttributeName(), (Object)this, object, object2, CollectionChangeEvent.REMOVE));
        }
    }

    public synchronized Object remove(Object object) {
        Object v = this.getDelegate().remove(object);
        if (v != null) {
            this.raiseRemoveChangeEvent(object, v);
        }
        return v;
    }

    public void setTrackedAttributeName(String string) {
        this.attributeName = string;
    }

    public void _persistence_setPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changeListener = propertyChangeListener;
    }

    public void setValueHolder(ValueHolderInterface valueHolderInterface) {
        this.delegate = null;
        this.valueHolder = valueHolderInterface;
    }

    public int size() {
        return this.getDelegate().size();
    }

    public Collection getRemovedElements() {
        return null;
    }

    public Collection getAddedElements() {
        return null;
    }

    public boolean hasDeferredChanges() {
        return false;
    }

    public String toString() {
        if (this.isInstantiated()) {
            return "{" + this.getDelegate().toString() + "}";
        }
        return "{" + Helper.getShortClassName(this.getClass()) + ": not instantiated}";
    }

    public Collection values() {
        return new Collection(){
            protected Collection delegateCollection;
            {
                this.delegateCollection = IndirectMap.this.getDelegate().values();
            }

            public int size() {
                return this.delegateCollection.size();
            }

            public boolean isEmpty() {
                return this.delegateCollection.isEmpty();
            }

            public boolean contains(Object object) {
                return this.delegateCollection.contains(object);
            }

            public Iterator iterator() {
                return new Iterator(){
                    Iterator delegateIterator;
                    Object currentObject;
                    {
                        this.delegateIterator = delegateCollection.iterator();
                    }

                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Object next() {
                        this.currentObject = this.delegateIterator.next();
                        return this.currentObject;
                    }

                    public void remove() {
                        for (Map.Entry entry : IndirectMap.this.getDelegate().entrySet()) {
                            if (!entry.getValue().equals(this.currentObject)) continue;
                            IndirectMap.this.raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                        }
                        this.delegateIterator.remove();
                    }
                };
            }

            public Object[] toArray() {
                return this.delegateCollection.toArray();
            }

            public Object[] toArray(Object[] objectArray) {
                return this.delegateCollection.toArray(objectArray);
            }

            public boolean add(Object object) {
                return this.delegateCollection.add(object);
            }

            public boolean remove(Object object) {
                Iterator iterator = IndirectMap.this.getDelegate().entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    if (entry.getValue().equals(object)) {
                        IndirectMap.this.raiseRemoveChangeEvent(entry.getKey(), entry.getValue());
                    }
                    return true;
                }
                return false;
            }

            public boolean containsAll(Collection collection) {
                return this.delegateCollection.containsAll(collection);
            }

            public boolean addAll(Collection collection) {
                return this.delegateCollection.addAll(collection);
            }

            public boolean removeAll(Collection collection) {
                boolean bl = false;
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    if (!this.remove(iterator.next())) continue;
                    bl = true;
                }
                return bl;
            }

            public boolean retainAll(Collection collection) {
                boolean bl = false;
                Iterator iterator = IndirectMap.this.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (collection.contains(entry.getValue())) continue;
                    iterator.remove();
                    bl = true;
                }
                return bl;
            }

            public void clear() {
                IndirectMap.this.clear();
            }

            public boolean equals(Object object) {
                return ((Object)this.delegateCollection).equals(object);
            }

            public int hashCode() {
                return ((Object)this.delegateCollection).hashCode();
            }
        };
    }
}

