/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.cobol;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.persistence.internal.eis.cobol.CobolRedefinedFieldValue;
import org.eclipse.persistence.internal.eis.cobol.CobolRow;
import org.eclipse.persistence.internal.eis.cobol.CompositeObject;
import org.eclipse.persistence.internal.eis.cobol.ElementaryFieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.FieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.RecordMetaData;
import org.eclipse.persistence.internal.helper.DatabaseField;

public class CompositeFieldMetaData
extends ElementaryFieldMetaData
implements CompositeObject {
    protected Vector myCompositeFields;

    public CompositeFieldMetaData() {
        this.initialize();
    }

    public CompositeFieldMetaData(String string, String string2) {
        super.initialize(string, string2);
        this.initialize();
    }

    public CompositeFieldMetaData(String string, RecordMetaData recordMetaData) {
        super.initialize(string, recordMetaData);
        this.initialize();
    }

    public CompositeFieldMetaData(String string, RecordMetaData recordMetaData, Vector vector) {
        super.initialize(string, recordMetaData);
        this.initialize(vector);
    }

    protected void initialize() {
        this.myCompositeFields = new Vector();
    }

    protected void initialize(Vector vector) {
        this.myCompositeFields = vector;
    }

    public FieldMetaData deepCopy() {
        CompositeFieldMetaData compositeFieldMetaData = new CompositeFieldMetaData(new String(this.myName), this.myRecord.getName());
        compositeFieldMetaData.setIsFieldRedefine(this.isRedefine);
        compositeFieldMetaData.setDecimalPosition(this.decimalPosition);
        compositeFieldMetaData.setArraySize(this.myArraySize);
        compositeFieldMetaData.setSize(this.mySize);
        compositeFieldMetaData.setOffset(this.myOffset);
        compositeFieldMetaData.setType(this.myType);
        if (this.isFieldRedefine()) {
            compositeFieldMetaData.setFieldRedefined(this.myFieldRedefined.deepCopy());
        }
        compositeFieldMetaData.setDependentFieldName(new String(this.myDependentFieldName));
        Enumeration enumeration = this.myCompositeFields.elements();
        while (enumeration.hasMoreElements()) {
            FieldMetaData fieldMetaData = (FieldMetaData)enumeration.nextElement();
            compositeFieldMetaData.addField(fieldMetaData.deepCopy());
        }
        return compositeFieldMetaData;
    }

    public int getSize() {
        Enumeration enumeration = this.myCompositeFields.elements();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            FieldMetaData fieldMetaData = (FieldMetaData)enumeration.nextElement();
            if (fieldMetaData.isFieldRedefine()) continue;
            n += fieldMetaData.getSize();
        }
        return n;
    }

    public void setSize(int n) {
    }

    public boolean hasDecimal() {
        return false;
    }

    public int getDecimalPosition() {
        return -1;
    }

    public void setDecimalPosition() {
    }

    public boolean isComposite() {
        return true;
    }

    public int getType() {
        return 3;
    }

    public void setType(int n) {
    }

    public Vector getFields() {
        return this.myCompositeFields;
    }

    public void setFields(Vector vector) {
        this.myCompositeFields = vector;
    }

    public void addField(FieldMetaData fieldMetaData) {
        this.myCompositeFields.addElement(fieldMetaData);
    }

    public FieldMetaData getFieldNamed(String string) {
        Enumeration enumeration = this.getFields().elements();
        while (enumeration.hasMoreElements()) {
            FieldMetaData fieldMetaData = (FieldMetaData)enumeration.nextElement();
            if (!fieldMetaData.getName().equals(string)) continue;
            return fieldMetaData;
        }
        return null;
    }

    public Object extractValueFromArray(byte[] byArray) {
        ArrayList<CobolRow> arrayList = new ArrayList<CobolRow>(this.getFields().size());
        if (this.isArray()) {
            int n = this.getOffset();
            for (int i = this.getArraySize(); i > 0; --i) {
                CompositeFieldMetaData compositeFieldMetaData = (CompositeFieldMetaData)this.deepCopy();
                compositeFieldMetaData.setOffset(n);
                compositeFieldMetaData.resetChildOffsets();
                CobolRow cobolRow = new CobolRow();
                compositeFieldMetaData.writeCompositeOnRow(cobolRow, byArray);
                arrayList.add(cobolRow);
                n += this.getSize();
            }
        } else {
            CobolRow cobolRow = new CobolRow();
            this.writeCompositeOnRow(cobolRow, byArray);
            arrayList.add(cobolRow);
        }
        return arrayList;
    }

    public void writeCompositeOnRow(CobolRow cobolRow, byte[] byArray) {
        Enumeration enumeration = this.getFields().elements();
        while (enumeration.hasMoreElements()) {
            FieldMetaData fieldMetaData = (FieldMetaData)enumeration.nextElement();
            fieldMetaData.writeOnRow(cobolRow, byArray);
        }
    }

    public void writeOnRow(CobolRow cobolRow, byte[] byArray) {
        if (this.isArray() && this.dependsOn()) {
            this.adjustArraySize(cobolRow);
        }
        DatabaseField databaseField = new DatabaseField(this.getName(), this.getRecord().getName());
        Object object = this.isFieldRedefine() ? new CobolRedefinedFieldValue(this, byArray) : this.extractValueFromArray(byArray);
        cobolRow.add(databaseField, object);
    }

    public void writeOnArray(CobolRow cobolRow, byte[] byArray) {
        Object object = cobolRow.get(this.getName());
        List list = (List)object;
        if (this.isArray()) {
            if (this.dependsOn()) {
                this.adjustArraySize(cobolRow);
            }
            int n = this.getOffset();
            Iterator iterator = list.iterator();
            for (int i = this.getArraySize(); i > 0; --i) {
                CompositeFieldMetaData compositeFieldMetaData = (CompositeFieldMetaData)this.deepCopy();
                compositeFieldMetaData.setOffset(n);
                compositeFieldMetaData.resetChildOffsets();
                CobolRow cobolRow2 = (CobolRow)iterator.next();
                compositeFieldMetaData.writeCompositeOnArray(cobolRow2, byArray);
                n += this.getSize();
            }
        } else {
            CobolRow cobolRow3 = (CobolRow)list.get(0);
            this.writeCompositeOnArray(cobolRow3, byArray);
        }
    }

    protected void writeCompositeOnArray(CobolRow cobolRow, byte[] byArray) {
        Enumeration enumeration = this.getFields().elements();
        while (enumeration.hasMoreElements()) {
            FieldMetaData fieldMetaData = (FieldMetaData)enumeration.nextElement();
            fieldMetaData.writeOnArray(cobolRow, byArray);
        }
    }

    protected void resetChildOffsets() {
        Enumeration enumeration = this.myCompositeFields.elements();
        int n = this.getOffset();
        while (enumeration.hasMoreElements()) {
            FieldMetaData fieldMetaData = (FieldMetaData)enumeration.nextElement();
            fieldMetaData.setOffset(n);
            if (fieldMetaData.isComposite()) {
                ((CompositeFieldMetaData)fieldMetaData).resetChildOffsets();
            }
            n += fieldMetaData.getSize();
        }
    }
}

