/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.eis.cobol;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.persistence.internal.eis.cobol.CompositeFieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.CompositeObject;
import org.eclipse.persistence.internal.eis.cobol.CopyBookParseException;
import org.eclipse.persistence.internal.eis.cobol.ElementaryFieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.FieldMetaData;
import org.eclipse.persistence.internal.eis.cobol.RecordMetaData;
import org.eclipse.persistence.internal.eis.cobol.helper.Helper;

public class CopyBookParser {
    private static final int maximumNestingLevels = 50;
    private String currentLine = new String();
    private int currentLineNumber = 0;

    public Vector parse(InputStream inputStream) throws Exception {
        Vector vector = new Vector();
        this.currentLineNumber = 0;
        try {
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            String string = new String(byArray);
            vector = this.buildStructure(string);
            for (int i = 0; i < vector.size(); ++i) {
                this.setOffsetsForComposite((CompositeObject)vector.elementAt(i), 0);
            }
        }
        catch (IOException iOException) {
            throw CopyBookParseException.ioException(iOException);
        }
        return vector;
    }

    private Vector buildStructure(String string) throws Exception {
        Serializable serializable;
        Object object;
        Vector<Object> vector = new Vector<Object>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, System.getProperty("line.separator"), false);
        RecordMetaData recordMetaData = new RecordMetaData();
        Vector<String> vector2 = new Vector<String>();
        Vector<Integer> vector3 = new Vector<Integer>();
        while (stringTokenizer.hasMoreTokens() && !this.currentLine.equalsIgnoreCase("procedure division.")) {
            this.currentLine = stringTokenizer.nextToken();
            ++this.currentLineNumber;
            if (this.currentLine.trim().startsWith("*") || this.currentLine.trim().length() <= 0) continue;
            StringTokenizer stringTokenizer2 = new StringTokenizer(this.currentLine);
            object = stringTokenizer2.nextToken();
            if (((String)object).endsWith(".")) {
                object = ((String)object).substring(0, this.currentLine.lastIndexOf("."));
            }
            if ((serializable = Helper.integerFromString((String)object)) == null || (Integer)serializable >= 50) continue;
            while (!this.currentLine.trim().endsWith(".")) {
                this.currentLine = this.currentLine + stringTokenizer.nextToken();
                ++this.currentLineNumber;
            }
            this.currentLine = this.currentLine.substring(0, this.currentLine.lastIndexOf("."));
            vector2.addElement(this.currentLine);
            vector3.addElement(new Integer(this.currentLineNumber));
        }
        int n = 50;
        object = new Stack();
        serializable = new Hashtable();
        Enumeration enumeration = vector2.elements();
        Enumeration enumeration2 = vector3.elements();
        while (enumeration.hasMoreElements()) {
            Object object2;
            this.currentLine = (String)enumeration.nextElement();
            this.currentLineNumber = (Integer)enumeration2.nextElement();
            StringTokenizer stringTokenizer3 = new StringTokenizer(this.currentLine);
            if (!stringTokenizer3.hasMoreTokens()) continue;
            String string2 = stringTokenizer3.nextToken();
            Integer n2 = Helper.integerFromString(string2);
            if (n2 == 1) {
                n = 50;
                object = new Stack<Object>();
                serializable = new Hashtable();
                object2 = this.buildRecord(stringTokenizer3);
                recordMetaData = (RecordMetaData)object2;
                vector.addElement(object2);
            } else if (n2 >= n) {
                object2 = this.buildField(stringTokenizer3);
                ((CompositeObject)((Stack)object).peek()).addField((FieldMetaData)object2);
            } else {
                while ((Integer)((Hashtable)serializable).get(((Stack)object).peek()) >= n2) {
                    ((Stack)object).pop();
                }
                object2 = this.buildField(stringTokenizer3);
                ((CompositeObject)((Stack)object).peek()).addField((FieldMetaData)object2);
            }
            n = n2;
            if (object2 instanceof FieldMetaData) {
                ((FieldMetaData)object2).setRecord(recordMetaData);
            }
            if (!(object2 instanceof CompositeObject)) continue;
            ((Stack)object).push(object2);
            ((Hashtable)serializable).put(object2, n2);
        }
        return vector;
    }

    private void setOffsetsForComposite(CompositeObject compositeObject, int n) {
        int n2 = n;
        int n3 = 0;
        Vector vector = compositeObject.getFields();
        Enumeration enumeration = vector.elements();
        FieldMetaData fieldMetaData = null;
        while (enumeration.hasMoreElements()) {
            FieldMetaData fieldMetaData2 = (FieldMetaData)enumeration.nextElement();
            if (fieldMetaData2.isFieldRedefine()) {
                fieldMetaData2.setFieldRedefined(fieldMetaData);
                if (fieldMetaData2 instanceof CompositeObject) {
                    this.setOffsetsForComposite((CompositeObject)((Object)fieldMetaData2), fieldMetaData.getOffset());
                }
                fieldMetaData2.setOffset(fieldMetaData.getOffset());
                if (n3 >= fieldMetaData2.getSize()) continue;
                n2 += fieldMetaData2.getSize() - n3;
                n3 = fieldMetaData2.getSize();
                continue;
            }
            if (fieldMetaData2 instanceof CompositeObject) {
                this.setOffsetsForComposite((CompositeObject)((Object)fieldMetaData2), n2);
            }
            fieldMetaData2.setOffset(n2);
            n2 += fieldMetaData2.getSize();
            fieldMetaData = fieldMetaData2;
            n3 = fieldMetaData2.getSize();
        }
    }

    private RecordMetaData buildRecord(StringTokenizer stringTokenizer) throws Exception {
        if (stringTokenizer.hasMoreTokens()) {
            String string = stringTokenizer.nextToken();
            RecordMetaData recordMetaData = new RecordMetaData(string);
            return recordMetaData;
        }
        throw this.invalidCopyBookException("The record has no name.");
    }

    private FieldMetaData buildField(StringTokenizer stringTokenizer) throws Exception {
        FieldMetaData fieldMetaData;
        String string;
        boolean bl = false;
        int n = -1;
        String[] stringArray = new String[stringTokenizer.countTokens()];
        int n2 = 0;
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            stringArray[n2++] = stringTokenizer.nextToken();
        }
        n2 = 0;
        if (stringArray.length > 0) {
            string = this.isKeyWord(stringArray[n2]) ? "filler" : stringArray[n2];
        } else {
            CompositeFieldMetaData compositeFieldMetaData = new CompositeFieldMetaData();
            compositeFieldMetaData.setName("filler");
            return compositeFieldMetaData;
        }
        for (int i = 0; i < stringArray.length && !stringArray[n2].equalsIgnoreCase("pic") && !stringArray[n2].equalsIgnoreCase("picture"); ++i) {
            if (stringArray[n2].equalsIgnoreCase("redefines")) {
                bl = true;
            }
            if (stringArray[n2].equalsIgnoreCase("occurs")) {
                n = this.handleOccursStatement(stringArray, ++n2);
                --n2;
            }
            if (stringArray[n2].equalsIgnoreCase("depending")) {
                string2 = this.handleDependeningStatement(stringArray, ++n2);
                --n2;
            }
            ++n2;
        }
        if (n2 < stringArray.length && (stringArray[n2].equalsIgnoreCase("pic") || stringArray[n2].equalsIgnoreCase("picture"))) {
            fieldMetaData = this.buildElementaryField(string, stringArray, n2);
        } else {
            fieldMetaData = new CompositeFieldMetaData();
            fieldMetaData.setName(string);
        }
        fieldMetaData.setIsFieldRedefine(bl);
        fieldMetaData.setArraySize(n);
        fieldMetaData.setDependentFieldName(string2);
        return fieldMetaData;
    }

    private String handleDependeningStatement(String[] stringArray, int n) throws Exception {
        String string = null;
        try {
            string = stringArray[n];
            if (n < stringArray.length && string.equalsIgnoreCase("on")) {
                string = stringArray[++n];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.invalidCopyBookException("There was no field name following the depending clause.", arrayIndexOutOfBoundsException);
        }
        return string;
    }

    private int handleOccursStatement(String[] stringArray, int n) throws Exception {
        try {
            Integer n2 = Helper.integerFromString(stringArray[n]);
            if (n < stringArray.length && stringArray[++n].equalsIgnoreCase("to")) {
                Integer n3 = Helper.integerFromString(stringArray[++n]);
                if (n2 > 0) {
                    n3 = new Integer(n3 - n2);
                }
                n2 = n3;
            }
            if (n2 < 1) {
                throw this.invalidCopyBookException("Must occur at least once.");
            }
            return n2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.invalidCopyBookException("Occurs clause must be folowed by and integer.", arrayIndexOutOfBoundsException);
        }
    }

    private FieldMetaData buildElementaryField(String string, String[] stringArray, int n) throws Exception {
        String string2;
        ElementaryFieldMetaData elementaryFieldMetaData = new ElementaryFieldMetaData();
        int n2 = 0;
        try {
            elementaryFieldMetaData.setName(string);
            string2 = stringArray[++n];
            if (string2.equalsIgnoreCase("is")) {
                string2 = stringArray[++n];
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw this.invalidCopyBookException("Picture clause must be followed by a pic statement.", arrayIndexOutOfBoundsException);
        }
        if (string2.toUpperCase().startsWith("A")) {
            elementaryFieldMetaData.setType(4);
            n2 = this.calculateSizeOfAlphaNumeric(string2, elementaryFieldMetaData);
        } else if (string2.toUpperCase().startsWith("X")) {
            elementaryFieldMetaData.setType(2);
            n2 = this.calculateSizeOfAlphaNumeric(string2, elementaryFieldMetaData);
        } else if (string2.toUpperCase().startsWith("9") || string2.toUpperCase().startsWith("V") || string2.toUpperCase().startsWith("Z") || string2.startsWith("+") || string2.startsWith("-") || string2.toUpperCase().startsWith("S")) {
            elementaryFieldMetaData.setType(1);
            n2 = this.calculateSizeOfNumeric(string2, stringArray, n, elementaryFieldMetaData);
        }
        elementaryFieldMetaData.setSize(n2);
        return elementaryFieldMetaData;
    }

    private int calculateSizeOfAlphaNumeric(String string, FieldMetaData fieldMetaData) throws Exception {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        int n3 = 0;
        block9: while (n2 < n) {
            char c = cArray[n2];
            switch (c) {
                case '(': {
                    String string2 = new String();
                    --n3;
                    c = cArray[++n2];
                    while (n2 < n && c != ')') {
                        string2 = string2 + c;
                        c = cArray[++n2];
                    }
                    try {
                        Integer n4 = new Integer(string2);
                        n3 += n4.intValue();
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw this.invalidCopyBookException("In pic statement a valid integer must be enclosed by the parenthesis.", numberFormatException);
                    }
                    if (c == ')') {
                        ++n2;
                        continue block9;
                    }
                    throw this.invalidCopyBookException("An open parenthesis must be followed by a close parenthesis.");
                }
                case '+': 
                case '-': 
                case '9': 
                case 'A': 
                case 'P': 
                case 'X': 
                case 'Z': 
                case 'a': 
                case 'p': 
                case 'x': 
                case 'z': {
                    ++n3;
                    ++n2;
                    continue block9;
                }
                case 'V': 
                case 'v': {
                    fieldMetaData.setDecimalPosition(n3);
                    ++n2;
                    continue block9;
                }
                case 'S': 
                case 's': {
                    ++n2;
                    continue block9;
                }
                case '.': {
                    if (n2 == n - 1) {
                        return n3;
                    }
                    ++n2;
                    ++n3;
                    continue block9;
                }
            }
            throw this.invalidCopyBookException("Invalid character: " + c + " in pic statement.");
        }
        return n3;
    }

    private int calculateSizeOfNumeric(String string, String[] stringArray, int n, FieldMetaData fieldMetaData) throws Exception {
        int n2 = 0;
        int n3 = 0;
        if (string.toUpperCase().startsWith("S")) {
            fieldMetaData.setIsSigned(true);
        }
        int n4 = n;
        while (n4 < stringArray.length) {
            String string2 = stringArray[n4];
            if (string2.equalsIgnoreCase("comp") || string2.equalsIgnoreCase("computational")) {
                n3 = this.calculateSizeOfAlphaNumeric(string, fieldMetaData);
                fieldMetaData.setType(5);
                if (n3 < 3) {
                    n2 = 1;
                } else if (n3 < 5) {
                    n2 = 2;
                } else if (n3 < 8) {
                    n2 = 3;
                } else if (n3 < 10) {
                    n2 = 4;
                } else if (n3 < 13) {
                    n2 = 5;
                } else if (n3 < 15) {
                    n2 = 6;
                } else if (n3 < 17) {
                    n2 = 7;
                } else if (n3 < 20) {
                    n2 = 8;
                }
                if (fieldMetaData.isSigned() && (n3 == 7 || n3 == 12 || n3 == 19)) {
                    ++n2;
                }
            } else {
                if (string2.equalsIgnoreCase("comp-2") || string2.equalsIgnoreCase("computational-2")) {
                    fieldMetaData.setType(6);
                    return 4;
                }
                if (string2.equalsIgnoreCase("comp-3") || string2.equalsIgnoreCase("computational-3") || string2.equalsIgnoreCase("packed-decimal")) {
                    int n5 = this.calculateSizeOfAlphaNumeric(string, fieldMetaData);
                    fieldMetaData.setType(7);
                    n2 = (n5 + 1) / 2;
                    if ((n5 + 1) % 2 > 0) {
                        ++n2;
                    }
                } else if (string2.equalsIgnoreCase("seperate")) {
                    n2 = this.calculateSizeOfAlphaNumeric(string, fieldMetaData);
                    ++n2;
                } else {
                    fieldMetaData.setType(2);
                    n2 = this.calculateSizeOfAlphaNumeric(string, fieldMetaData);
                }
            }
            ++n4;
            ++n;
        }
        return n2;
    }

    private boolean isKeyWord(String string) {
        String[] stringArray = new String[]{"pic", "picture", "redefines", "blank", "external", "global", "justified", "just", "occurs"};
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    private CopyBookParseException invalidCopyBookException(String string) {
        return CopyBookParseException.invalidCopyBookException(string + " Error occrured on line " + this.currentLineNumber + ":" + this.currentLine);
    }

    private CopyBookParseException invalidCopyBookException(String string, Exception exception) {
        CopyBookParseException copyBookParseException = this.invalidCopyBookException(string);
        copyBookParseException.setInternalException(exception);
        return copyBookParseException;
    }
}

