/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.parsing;

import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.jpa.parsing.GenerationContext;
import org.eclipse.persistence.internal.jpa.parsing.Node;
import org.eclipse.persistence.internal.jpa.parsing.ParseTreeContext;
import org.eclipse.persistence.internal.jpa.parsing.StringFunctionNode;
import org.eclipse.persistence.internal.jpa.parsing.TypeHelper;

public class TrimNode
extends StringFunctionNode {
    private Node trimChar;
    private boolean leading;
    private boolean trailing;
    private boolean both;

    public void validate(ParseTreeContext parseTreeContext) {
        TypeHelper typeHelper = parseTreeContext.getTypeHelper();
        if (this.left != null) {
            this.left.validate(parseTreeContext);
            this.left.validateParameter(parseTreeContext, typeHelper.getStringType());
        }
        if (this.trimChar != null) {
            this.trimChar.validate(parseTreeContext);
            this.trimChar.validateParameter(parseTreeContext, typeHelper.getCharType());
        }
        this.setType(typeHelper.getStringType());
    }

    public Expression generateExpression(GenerationContext generationContext) {
        Expression expression = this.getLeft().generateExpression(generationContext);
        if (this.leading) {
            if (this.trimChar != null) {
                Expression expression2 = this.trimChar.generateExpression(generationContext);
                expression = expression.leftTrim(expression2);
            } else {
                expression = expression.leftTrim();
            }
        } else if (this.trailing) {
            if (this.trimChar != null) {
                Expression expression3 = this.trimChar.generateExpression(generationContext);
                expression = expression.rightTrim(expression3);
            } else {
                expression = expression.rightTrim();
            }
        } else if (this.trimChar != null) {
            Expression expression4 = this.trimChar.generateExpression(generationContext);
            expression = expression.leftTrim(expression4).rightTrim(expression4);
        } else {
            expression = expression.leftTrim().rightTrim();
        }
        return expression;
    }

    public void setTrimChar(Node node) {
        this.trimChar = node;
    }

    public boolean isLeading() {
        return this.leading;
    }

    public void setLeading(boolean bl) {
        this.leading = bl;
    }

    public boolean isTrailing() {
        return this.trailing;
    }

    public void setTrailing(boolean bl) {
        this.trailing = bl;
    }

    public boolean isBoth() {
        return this.both;
    }

    public void setBoth(boolean bl) {
        this.both = bl;
    }
}

