/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.weaving;

import java.io.File;
import java.io.FileOutputStream;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.Map;
import java.util.StringTokenizer;
import javax.persistence.spi.ClassTransformer;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.libraries.asm.ClassReader;
import org.eclipse.persistence.internal.libraries.asm.ClassVisitor;
import org.eclipse.persistence.internal.libraries.asm.ClassWriter;
import org.eclipse.persistence.internal.libraries.asm.attrs.Attributes;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.weaving.ClassDetails;
import org.eclipse.persistence.internal.weaving.ClassWeaver;
import org.eclipse.persistence.sessions.Session;

public class PersistenceWeaver
implements ClassTransformer {
    public static final String WEAVING_OUTPUT_PATH = "eclipselink.weaving.output.path";
    public static final String WEAVING_SHOULD_OVERWRITE = "eclipselink.weaving.overwrite.existing";
    public static final String WEAVER_NOT_OVERWRITING = "weaver_not_overwriting";
    public static final String WEAVER_COULD_NOT_WRITE = "weaver_could_not_write";
    public static final String EXCEPTION_WHILE_WEAVING = "exception_while_weaving";
    protected Session session;
    protected Map classDetailsMap;

    public PersistenceWeaver(Session session, Map map) {
        this.session = session;
        this.classDetailsMap = map;
    }

    public Map getClassDetailsMap() {
        return this.classDetailsMap;
    }

    public byte[] transform(ClassLoader classLoader, String string, Class clazz, ProtectionDomain protectionDomain, byte[] byArray) throws IllegalClassFormatException {
        try {
            ClassDetails classDetails = (ClassDetails)this.classDetailsMap.get(Helper.toSlashedClassName(string));
            if (classDetails != null) {
                ((AbstractSession)this.session).log(1, "weaver", "begin_weaving_class", string);
                ClassReader classReader = new ClassReader(byArray);
                ClassWriter classWriter = new ClassWriter(true, true);
                ClassWeaver classWeaver = new ClassWeaver(classWriter, classDetails);
                classReader.accept((ClassVisitor)classWeaver, Attributes.getDefaultAttributes(), false);
                if (classWeaver.alreadyWeaved) {
                    ((AbstractSession)this.session).log(1, "weaver", "end_weaving_class", string);
                    return null;
                }
                if (classWeaver.weaved) {
                    byte[] byArray2 = classWriter.toByteArray();
                    String string2 = System.getProperty(WEAVING_OUTPUT_PATH, "");
                    if (!string2.equals("")) {
                        this.outputFile(string, byArray2, string2);
                    }
                    if (classWeaver.weavedPersistenceEntity) {
                        ((AbstractSession)this.session).log(1, "weaver", "weaved_persistenceentity", string);
                    }
                    if (classWeaver.weavedChangeTracker) {
                        ((AbstractSession)this.session).log(1, "weaver", "weaved_changetracker", string);
                    }
                    if (classWeaver.weavedLazy) {
                        ((AbstractSession)this.session).log(1, "weaver", "weaved_lazy", string);
                    }
                    if (classWeaver.weavedFetchGroups) {
                        ((AbstractSession)this.session).log(1, "weaver", "weaved_fetchgroups", string);
                    }
                    ((AbstractSession)this.session).log(1, "weaver", "end_weaving_class", string);
                    return byArray2;
                }
                ((AbstractSession)this.session).log(1, "weaver", "end_weaving_class", string);
            }
        }
        catch (Throwable throwable) {
            ((AbstractSession)this.session).log(6, "weaver", EXCEPTION_WHILE_WEAVING, string, throwable);
            ((AbstractSession)this.session).logThrowable(1, "weaver", throwable);
        }
        return null;
    }

    protected void outputFile(String string, byte[] byArray, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n\\/");
        String string3 = null;
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            if (!stringTokenizer.hasMoreTokens()) continue;
            stringBuffer.append(string3 + File.separator);
        }
        try {
            String string4 = string2;
            if (!string2.endsWith(File.separator)) {
                string4 = string2 + File.separator;
            }
            File file = new File(string4 + stringBuffer);
            file.mkdirs();
            file = new File(file, string3 + ".class");
            if (!file.exists()) {
                file.createNewFile();
            } else if (!System.getProperty(WEAVING_SHOULD_OVERWRITE, "false").equalsIgnoreCase("true")) {
                ((AbstractSession)this.session).log(6, "weaver", WEAVER_NOT_OVERWRITING, string);
                return;
            }
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray);
            fileOutputStream.close();
        }
        catch (Exception exception) {
            ((AbstractSession)this.session).log(6, "weaver", WEAVER_COULD_NOT_WRITE, string, exception);
            ((AbstractSession)this.session).logThrowable(1, "weaver", exception);
        }
    }

    protected static String getShortName(String string) {
        int n = string.lastIndexOf(47);
        if (n >= 0) {
            if ((string = string.substring(n + 1)).endsWith(";")) {
                string = string.substring(0, string.length() - 1);
            }
            return string;
        }
        return "";
    }
}

