/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.Map;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorEvent;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AggregateAttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.AggregateChangeRecord;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.queries.DeleteObjectQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.ObjectLevelModifyQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.ObjectCopyingPolicy;
import org.eclipse.persistence.sessions.remote.DistributedSession;
import org.eclipse.persistence.sessions.remote.RemoteSession;

public abstract class AggregateMapping
extends DatabaseMapping {
    protected Class referenceClass;
    protected String referenceClassName;
    protected ClassDescriptor referenceDescriptor;

    protected DeleteObjectQuery buildAggregateDeleteQuery(DeleteObjectQuery deleteObjectQuery, Object object) {
        DeleteObjectQuery deleteObjectQuery2 = new DeleteObjectQuery();
        this.buildAggregateModifyQuery(deleteObjectQuery, deleteObjectQuery2, object);
        return deleteObjectQuery2;
    }

    protected void buildAggregateModifyQuery(ObjectLevelModifyQuery objectLevelModifyQuery, ObjectLevelModifyQuery objectLevelModifyQuery2, Object object) {
        if (objectLevelModifyQuery.getSession().isUnitOfWork()) {
            Object object2 = this.getAttributeValueFromBackupClone(objectLevelModifyQuery.getBackupClone());
            if (object2 == null) {
                object2 = this.getObjectBuilder(object, objectLevelModifyQuery.getSession()).buildNewInstance();
            }
            objectLevelModifyQuery2.setBackupClone(object2);
        }
        objectLevelModifyQuery2.setCascadePolicy(objectLevelModifyQuery.getCascadePolicy());
        objectLevelModifyQuery2.setObject(object);
        objectLevelModifyQuery2.setTranslationRow(objectLevelModifyQuery.getTranslationRow());
        objectLevelModifyQuery2.setSession(objectLevelModifyQuery.getSession());
        objectLevelModifyQuery2.setProperties(objectLevelModifyQuery.getProperties());
    }

    protected WriteObjectQuery buildAggregateWriteQuery(WriteObjectQuery writeObjectQuery, Object object) {
        WriteObjectQuery writeObjectQuery2 = new WriteObjectQuery();
        this.buildAggregateModifyQuery(writeObjectQuery, writeObjectQuery2, object);
        return writeObjectQuery2;
    }

    public void buildBackupClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        Object object3 = this.getAttributeValueFromObject(object);
        this.setAttributeValueInObject(object2, this.buildBackupClonePart(object3, unitOfWorkImpl));
    }

    protected Object buildBackupClonePart(Object object, UnitOfWorkImpl unitOfWorkImpl) {
        if (object == null) {
            return null;
        }
        return this.getObjectBuilder(object, unitOfWorkImpl).buildBackupClone(object, unitOfWorkImpl);
    }

    public void buildClone(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        Object object3 = this.getAttributeValueFromObject(object);
        this.setAttributeValueInObject(object2, this.buildClonePart(object, object3, unitOfWorkImpl));
    }

    public void buildCloneFromRow(AbstractRecord abstractRecord, JoinedAttributeManager joinedAttributeManager, Object object, ObjectBuildingQuery objectBuildingQuery, UnitOfWorkImpl unitOfWorkImpl, AbstractSession abstractSession) {
        Object object2 = this.valueFromRow(abstractRecord, joinedAttributeManager, objectBuildingQuery, abstractSession);
        this.setAttributeValueInObject(object, object2);
    }

    protected Object buildClonePart(Object object, Object object2, UnitOfWorkImpl unitOfWorkImpl) {
        if (object2 == null) {
            return null;
        }
        if (unitOfWorkImpl.isOriginalNewObject(object)) {
            unitOfWorkImpl.addNewAggregate(object2);
        }
        if (unitOfWorkImpl.isClassReadOnly(object2.getClass())) {
            return object2;
        }
        ObjectBuilder objectBuilder = this.getObjectBuilder(object2, unitOfWorkImpl);
        Object object3 = objectBuilder.instantiateWorkingCopyClone(object2, unitOfWorkImpl);
        objectBuilder.populateAttributesForClone(object2, object3, unitOfWorkImpl);
        return object3;
    }

    public void buildCopy(Object object, Object object2, ObjectCopyingPolicy objectCopyingPolicy) {
        Object object3 = this.getAttributeValueFromObject(object2);
        this.setAttributeValueInObject(object, this.buildCopyOfAttributeValue(object3, objectCopyingPolicy));
    }

    protected Object buildCopyOfAttributeValue(Object object, ObjectCopyingPolicy objectCopyingPolicy) {
        if (object == null) {
            return null;
        }
        return this.getObjectBuilder(object, objectCopyingPolicy.getSession()).copyObject(object, objectCopyingPolicy);
    }

    public Expression buildExpression(Object object, QueryByExamplePolicy queryByExamplePolicy, Expression expression, Map map, AbstractSession abstractSession) {
        String string = this.getAttributeName();
        Object object2 = this.getRealAttributeValueFromObject(object, abstractSession);
        if (!queryByExamplePolicy.shouldIncludeInQuery(object.getClass(), string, object2)) {
            return null;
        }
        if (object2 == null) {
            Expression expression2 = expression.get(string);
            return queryByExamplePolicy.completeExpressionForNull(expression2);
        }
        ObjectBuilder objectBuilder = this.getReferenceDescriptor().getObjectBuilder();
        return objectBuilder.buildExpressionFromExample(object2, queryByExamplePolicy, expression.get(string), map, abstractSession);
    }

    protected Object buildNewMergeInstanceOf(Object object, AbstractSession abstractSession) {
        return this.getObjectBuilder(object, abstractSession).buildNewInstance();
    }

    protected boolean compareAttributeValues(Object object, Object object2, AbstractSession abstractSession) {
        if (object == null && object2 == null) {
            return true;
        }
        if (object == null || object2 == null) {
            return false;
        }
        if (object.getClass() != object2.getClass()) {
            return false;
        }
        return this.getObjectBuilder(object, abstractSession).compareObjects(object, object2, abstractSession);
    }

    public ChangeRecord compareForChange(Object object, Object object2, ObjectChangeSet objectChangeSet, AbstractSession abstractSession) {
        Object object3 = this.getAttributeValueFromObject(object);
        Object object4 = null;
        if (!objectChangeSet.isNew()) {
            object4 = this.getAttributeValueFromObject(object2);
            if (object3 == null && object4 == null) {
                return null;
            }
            if (object3 != null && object4 != null && !object3.getClass().equals(object4.getClass())) {
                object4 = null;
            }
        }
        AggregateChangeRecord aggregateChangeRecord = new AggregateChangeRecord(objectChangeSet);
        aggregateChangeRecord.setAttribute(this.getAttributeName());
        aggregateChangeRecord.setMapping(this);
        if (object3 == null) {
            aggregateChangeRecord.setChangedObject(null);
            return aggregateChangeRecord;
        }
        ObjectBuilder objectBuilder = this.getObjectBuilder(object3, abstractSession);
        ObjectChangeSet objectChangeSet2 = objectBuilder.createObjectChangeSet(object3, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), object4 == null, abstractSession);
        ObjectChangeSet objectChangeSet3 = objectBuilder.compareForChange(object3, object4, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), abstractSession);
        if (objectChangeSet3 == null) {
            if (objectChangeSet2.isNew()) {
                objectChangeSet3 = objectChangeSet2;
            } else {
                return null;
            }
        }
        aggregateChangeRecord.setChangedObject(objectChangeSet3);
        return aggregateChangeRecord;
    }

    public boolean compareObjects(Object object, Object object2, AbstractSession abstractSession) {
        return this.compareAttributeValues(this.getAttributeValueFromObject(object), this.getAttributeValueFromObject(object2), abstractSession);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        Class clazz;
        block5: {
            clazz = null;
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        clazz = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.getReferenceClassName(), true, classLoader));
                        break block5;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), privilegedActionException.getException());
                    }
                }
                clazz = PrivilegedAccessHelper.getClassForName(this.getReferenceClassName(), true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.getReferenceClassName(), classNotFoundException);
            }
        }
        this.setReferenceClass(clazz);
    }

    protected void executeEvent(int n, ObjectLevelModifyQuery objectLevelModifyQuery) {
        ClassDescriptor classDescriptor = this.getReferenceDescriptor(objectLevelModifyQuery.getObject(), objectLevelModifyQuery.getSession());
        if (classDescriptor.getEventManager().hasAnyEventListeners()) {
            classDescriptor.getEventManager().executeEvent(new DescriptorEvent(n, objectLevelModifyQuery));
        }
    }

    protected void fixAttributeValue(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        if (object == null) {
            return;
        }
        this.getObjectBuilder(object, objectLevelReadQuery.getSession()).fixObjectReferences(object, map, map2, objectLevelReadQuery, remoteSession);
    }

    public void fixObjectReferences(Object object, Map map, Map map2, ObjectLevelReadQuery objectLevelReadQuery, RemoteSession remoteSession) {
        Object object2 = this.getAttributeValueFromObject(object);
        this.fixAttributeValue(object2, map, map2, objectLevelReadQuery, remoteSession);
    }

    protected Object getAttributeValueFromBackupClone(Object object) {
        return this.getAttributeValueFromObject(object);
    }

    protected ObjectBuilder getObjectBuilderForClass(Class clazz, AbstractSession abstractSession) {
        return this.getReferenceDescriptor(clazz, abstractSession).getObjectBuilder();
    }

    protected ObjectBuilder getObjectBuilder(Object object, AbstractSession abstractSession) {
        return this.getReferenceDescriptor(object, abstractSession).getObjectBuilder();
    }

    protected DescriptorQueryManager getQueryManager(Object object, AbstractSession abstractSession) {
        return this.getReferenceDescriptor(object, abstractSession).getQueryManager();
    }

    public Class getReferenceClass() {
        return this.referenceClass;
    }

    public String getReferenceClassName() {
        if (this.referenceClassName == null && this.referenceClass != null) {
            this.referenceClassName = this.referenceClass.getName();
        }
        return this.referenceClassName;
    }

    public ClassDescriptor getReferenceDescriptor() {
        return this.referenceDescriptor;
    }

    protected ClassDescriptor getReferenceDescriptor(Class clazz, AbstractSession abstractSession) {
        if (this.getReferenceDescriptor().getJavaClass().equals(clazz)) {
            return this.getReferenceDescriptor();
        }
        ClassDescriptor classDescriptor = abstractSession.getDescriptor(clazz);
        if (classDescriptor == null) {
            throw DescriptorException.noSubClassMatch(clazz, this);
        }
        return classDescriptor;
    }

    protected ClassDescriptor getReferenceDescriptor(Object object, AbstractSession abstractSession) {
        if (object == null) {
            return this.getReferenceDescriptor();
        }
        return this.getReferenceDescriptor(object.getClass(), abstractSession);
    }

    public void initialize(AbstractSession abstractSession) throws DescriptorException {
        super.initialize(abstractSession);
        if (this.getReferenceClass() == null) {
            throw DescriptorException.referenceClassNotSpecified(this);
        }
        this.setReferenceDescriptor(abstractSession.getDescriptor(this.getReferenceClass()));
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        if (classDescriptor == null) {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.descriptorIsMissing(this.getReferenceClass().getName(), this));
            return;
        }
        if (classDescriptor.isAggregateDescriptor()) {
            classDescriptor.checkInheritanceTreeAggregateSettings(abstractSession, this);
        } else {
            abstractSession.getIntegrityChecker().handleError(DescriptorException.referenceDescriptorIsNotAggregate(this.getReferenceClass().getName(), this));
        }
    }

    public boolean isAggregateMapping() {
        return true;
    }

    public void iterate(DescriptorIterator descriptorIterator) {
        this.iterateOnAttributeValue(descriptorIterator, this.getAttributeValueFromObject(descriptorIterator.getVisitedParent()));
    }

    protected void iterateOnAttributeValue(DescriptorIterator descriptorIterator, Object object) {
        descriptorIterator.iterateForAggregateMapping(object, this, this.getReferenceDescriptor(object, descriptorIterator.getSession()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeAttributeValue(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        if (mergeManager.getSession().isClassReadOnly(object2.getClass())) {
            return;
        }
        if (mergeManager.getSession().isClassReadOnly(object.getClass())) {
            return;
        }
        ClassDescriptor classDescriptor = this.getReferenceDescriptor(object2, mergeManager.getSession());
        classDescriptor.getObjectChangePolicy().dissableEventProcessing(object);
        try {
            classDescriptor.getObjectBuilder().mergeIntoObject(object, bl, object2, mergeManager);
        }
        finally {
            classDescriptor.getObjectChangePolicy().enableEventProcessing(object);
        }
    }

    public void mergeChangesIntoObject(Object object, ChangeRecord changeRecord, Object object2, MergeManager mergeManager) {
        ObjectChangeSet objectChangeSet = (ObjectChangeSet)((AggregateChangeRecord)changeRecord).getChangedObject();
        if (objectChangeSet == null) {
            this.setAttributeValueInObject(object, null);
            return;
        }
        Object object3 = null;
        if (object2 != null) {
            object3 = this.getAttributeValueFromObject(object2);
        }
        ObjectBuilder objectBuilder = this.getObjectBuilderForClass(objectChangeSet.getClassType(mergeManager.getSession()), mergeManager.getSession());
        Object object4 = this.getAttributeValueFromObject(object);
        if (object4 == null) {
            object4 = objectBuilder.buildNewInstance();
        } else if (objectChangeSet.getClassType(mergeManager.getSession()) != object4.getClass()) {
            object4 = objectBuilder.buildNewInstance();
        }
        objectBuilder.mergeChangesIntoObject(object4, objectChangeSet, object3, mergeManager);
        this.setAttributeValueInObject(object, object4);
    }

    public void mergeIntoObject(Object object, boolean bl, Object object2, MergeManager mergeManager) {
        Object object3 = this.getAttributeValueFromObject(object2);
        if (object3 == null) {
            this.setAttributeValueInObject(object, null);
            return;
        }
        Object object4 = this.getAttributeValueFromObject(object);
        if (object4 == null) {
            object4 = this.buildNewMergeInstanceOf(object3, mergeManager.getSession());
            this.mergeAttributeValue(object4, true, object3, mergeManager);
            if (mergeManager.shouldMergeCloneIntoWorkingCopy() || mergeManager.shouldMergeCloneWithReferencesIntoWorkingCopy()) {
                this.descriptor.getObjectChangePolicy().raiseInternalPropertyChangeEvent(object, this.getAttributeName(), this.getAttributeValueFromObject(object), object4);
            }
        } else {
            this.mergeAttributeValue(object4, bl, object3, mergeManager);
        }
        this.setAttributeValueInObject(object, object4);
    }

    public void postDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.postDeleteAttributeValue(deleteObjectQuery, this.getAttributeValueFromObject(deleteObjectQuery.getObject()));
        }
    }

    protected void postDeleteAttributeValue(DeleteObjectQuery deleteObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ClassDescriptor classDescriptor = this.getReferenceDescriptor(object, deleteObjectQuery.getSession());
        if (classDescriptor.getObjectBuilder().isSimple() && !classDescriptor.getEventManager().hasAnyEventListeners()) {
            return;
        }
        DeleteObjectQuery deleteObjectQuery2 = this.buildAggregateDeleteQuery(deleteObjectQuery, object);
        classDescriptor.getQueryManager().postDelete(deleteObjectQuery2);
        this.executeEvent(3, deleteObjectQuery2);
    }

    public void postInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.postInsertAttributeValue(writeObjectQuery, this.getAttributeValueFromObject(writeObjectQuery.getObject()));
        }
    }

    protected void postInsertAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        ClassDescriptor classDescriptor = this.getReferenceDescriptor(object, writeObjectQuery.getSession());
        if (classDescriptor.getObjectBuilder().isSimple() && !classDescriptor.getEventManager().hasAnyEventListeners()) {
            return;
        }
        WriteObjectQuery writeObjectQuery2 = this.buildAggregateWriteQuery(writeObjectQuery, object);
        classDescriptor.getQueryManager().postInsert(writeObjectQuery2);
        this.executeEvent(5, writeObjectQuery2);
        this.executeEvent(1, writeObjectQuery2);
    }

    public void postUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.postUpdateAttributeValue(writeObjectQuery, this.getAttributeValueFromObject(writeObjectQuery.getObject()));
        }
    }

    protected void postUpdateAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        AbstractSession abstractSession = writeObjectQuery.getSession();
        ClassDescriptor classDescriptor = this.getReferenceDescriptor(object, abstractSession);
        if (classDescriptor.getObjectBuilder().isSimple() && !classDescriptor.getEventManager().hasAnyEventListeners()) {
            return;
        }
        ObjectChangeSet objectChangeSet = null;
        UnitOfWorkChangeSet unitOfWorkChangeSet = null;
        if (abstractSession.isUnitOfWork() && ((UnitOfWorkImpl)abstractSession).getUnitOfWorkChangeSet() != null) {
            unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)abstractSession).getUnitOfWorkChangeSet();
            objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object);
        }
        WriteObjectQuery writeObjectQuery2 = this.buildAggregateWriteQuery(writeObjectQuery, object);
        writeObjectQuery2.setObjectChangeSet(objectChangeSet);
        classDescriptor.getQueryManager().postUpdate(writeObjectQuery2);
        this.executeEvent(7, writeObjectQuery2);
        this.executeEvent(1, writeObjectQuery2);
    }

    public void preDelete(DeleteObjectQuery deleteObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.preDeleteAttributeValue(deleteObjectQuery, this.getAttributeValueFromObject(deleteObjectQuery.getObject()));
        }
    }

    protected void preDeleteAttributeValue(DeleteObjectQuery deleteObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        AbstractSession abstractSession = deleteObjectQuery.getSession();
        ClassDescriptor classDescriptor = this.getReferenceDescriptor(object, abstractSession);
        if (classDescriptor.getObjectBuilder().isSimple() && !classDescriptor.getEventManager().hasAnyEventListeners()) {
            return;
        }
        DeleteObjectQuery deleteObjectQuery2 = this.buildAggregateDeleteQuery(deleteObjectQuery, object);
        this.executeEvent(2, deleteObjectQuery2);
        classDescriptor.getQueryManager().preDelete(deleteObjectQuery2);
    }

    public void preInsert(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.preInsertAttributeValue(writeObjectQuery, this.getAttributeValueFromObject(writeObjectQuery.getObject()));
        }
    }

    protected void preInsertAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        AbstractSession abstractSession = writeObjectQuery.getSession();
        ClassDescriptor classDescriptor = this.getReferenceDescriptor(object, abstractSession);
        if (classDescriptor.getObjectBuilder().isSimple() && !classDescriptor.getEventManager().hasAnyEventListeners()) {
            return;
        }
        WriteObjectQuery writeObjectQuery2 = this.buildAggregateWriteQuery(writeObjectQuery, object);
        ObjectChangeSet objectChangeSet = null;
        if (abstractSession.isUnitOfWork() && ((UnitOfWorkImpl)abstractSession).getUnitOfWorkChangeSet() != null) {
            UnitOfWorkChangeSet unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)abstractSession).getUnitOfWorkChangeSet();
            objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(writeObjectQuery2.getObject());
        }
        writeObjectQuery2.setObjectChangeSet(objectChangeSet);
        if (objectChangeSet == null) {
            this.executeEvent(0, writeObjectQuery2);
            this.executeEvent(4, writeObjectQuery2);
        }
        classDescriptor.getQueryManager().preInsert(writeObjectQuery2);
    }

    public void preUpdate(WriteObjectQuery writeObjectQuery) throws DatabaseException, OptimisticLockException {
        if (!this.isReadOnly()) {
            this.preUpdateAttributeValue(writeObjectQuery, this.getAttributeValueFromObject(writeObjectQuery.getObject()));
        }
    }

    protected void preUpdateAttributeValue(WriteObjectQuery writeObjectQuery, Object object) throws DatabaseException, OptimisticLockException {
        if (object == null) {
            return;
        }
        AbstractSession abstractSession = writeObjectQuery.getSession();
        ClassDescriptor classDescriptor = this.getReferenceDescriptor(object, abstractSession);
        if (classDescriptor.getObjectBuilder().isSimple() && !classDescriptor.getEventManager().hasAnyEventListeners()) {
            return;
        }
        WriteObjectQuery writeObjectQuery2 = this.buildAggregateWriteQuery(writeObjectQuery, object);
        ObjectChangeSet objectChangeSet = null;
        UnitOfWorkChangeSet unitOfWorkChangeSet = null;
        if (abstractSession.isUnitOfWork() && ((UnitOfWorkImpl)abstractSession).getUnitOfWorkChangeSet() != null) {
            unitOfWorkChangeSet = (UnitOfWorkChangeSet)((UnitOfWorkImpl)abstractSession).getUnitOfWorkChangeSet();
            objectChangeSet = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(writeObjectQuery2.getObject());
        }
        writeObjectQuery2.setObjectChangeSet(objectChangeSet);
        if (objectChangeSet == null) {
            this.executeEvent(0, writeObjectQuery2);
            this.executeEvent(6, writeObjectQuery2);
        }
        classDescriptor.getQueryManager().preUpdate(writeObjectQuery2);
    }

    public void remoteInitialization(DistributedSession distributedSession) {
        super.remoteInitialization(distributedSession);
        ClassDescriptor classDescriptor = this.getReferenceDescriptor();
        if (distributedSession.hasCorrespondingDescriptor(classDescriptor)) {
            ClassDescriptor classDescriptor2 = distributedSession.getDescriptorCorrespondingTo(classDescriptor);
            this.setReferenceDescriptor(classDescriptor2);
        } else {
            distributedSession.privilegedAddDescriptor(classDescriptor);
            classDescriptor.remoteInitialization(distributedSession);
        }
    }

    public void setReferenceClass(Class clazz) {
        this.referenceClass = clazz;
    }

    public void setReferenceClassName(String string) {
        this.referenceClassName = string;
    }

    protected void setReferenceDescriptor(ClassDescriptor classDescriptor) {
        this.referenceDescriptor = classDescriptor;
    }

    public void updateChangeRecord(Object object, Object object2, Object object3, ObjectChangeSet objectChangeSet, UnitOfWorkImpl unitOfWorkImpl) throws DescriptorException {
        AggregateChangeRecord aggregateChangeRecord = (AggregateChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (aggregateChangeRecord == null) {
            aggregateChangeRecord = new AggregateChangeRecord(objectChangeSet);
            aggregateChangeRecord.setAttribute(this.getAttributeName());
            aggregateChangeRecord.setMapping(this);
            objectChangeSet.addChange(aggregateChangeRecord);
        }
        if (object.getClass().equals(objectChangeSet.getClassType(unitOfWorkImpl))) {
            ClassDescriptor classDescriptor = this.getReferenceDescriptor(object2, (AbstractSession)unitOfWorkImpl);
            if (object2 == null) {
                aggregateChangeRecord.setChangedObject(null);
                if (classDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                    ((AggregateAttributeChangeListener)((ChangeTracker)object3)._persistence_getPropertyChangeListener()).setParentListener(null);
                }
                return;
            }
            UnitOfWorkChangeSet unitOfWorkChangeSet = (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet();
            ObjectChangeSet objectChangeSet2 = (ObjectChangeSet)unitOfWorkChangeSet.getObjectChangeSetForClone(object2);
            if (objectChangeSet2 != null) {
                objectChangeSet2.clear();
            }
            if (classDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
                AggregateAttributeChangeListener aggregateAttributeChangeListener;
                if (object3 != null) {
                    ((AggregateAttributeChangeListener)((ChangeTracker)object3)._persistence_getPropertyChangeListener()).setParentListener(null);
                }
                if ((aggregateAttributeChangeListener = (AggregateAttributeChangeListener)((ChangeTracker)object2)._persistence_getPropertyChangeListener()) == null) {
                    aggregateAttributeChangeListener = new AggregateAttributeChangeListener(classDescriptor, unitOfWorkImpl, (AttributeChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener(), this.getAttributeName(), object2);
                    ((ChangeTracker)object2)._persistence_setPropertyChangeListener(aggregateAttributeChangeListener);
                }
                aggregateAttributeChangeListener.setParentListener((AttributeChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener());
            }
            aggregateChangeRecord.setChangedObject(classDescriptor.getObjectChangePolicy().createObjectChangeSetThroughComparison(object2, object3, unitOfWorkChangeSet, object3 == null, unitOfWorkImpl, classDescriptor));
            classDescriptor.getObjectChangePolicy().setChangeSetOnListener((ObjectChangeSet)aggregateChangeRecord.getChangedObject(), object2);
        } else if (this.referenceDescriptor.getObjectChangePolicy().isAttributeChangeTrackingPolicy()) {
            aggregateChangeRecord.setChangedObject(((AggregateAttributeChangeListener)((ChangeTracker)object)._persistence_getPropertyChangeListener()).getObjectChangeSet());
        } else {
            aggregateChangeRecord.setChangedObject(this.referenceDescriptor.getObjectChangePolicy().createObjectChangeSetThroughComparison(object, null, (UnitOfWorkChangeSet)objectChangeSet.getUOWChangeSet(), true, unitOfWorkImpl, this.referenceDescriptor));
        }
    }

    public boolean verifyDelete(Object object, AbstractSession abstractSession) throws DatabaseException {
        return this.verifyDeleteOfAttributeValue(this.getAttributeValueFromObject(object), abstractSession);
    }

    protected boolean verifyDeleteOfAttributeValue(Object object, AbstractSession abstractSession) throws DatabaseException {
        if (object == null) {
            return true;
        }
        Enumeration<DatabaseMapping> enumeration = this.getReferenceDescriptor(object, abstractSession).getMappings().elements();
        while (enumeration.hasMoreElements()) {
            DatabaseMapping databaseMapping = enumeration.nextElement();
            if (databaseMapping.verifyDelete(object, abstractSession)) continue;
            return false;
        }
        return true;
    }
}

