/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.sessions.Session;

public class ClassInstanceConverter
implements Converter {
    protected DatabaseMapping mapping;

    public Object convertDataValueToObjectValue(Object object, Session session) {
        Object object2;
        block6: {
            object2 = null;
            if (object != null) {
                Class clazz = (Class)((AbstractSession)session).getDatasourcePlatform().convertObject(object, ClassConstants.CLASS);
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            object2 = AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(clazz));
                            break block6;
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw ConversionException.couldNotBeConverted(object, clazz, privilegedActionException.getException());
                        }
                    }
                    object2 = PrivilegedAccessHelper.newInstanceFromClass(clazz);
                }
                catch (Exception exception) {
                    throw ConversionException.couldNotBeConverted(object, clazz, exception);
                }
            }
        }
        return object2;
    }

    public Object convertObjectValueToDataValue(Object object, Session session) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName();
    }

    public void initialize(DatabaseMapping databaseMapping, Session session) {
        AbstractDirectMapping abstractDirectMapping;
        this.mapping = databaseMapping;
        if (this.getMapping().isDirectToFieldMapping() && (abstractDirectMapping = (AbstractDirectMapping)this.getMapping()).getFieldClassification() == null) {
            abstractDirectMapping.setFieldClassification(ClassConstants.STRING);
        }
    }

    protected DatabaseMapping getMapping() {
        return this.mapping;
    }

    public boolean isMutable() {
        return false;
    }
}

