/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings.converters;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.EnumSet;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.sessions.Session;

public class EnumTypeConverter
extends ObjectTypeConverter {
    private Class m_enumClass;
    private String m_enumClassName;

    public EnumTypeConverter(DatabaseMapping databaseMapping, Class clazz, boolean bl) {
        super(databaseMapping);
        this.m_enumClassName = clazz.getName();
        this.m_enumClass = clazz;
        EnumSet<Enum> enumSet = EnumSet.allOf(clazz);
        for (Enum enum_ : enumSet) {
            if (bl) {
                this.addConversionValue(enum_.ordinal(), enum_.name());
                continue;
            }
            this.addConversionValue(enum_.name(), enum_.name());
        }
    }

    public EnumTypeConverter(DatabaseMapping databaseMapping, String string) {
        super(databaseMapping);
        this.m_enumClassName = string;
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        block5: {
            try {
                if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                    try {
                        this.m_enumClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.m_enumClassName, true, classLoader));
                        break block5;
                    }
                    catch (PrivilegedActionException privilegedActionException) {
                        throw ValidationException.classNotFoundWhileConvertingClassNames(this.m_enumClassName, privilegedActionException.getException());
                    }
                }
                this.m_enumClass = PrivilegedAccessHelper.getClassForName(this.m_enumClassName, true, classLoader);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw ValidationException.classNotFoundWhileConvertingClassNames(this.m_enumClassName, classNotFoundException);
            }
        }
    }

    public Object convertDataValueToObjectValue(Object object, Session session) {
        Object object2 = super.convertDataValueToObjectValue(object, session);
        if (object == null || object2 == null) {
            return object2;
        }
        return Enum.valueOf(this.m_enumClass, (String)object2);
    }

    public Object convertObjectValueToDataValue(Object object, Session session) {
        if (object == null) {
            return super.convertObjectValueToDataValue(null, session);
        }
        return super.convertObjectValueToDataValue(((Enum)object).name(), session);
    }
}

