/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import org.eclipse.persistence.internal.oxm.XMLObjectBuilder;
import org.eclipse.persistence.internal.oxm.documentpreservation.XMLBinderPolicy;
import org.eclipse.persistence.internal.oxm.record.DOMReader;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshaller;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.oxm.XMLContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.oxm.documentpreservation.DocumentPreservationPolicy;
import org.eclipse.persistence.oxm.record.DOMRecord;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBinder {
    SAXUnmarshaller saxUnmarshaller;
    XMLContext context;
    XMLUnmarshaller unmarshaller;
    DocumentPreservationPolicy documentPreservationPolicy;
    DOMReader reader;

    public XMLBinder(XMLContext xMLContext) {
        this.unmarshaller = xMLContext.createUnmarshaller();
        this.saxUnmarshaller = new SAXUnmarshaller(this.unmarshaller);
        this.context = xMLContext;
        this.documentPreservationPolicy = new XMLBinderPolicy();
        this.reader = new DOMReader();
    }

    public Object unmarshal(Node node) {
        this.reader.setDocPresPolicy(this.documentPreservationPolicy);
        Object object = this.saxUnmarshaller.unmarshal(this.reader, node);
        return object;
    }

    public XMLRoot unmarshal(Node node, Class clazz) {
        XMLRoot xMLRoot = null;
        this.reader.setDocPresPolicy(this.documentPreservationPolicy);
        xMLRoot = (XMLRoot)this.saxUnmarshaller.unmarshal(this.reader, node, clazz);
        return xMLRoot;
    }

    public void updateXML(Object object) {
        Node node;
        if (object instanceof XMLRoot) {
            object = ((XMLRoot)object).getObject();
        }
        if ((node = this.documentPreservationPolicy.getNodeForObject(object)) == null) {
            return;
        }
        this.updateXML(object, node);
    }

    public void updateXML(Object object, Node node) {
        if (object instanceof XMLRoot) {
            object = ((XMLRoot)object).getObject();
        }
        AbstractSession abstractSession = this.context.getSession(object);
        DOMRecord dOMRecord = new DOMRecord((Element)node);
        dOMRecord.setDocPresPolicy(this.documentPreservationPolicy);
        XMLDescriptor xMLDescriptor = (XMLDescriptor)abstractSession.getDescriptor(object);
        ((XMLObjectBuilder)xMLDescriptor.getObjectBuilder()).buildIntoNestedRow(dOMRecord, object, abstractSession);
    }

    public Node getXMLNode(Object object) {
        return this.documentPreservationPolicy.getNodeForObject(object);
    }

    public Object getObject(Node node) {
        return this.documentPreservationPolicy.getObjectForNode(node);
    }

    public void updateObject(Node node) {
        Object object = this.documentPreservationPolicy.getObjectForNode(node);
        if (object != null) {
            this.unmarshal(node);
        }
    }

    public DocumentPreservationPolicy getDocumentPreservationPolicy() {
        return this.documentPreservationPolicy;
    }
}

