/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.oxm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.oxm.XMLConversionManager;
import org.eclipse.persistence.internal.oxm.XMLConversionPair;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.oxm.NamespaceResolver;

public class XMLField
extends DatabaseField {
    private NamespaceResolver namespaceResolver;
    private QName schemaType;
    private XPathFragment xPathFragment;
    private XPathFragment lastXPathFragment;
    private boolean isCDATA = false;
    private boolean usesSingleNode;
    protected HashMap userXMLTypes;
    protected HashMap userJavaTypes;
    private boolean isTypedTextField = false;
    private QName leafElementType;

    public XMLField() {
    }

    public XMLField(String string) {
        this.setXPath(string);
    }

    public String getXPath() {
        return this.getName();
    }

    public void setXPath(String string) {
        this.setName(string);
    }

    public NamespaceResolver getNamespaceResolver() {
        return this.namespaceResolver;
    }

    public void setNamespaceResolver(NamespaceResolver namespaceResolver) {
        this.namespaceResolver = namespaceResolver;
    }

    public void setUsesSingleNode(boolean bl) {
        this.usesSingleNode = bl;
    }

    public boolean usesSingleNode() {
        return this.usesSingleNode;
    }

    public void setSchemaType(QName qName) {
        this.schemaType = qName;
    }

    public QName getSchemaType() {
        return this.schemaType;
    }

    public boolean isTypedTextField() {
        return this.isTypedTextField;
    }

    public void setIsTypedTextField(boolean bl) {
        this.isTypedTextField = bl;
    }

    public boolean isSelfField() {
        if (null == this.xPathFragment) {
            return false;
        }
        return this.xPathFragment.isSelfFragment();
    }

    public boolean isUnionField() {
        return false;
    }

    public void setName(String string) {
        super.setName(string);
        if (this.hasPath(string)) {
            this.buildFragments(string);
        } else {
            XPathFragment xPathFragment = new XPathFragment(string);
            this.setXPathFragment(xPathFragment);
            this.setLastXPathFragment(xPathFragment);
        }
    }

    private boolean hasPath(String string) {
        return string != null && string.indexOf(47) != -1;
    }

    private void buildFragments(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
        int n = 0;
        XPathFragment xPathFragment = null;
        XPathFragment xPathFragment2 = null;
        if (string.startsWith("/")) {
            string2 = stringTokenizer.nextToken();
            string2 = "/" + string2;
            xPathFragment = new XPathFragment(string2);
            this.setXPathFragment(xPathFragment);
            ++n;
        }
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (null != string2) {
                xPathFragment2 = string2.equals("text()") ? new XPathFragment("text()") : new XPathFragment(string2);
                if (0 == n) {
                    this.setXPathFragment(xPathFragment2);
                } else {
                    xPathFragment.setNextFragment(xPathFragment2);
                    if (xPathFragment2.isAttribute() || xPathFragment2.nameIsText()) {
                        xPathFragment.setHasText(true);
                    }
                }
                xPathFragment = xPathFragment2;
                ++n;
            }
            this.setLastXPathFragment(xPathFragment);
        }
    }

    public XPathFragment getXPathFragment() {
        return this.xPathFragment;
    }

    public void setXPathFragment(XPathFragment xPathFragment) {
        this.xPathFragment = xPathFragment;
    }

    public XPathFragment getLastXPathFragment() {
        return this.lastXPathFragment;
    }

    public void setLastXPathFragment(XPathFragment xPathFragment) {
        this.lastXPathFragment = xPathFragment;
    }

    public Class getJavaClass(QName qName) {
        if (this.userXMLTypes != null && this.userXMLTypes.containsKey(qName)) {
            return (Class)this.userXMLTypes.get(qName);
        }
        return (Class)XMLConversionManager.getDefaultXMLTypes().get(qName);
    }

    public QName getXMLType(Class clazz) {
        if (this.userJavaTypes != null && this.userJavaTypes.containsKey(clazz)) {
            return (QName)this.userJavaTypes.get(clazz);
        }
        return (QName)XMLConversionManager.getDefaultJavaTypes().get(clazz);
    }

    private HashMap getUserJavaTypes() {
        if (this.userJavaTypes == null) {
            this.userJavaTypes = new HashMap();
        }
        return this.userJavaTypes;
    }

    private HashMap getUserXMLTypes() {
        if (this.userXMLTypes == null) {
            this.userXMLTypes = new HashMap();
        }
        return this.userXMLTypes;
    }

    public ArrayList getUserXMLTypesForDeploymentXML() {
        if (this.userXMLTypes != null) {
            ArrayList<XMLConversionPair> arrayList = new ArrayList<XMLConversionPair>(this.userXMLTypes.size());
            for (QName qName : this.userXMLTypes.keySet()) {
                Class clazz = (Class)this.userXMLTypes.get(qName);
                XMLConversionPair xMLConversionPair = new XMLConversionPair(qName, clazz.getName());
                arrayList.add(xMLConversionPair);
            }
            return arrayList;
        }
        return null;
    }

    public void setUserXMLTypesForDeploymentXML(ArrayList arrayList) throws Exception {
        if (arrayList.size() > 0) {
            this.userXMLTypes = new HashMap();
            for (XMLConversionPair xMLConversionPair : arrayList) {
                if (xMLConversionPair.getXmlType() == null || xMLConversionPair.getJavaType() == null) continue;
                this.userXMLTypes.put(xMLConversionPair.getXmlType(), Class.forName(xMLConversionPair.getJavaType()));
            }
        }
    }

    public ArrayList getUserJavaTypesForDeploymentXML() {
        if (this.userJavaTypes != null) {
            ArrayList<XMLConversionPair> arrayList = new ArrayList<XMLConversionPair>(this.userJavaTypes.size());
            for (Class clazz : this.userJavaTypes.keySet()) {
                QName qName = (QName)this.userJavaTypes.get(clazz);
                XMLConversionPair xMLConversionPair = new XMLConversionPair(qName, clazz.getName());
                arrayList.add(xMLConversionPair);
            }
            return arrayList;
        }
        return null;
    }

    public void setUserJavaTypesForDeploymentXML(ArrayList arrayList) throws Exception {
        if (arrayList.size() > 0) {
            this.userJavaTypes = new HashMap();
            for (XMLConversionPair xMLConversionPair : arrayList) {
                if (xMLConversionPair.getXmlType() == null || xMLConversionPair.getJavaType() == null) continue;
                this.userJavaTypes.put(Class.forName(xMLConversionPair.getJavaType()), xMLConversionPair.getXmlType());
            }
        }
    }

    public Object convertValueBasedOnSchemaType(Object object, XMLConversionManager xMLConversionManager) {
        if (this.getSchemaType() != null) {
            Class clazz = this.getType();
            if (clazz == null) {
                clazz = this.getJavaClass(this.getSchemaType());
            }
            return xMLConversionManager.convertObject(object, clazz, this.getSchemaType());
        }
        return object;
    }

    public void addXMLConversion(QName qName, Class clazz) {
        this.getUserXMLTypes().put(qName, clazz);
    }

    public void addJavaConversion(Class clazz, QName qName) {
        this.getUserJavaTypes().put(clazz, qName);
    }

    public void addConversion(QName qName, Class clazz) {
        this.addJavaConversion(clazz, qName);
        this.addXMLConversion(qName, clazz);
    }

    public void removeXMLConversion(QName qName) {
        this.getUserXMLTypes().remove(qName);
    }

    public void removeJavaConversion(Class clazz) {
        this.getUserJavaTypes().remove(clazz);
    }

    public void removeConversion(QName qName, Class clazz) {
        this.removeJavaConversion(clazz);
        this.removeXMLConversion(qName);
    }

    public void setLeafElementType(QName qName) {
        this.leafElementType = qName;
        if (this.hasLastXPathFragment()) {
            this.getLastXPathFragment().setLeafElementType(qName);
        }
    }

    public QName getLeafElementType() {
        if (this.hasLastXPathFragment()) {
            return this.getLastXPathFragment().getLeafElementType();
        }
        return this.leafElementType;
    }

    public boolean hasLastXPathFragment() {
        return this.getLastXPathFragment() != null;
    }

    public void setIsCDATA(boolean bl) {
        this.isCDATA = bl;
    }

    public boolean isCDATA() {
        return this.isCDATA;
    }
}

