/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.DescriptorQueryManager;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.internal.databaseaccess.DatabaseAccessor;
import org.eclipse.persistence.internal.databaseaccess.DatabaseCall;
import org.eclipse.persistence.internal.databaseaccess.DatabasePlatform;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.helper.InvalidObject;
import org.eclipse.persistence.internal.helper.NonSynchronizedVector;
import org.eclipse.persistence.internal.indirection.ProxyIndirectionPolicy;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.Transporter;
import org.eclipse.persistence.queries.Call;
import org.eclipse.persistence.queries.ComplexQueryResult;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectLevelReadQuery;
import org.eclipse.persistence.queries.QueryByExamplePolicy;
import org.eclipse.persistence.queries.QueryRedirector;
import org.eclipse.persistence.sessions.remote.RemoteSession;
import org.eclipse.persistence.tools.profiler.QueryMonitor;

public class ReadObjectQuery
extends ObjectLevelReadQuery {
    protected transient Object selectionObject;
    protected Vector selectionKey;
    protected boolean shouldLoadResultIntoSelectionObject = false;

    public ReadObjectQuery() {
    }

    public ReadObjectQuery(Class clazz) {
        this();
        this.referenceClass = clazz;
    }

    public ReadObjectQuery(Class clazz, Expression expression) {
        this();
        this.referenceClass = clazz;
        this.setSelectionCriteria(expression);
    }

    public ReadObjectQuery(Class clazz, ExpressionBuilder expressionBuilder) {
        this();
        this.defaultBuilder = expressionBuilder;
        this.referenceClass = clazz;
    }

    public ReadObjectQuery(Class clazz, Call call) {
        this();
        this.referenceClass = clazz;
        this.setCall(call);
    }

    public ReadObjectQuery(Call call) {
        this();
        this.setCall(call);
    }

    public ReadObjectQuery(Object object) {
        this();
        this.setSelectionObject(object);
    }

    public ReadObjectQuery(Object object, QueryByExamplePolicy queryByExamplePolicy) {
        this();
        this.setExampleObject(object);
        this.setQueryByExamplePolicy(queryByExamplePolicy);
    }

    public ReadObjectQuery(ExpressionBuilder expressionBuilder) {
        this();
        this.defaultBuilder = expressionBuilder;
    }

    public void cacheResult(Object object) {
        Object object2 = object;
        if (this.shouldUseWrapperPolicy()) {
            object2 = this.getSession().wrapObject(object);
        }
        this.setTemporaryCachedQueryResults(object2);
    }

    public void checkCacheByExactPrimaryKey() {
        this.setCacheUsage(1);
    }

    public void checkCacheByPrimaryKey() {
        this.setCacheUsage(2);
    }

    public void checkCacheThenDatabase() {
        this.setCacheUsage(3);
    }

    public void checkDescriptor(AbstractSession abstractSession) throws QueryException {
        if (this.getReferenceClass() == null) {
            throw QueryException.referenceClassMissing(this);
        }
        if (this.getDescriptor() == null) {
            ClassDescriptor classDescriptor = this.getSelectionObject() != null && abstractSession.getProject().hasProxyIndirection() ? abstractSession.getDescriptor(this.getSelectionObject()) : abstractSession.getDescriptor(this.getReferenceClass());
            if (classDescriptor == null) {
                throw QueryException.descriptorIsMissing(this.getReferenceClass(), this);
            }
            this.setDescriptor(classDescriptor);
        }
    }

    protected Object checkEarlyReturnImpl(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        if (!(!this.shouldCheckCache() || !this.shouldMaintainCache() || this.shouldRefreshIdentityMapResult() || abstractSession.isRemoteSession() && (this.shouldRefreshRemoteIdentityMapResult() || this.getDescriptor().shouldDisableCacheHitsOnRemote()) || this.shouldCheckDescriptorForCacheUsage() && this.getDescriptor().shouldDisableCacheHits() || this.getDescriptor().isDescriptorForInterface())) {
            Object object = this.getQueryMechanism().checkCacheForObject(abstractRecord, abstractSession);
            if (object == InvalidObject.instance) {
                return object;
            }
            if (object != null) {
                if (this.shouldLoadResultIntoSelectionObject()) {
                    ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
                    objectBuilder.copyInto(object, this.getSelectionObject());
                    abstractSession.getIdentityMapAccessorInstance().putInIdentityMap(this.getSelectionObject());
                    object = this.getSelectionObject();
                }
                if (this.isLockQuery() && abstractSession.isUnitOfWork() && !((UnitOfWorkImpl)abstractSession).isPessimisticLocked(object)) {
                    if (QueryMonitor.shouldMonitor()) {
                        QueryMonitor.incrementReadObjectMisses(this);
                    }
                    return null;
                }
                if (QueryMonitor.shouldMonitor()) {
                    QueryMonitor.incrementReadObjectHits(this);
                }
            } else if (QueryMonitor.shouldMonitor()) {
                QueryMonitor.incrementReadObjectMisses(this);
            }
            if (this.shouldUseWrapperPolicy()) {
                object = this.getDescriptor().getObjectBuilder().wrapObject(object, abstractSession);
            }
            return object;
        }
        if (QueryMonitor.shouldMonitor()) {
            QueryMonitor.incrementReadObjectMisses(this);
        }
        return null;
    }

    protected DatabaseQuery checkForCustomQuery(AbstractSession abstractSession, AbstractRecord abstractRecord) {
        this.checkDescriptor(abstractSession);
        if (this.isCustomQueryUsed() == null) {
            DescriptorQueryManager descriptorQueryManager;
            if (!(this.isUserDefined() || this.isCallQuery() || !(descriptorQueryManager = this.getDescriptor().getQueryManager()).hasReadObjectQuery() || this.hasJoining() && this.getJoinedAttributeManager().hasJoinedAttributeExpressions() || this.hasPartialAttributeExpressions() || this.hasAsOfClause() || this.hasNonDefaultFetchGroup() || this.getHintString() != null || !this.wasDefaultLockMode() || !this.shouldIgnoreBindAllParameters() || this.hasFetchGroup() || this.getFetchGroupName() != null || !this.shouldUseDefaultFetchGroup())) {
                AbstractRecord abstractRecord2;
                if (this.getSelectionKey() != null || this.getSelectionObject() != null) {
                    this.setIsCustomQueryUsed(true);
                } else if (this.getSelectionCriteria() != null && (abstractRecord2 = this.getDescriptor().getObjectBuilder().extractPrimaryKeyRowFromExpression(this.getSelectionCriteria(), abstractRecord, abstractSession)) != null) {
                    this.setIsCustomQueryUsed(true);
                }
            }
            if (this.isCustomQueryUsed() == null) {
                this.setIsCustomQueryUsed(false);
            }
        }
        if (this.isCustomQueryUsed().booleanValue()) {
            return this.getDescriptor().getQueryManager().getReadObjectQuery();
        }
        return null;
    }

    protected Object conformResult(Object object, UnitOfWorkImpl unitOfWorkImpl, AbstractRecord abstractRecord, boolean bl) {
        Object object2;
        Object object3 = null;
        object3 = bl ? object : this.getDescriptor().getObjectBuilder().unwrapObject(object, unitOfWorkImpl.getParent());
        if (this.getSelectionCriteria() != null && this.getSelectionKey() == null && this.getSelectionObject() == null) {
            object2 = this.getSelectionCriteria().getBuilder();
            ((ExpressionBuilder)object2).setSession(unitOfWorkImpl.getRootSession(null));
            ((ExpressionBuilder)object2).setQueryClass(this.getReferenceClass());
        }
        if ((object2 = this.conformIndividualResult(object3, unitOfWorkImpl, abstractRecord, this.getSelectionCriteria(), null, bl)) == null) {
            return object2;
        }
        if (this.shouldUseWrapperPolicy()) {
            return this.getDescriptor().getObjectBuilder().wrapObject(object2, unitOfWorkImpl);
        }
        return object2;
    }

    public void dontLoadResultIntoSelectionObject() {
        this.setShouldLoadResultIntoSelectionObject(false);
    }

    public Object execute(AbstractSession abstractSession, AbstractRecord abstractRecord) throws DatabaseException {
        if (this.shouldCacheQueryResults()) {
            if (this.shouldConformResultsInUnitOfWork()) {
                throw QueryException.cannotConformAndCacheQueryResults(this);
            }
            if (this.isPrepared()) {
                Object object = this.getQueryResults(abstractSession, abstractRecord, true);
                if (object == InvalidObject.instance) {
                    return null;
                }
                if (object != null) {
                    if (abstractSession.isUnitOfWork()) {
                        object = ((UnitOfWorkImpl)abstractSession).registerExistingObject(object);
                    }
                    return object;
                }
            }
        }
        return super.execute(abstractSession, abstractRecord);
    }

    protected Object executeObjectLevelReadQuery() throws DatabaseException {
        Object object;
        Object object2;
        if (this.getDescriptor().isDescriptorForInterface() || this.getDescriptor().hasTablePerClassPolicy()) {
            object2 = this.getDescriptor().getInterfacePolicy().selectOneObjectUsingMultipleTableSubclassRead(this);
            if (!this.getDescriptor().hasTablePerClassPolicy() || object2 != null) {
                this.setExecutionTime(System.currentTimeMillis());
                return object2;
            }
        }
        object2 = null;
        AbstractSession abstractSession = this.getSession();
        if (this.hasJoining() && this.getJoinedAttributeManager().isToManyJoin()) {
            object = this.getQueryMechanism().selectAllRows();
            if (object.size() > 0) {
                object2 = (AbstractRecord)object.get(0);
            }
            this.getJoinedAttributeManager().setDataResults((List)object, abstractSession);
        } else {
            object2 = this.getQueryMechanism().selectOneRow();
        }
        this.setExecutionTime(System.currentTimeMillis());
        object = null;
        if (abstractSession.isUnitOfWork()) {
            object = this.registerResultInUnitOfWork(object2, (UnitOfWorkImpl)abstractSession, this.getTranslationRow(), true);
        } else if (object2 != null) {
            object = this.buildObject((AbstractRecord)object2);
        }
        if (object == null && this.shouldRefreshIdentityMapResult()) {
            if (this.getSelectionKey() != null) {
                abstractSession.getParentIdentityMapSession(this, true, true).getIdentityMapAccessor().invalidateObject(this.getSelectionKey(), this.getReferenceClass());
            } else if (this.getSelectionObject() != null) {
                abstractSession.getParentIdentityMapSession(this, true, true).getIdentityMapAccessor().invalidateObject(this.getSelectionObject());
            }
        }
        if (this.shouldIncludeData()) {
            ComplexQueryResult complexQueryResult = new ComplexQueryResult();
            complexQueryResult.setResult(object);
            complexQueryResult.setData(object2);
            return complexQueryResult;
        }
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object executeObjectLevelReadQueryFromResultSet() throws DatabaseException {
        Object object;
        boolean bl;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        DatabaseCall databaseCall;
        DatabaseAccessor databaseAccessor;
        UnitOfWorkImpl unitOfWorkImpl;
        block13: {
            Object var9_9;
            block12: {
                unitOfWorkImpl = (UnitOfWorkImpl)this.getSession();
                databaseAccessor = (DatabaseAccessor)unitOfWorkImpl.getAccessor();
                DatabasePlatform databasePlatform = databaseAccessor.getPlatform();
                databaseCall = (DatabaseCall)this.getCall().clone();
                databaseCall.setQuery(this);
                AbstractRecord abstractRecord = this.getTranslationRow();
                databaseCall.translate(this.getTranslationRow(), null, unitOfWorkImpl);
                preparedStatement = null;
                resultSet = null;
                bl = false;
                try {
                    try {
                        databaseAccessor.incrementCallCount(unitOfWorkImpl);
                        preparedStatement = (PreparedStatement)databaseCall.prepareStatement(databaseAccessor, abstractRecord, unitOfWorkImpl);
                        resultSet = preparedStatement.executeQuery();
                        if (!resultSet.next()) {
                            var9_9 = null;
                            Object var12_12 = null;
                            break block12;
                        }
                        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                        object = this.getDescriptor().getObjectBuilder().buildWorkingCopyCloneFromResultSet(this, null, resultSet, unitOfWorkImpl, databaseAccessor, resultSetMetaData, databasePlatform);
                        break block13;
                    }
                    catch (SQLException sQLException) {
                        bl = true;
                        DatabaseException databaseException = databaseAccessor.processExceptionForCommError(this.session, sQLException, databaseCall);
                        if (databaseException == null) throw DatabaseException.sqlException(sQLException, databaseCall, databaseAccessor, unitOfWorkImpl, false);
                        throw databaseException;
                    }
                }
                catch (Throwable throwable) {
                    Object var12_14 = null;
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                        if (preparedStatement == null) throw throwable;
                        databaseAccessor.releaseStatement(preparedStatement, databaseCall.getSQLString(), databaseCall, unitOfWorkImpl);
                        throw throwable;
                    }
                    catch (SQLException sQLException2) {
                        if (bl) throw throwable;
                        DatabaseException databaseException = databaseAccessor.processExceptionForCommError(this.session, sQLException2, databaseCall);
                        if (databaseException == null) throw DatabaseException.sqlException(sQLException2, databaseCall, databaseAccessor, this.session, false);
                        throw databaseException;
                    }
                }
            }
            try {}
            catch (SQLException sQLException) {
                if (bl) return var9_9;
                DatabaseException databaseException = databaseAccessor.processExceptionForCommError(this.session, sQLException, databaseCall);
                if (databaseException == null) throw DatabaseException.sqlException(sQLException, databaseCall, databaseAccessor, this.session, false);
                throw databaseException;
            }
            if (resultSet != null) {
                resultSet.close();
            }
            if (preparedStatement == null) return var9_9;
            databaseAccessor.releaseStatement(preparedStatement, databaseCall.getSQLString(), databaseCall, unitOfWorkImpl);
            return var9_9;
        }
        Object var12_13 = null;
        try {}
        catch (SQLException sQLException) {
            if (bl) return object;
            DatabaseException databaseException = databaseAccessor.processExceptionForCommError(this.session, sQLException, databaseCall);
            if (databaseException == null) throw DatabaseException.sqlException(sQLException, databaseCall, databaseAccessor, this.session, false);
            throw databaseException;
        }
        if (resultSet != null) {
            resultSet.close();
        }
        if (preparedStatement == null) return object;
        databaseAccessor.releaseStatement(preparedStatement, databaseCall.getSQLString(), databaseCall, unitOfWorkImpl);
        return object;
    }

    public Object extractRemoteResult(Transporter transporter) {
        return ((RemoteSession)this.getSession()).getObjectCorrespondingTo(transporter.getObject(), transporter.getObjectDescriptors(), new IdentityHashMap(), this);
    }

    protected QueryRedirector getDefaultRedirector() {
        return this.descriptor.getDefaultReadObjectQueryRedirector();
    }

    public Vector getSelectionKey() {
        return this.selectionKey;
    }

    public Object getSelectionObject() {
        return this.selectionObject;
    }

    public boolean isReadObjectQuery() {
        return true;
    }

    public void loadResultIntoSelectionObject() {
        this.setShouldLoadResultIntoSelectionObject(true);
    }

    public void copyFromQuery(DatabaseQuery databaseQuery) {
        super.copyFromQuery(databaseQuery);
        if (databaseQuery.isReadObjectQuery()) {
            ReadObjectQuery readObjectQuery = (ReadObjectQuery)databaseQuery;
            this.selectionKey = readObjectQuery.selectionKey;
            this.selectionObject = readObjectQuery.selectionObject;
            this.shouldLoadResultIntoSelectionObject = readObjectQuery.shouldLoadResultIntoSelectionObject;
        }
    }

    protected void prepare() throws QueryException {
        if (this.prepareFromCachedQuery()) {
            return;
        }
        super.prepare();
        if (this.getSelectionKey() != null || this.getSelectionObject() != null) {
            this.setSelectionCriteria(this.getDescriptor().getObjectBuilder().getPrimaryKeyExpression());
            if (!this.shouldPrepare()) {
                if (this.getSelectionKey() != null) {
                    this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowFromPrimaryKeyValues(this.getSelectionKey(), this.getSession()));
                } else {
                    this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getSelectionObject(), this.getSession()));
                }
            }
        }
        if (this.getDescriptor().isDescriptorForInterface()) {
            return;
        }
        if (this.hasJoining() && this.getJoinedAttributeManager().isToManyJoin()) {
            this.getQueryMechanism().prepareSelectAllRows();
        } else {
            this.getQueryMechanism().prepareSelectOneRow();
        }
    }

    protected void prepareCustomQuery(DatabaseQuery databaseQuery) {
        ReadObjectQuery readObjectQuery = (ReadObjectQuery)databaseQuery;
        readObjectQuery.setShouldRefreshIdentityMapResult(this.shouldRefreshIdentityMapResult());
        readObjectQuery.setCascadePolicy(this.getCascadePolicy());
        readObjectQuery.setShouldMaintainCache(this.shouldMaintainCache());
        readObjectQuery.setShouldUseWrapperPolicy(this.shouldUseWrapperPolicy());
        readObjectQuery.setQueryId(this.getQueryId());
        readObjectQuery.setExecutionTime(this.getExecutionTime());
        readObjectQuery.setShouldLoadResultIntoSelectionObject(this.shouldLoadResultIntoSelectionObject());
        if (this.getSelectionObject() != null) {
            readObjectQuery.setSelectionObject(this.getSelectionObject());
        } else if (this.getSelectionKey() != null) {
            readObjectQuery.setSelectionKey(this.getSelectionKey());
        } else {
            AbstractRecord abstractRecord = databaseQuery.getDescriptor().getObjectBuilder().extractPrimaryKeyRowFromExpression(this.getSelectionCriteria(), databaseQuery.getTranslationRow(), readObjectQuery.getSession());
            readObjectQuery.setTranslationRow(abstractRecord);
        }
    }

    public void prepareForExecution() throws QueryException {
        super.prepareForExecution();
        if (this.shouldPrepare()) {
            if (this.getSelectionKey() != null) {
                this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowFromPrimaryKeyValues(this.getSelectionKey(), this.getSession()));
            } else if (this.getSelectionObject() != null) {
                this.setTranslationRow(this.getDescriptor().getObjectBuilder().buildRowForTranslation(this.getSelectionObject(), this.getSession()));
            }
        }
    }

    protected void prePrepare() throws QueryException {
        super.prePrepare();
        if (this.getSelectionObject() != null && this.getSession().getProject().hasProxyIndirection()) {
            this.setSelectionObject(ProxyIndirectionPolicy.getValueFromProxy(this.getSelectionObject()));
        }
    }

    public Object registerResultInUnitOfWork(Object object, UnitOfWorkImpl unitOfWorkImpl, AbstractRecord abstractRecord, boolean bl) {
        if (object == null) {
            return null;
        }
        if (this.shouldConformResultsInUnitOfWork() || this.getDescriptor().shouldAlwaysConformResultsInUnitOfWork()) {
            return this.conformResult(object, unitOfWorkImpl, abstractRecord, bl);
        }
        Object object2 = null;
        object2 = bl ? this.buildObject((AbstractRecord)object) : this.registerIndividualResult(object, unitOfWorkImpl, null);
        if (this.shouldUseWrapperPolicy()) {
            object2 = this.getDescriptor().getObjectBuilder().wrapObject(object2, unitOfWorkImpl);
        }
        return object2;
    }

    protected Object remoteExecute() {
        Object object;
        this.checkDescriptor(this.session);
        if (this.getSelectionObject() != null) {
            this.setSelectionKey(this.getDescriptor().getObjectBuilder().extractPrimaryKeyFromObject(this.getSelectionObject(), this.session));
        }
        if ((object = this.checkEarlyReturn(this.getSession(), this.getTranslationRow())) != null || this.shouldCheckCacheOnly()) {
            return object;
        }
        return super.remoteExecute();
    }

    public Map replaceValueHoldersIn(Object object, RemoteSessionController remoteSessionController) {
        return remoteSessionController.replaceValueHoldersIn(object);
    }

    public void setSelectionKey(List list) {
        this.selectionKey = list == null ? null : (list instanceof NonSynchronizedVector ? (Vector)list : new NonSynchronizedVector((Collection)list));
    }

    public void setSelectionObject(Object object) {
        if (object == null) {
            throw QueryException.selectionObjectCannotBeNull(this);
        }
        this.setSelectionKey(null);
        if (this.selectionObject == null || this.selectionObject.getClass() != object.getClass()) {
            this.setIsPrepared(false);
        }
        this.setReferenceClass(object.getClass());
        this.selectionObject = object;
    }

    public void setShouldLoadResultIntoSelectionObject(boolean bl) {
        this.shouldLoadResultIntoSelectionObject = bl;
    }

    public void setSingletonSelectionKey(Object object) {
        Vector<Object> vector = new Vector<Object>();
        vector.addElement(object);
        this.setSelectionKey(vector);
    }

    public boolean shouldCheckCache() {
        return this.cacheUsage != 0;
    }

    public boolean shouldCheckCacheByExactPrimaryKey() {
        return this.cacheUsage == 1;
    }

    public boolean shouldCheckCacheByPrimaryKey() {
        return this.cacheUsage == 2 || this.cacheUsage == -1;
    }

    public boolean shouldCheckCacheThenDatabase() {
        return this.cacheUsage == 3;
    }

    public boolean shouldLoadResultIntoSelectionObject() {
        return this.shouldLoadResultIntoSelectionObject;
    }

    protected boolean hasNonDefaultFetchGroup() {
        return this.getDescriptor().hasFetchGroupManager() && (this.getFetchGroup() != null || this.getFetchGroupName() != null || !this.shouldUseDefaultFetchGroup());
    }
}

