/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.queries;

import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.QueryException;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.helper.NonSynchronizedSubVector;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedInvokeConstructor;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.foundation.AbstractDirectMapping;
import org.eclipse.persistence.queries.ConstructorReportItem;
import org.eclipse.persistence.queries.ReadObjectQuery;
import org.eclipse.persistence.queries.ReportQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;
import org.eclipse.persistence.sessions.Session;

public class ReportQueryResult
implements Serializable,
Map {
    protected Vector names;
    protected Vector results;
    protected Vector primaryKeyValues;
    protected StringBuffer key;

    public ReportQueryResult(Vector vector, Vector vector2) {
        this.results = vector;
        this.primaryKeyValues = vector2;
    }

    public ReportQueryResult(ReportQuery reportQuery, AbstractRecord abstractRecord, Vector vector) {
        this.names = reportQuery.getNames();
        this.buildResult(reportQuery, abstractRecord, vector);
    }

    protected void buildResult(ReportQuery reportQuery, AbstractRecord abstractRecord, Vector vector) {
        if (reportQuery.shouldDistinctBeUsed() && reportQuery.shouldFilterDuplicates()) {
            this.key = new StringBuffer();
        }
        Vector vector2 = reportQuery.getItems();
        int n = vector2.size();
        Vector<Object> vector3 = new Vector<Object>(n);
        if (reportQuery.shouldRetrievePrimaryKeys()) {
            this.setPrimaryKeyValues(reportQuery.getDescriptor().getObjectBuilder().extractPrimaryKeyFromRow(abstractRecord, reportQuery.getSession()));
        }
        for (int i = 0; i < n; ++i) {
            Object object;
            ReportItem reportItem = (ReportItem)vector2.get(i);
            if (reportItem.isConstructorItem()) {
                Object object2;
                object = (ConstructorReportItem)reportItem;
                Class[] classArray = ((ConstructorReportItem)object).getConstructorArgTypes();
                int n2 = ((ConstructorReportItem)object).getReportItems().size();
                Object[] objectArray = new Object[n2];
                for (int j = 0; j < n2; ++j) {
                    object2 = (ReportItem)((ConstructorReportItem)object).getReportItems().get(j);
                    Object object3 = this.processItem(reportQuery, abstractRecord, vector, (ReportItem)object2);
                    objectArray[j] = ConversionManager.getDefaultManager().convertObject(object3, classArray[j]);
                }
                try {
                    Constructor constructor = ((ConstructorReportItem)object).getConstructor();
                    object2 = null;
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        try {
                            object2 = AccessController.doPrivileged(new PrivilegedInvokeConstructor(constructor, objectArray));
                        }
                        catch (PrivilegedActionException privilegedActionException) {
                            throw QueryException.exceptionWhileUsingConstructorExpression(privilegedActionException.getException(), reportQuery);
                        }
                    } else {
                        object2 = PrivilegedAccessHelper.invokeConstructor(constructor, objectArray);
                    }
                    vector3.add(object2);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(illegalAccessException, reportQuery);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(invocationTargetException, reportQuery);
                }
                catch (InstantiationException instantiationException) {
                    throw QueryException.exceptionWhileUsingConstructorExpression(instantiationException, reportQuery);
                }
            }
            object = this.processItem(reportQuery, abstractRecord, vector, reportItem);
            vector3.addElement(object);
        }
        this.setResults(vector3);
    }

    protected Object processItem(ReportQuery reportQuery, AbstractRecord abstractRecord, Vector vector, ReportItem reportItem) {
        JoinedAttributeManager joinedAttributeManager = null;
        if (reportItem.hasJoining() && (joinedAttributeManager = reportItem.getJoinedAttributeManager()).isToManyJoin() && joinedAttributeManager.getDataResults_() == null) {
            joinedAttributeManager.setDataResults(new ArrayList(vector), reportQuery.getSession());
        }
        Object object = null;
        DatabaseMapping databaseMapping = reportItem.getMapping();
        int n = abstractRecord.size();
        int n2 = reportItem.getResultIndex();
        ClassDescriptor classDescriptor = reportItem.getDescriptor();
        if (!reportItem.isPlaceHolder()) {
            if (databaseMapping != null) {
                if (n2 >= n) {
                    throw QueryException.reportQueryResultSizeMismatch(n2 + 1, n);
                }
                object = abstractRecord.getValues().get(n2);
                object = ((AbstractDirectMapping)databaseMapping).getAttributeValue(object, reportQuery.getSession());
                if (this.key != null) {
                    this.key.append(object);
                    this.key.append("_");
                }
            } else if (classDescriptor != null) {
                Object object2;
                Vector vector2;
                if (n2 + classDescriptor.getAllFields().size() > n) {
                    throw QueryException.reportQueryResultSizeMismatch(n2 + classDescriptor.getAllFields().size(), n);
                }
                AbstractRecord abstractRecord2 = abstractRecord;
                if (n2 > 0) {
                    vector2 = new NonSynchronizedSubVector(abstractRecord.getFields(), n2, n);
                    object2 = new NonSynchronizedSubVector(abstractRecord.getValues(), n2, n);
                    abstractRecord2 = new DatabaseRecord(vector2, (Vector)object2);
                }
                object = classDescriptor.getObjectBuilder().buildObject(reportQuery, abstractRecord2, joinedAttributeManager);
                if (this.key != null) {
                    vector2 = classDescriptor.getObjectBuilder().extractPrimaryKeyFromRow(abstractRecord2, reportQuery.getSession());
                    if (vector2 != null) {
                        object2 = vector2.iterator();
                        while (object2.hasNext()) {
                            this.key.append(object2.next());
                            this.key.append("-");
                        }
                    }
                    this.key.append("_");
                }
            } else {
                object = abstractRecord.getValues().get(n2);
                if (this.key != null) {
                    this.key.append(object);
                }
            }
        }
        return object;
    }

    public void clear() {
        this.names = new Vector();
        this.results = new Vector();
    }

    public boolean contains(Object object) {
        return this.containsValue(object);
    }

    public boolean containsKey(Object object) {
        return this.getNames().contains(object);
    }

    public boolean containsValue(Object object) {
        return this.getResults().contains(object);
    }

    public Enumeration elements() {
        return this.getResults().elements();
    }

    public Set entrySet() {
        int n = this.size();
        HashMap hashMap = new HashMap(n);
        for (int i = 0; i < n; ++i) {
            hashMap.put(this.getNames().elementAt(i), this.getResults().elementAt(i));
        }
        return hashMap.entrySet();
    }

    public boolean equals(Object object) {
        if (object instanceof ReportQueryResult) {
            return this.equals((ReportQueryResult)object);
        }
        return false;
    }

    public boolean equals(ReportQueryResult reportQueryResult) {
        if (this == reportQueryResult) {
            return true;
        }
        if (!Helper.compareOrderedVectors(this.getResults(), reportQueryResult.getResults())) {
            return false;
        }
        if (this.getPrimaryKeyValues() != null) {
            if (reportQueryResult.getPrimaryKeyValues() == null) {
                return false;
            }
            return Helper.compareOrderedVectors(this.getPrimaryKeyValues(), reportQueryResult.getPrimaryKeyValues());
        }
        return true;
    }

    public Object get(Object object) {
        if (object instanceof String) {
            return this.get((String)object);
        }
        return null;
    }

    public Object get(String string) {
        int n = this.getNames().indexOf(string);
        if (n == -1) {
            return null;
        }
        return this.getResults().elementAt(n);
    }

    public Object getByIndex(int n) {
        return this.getResults().elementAt(n);
    }

    public String getResultKey() {
        if (this.key != null) {
            return this.key.toString();
        }
        return null;
    }

    public Vector getNames() {
        return this.names;
    }

    public Vector getPrimaryKeyValues() {
        return this.primaryKeyValues;
    }

    public Vector getResults() {
        return this.results;
    }

    public boolean isEmpty() {
        return this.getNames().isEmpty();
    }

    public Enumeration keys() {
        return this.getNames().elements();
    }

    public Set keySet() {
        return new HashSet(this.getNames());
    }

    public Object put(Object object, Object object2) {
        int n = this.getNames().indexOf(object);
        if (n == -1) {
            this.getNames().addElement(object);
            this.getResults().addElement(object2);
            return null;
        }
        Object e = this.getResults().elementAt(n);
        this.getResults().setElementAt(object2, n);
        return e;
    }

    public void putAll(Map map) {
        for (Map.Entry entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public Object readObject(Class clazz, Session session) {
        if (this.getPrimaryKeyValues() == null) {
            throw QueryException.reportQueryResultWithoutPKs(this);
        }
        ReadObjectQuery readObjectQuery = new ReadObjectQuery(clazz);
        readObjectQuery.setSelectionKey(this.getPrimaryKeyValues());
        return session.executeQuery(readObjectQuery);
    }

    public Object remove(Object object) {
        int n = this.getNames().indexOf(object);
        if (n >= 0) {
            this.getNames().removeElementAt(n);
            Object e = this.getResults().elementAt(n);
            this.getResults().removeElementAt(n);
            return e;
        }
        return null;
    }

    protected void setNames(Vector vector) {
        this.names = vector;
    }

    protected void setPrimaryKeyValues(Vector vector) {
        this.primaryKeyValues = vector;
    }

    public void setResults(Vector vector) {
        this.results = vector;
    }

    public int size() {
        return this.getNames().size();
    }

    public Object[] toArray() {
        Vector vector = this.getResults();
        return vector == null ? null : vector.toArray();
    }

    public List toList() {
        return this.getResults();
    }

    public String toString() {
        StringWriter stringWriter = new StringWriter();
        stringWriter.write("ReportQueryResult(");
        for (int i = 0; i < this.getResults().size(); ++i) {
            stringWriter.write(String.valueOf(this.getResults().elementAt(i)));
            if (i >= this.getResults().size() - 1) continue;
            stringWriter.write(", ");
        }
        stringWriter.write(")");
        return stringWriter.toString();
    }

    public Collection values() {
        return this.getResults();
    }
}

