/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.schemaframework;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.queries.SQLCall;
import org.eclipse.persistence.sequencing.Sequence;
import org.eclipse.persistence.tools.schemaframework.SequenceDefinition;

public class SequenceObjectDefinition
extends SequenceDefinition {
    public SequenceObjectDefinition(Sequence sequence) {
        super(sequence);
    }

    public Writer buildCreationWriter(AbstractSession abstractSession, Writer writer) {
        try {
            int n = this.sequence.getInitialValue() + this.sequence.getPreallocationSize() - 1;
            abstractSession.getPlatform().buildSequenceObjectCreationWriter(writer, this.getFullName(), this.sequence.getPreallocationSize(), n);
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildDeletionWriter(AbstractSession abstractSession, Writer writer) {
        try {
            abstractSession.getPlatform().buildSequenceObjectDeletionWriter(writer, this.getFullName());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public Writer buildAlterIncrementWriter(AbstractSession abstractSession, Writer writer) {
        try {
            abstractSession.getPlatform().buildSequenceObjectAlterIncrementWriter(writer, this.getFullName(), this.sequence.getPreallocationSize());
        }
        catch (IOException iOException) {
            throw ValidationException.fileError(iOException);
        }
        return writer;
    }

    public boolean checkIfExist(AbstractSession abstractSession) throws DatabaseException {
        boolean bl = this.sequence.isConnected();
        if (!bl) {
            this.sequence.onConnect(abstractSession.getPlatform());
        }
        try {
            if (this.sequence.shouldUsePreallocation()) {
                this.sequence.getGeneratedVector(null, abstractSession);
            } else {
                this.sequence.getGeneratedValue(null, abstractSession);
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (DatabaseException databaseException) {
            boolean bl3 = false;
            return bl3;
        }
        catch (ValidationException validationException) {
            if (validationException.getErrorCode() == 7027) {
                boolean bl4 = true;
                return bl4;
            }
            throw validationException;
        }
        finally {
            if (!bl) {
                this.sequence.onDisconnect(abstractSession.getPlatform());
            }
        }
    }

    public boolean isAlterSupported(AbstractSession abstractSession) {
        return abstractSession.getPlatform().isAlterSequenceObjectSupported();
    }

    public void alterOnDatabase(AbstractSession abstractSession) throws EclipseLinkException {
        abstractSession.executeNonSelectingCall(new SQLCall(this.buildAlterIncrementWriter(abstractSession, new StringWriter()).toString()));
    }

    public void alterIncrement(AbstractSession abstractSession, Writer writer) throws ValidationException {
        if (writer == null) {
            this.alterOnDatabase(abstractSession);
        } else {
            this.buildAlterIncrementWriter(abstractSession, writer);
        }
    }
}

