/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo;

import commonj.sdo.ChangeSummary;
import commonj.sdo.DataGraph;
import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Sequence;
import commonj.sdo.helper.HelperContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.persistence.sdo.SDODataGraph;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.SDOSequence;
import org.eclipse.persistence.sdo.SDOSetting;
import org.eclipse.persistence.sdo.SDOType;
import org.eclipse.persistence.sdo.ValueStore;
import org.eclipse.persistence.sdo.helper.ListWrapper;
import org.eclipse.persistence.sdo.helper.SDOCopyHelper;

public class SDOChangeSummary
implements ChangeSummary {
    private SDODataObject rootDataObject;
    private boolean logging;
    private boolean loggingMapping;
    private DataGraph dataGraph;
    private List createdList = new ArrayList();
    private List deletedList;
    private Map deepCopies = new HashMap();
    private List createdXPaths;
    private List deletedXPaths;
    private List modifiedDoms;
    private Map unsetPropsMap;
    private Map originalValueStores;
    private Map originalElements;
    private Map oldContainer;
    private Map oldContainmentProperty;
    private Map oldSequences;
    private Map originalSequences;
    private Map unsetOCPropsMap;
    private Map oldSettings;
    private Map reverseDeletedMap;
    private HelperContext aHelperContext;

    public SDOChangeSummary() {
        this.deletedList = new ArrayList();
        this.oldSettings = new HashMap();
        this.oldContainer = new HashMap();
        this.oldContainmentProperty = new HashMap();
        this.unsetPropsMap = new HashMap();
        this.unsetOCPropsMap = new HashMap();
        this.originalValueStores = new HashMap();
        this.originalElements = new HashMap();
        this.reverseDeletedMap = new HashMap();
    }

    public SDOChangeSummary(SDODataObject sDODataObject, HelperContext helperContext) {
        this();
        this.aHelperContext = helperContext;
        this.rootDataObject = sDODataObject;
    }

    public SDOChangeSummary(SDODataGraph sDODataGraph, HelperContext helperContext) {
        this();
        this.aHelperContext = helperContext;
        this.dataGraph = sDODataGraph;
    }

    public boolean isLogging() {
        return this.logging;
    }

    public void setCreated(DataObject dataObject, boolean bl) {
        if (this.getRootObject() == dataObject) {
            return;
        }
        if (this.isLogging() && !bl) {
            this.createdList.remove(dataObject);
        }
        if (this.isLogging() && !this.isCreated(dataObject) && bl) {
            this.deletedList.remove(dataObject);
            this.createdList.add(dataObject);
        }
    }

    public boolean setDeleted(DataObject dataObject, boolean bl) {
        if (this.getRootObject() == dataObject) {
            return false;
        }
        if (this.isLogging() && !bl) {
            this.deletedList.remove(dataObject);
        }
        if (this.isLogging() && !this.isDeleted(dataObject) && bl) {
            if (this.isCreated(dataObject)) {
                this.createdList.remove(dataObject);
                this.oldSettings.remove(dataObject);
                this.originalValueStores.remove(dataObject);
                this.originalElements.remove(dataObject);
                return false;
            }
            this.pauseLogging();
            this.deletedList.add(dataObject);
            this.resumeLogging();
        }
        return true;
    }

    public void setOldContainer(SDODataObject sDODataObject, DataObject dataObject) {
        this.oldContainer.put(sDODataObject, dataObject);
    }

    public Map getOldContainers() {
        return this.oldContainer;
    }

    public void setOldContainmentProperty(SDODataObject sDODataObject, Property property) {
        this.oldContainmentProperty.put(sDODataObject, property);
    }

    public void setOldSequence(SDODataObject sDODataObject, Sequence sequence) {
        this.getOldSequences().put(sDODataObject, sequence);
    }

    public DataGraph getDataGraph() {
        return this.dataGraph;
    }

    public List getChangedDataObjects() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getModified());
        if (this.deletedList != null) {
            arrayList.addAll(this.deletedList);
        }
        if (this.createdList != null) {
            arrayList.addAll(this.createdList);
        }
        return arrayList;
    }

    public List getModified() {
        ArrayList arrayList = new ArrayList();
        this.getModified(this.rootDataObject, arrayList);
        return arrayList;
    }

    private void getModified(SDODataObject sDODataObject, List list) {
        if (null == sDODataObject) {
            return;
        }
        if (this.isModified(sDODataObject)) {
            list.add(sDODataObject);
        }
        List list2 = sDODataObject.getInstanceProperties();
        for (int i = 0; i < list2.size(); ++i) {
            Property property = (Property)list2.get(i);
            if (!property.isContainment()) continue;
            if (property.isMany()) {
                List list3 = sDODataObject.getList(property);
                for (int j = 0; j < list3.size(); ++j) {
                    this.getModified((SDODataObject)list3.get(j), list);
                }
                continue;
            }
            if (property.getType() == null || ((SDOType)property.getType()).isChangeSummaryType()) continue;
            this.getModified((SDODataObject)sDODataObject.getDataObject(property), list);
        }
    }

    public List getDeleted() {
        return this.deletedList;
    }

    public List getCreated() {
        return this.createdList;
    }

    public boolean isCreated(DataObject dataObject) {
        return this.createdList != null && this.createdList.contains(dataObject);
    }

    public boolean isDeleted(DataObject dataObject) {
        return this.deletedList != null && this.deletedList.contains(dataObject);
    }

    public boolean isModified(DataObject dataObject) {
        return this.originalValueStores.get(dataObject) != null && !this.isDeleted(dataObject);
    }

    public List getOldValues(DataObject dataObject) {
        if (dataObject == null || !this.isDeleted(dataObject) && dataObject.getChangeSummary() != null && dataObject.getChangeSummary() != this) {
            return new ArrayList();
        }
        if (!this.isCreated(dataObject) && this.isDirty(dataObject)) {
            Object object;
            ArrayList<ChangeSummary.Setting> arrayList = new ArrayList<ChangeSummary.Setting>();
            for (int i = 0; i < dataObject.getInstanceProperties().size(); ++i) {
                SDOProperty sDOProperty = (SDOProperty)dataObject.getInstanceProperties().get(i);
                object = this.getOldValueForChangedDataObject(dataObject, sDOProperty);
                if (object == null) continue;
                arrayList.add((ChangeSummary.Setting)object);
            }
            List list = (List)this.getUnsetOCPropertiesMap().get(dataObject);
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    object = (SDOProperty)list.get(i);
                    ChangeSummary.Setting setting = this.getOldValueForChangedDataObject(dataObject, (SDOProperty)object);
                    if (setting == null) continue;
                    arrayList.add(setting);
                }
            }
            return arrayList;
        }
        return new ArrayList();
    }

    public List getUnsetProps(DataObject dataObject) {
        this.getOldValues(dataObject);
        Object v = this.unsetPropsMap.get(dataObject);
        if (v == null) {
            return new ArrayList();
        }
        return (List)v;
    }

    public Map getUnsetOCPropertiesMap() {
        return this.unsetOCPropsMap;
    }

    public List getUnsetOCProperties(DataObject dataObject) {
        Object v = this.unsetOCPropsMap.get(dataObject);
        if (null == v) {
            return new ArrayList();
        }
        return (List)v;
    }

    public void setUnsetOCProperty(DataObject dataObject, Property property) {
        Object v = this.unsetOCPropsMap.get(dataObject);
        if (null == v) {
            ArrayList<Property> arrayList = new ArrayList<Property>();
            arrayList.add(property);
            this.unsetOCPropsMap.put(dataObject, arrayList);
        } else if (!((List)v).contains(property)) {
            ((List)v).add(property);
        }
    }

    public void removeUnsetOCProperty(DataObject dataObject, Property property) {
        Object v = this.unsetOCPropsMap.get(dataObject);
        if (v != null && ((List)v).remove(property) && ((List)v).size() <= 0) {
            this.unsetOCPropsMap.remove(dataObject);
        }
    }

    public void beginLogging() {
        if (!this.logging) {
            this.logging = true;
            this.loggingMapping = true;
            this.resetChanges();
            this.rootDataObject.resetChanges();
        }
    }

    public void resumeLogging() {
        if (!this.logging) {
            this.logging = true;
            this.loggingMapping = true;
        }
    }

    public void endLogging() {
        this.logging = false;
        this.loggingMapping = false;
    }

    public void pauseLogging() {
        this.logging = false;
        this.loggingMapping = false;
    }

    private void resetChanges() {
        this.createdList.clear();
        this.deletedList.clear();
        this.oldSettings.clear();
        this.deepCopies.clear();
        this.oldContainer.clear();
        this.oldContainmentProperty.clear();
        this.unsetPropsMap.clear();
        this.unsetOCPropsMap.clear();
        this.originalValueStores.clear();
        this.originalElements.clear();
        this.reverseDeletedMap.clear();
        this.getOldSequences().clear();
        this.getOriginalSequences().clear();
    }

    public DataObject getRootObject() {
        return this.rootDataObject;
    }

    public ChangeSummary.Setting getOldValue(DataObject dataObject, Property property) {
        if (dataObject == null || !this.isDeleted(dataObject) && dataObject.getChangeSummary() != null && dataObject.getChangeSummary() != this) {
            return null;
        }
        if (!this.isCreated(dataObject) && this.isDirty(dataObject)) {
            return this.getOldValueForChangedDataObject(dataObject, (SDOProperty)property);
        }
        return null;
    }

    private ChangeSummary.Setting getOldValueForChangedDataObject(DataObject dataObject, SDOProperty sDOProperty) {
        if (null == sDOProperty || sDOProperty.getType().isChangeSummaryType()) {
            return null;
        }
        ChangeSummary.Setting setting = this.getPropertyInOldSettings(dataObject, sDOProperty);
        if (setting == null) {
            SDODataObject sDODataObject = (SDODataObject)dataObject;
            boolean bl = this.isDeleted(dataObject);
            ArrayList arrayList = this.getPropertyInternal(sDODataObject, sDOProperty);
            Object object = sDODataObject.getPropertyInternal(sDOProperty);
            boolean bl2 = sDODataObject.isSetInternal(sDOProperty);
            boolean bl3 = this.wasSet(sDODataObject, sDOProperty);
            if (sDOProperty.isMany()) {
                object = ((ListWrapper)object).getCurrentElements();
                if (this.isDirty((ListWrapper)((Object)arrayList))) {
                    List list = (List)this.getOriginalElements().get(arrayList);
                    arrayList = new ArrayList(list);
                    if (!sDOProperty.getType().isDataType()) {
                        for (int i = 0; i < ((List)arrayList).size(); ++i) {
                            Object e = ((List)arrayList).get(i);
                            DataObject dataObject2 = this.getOrCreateDeepCopy((DataObject)e);
                            ((List)arrayList).set(i, dataObject2);
                        }
                    }
                } else {
                    arrayList = object;
                }
            }
            if (bl || bl3 != bl2 || arrayList != object) {
                if (arrayList != null && !sDOProperty.getType().isDataType() && arrayList instanceof DataObject) {
                    arrayList = this.getOrCreateDeepCopy((DataObject)arrayList);
                }
                setting = this.buildAndAddOldSetting((SDODataObject)dataObject, sDOProperty, arrayList, bl3);
            }
        }
        return setting;
    }

    private ChangeSummary.Setting buildAndAddOldSetting(SDODataObject sDODataObject, Property property, Object object, boolean bl) {
        List<String> list;
        SDOSetting sDOSetting = new SDOSetting(property, object);
        sDOSetting.setIsSet(bl);
        if (this.oldSettings.get(sDODataObject) == null) {
            list = new ArrayList<SDOSetting>();
            list.add((String)((Object)sDOSetting));
            this.oldSettings.put(sDODataObject, list);
        } else {
            list = (List)this.oldSettings.get(sDODataObject);
            list.add((String)((Object)sDOSetting));
        }
        if (!sDOSetting.isSet()) {
            list = (List)this.unsetPropsMap.get(sDODataObject);
            if (list == null) {
                ArrayList<String> arrayList = new ArrayList<String>();
                arrayList.add(sDOSetting.getProperty().getName());
                this.unsetPropsMap.put(sDODataObject, arrayList);
            } else if (!list.contains(sDOSetting.getProperty().getName())) {
                list.add(sDOSetting.getProperty().getName());
            }
        }
        return sDOSetting;
    }

    public DataObject getOldContainer(DataObject dataObject) {
        return (DataObject)this.oldContainer.get(dataObject);
    }

    public Property getOldContainmentProperty(DataObject dataObject) {
        return (Property)this.oldContainmentProperty.get(dataObject);
    }

    public Sequence getOldSequence(DataObject dataObject) {
        if (dataObject == null || !this.isDeleted(dataObject) && dataObject.getChangeSummary() != null && dataObject.getChangeSummary() != this) {
            return null;
        }
        if (!this.isCreated(dataObject) && dataObject.getType().isSequenced()) {
            if (this.getOldSequences().containsKey(dataObject)) {
                return (Sequence)this.getOldSequences().get(dataObject);
            }
            SDOSequence sDOSequence = (SDOSequence)this.getOriginalSequences().get(dataObject);
            if (sDOSequence == null) {
                sDOSequence = (SDOSequence)dataObject.getSequence();
            }
            SDOSequence sDOSequence2 = new SDOSequence((SDODataObject)dataObject);
            for (int i = 0; i < sDOSequence.size(); ++i) {
                Object object = sDOSequence.getValue(i);
                if (object == null) continue;
                Property property = sDOSequence.getProperty(i);
                if (property == null) {
                    sDOSequence2.addText(object.toString());
                    continue;
                }
                if (property.getType().isDataType()) {
                    sDOSequence2.addSettingWithoutModifyingDataObject(property, object, false);
                    continue;
                }
                sDOSequence2.addSettingWithoutModifyingDataObject(property, this.getOrCreateDeepCopy((DataObject)object), false);
            }
            this.getOldSequences().put(dataObject, sDOSequence2);
            return sDOSequence2;
        }
        return null;
    }

    public void undoChanges() {
        Property property = this.getOldContainmentProperty(this.rootDataObject);
        String string = null;
        if (property != null) {
            string = property.getName();
        }
        this.rootDataObject.undoChanges(true, this, (SDODataObject)this.getOldContainer(this.rootDataObject), string);
        this.resetChanges();
        this.rootDataObject.resetChanges();
    }

    public void setRootDataObject(DataObject dataObject) {
        this.rootDataObject = (SDODataObject)dataObject;
    }

    public void setLogging(boolean bl) {
        if (bl) {
            this.beginLogging();
        } else {
            this.endLogging();
        }
        this.loggingMapping = bl;
    }

    private ChangeSummary.Setting getPropertyInOldSettings(DataObject dataObject, Property property) {
        Iterator iterator = null;
        List list = (List)this.oldSettings.get(dataObject);
        if (list != null) {
            for (ChangeSummary.Setting setting : list) {
                if (!setting.getProperty().equals(property)) continue;
                return setting;
            }
        }
        return null;
    }

    public void setHelperContext(HelperContext helperContext) {
        this.aHelperContext = helperContext;
    }

    public void setCreatedXPaths(List list) {
        this.createdXPaths = list;
    }

    public List getCreatedXPaths() {
        return this.createdXPaths;
    }

    public boolean isLoggingMapping() {
        return this.loggingMapping;
    }

    public void setModifiedDoms(List list) {
        this.modifiedDoms = list;
    }

    public List getModifiedDoms() {
        return this.modifiedDoms;
    }

    public void setDeletedXPaths(List list) {
        this.deletedXPaths = list;
    }

    public Map getOldContainmentProperty() {
        return this.oldContainmentProperty;
    }

    public Map getOldContainer() {
        return this.oldContainer;
    }

    public boolean wasSet(DataObject dataObject, Property property) {
        ValueStore valueStore = (ValueStore)this.originalValueStores.get(dataObject);
        if (null == valueStore) {
            valueStore = ((SDODataObject)dataObject)._getCurrentValueStore();
        }
        if (property.isOpenContent()) {
            return valueStore.isSetOpenContentProperty(property);
        }
        return valueStore.isSetDeclaredProperty(((SDOProperty)property).getIndexInType());
    }

    public Object getPropertyInternal(DataObject dataObject, Property property) {
        ValueStore valueStore = (ValueStore)this.originalValueStores.get(dataObject);
        if (null == valueStore) {
            valueStore = ((SDODataObject)dataObject)._getCurrentValueStore();
        }
        if (property.isOpenContent()) {
            return valueStore.getOpenContentProperty(property);
        }
        return valueStore.getDeclaredProperty(((SDOProperty)property).getIndexInType());
    }

    public void setPropertyInternal(DataObject dataObject, Property property, Object object) {
        ValueStore valueStore = (ValueStore)this.originalValueStores.get(dataObject);
        if (property.isOpenContent()) {
            valueStore.setOpenContentProperty(property, object);
        } else {
            valueStore.setDeclaredProperty(((SDOProperty)property).getIndexInType(), object);
        }
    }

    public Map getOriginalValueStores() {
        return this.originalValueStores;
    }

    public boolean isDirty(DataObject dataObject) {
        ValueStore valueStore = (ValueStore)this.originalValueStores.get(dataObject);
        return valueStore != null;
    }

    public boolean isDirty(ListWrapper listWrapper) {
        Object v = this.getOriginalElements().get(listWrapper);
        return v != null;
    }

    public boolean isDirty(SDOSequence sDOSequence) {
        Object v = this.getOriginalSequences().get(sDOSequence.getDataObject());
        return v != null;
    }

    public void unsetPropertyInternal(DataObject dataObject, Property property) {
        ValueStore valueStore = (ValueStore)this.originalValueStores.get(dataObject);
        if (property.isMany()) {
            ListWrapper listWrapper = (ListWrapper)dataObject.getList(property);
            this.originalElements.put(listWrapper, new ArrayList());
            if (property.isOpenContent()) {
                valueStore.unsetOpenContentProperty(property);
            } else {
                valueStore.unsetDeclaredProperty(((SDOProperty)property).getIndexInType());
            }
        } else if (property.isOpenContent()) {
            valueStore.unsetOpenContentProperty(property);
        } else {
            valueStore.unsetDeclaredProperty(((SDOProperty)property).getIndexInType());
        }
    }

    public Map getOriginalElements() {
        return this.originalElements;
    }

    private DataObject getOrCreateDeepCopy(DataObject dataObject) {
        DataObject dataObject2 = (DataObject)this.getDeepCopies().get(dataObject);
        if (null == dataObject2) {
            DataObject dataObject3 = ((SDOCopyHelper)this.aHelperContext.getCopyHelper()).copy(dataObject, this);
            this.getDeepCopies().put(dataObject, dataObject3);
            this.getReverseDeletedMap().put(dataObject3, dataObject);
            return dataObject3;
        }
        return dataObject2;
    }

    public Map getDeepCopies() {
        return this.deepCopies;
    }

    public Map getReverseDeletedMap() {
        return this.reverseDeletedMap;
    }

    public Map getOriginalSequences() {
        if (null == this.originalSequences) {
            this.originalSequences = new HashMap();
        }
        return this.originalSequences;
    }

    public Map getOldSequences() {
        if (null == this.oldSequences) {
            this.oldSequences = new HashMap();
        }
        return this.oldSequences;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ChangeSummary@");
        stringBuffer.append(this.getClass().hashCode());
        stringBuffer.append(" [logging: ");
        stringBuffer.append(this.logging);
        stringBuffer.append(", root: ");
        stringBuffer.append(this.rootDataObject);
        List list = this.getChangedDataObjects();
        if (list != null) {
            stringBuffer.append(", ");
            stringBuffer.append(list.size());
            stringBuffer.append(" changes: <");
            boolean bl = true;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(iterator.next());
            }
        }
        stringBuffer.append(">]");
        return stringBuffer.toString();
    }
}

