/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper;

import commonj.sdo.Property;
import commonj.sdo.helper.HelperContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.mappings.AttributeAccessor;
import org.eclipse.persistence.oxm.XMLMarshaller;
import org.eclipse.persistence.oxm.XMLRoot;
import org.eclipse.persistence.oxm.XMLUnmarshalListener;
import org.eclipse.persistence.oxm.XMLUnmarshaller;
import org.eclipse.persistence.platform.xml.XMLPlatform;
import org.eclipse.persistence.platform.xml.XMLPlatformFactory;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.helper.SDOCSUnmarshalListener;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SDOFragmentMappingAttributeAccessor
extends AttributeAccessor {
    protected SDOProperty property;
    protected HelperContext helperContext;

    public SDOFragmentMappingAttributeAccessor(SDOProperty sDOProperty, HelperContext helperContext) {
        this.property = sDOProperty;
        this.helperContext = helperContext;
    }

    public Object getAttributeValueFromObject(Object object) throws DescriptorException {
        ArrayList<Object> arrayList = ((SDODataObject)object).get(this.property);
        if (arrayList != null) {
            if (this.property.isMany()) {
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                Iterator iterator = ((Collection)arrayList).iterator();
                while (iterator.hasNext()) {
                    arrayList2.add(this.buildFragment(this.property, (SDODataObject)object, (SDODataObject)iterator.next()));
                }
                arrayList = arrayList2;
            } else {
                arrayList = this.buildFragment(this.property, (SDODataObject)object, (SDODataObject)((Object)arrayList));
            }
        }
        return arrayList;
    }

    public void initializeAttributes(Class clazz) throws DescriptorException {
        if (this.getAttributeName() == null) {
            throw DescriptorException.attributeNameNotSpecified();
        }
    }

    public boolean isMethodAttributeAccessor() {
        return true;
    }

    public void setAttributeValueInObject(Object object, Object object2) throws DescriptorException {
        XMLUnmarshaller xMLUnmarshaller = ((SDOXMLHelper)this.helperContext.getXMLHelper()).getXmlContext().createUnmarshaller();
        xMLUnmarshaller.setUnmarshalListener((XMLUnmarshalListener)new SDOCSUnmarshalListener(this.helperContext));
        if (object2 instanceof Collection) {
            ArrayList<Object> arrayList = new ArrayList<Object>();
            for (Node node : (Collection)object2) {
                Object object3 = xMLUnmarshaller.unmarshal(node);
                if (object3 instanceof XMLRoot) {
                    object3 = ((XMLRoot)object3).getObject();
                }
                arrayList.add(object3);
            }
            ((SDODataObject)object).set(this.property, arrayList);
        } else {
            Node node;
            Object object4 = null;
            if (object2 != null && (object4 = xMLUnmarshaller.unmarshal(node = (Node)object2)) instanceof XMLRoot) {
                object4 = ((XMLRoot)object4).getObject();
            }
            ((SDODataObject)object).set(this.property, object4);
        }
    }

    public void setProperty(SDOProperty sDOProperty) {
        this.property = sDOProperty;
    }

    public SDOProperty getPropertyName() {
        return this.property;
    }

    private Object buildFragment(Property property, SDODataObject sDODataObject, SDODataObject sDODataObject2) {
        XMLPlatform xMLPlatform = XMLPlatformFactory.getInstance().getXMLPlatform();
        XMLMarshaller xMLMarshaller = ((SDOXMLHelper)this.helperContext.getXMLHelper()).getXmlMarshaller();
        Document document = xMLPlatform.createDocument();
        XMLRoot xMLRoot = new XMLRoot();
        xMLRoot.setObject((Object)sDODataObject2);
        xMLRoot.setLocalName(property.getName());
        if (((SDOProperty)property).isNamespaceQualified()) {
            xMLRoot.setNamespaceURI(sDODataObject.getType().getURI());
        }
        xMLMarshaller.marshal((Object)xMLRoot, (Node)document);
        return document.getDocumentElement();
    }
}

