/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.extension;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.persistence.exceptions.ConversionException;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.SDOProperty;
import org.eclipse.persistence.sdo.helper.SDOXMLHelper;
import org.eclipse.persistence.sdo.helper.XPathEngine;
import org.eclipse.persistence.sdo.helper.extension.OPStack;
import org.eclipse.persistence.sdo.helper.extension.Token;
import org.eclipse.persistence.sdo.helper.extension.XPathExpression;

public class XPathHelper {
    private static XPathHelper instance;
    static final int GTE = 4;
    static final int LTE = 5;
    static final int GT = 6;
    static final int LT = 7;
    static final int EQ = 8;
    static final int NEQ = 9;
    static final int AND = 10;
    static final int OR = 11;
    private static final String GTE_STR = ">=";
    private static final String LTE_STR = "<=";
    private static final String GT_STR = ">";
    private static final String LT_STR = "<";
    private static final String EQ_STR = "=";
    private static final String NEQ_STR = "!=";
    private static final String AND_STR = "and";
    private static final String OR_STR = "or";

    public static XPathHelper getInstance() {
        if (instance == null) {
            instance = new XPathHelper();
        }
        return instance;
    }

    public XPathExpression prepareExpression(String string) {
        return new XPathExpression(string);
    }

    public List evaluate(String string, DataObject dataObject) {
        ArrayList arrayList = new ArrayList();
        if (this.shouldCallXPathEngine(string)) {
            return this.addResultsToList(XPathEngine.getInstance().get(string, dataObject), arrayList);
        }
        return this.evaluate(string, dataObject, arrayList);
    }

    private List evaluate(String string, DataObject dataObject, List list) {
        int n = string.indexOf(47);
        if (n > -1) {
            if (n == string.length() - 1) {
                return this.addResultsToList(this.processFragment(string.substring(0, n), dataObject), list);
            }
            Object object = this.processFragment(string.substring(0, n), dataObject);
            if (object instanceof DataObject) {
                return this.evaluate(string.substring(n + 1, string.length()), (DataObject)object, list);
            }
            if (object instanceof List) {
                Iterator iterator = ((List)object).iterator();
                while (iterator.hasNext()) {
                    this.evaluate(string.substring(n + 1, string.length()), (DataObject)iterator.next(), list);
                }
                return list;
            }
            return null;
        }
        return this.addResultsToList(this.processFragment(string, dataObject), list);
    }

    private Object processFragment(String string, DataObject dataObject) {
        if (string.equals(".")) {
            return dataObject;
        }
        if (string.equals("..")) {
            return dataObject.getContainer();
        }
        int n = (string = this.getPathWithAtRemoved(string)).indexOf(91);
        if (n > -1) {
            return this.processBracket(string, dataObject, n);
        }
        Property property = dataObject.getInstanceProperty(string);
        try {
            return dataObject.get(property);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private Object processBracket(String string, DataObject dataObject, int n) {
        int n2 = string.indexOf(93);
        if (n2 == -1 || n2 < n) {
            return null;
        }
        String string2 = string.substring(n + 1, n2);
        if (string2.matches("[1-9][0-9]*")) {
            return this.processIndex(string, dataObject, n, Integer.parseInt(string2) - 1);
        }
        if (string2.matches("[1-9].[0-9]*")) {
            Float f = Float.valueOf(string2);
            return this.processIndex(string, dataObject, n, f.intValue() - 1);
        }
        String string3 = string.substring(0, n);
        if (string2.indexOf(AND_STR) != -1 || string2.indexOf(OR_STR) != -1) {
            return this.processComplexQuery(dataObject, string3, string2);
        }
        return this.processSimpleQuery(dataObject, string3, string2);
    }

    private Object processIndex(String string, DataObject dataObject, int n, int n2) {
        try {
            Property property = dataObject.getInstanceProperty(string.substring(0, n));
            List list = dataObject.getList(property);
            if (n2 < list.size()) {
                return list.get(n2);
            }
            throw new IndexOutOfBoundsException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    private Object processComplexQuery(DataObject dataObject, String string, String string2) {
        Object object;
        Object object2;
        Object object3;
        OPStack oPStack = new OPStack();
        List list = oPStack.processExpression(string2);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < list.size(); ++i) {
            object3 = (Token)list.get(i);
            if (((Token)object3).getName().equals(AND_STR) || ((Token)object3).getName().equals(OR_STR)) {
                arrayList.add(((Token)object3).getName());
                continue;
            }
            object2 = ((Token)list.get(i)).getName();
            object = ((Token)list.get(++i)).getName();
            int n = this.getOperandFromString(((Token)list.get(++i)).getName());
            arrayList.add(new QueryPart(((String)object2).trim(), (String)object, n));
        }
        Property property = dataObject.getInstanceProperty(string);
        if (property.isMany()) {
            object3 = dataObject.getList(property);
        } else {
            object3 = new ArrayList<DataObject>();
            object2 = dataObject.getDataObject(property);
            if (object2 != null) {
                object3.add(object2);
            }
        }
        object2 = new ArrayList();
        object = object3.iterator();
        while (object.hasNext()) {
            Object object4;
            int n;
            SDODataObject sDODataObject = (SDODataObject)object.next();
            ArrayList arrayList2 = new ArrayList();
            for (n = 0; n < arrayList.size(); ++n) {
                if (arrayList.get(n).equals(AND_STR) || arrayList.get(n).equals(OR_STR)) {
                    arrayList2.add(arrayList.get(n));
                    continue;
                }
                object4 = (QueryPart)arrayList.get(n);
                arrayList2.add(((QueryPart)object4).evaluate(sDODataObject));
            }
            for (n = 0; n < arrayList2.size(); ++n) {
                if (!arrayList2.get(n).equals(AND_STR) && !arrayList2.get(n).equals(OR_STR) || n < 2) continue;
                object4 = (Boolean)arrayList2.get(n - 1);
                Boolean bl = (Boolean)arrayList2.get(n - 2);
                int n2 = this.getOperandFromString((String)arrayList2.get(n));
                arrayList2.remove(n);
                arrayList2.remove(n - 1);
                arrayList2.set(n - 2, this.evaluate((Boolean)object4, bl, n2));
                n = 0;
            }
            if (arrayList2.size() != 1 || !((Boolean)arrayList2.get(0)).booleanValue()) continue;
            object2.add(sDODataObject);
        }
        return object2;
    }

    private boolean evaluate(boolean bl, boolean bl2, int n) {
        switch (n) {
            case 10: {
                return bl && bl2;
            }
            case 11: {
                return bl || bl2;
            }
        }
        return false;
    }

    private Object processSimpleQuery(DataObject dataObject, String string, String string2) {
        Object object;
        ArrayList<Object> arrayList;
        Property property = dataObject.getInstanceProperty(string);
        if (property.isMany()) {
            arrayList = dataObject.getList(property);
        } else {
            arrayList = new ArrayList<Object>();
            object = dataObject.getDataObject(property);
            if (object != null) {
                arrayList.add(object);
            }
        }
        object = new ArrayList();
        QueryPart queryPart = new QueryPart(string2);
        for (SDODataObject sDODataObject : arrayList) {
            if (!queryPart.evaluate(sDODataObject)) continue;
            object.add(sDODataObject);
        }
        return object;
    }

    protected List addResultsToList(Object object, List list) {
        if (object != null) {
            if (object instanceof List) {
                for (Object e : (List)object) {
                    if (e == null) continue;
                    list.add(e);
                }
            } else {
                list.add(object);
            }
        }
        return list;
    }

    protected String getPathWithAtRemoved(String string) {
        int n = string.indexOf(64);
        if (n > -1) {
            if (n > 0) {
                StringBuffer stringBuffer = new StringBuffer(string.substring(0, n));
                stringBuffer.append(string.substring(n + 1, string.length()));
                return stringBuffer.toString();
            }
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    protected String getPathWithPrefixRemoved(String string) {
        int n = string.indexOf(58);
        if (n > -1) {
            return string.substring(n + 1, string.length());
        }
        return string;
    }

    private int getOperandFromString(String string) {
        if (string.equals(EQ_STR)) {
            return 8;
        }
        if (string.equals(NEQ_STR)) {
            return 9;
        }
        if (string.equals(GT_STR)) {
            return 6;
        }
        if (string.equals(LT_STR)) {
            return 7;
        }
        if (string.equals(GTE_STR)) {
            return 4;
        }
        if (string.equals(LTE_STR)) {
            return 5;
        }
        if (string.equals(AND_STR)) {
            return 10;
        }
        if (string.equals(OR_STR)) {
            return 11;
        }
        return -1;
    }

    private String getStringFromOperand(int n) {
        switch (n) {
            case 8: {
                return EQ_STR;
            }
            case 9: {
                return NEQ_STR;
            }
            case 4: {
                return GTE_STR;
            }
            case 5: {
                return LTE_STR;
            }
            case 6: {
                return GT_STR;
            }
            case 7: {
                return LT_STR;
            }
            case 10: {
                return AND_STR;
            }
            case 11: {
                return OR_STR;
            }
        }
        return "";
    }

    protected boolean shouldCallXPathEngine(String string) {
        return false;
    }

    public class QueryPart {
        String propertyName;
        String queryValue;
        int relOperand;
        int logOperand;

        public QueryPart(String string) {
            this.processQueryContents(string);
        }

        public QueryPart(String string, String string2, int n) {
            this.relOperand = n;
            this.propertyName = string;
            this.queryValue = this.formatValue(string2);
        }

        private void processQueryContents(String string) {
            int n = -1;
            int n2 = 1;
            this.relOperand = 1;
            n = string.indexOf(XPathHelper.GTE_STR);
            if (n != -1) {
                this.relOperand = 4;
                n2 = 2;
            } else {
                n = string.indexOf(XPathHelper.LTE_STR);
                if (n != -1) {
                    this.relOperand = 5;
                    n2 = 2;
                } else {
                    n = string.indexOf(XPathHelper.NEQ_STR);
                    if (n != -1) {
                        this.relOperand = 9;
                        n2 = 2;
                    } else {
                        n = string.indexOf(XPathHelper.GT_STR);
                        if (n != -1) {
                            this.relOperand = 6;
                        } else {
                            n = string.indexOf(XPathHelper.LT_STR);
                            if (n != -1) {
                                this.relOperand = 7;
                            } else {
                                n = string.indexOf(XPathHelper.EQ_STR);
                                if (n != -1) {
                                    this.relOperand = 8;
                                }
                            }
                        }
                    }
                }
            }
            this.propertyName = string.substring(0, n).trim();
            this.queryValue = this.formatValue(string.substring(n + n2));
        }

        private String formatValue(String string) {
            int n = string.indexOf(39);
            int n2 = string.lastIndexOf(39);
            if (n == -1 && n2 == -1) {
                n = string.indexOf("\"");
                n2 = string.lastIndexOf("\"");
            }
            string = n != -1 && n2 != -1 && n < n2 ? string.substring(n + 1, n2) : string.trim();
            return string;
        }

        public boolean evaluate(SDODataObject sDODataObject) {
            Object object;
            Object object2 = this.queryValue;
            Object var3_3 = null;
            SDOProperty sDOProperty = sDODataObject.getInstanceProperty(this.propertyName);
            try {
                object = (SDOXMLHelper)sDODataObject.getType().getHelperContext().getXMLHelper();
                object2 = object.getXmlConversionManager().convertObject((Object)this.queryValue, sDOProperty.getType().getInstanceClass());
            }
            catch (ConversionException conversionException) {
                // empty catch block
            }
            if (!sDOProperty.isMany()) {
                object = new ArrayList();
                object.add(sDODataObject.get(sDOProperty));
            } else {
                object = sDODataObject.getList(sDOProperty);
            }
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                int n;
                var3_3 = iterator.next();
                if (var3_3 == null) continue;
                try {
                    n = ((Comparable)var3_3).compareTo(object2);
                }
                catch (Exception exception) {
                    continue;
                }
                switch (this.relOperand) {
                    case 8: {
                        if (n != 0) break;
                        return true;
                    }
                    case 9: {
                        if (n == 0) break;
                        return true;
                    }
                    case 4: {
                        if (n < 0) break;
                        return true;
                    }
                    case 5: {
                        if (n > 0) break;
                        return true;
                    }
                    case 6: {
                        if (n <= 0) break;
                        return true;
                    }
                    case 7: {
                        if (n >= 0) break;
                        return true;
                    }
                }
            }
            return false;
        }

        public String toString() {
            return "QueryPart {" + this.propertyName + " " + XPathHelper.this.getStringFromOperand(this.relOperand) + " " + this.queryValue + "}";
        }
    }
}

