/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.sdo.helper.jaxb;

import commonj.sdo.DataObject;
import commonj.sdo.Property;
import commonj.sdo.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.SDOException;
import org.eclipse.persistence.internal.helper.IdentityWeakHashMap;
import org.eclipse.persistence.jaxb.JAXBContext;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.schema.XMLSchemaReference;
import org.eclipse.persistence.sdo.SDODataObject;
import org.eclipse.persistence.sdo.helper.SDOCopyHelper;
import org.eclipse.persistence.sdo.helper.SDODataHelper;
import org.eclipse.persistence.sdo.helper.SDOEqualityHelper;
import org.eclipse.persistence.sdo.helper.SDOHelperContext;
import org.eclipse.persistence.sdo.helper.delegates.SDOTypeHelperDelegate;
import org.eclipse.persistence.sdo.helper.delegates.SDOXSDHelperDelegate;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBDataFactory;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBValueStore;
import org.eclipse.persistence.sdo.helper.jaxb.JAXBXMLHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JAXBHelperContext
extends SDOHelperContext {
    private JAXBContext jaxbContext;
    private Map<Object, SDODataObject> wrapperDataObjects = new IdentityWeakHashMap();

    public JAXBHelperContext(javax.xml.bind.JAXBContext jAXBContext) {
        this(jAXBContext, Thread.currentThread().getContextClassLoader());
    }

    public JAXBHelperContext(javax.xml.bind.JAXBContext jAXBContext, ClassLoader classLoader) {
        super(classLoader);
        this.jaxbContext = (JAXBContext)jAXBContext;
    }

    @Override
    protected void initialize(ClassLoader classLoader) {
        this.copyHelper = new SDOCopyHelper(this);
        this.dataFactory = new JAXBDataFactory(this);
        this.dataHelper = new SDODataHelper(this);
        this.equalityHelper = new SDOEqualityHelper(this);
        this.xmlHelper = new JAXBXMLHelper(this, classLoader);
        this.typeHelper = new SDOTypeHelperDelegate(this);
        this.xsdHelper = new SDOXSDHelperDelegate(this);
    }

    public javax.xml.bind.JAXBContext getJAXBContext() {
        return this.jaxbContext;
    }

    public Type getType(Class clazz) {
        Type type;
        if (null == clazz) {
            return null;
        }
        XMLDescriptor xMLDescriptor = null;
        try {
            xMLDescriptor = (XMLDescriptor)this.jaxbContext.getXMLContext().getSession(clazz).getDescriptor(clazz);
        }
        catch (Exception exception) {
            return null;
        }
        XMLSchemaReference xMLSchemaReference = xMLDescriptor.getSchemaReference();
        if (null == xMLSchemaReference) {
            throw SDOException.sdoJaxbNoSchemaReference((Class)clazz);
        }
        QName qName = xMLSchemaReference.getSchemaContextAsQName(xMLDescriptor.getNamespaceResolver());
        if (null == qName) {
            throw SDOException.sdoJaxbNoSchemaContext((Class)clazz);
        }
        if (xMLDescriptor.getSchemaReference().getType() == 1) {
            type = this.getTypeHelper().getType(qName.getNamespaceURI(), qName.getLocalPart());
        } else {
            Property property = this.getXSDHelper().getGlobalProperty(qName.getNamespaceURI(), qName.getLocalPart(), true);
            type = property.getType();
        }
        if (null == type) {
            throw SDOException.sdoJaxbNoTypeForClassBySchemaContext((Class)clazz, (QName)qName);
        }
        return type;
    }

    public DataObject wrap(Object object) {
        if (null == object) {
            return null;
        }
        SDODataObject sDODataObject = this.wrapperDataObjects.get(object);
        if (null != sDODataObject) {
            return sDODataObject;
        }
        Type type = this.getType(object.getClass());
        if (null == type) {
            throw SDOException.sdoJaxbNoTypeForClass(object.getClass());
        }
        sDODataObject = (SDODataObject)this.getDataFactory().create(type);
        JAXBValueStore jAXBValueStore = new JAXBValueStore(this, object);
        sDODataObject._setCurrentValueStore(jAXBValueStore);
        jAXBValueStore.initialize(sDODataObject);
        this.wrapperDataObjects.put(object, sDODataObject);
        return sDODataObject;
    }

    DataObject wrap(Object object, Property property, DataObject dataObject) {
        SDODataObject sDODataObject = (SDODataObject)this.wrap(object);
        if (null == dataObject) {
            sDODataObject._setContainmentPropertyName(null);
        } else {
            sDODataObject._setContainmentPropertyName(property.getName());
        }
        sDODataObject._setContainer(dataObject);
        return sDODataObject;
    }

    public List<DataObject> wrap(Collection<Object> collection) {
        return this.wrap(collection, null, null);
    }

    List<DataObject> wrap(Collection<Object> collection, Property property, DataObject dataObject) {
        if (null == collection) {
            return new ArrayList<DataObject>(0);
        }
        ArrayList<DataObject> arrayList = new ArrayList<DataObject>(collection.size());
        for (Object object : collection) {
            arrayList.add(this.wrap(object, property, dataObject));
        }
        return arrayList;
    }

    public Object unwrap(DataObject dataObject) {
        try {
            if (null == dataObject) {
                return null;
            }
            SDODataObject sDODataObject = (SDODataObject)dataObject;
            JAXBValueStore jAXBValueStore = (JAXBValueStore)sDODataObject._getCurrentValueStore();
            return jAXBValueStore.getEntity();
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    public List<Object> unwrap(Collection<DataObject> collection) {
        if (null == collection) {
            return new ArrayList<Object>(0);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(collection.size());
        for (DataObject dataObject : collection) {
            arrayList.add(this.unwrap(dataObject));
        }
        return arrayList;
    }

    void putWrapperDataObject(Object object, SDODataObject sDODataObject) {
        this.wrapperDataObjects.put(object, sDODataObject);
    }
}

