/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl;

import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.persistence.platform.database.oracle.publisher.PublisherException;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Field;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Method;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlName;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlReflector;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlType;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.SqlTypeWithMethods;
import org.eclipse.persistence.platform.database.oracle.publisher.sqlrefl.Type;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.AllTypes;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.FieldInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.MethodInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ParamInfo;
import org.eclipse.persistence.platform.database.oracle.publisher.viewcache.ResultInfo;

public class SqlObjectType
extends SqlTypeWithMethods {
    SqlType m_supertype = null;
    boolean m_supertypeKnown = false;
    boolean m_isFinal = true;
    int m_modifiers = 0;

    public SqlObjectType(SqlName sqlName, boolean bl, SqlType sqlType, SqlReflector sqlReflector) throws SQLException {
        this(sqlName, 2002, bl, sqlType, sqlReflector);
    }

    public SqlObjectType(SqlName sqlName, int n, boolean bl, SqlType sqlType, SqlReflector sqlReflector) throws SQLException {
        super(sqlName, n, bl, sqlType, null, sqlReflector);
    }

    public SqlObjectType(SqlName sqlName, Field[] fieldArray, SqlReflector sqlReflector) throws SQLException {
        super(sqlName, 2002, true, null, null, sqlReflector);
        this.m_modifiers = 1;
        this.m_fields = fieldArray;
        this.m_fieldsPublishedOnly = fieldArray;
        this.m_methods = new Method[0];
    }

    public void setFields(Field[] fieldArray) {
        this.m_fields = fieldArray;
        this.m_fieldsPublishedOnly = fieldArray;
    }

    @Override
    public Type getSupertype() throws SQLException, PublisherException {
        if (this.m_supertypeKnown) {
            return this.m_supertype;
        }
        this.m_supertypeKnown = true;
        SqlName sqlName = (SqlName)this.getNameObject();
        String string = sqlName.getSchemaName();
        String string2 = sqlName.getTypeName();
        Iterator iterator = this.m_viewCache.getRows("ALL_TYPES", new String[0], new String[]{"OWNER", "TYPE_NAME"}, new Object[]{string, string2}, new String[0]);
        if (iterator.hasNext()) {
            AllTypes allTypes = (AllTypes)iterator.next();
            String string3 = allTypes.supertypeName;
            String string4 = allTypes.supertypeOwner;
            if (string3 != null) {
                this.m_supertype = this.m_reflector.addSqlDBType(string4, string3, null, "", false, this);
            }
        }
        return this.m_supertype;
    }

    @Override
    public int getModifiers() throws SQLException {
        if (this.m_modifiers == 0) {
            this.m_modifiers = 1;
            SqlName sqlName = (SqlName)this.getNameObject();
            String string = sqlName.getSchemaName();
            String string2 = sqlName.getTypeName();
            Iterator iterator = this.m_viewCache.getRows("ALL_TYPES", new String[0], new String[]{"OWNER", "TYPE_NAME"}, new Object[]{string, string2}, new String[0]);
            if (iterator.hasNext()) {
                String string3;
                String string4;
                AllTypes allTypes = (AllTypes)iterator.next();
                String string5 = allTypes.finalProp;
                if (string5.equals("YES")) {
                    this.m_modifiers += 16;
                }
                if ((string4 = allTypes.instantiable).equals("NO")) {
                    this.m_modifiers += 1024;
                }
                if ((string3 = allTypes.incomplete).equals("YES")) {
                    this.m_modifiers += 0x20000000;
                }
            }
        }
        return this.m_modifiers;
    }

    @Override
    public Field[] getFields(boolean bl) throws SecurityException, SQLException, PublisherException {
        return this.getFields(0, bl);
    }

    protected Field[] getFields(int n, boolean bl) throws SecurityException, SQLException, PublisherException {
        Field[] fieldArray = this.getDeclaredFields(bl);
        SqlObjectType sqlObjectType = (SqlObjectType)this.getSupertype();
        if (sqlObjectType == null && n == 0) {
            return fieldArray;
        }
        int n2 = fieldArray.length;
        int n3 = n2 + n;
        Field[] fieldArray2 = sqlObjectType == null ? new Field[n3] : sqlObjectType.getFields(n3, bl);
        int n4 = fieldArray2.length - n3;
        for (int i = 0; i < n2; ++i) {
            fieldArray2[n4++] = fieldArray[i];
        }
        return fieldArray2;
    }

    @Override
    protected FieldInfo[] getFieldInfo() throws SQLException {
        SqlName sqlName = this.getSqlName();
        String string = sqlName.getSchemaName();
        String string2 = sqlName.getTypeName();
        Iterator iterator = this.m_viewCache.getRows("ALL_TYPE_ATTRS", new String[0], new String[]{"OWNER", "TYPE_NAME", "INHERITED"}, new Object[]{string, string2, "NO"}, new String[]{"ATTR_NO"});
        return FieldInfo.getFieldInfo(iterator);
    }

    @Override
    protected MethodInfo[] getMethodInfo(String string, String string2) throws SQLException {
        Iterator iterator = null;
        iterator = this.m_reflector.geqOracle9() ? this.m_viewCache.getRows("ALL_TYPE_METHODS", new String[0], new String[]{"OWNER", "TYPE_NAME", "INSTANTIABLE"}, new String[]{string, string2, "YES"}, new String[]{"METHOD_NAME", "METHOD_NO"}) : this.m_viewCache.getRows("ALL_TYPE_METHODS", new String[0], new String[]{"OWNER", "TYPE_NAME"}, new String[]{string, string2}, new String[]{"METHOD_NAME"});
        return MethodInfo.getMethodInfo(iterator);
    }

    @Override
    protected ResultInfo getResultInfo(String string, String string2, String string3, String string4) throws SQLException {
        Iterator iterator = this.m_viewCache.getRows("ALL_METHOD_RESULTS", new String[0], new String[]{"OWNER", "TYPE_NAME", "METHOD_NO"}, new Object[]{string, string2, string4}, new String[0]);
        return ResultInfo.getResultInfo(iterator);
    }

    @Override
    protected ParamInfo[] getParamInfo(String string, String string2, String string3, String string4) throws SQLException {
        Iterator iterator = this.m_viewCache.getRows("ALL_METHOD_PARAMS", new String[0], new String[]{"OWNER", "TYPE_NAME", "METHOD_NO"}, new Object[]{string, string2, string4}, new String[]{"PARAM_NO"});
        return ParamInfo.getParamInfo(iterator);
    }
}

