/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.File;
import java.io.FileInputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.JarArchiver;
import org.eclipse.persistence.tools.dbws.ProviderPackager;

public class JavasePackager
extends ProviderPackager {
    public JavasePackager() {
        this(new JavaseArchiver(), "javase", DBWSPackager.ArchiveUse.archive);
    }

    protected JavasePackager(DBWSPackager.Archiver archiver, String string, DBWSPackager.ArchiveUse archiveUse) {
        super(archiver, string, archiveUse);
    }

    @Override
    public DBWSPackager.Archiver buildDefaultArchiver() {
        return new JavaseArchiver(this);
    }

    @Override
    public String getWSDLPathPrefix() {
        return null;
    }

    static class JavaseArchiver
    extends JarArchiver {
        JavaseArchiver() {
        }

        JavaseArchiver(DBWSPackager dBWSPackager) {
            super(dBWSPackager);
        }

        @Override
        protected void addFilesToJarOutputStream(JarOutputStream jarOutputStream) {
            super.addFilesToJarOutputStream(jarOutputStream);
            try {
                jarOutputStream.putNextEntry(this.getDBWSProviderClassJarEntry());
                this.f = new File(this.packager.getStageDir(), "DBWSProvider.class");
                this.fis = new FileInputStream(this.f);
                int n = 0;
                while (n != -1) {
                    jarOutputStream.write(this.buffer, 0, n);
                    n = this.fis.read(this.buffer);
                }
                this.fis.close();
                this.f.deleteOnExit();
                jarOutputStream.putNextEntry(this.getWSDLJarEntry());
                this.f = new File(this.packager.getStageDir(), "eclipselink-dbws.wsdl");
                this.fis = new FileInputStream(this.f);
                n = 0;
                while (n != -1) {
                    jarOutputStream.write(this.buffer, 0, n);
                    n = this.fis.read(this.buffer);
                }
                this.fis.close();
                this.f.deleteOnExit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        protected JarEntry getSchemaJarEntry() {
            return new JarEntry(this.getWSDLPathPrefix() + "eclipselink-dbws-schema.xsd");
        }

        @Override
        protected JarEntry getSWARefJarEntry() {
            return new JarEntry(this.getWSDLPathPrefix() + "swaref.xsd");
        }

        ZipEntry getWSDLJarEntry() {
            return new JarEntry(this.getWSDLPathPrefix() + "eclipselink-dbws.wsdl");
        }

        ZipEntry getDBWSProviderClassJarEntry() {
            return new JarEntry("_dbws/DBWSProvider.class");
        }
    }
}

