/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.eclipse.persistence.internal.oxm.schema.model.Any;
import org.eclipse.persistence.internal.oxm.schema.model.ComplexType;
import org.eclipse.persistence.internal.oxm.schema.model.Schema;
import org.eclipse.persistence.internal.oxm.schema.model.Sequence;
import org.eclipse.persistence.internal.xr.QNameTransformer;
import org.eclipse.persistence.oxm.XMLConstants;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredArgument;
import org.eclipse.persistence.tools.dbws.jdbc.DbStoredProcedure;

public class Util {
    public static final String CLASSES = "classes";
    public static final String DEFAULT_WSDL_LOCATION_URI = "REPLACE_WITH_ENDPOINT_ADDRESS";
    public static final String SWAREF_FILENAME = "swaref.xsd";
    public static final String WEB_XML_FILENAME = "web.xml";
    public static final String DEFAULT_PLATFORM_CLASSNAME = "org.eclipse.persistence.platform.database.OraclePlatform";
    public static final String UNDER_DBWS = "_dbws";
    public static final String WSI_SWAREF = "swaref";
    public static final String WSI_SWAREF_PREFIX = "ref";
    public static final String WSI_SWAREF_URI = "http://ws-i.org/profiles/basic/1.1/xsd";
    public static final String WSI_SWAREF_XSD_FILE = "swaref.xsd";
    public static final String PK_QUERYNAME = "findByPrimaryKey";
    public static final String THE_INSTANCE_NAME = "theInstance";
    public static final String FINDALL_QUERYNAME = "findAll";
    public static final String CREATE_OPERATION_NAME = "create";
    public static final String UPDATE_OPERATION_NAME = "update";
    public static final String REMOVE_OPERATION_NAME = "delete";
    public static final String DBWS_PROVIDER_PACKAGE = "_dbws";
    public static final String DBWS_PROVIDER_NAME = "DBWSProvider";
    public static final String DBWS_PROVIDER_CLASS_FILE = "DBWSProvider.class";
    public static final String DBWS_PROVIDER_SOURCE_FILE = "DBWSProvider.java";
    public static final QName SXF_QNAME_CURSOR = new QName("", "cursor of simple-xml-format");

    public static QName getXMLTypeFromJDBCType(Short s) {
        return Util.getXMLTypeFromJDBCType(s.intValue());
    }

    public static QName getXMLTypeFromJDBCType(int n) {
        switch (n) {
            case -1: 
            case 1: 
            case 12: {
                return XMLConstants.STRING_QNAME;
            }
            case -5: {
                return XMLConstants.INTEGER_QNAME;
            }
            case -6: 
            case 4: 
            case 5: {
                return XMLConstants.INT_QNAME;
            }
            case 3: {
                return XMLConstants.DECIMAL_QNAME;
            }
            case 2: 
            case 6: 
            case 7: 
            case 8: {
                return XMLConstants.DOUBLE_QNAME;
            }
            case 91: {
                return XMLConstants.DATE_QNAME;
            }
            case 92: {
                return XMLConstants.TIME_QNAME;
            }
            case 93: {
                return XMLConstants.DATE_TIME_QNAME;
            }
        }
        return XMLConstants.BASE_64_BINARY_QNAME;
    }

    public static QName qNameFromString(String string, Schema schema) {
        QName qName = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (string != null) {
            if (string.charAt(0) == '{') {
                int n = string.indexOf(125);
                if (n == -1) {
                    throw new IllegalArgumentException("cannot create QName from \"" + string + "\", missing closing \"}\"");
                }
                string2 = string.substring(1, n);
                string4 = string.substring(n + 1);
            } else {
                int n = string.indexOf(58);
                if (n > 0) {
                    string3 = string.substring(0, n);
                    string4 = string.substring(n + 1);
                    string2 = schema.getNamespaceResolver().resolveNamespacePrefix(string3);
                    if (string2 == null) {
                        string2 = "";
                    }
                } else {
                    string4 = string;
                }
            }
            if ("http://www.w3.org/2001/XMLSchema".equals(string2)) {
                qName = (QName)QNameTransformer.SCHEMA_QNAMES.get(string4);
                if (qName == null) {
                    qName = new QName("http://www.w3.org/2001/XMLSchema", string4, string3 == null ? "" : string3);
                }
            } else {
                qName = new QName(string2 == null ? "" : string2, string4, string3 == null ? "" : string3);
            }
        }
        return qName;
    }

    public static void addSimpleXMLFormat(Schema schema) {
        ComplexType complexType = new ComplexType();
        complexType.setName("simple-xml-format");
        Sequence sequence = new Sequence();
        Any any = new Any();
        any.setMinOccurs("0");
        sequence.addAny(any);
        complexType.setSequence(sequence);
        schema.addTopLevelComplexTypes(complexType);
    }

    public static boolean noOutArguments(DbStoredProcedure dbStoredProcedure) {
        boolean bl = true;
        if (dbStoredProcedure.getArguments() != null && dbStoredProcedure.getArguments().size() > 0) {
            for (DbStoredArgument dbStoredArgument : dbStoredProcedure.getArguments()) {
                if (dbStoredArgument.getInOut() != InOut.INOUT && dbStoredArgument.getInOut() != InOut.OUT) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public static String escapePunctuation(String string, boolean bl) {
        if (string == null || string.length() == 0) {
            if (bl) {
                return null;
            }
            return string;
        }
        return string.trim().replaceAll("[\\p{Punct}&&[^_%]]", "\\\\$0");
    }

    public static boolean sqlMatch(String string, String string2) {
        if (string != null && string.length() > 0) {
            String string3 = string.replace('_', '.').replace("%", ".*");
            Pattern pattern = Pattern.compile(string3, 66);
            return pattern.matcher(string2).matches();
        }
        return false;
    }

    public static enum InOut {
        IN,
        OUT,
        INOUT,
        RETURN;

    }
}

