/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.dbws;

import java.io.OutputStream;
import org.eclipse.persistence.internal.sessions.factories.model.SessionConfigs;
import org.eclipse.persistence.internal.sessions.factories.model.log.LogConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.DatabaseLoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.login.LoginConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.CustomServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.platform.ServerPlatformConfig;
import org.eclipse.persistence.internal.sessions.factories.model.project.ProjectConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.DatabaseSessionConfig;
import org.eclipse.persistence.internal.sessions.factories.model.session.ServerSessionConfig;
import org.eclipse.persistence.tools.dbws.DBWSBuilder;
import org.eclipse.persistence.tools.dbws.DBWSPackager;
import org.eclipse.persistence.tools.dbws.WarArchiver;
import org.eclipse.persistence.tools.dbws.WebServicePackager;

public class WeblogicPackager
extends WebServicePackager {
    public WeblogicPackager() {
        this(new WarArchiver(), "wls", DBWSPackager.ArchiveUse.archive);
    }

    protected WeblogicPackager(DBWSPackager.Archiver archiver, String string, DBWSPackager.ArchiveUse archiveUse) {
        super(archiver, string, archiveUse);
    }

    @Override
    public String getAdditionalUsage() {
        return " [warFilename]";
    }

    @Override
    public SessionConfigs buildSessionsXML(OutputStream outputStream, DBWSBuilder dBWSBuilder) {
        SessionConfigs sessionConfigs = super.buildSessionsXML(outputStream, dBWSBuilder);
        String string = dBWSBuilder.getDataSource();
        if (string != null) {
            DatabaseSessionConfig databaseSessionConfig = (DatabaseSessionConfig)sessionConfigs.getSessionConfigs().firstElement();
            ProjectConfig projectConfig = databaseSessionConfig.getPrimaryProject();
            LogConfig logConfig = databaseSessionConfig.getLogConfig();
            String string2 = databaseSessionConfig.getName();
            ServerSessionConfig serverSessionConfig = new ServerSessionConfig();
            serverSessionConfig.setPrimaryProject(projectConfig);
            serverSessionConfig.setName(string2);
            serverSessionConfig.setLogConfig(logConfig);
            CustomServerPlatformConfig customServerPlatformConfig = new CustomServerPlatformConfig();
            customServerPlatformConfig.setEnableJTA(true);
            customServerPlatformConfig.setEnableRuntimeServices(true);
            customServerPlatformConfig.setServerClassName("org.eclipse.persistence.platform.server.wls.WebLogic_10_Platform");
            customServerPlatformConfig.setExternalTransactionControllerClass("org.eclipse.persistence.transaction.wls.WebLogicTransactionController");
            serverSessionConfig.setServerPlatformConfig((ServerPlatformConfig)customServerPlatformConfig);
            DatabaseLoginConfig databaseLoginConfig = new DatabaseLoginConfig();
            databaseLoginConfig.setPlatformClass(dBWSBuilder.getPlatformClassname());
            databaseLoginConfig.setExternalConnectionPooling(true);
            databaseLoginConfig.setExternalTransactionController(true);
            databaseLoginConfig.setDatasource(string);
            databaseLoginConfig.setBindAllParameters(true);
            serverSessionConfig.setLoginConfig((LoginConfig)databaseLoginConfig);
            sessionConfigs.getSessionConfigs().set(0, serverSessionConfig);
        }
        return sessionConfigs;
    }
}

