/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.utils.rename;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.eclipse.persistence.utils.rename.PackageRenamer;

public class MigrateTopLinkToEclipseLink {
    private static final String PROPERTIES_FILE = "package-rename.properties";

    public static void main(String[] stringArray) {
        if (stringArray.length < 2 || stringArray.length > 3) {
            System.out.println("Usage: MigrateTopLinkToEclipseLink sourceDir targetDir (propertiesFile)");
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        String string3 = PROPERTIES_FILE;
        if (stringArray.length == 3) {
            string3 = stringArray[2];
        }
        new MigrateTopLinkToEclipseLink().migrate(string, string2, string3);
    }

    public void migrate(String string, String string2, String string3) {
        Properties properties = this.readProperties(string3);
        this.clearTargetFolder(string2);
        PackageRenamer packageRenamer = new PackageRenamer(string, string2, properties);
        packageRenamer.run();
    }

    private void clearTargetFolder(String string) {
        File file = new File(string);
        if (file.exists()) {
            this.removeAllJavaFiles(file);
        }
    }

    private void removeAllJavaFiles(File file) {
        File[] fileArray = file.listFiles();
        for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
            File file2 = fileArray[i];
            if (file2.isDirectory()) {
                this.removeAllJavaFiles(file2);
                continue;
            }
            if (!file2.getName().endsWith(".java")) continue;
            file2.delete();
        }
    }

    private Properties readProperties(String string) {
        Properties properties = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            properties.load(fileInputStream);
            ((InputStream)fileInputStream).close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new RuntimeException("Properties file was not found: " + string);
        }
        catch (IOException iOException) {
            throw new RuntimeException("IO error occurred while reading the properties file:'" + string + "'" + iOException.getMessage());
        }
        return properties;
    }
}

