/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.List;
import org.eclipse.persistence.internal.helper.ConversionManager;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWDescriptorHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWClassIndicatorValue
extends MWModel {
    private volatile Object indicatorValue;
    public static final String INDICATOR_VALUE_PROPERTY = "indicatorValue";
    private MWDescriptorHandle descriptorValueHandle;
    public static final String DESCRIPTOR_PROPERTY = "descriptorValue";
    private volatile boolean include;
    public static final String INCLUDE_PROPERTY = "include";

    private MWClassIndicatorValue() {
    }

    MWClassIndicatorValue(MWClassIndicatorFieldPolicy mWClassIndicatorFieldPolicy, MWMappingDescriptor mWMappingDescriptor, Object object) {
        super(mWClassIndicatorFieldPolicy);
        this.descriptorValueHandle.setDescriptor(mWMappingDescriptor);
        this.indicatorValue = object;
        if (mWMappingDescriptor != null && mWMappingDescriptor.getMWClass().isInstantiable() && (mWMappingDescriptor.getMWClass().zeroArgumentConstructor() != null || mWMappingDescriptor.hasActiveInstantiationPolicy())) {
            this.include = true;
        }
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.descriptorValueHandle = new MWDescriptorHandle(this, this.buildDescriptorValueScrubber());
    }

    private MWClassIndicatorFieldPolicy getPolicy() {
        return (MWClassIndicatorFieldPolicy)this.getParent();
    }

    public boolean isInclude() {
        return this.include;
    }

    public void setInclude(boolean bl) {
        boolean bl2 = this.include;
        this.include = bl;
        if (!bl) {
            this.setIndicatorValue(null);
        }
        this.firePropertyChanged(INCLUDE_PROPERTY, bl2, this.include);
    }

    public MWDescriptor getDescriptorValue() {
        return this.descriptorValueHandle.getDescriptor();
    }

    public void setDescriptorValue(MWDescriptor mWDescriptor) {
        MWDescriptor mWDescriptor2 = this.getDescriptorValue();
        this.descriptorValueHandle.setDescriptor(mWDescriptor);
        this.firePropertyChanged(DESCRIPTOR_PROPERTY, mWDescriptor2, this.getDescriptorValue());
    }

    public Object getIndicatorValue() {
        return this.indicatorValue;
    }

    public String getIndicatorValueAsString() {
        return (String)ConversionManager.getDefaultManager().convertObject(this.indicatorValue, String.class);
    }

    public void setIndicatorValue(Object object) {
        Object object2 = this.indicatorValue;
        this.indicatorValue = object;
        this.firePropertyChanged(INDICATOR_VALUE_PROPERTY, object2, object);
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.descriptorValueHandle);
    }

    private MWHandle.NodeReferenceScrubber buildDescriptorValueScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWClassIndicatorValue.this.descriptorRemoved();
            }

            public String toString() {
                return "MWClassIndicatorValue.buildDescriptorValueScrubber()";
            }
        };
    }

    void descriptorRemoved() {
        this.getPolicy().removeIndicator(this);
    }

    public void descriptorReplaced(MWDescriptor mWDescriptor, MWDescriptor mWDescriptor2) {
        super.descriptorReplaced(mWDescriptor, mWDescriptor2);
        if (this.getDescriptorValue() == mWDescriptor) {
            this.setDescriptorValue(mWDescriptor2);
        }
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(this.getIndicatorValue());
        stringBuffer.append(" -> ");
        if (this.getDescriptorValue() != null) {
            stringBuffer.append(this.getDescriptorValue().getMWClass().shortName());
        } else {
            stringBuffer.append("null");
        }
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        this.checkClassIndicatorValue(list);
    }

    private void checkClassIndicatorValue(List list) {
        if (this.isInclude() && (this.getIndicatorValue() == null || this.getIndicatorValueAsString().length() == 0)) {
            list.add(this.buildProblem("0055", this.getDescriptorValue().displayStringWithPackage()));
        }
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWClassIndicatorValue.class);
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName(INDICATOR_VALUE_PROPERTY);
        xMLDirectMapping.setGetMethodName("getIndicatorValueForTopLink");
        xMLDirectMapping.setSetMethodName("setIndicatorValueForTopLink");
        xMLDirectMapping.setXPath("indicator/text()");
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("descriptorValueHandle");
        xMLCompositeObjectMapping.setGetMethodName("getDescriptorValueHandleForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setDescriptorValueHandleForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWDescriptorHandle.class);
        xMLCompositeObjectMapping.setXPath("descriptor-value-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        return xMLDescriptor;
    }

    private MWDescriptorHandle getDescriptorValueHandleForTopLink() {
        return this.descriptorValueHandle.getDescriptor() == null ? null : this.descriptorValueHandle;
    }

    private void setDescriptorValueHandleForTopLink(MWDescriptorHandle mWDescriptorHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildDescriptorValueScrubber();
        this.descriptorValueHandle = mWDescriptorHandle == null ? new MWDescriptorHandle(this, nodeReferenceScrubber) : mWDescriptorHandle.setScrubber(nodeReferenceScrubber);
    }

    private Object getIndicatorValueForTopLink() {
        return this.getIndicatorValueAsString();
    }

    private void setIndicatorValueForTopLink(Object object) {
        this.indicatorValue = object;
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        this.include = true;
    }
}

