/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.invalidation.CacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.DailyCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.NoExpiryCacheInvalidationPolicy;
import org.eclipse.persistence.descriptors.invalidation.TimeToLiveCacheInvalidationPolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.MWModel;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCacheExpiry;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWCachingPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWTransactionalPolicy;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public final class MWDescriptorCacheExpiry
extends MWModel
implements MWCacheExpiry {
    private volatile String expiryType;
    private volatile boolean updateReadTimeOnUpdate;
    private volatile Long timeToLiveExpiry;
    private volatile Date dailyExpiryTime;

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWDescriptorCacheExpiry.class);
        ObjectTypeConverter objectTypeConverter = new ObjectTypeConverter();
        objectTypeConverter.addConversionValue((Object)"No Expiry", (Object)"No Expiry");
        objectTypeConverter.addConversionValue((Object)"Time to Live Expiry", (Object)"Time to Live Expiry");
        objectTypeConverter.addConversionValue((Object)"Daily Expiry", (Object)"Daily Expiry");
        XMLDirectMapping xMLDirectMapping = new XMLDirectMapping();
        xMLDirectMapping.setAttributeName("expiryType");
        xMLDirectMapping.setNullValue((Object)"No Expiry");
        xMLDirectMapping.setXPath("expiry-type/text()");
        xMLDirectMapping.setConverter((Converter)objectTypeConverter);
        xMLDescriptor.addMapping((DatabaseMapping)xMLDirectMapping);
        XMLDirectMapping xMLDirectMapping2 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("timeToLiveExpiry", "time-to-live-expiry/text()");
        xMLDirectMapping2.setNullValue((Object)DEFAULT_TIME_TO_LIVE_EXPIRY);
        XMLDirectMapping xMLDirectMapping3 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("dailyExpiryTime", "daily-expiry-time/text()");
        xMLDirectMapping3.setNullValue((Object)DEFAULT_DAILY_EXPIRY_TIME);
        XMLDirectMapping xMLDirectMapping4 = (XMLDirectMapping)xMLDescriptor.addDirectMapping("updateReadTimeOnUpdate", "update-read-time-on-update/text()");
        xMLDirectMapping4.setNullValue((Object)false);
        return xMLDescriptor;
    }

    private MWDescriptorCacheExpiry() {
    }

    public MWDescriptorCacheExpiry(MWCachingPolicy mWCachingPolicy) {
        super(mWCachingPolicy);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.dailyExpiryTime = DEFAULT_DAILY_EXPIRY_TIME;
        this.expiryType = "No Expiry";
        this.timeToLiveExpiry = DEFAULT_TIME_TO_LIVE_EXPIRY;
        this.updateReadTimeOnUpdate = false;
    }

    public Date getDailyExpiryTime() {
        return this.dailyExpiryTime;
    }

    public void setDailyExpiryTime(Date date) {
        Date date2 = this.dailyExpiryTime;
        if (this.newExpiryTimeDifferent(date)) {
            this.dailyExpiryTime = date;
            this.firePropertyChanged("dailyExpiryTime", date2, this.dailyExpiryTime);
        }
    }

    private boolean newExpiryTimeDifferent(Date date) {
        Date date2 = this.getDailyExpiryTime();
        return date.getHours() != date2.getHours() || date.getMinutes() != date2.getMinutes() || date.getSeconds() != date2.getSeconds();
    }

    public void setDailyExpiryTime(Calendar calendar) {
        this.setDailyExpiryTime(calendar.getTime());
    }

    public String getExpiryType() {
        return this.expiryType;
    }

    public void setExpiryType(String string) {
        String string2 = this.expiryType;
        this.expiryType = string;
        this.firePropertyChanged("expiryType", string2, this.expiryType);
        if (this.valuesAreDifferent(string2, this.expiryType) && this.expiryType == "No Expiry") {
            this.setUpdateReadTimeOnUpdate(false);
        }
    }

    public boolean getUpdateReadTimeOnUpdate() {
        return this.updateReadTimeOnUpdate;
    }

    public void setUpdateReadTimeOnUpdate(boolean bl) {
        boolean bl2 = this.updateReadTimeOnUpdate;
        this.updateReadTimeOnUpdate = bl;
        this.firePropertyChanged("updateReadTimeOnUpdate", bl2, this.updateReadTimeOnUpdate);
    }

    public Long getTimeToLiveExpiry() {
        return this.timeToLiveExpiry;
    }

    public void setTimeToLiveExpiry(Long l) {
        Long l2 = this.timeToLiveExpiry;
        this.timeToLiveExpiry = l;
        this.firePropertyChanged("timeToLiveExpiry", l2, this.timeToLiveExpiry);
    }

    public MWMappingDescriptor getOwningDescriptor() {
        return (MWMappingDescriptor)((MWTransactionalPolicy)this.getParent()).getParent();
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        if (this.getExpiryType() == "No Expiry") {
            classDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new NoExpiryCacheInvalidationPolicy());
        } else if (this.getExpiryType() == "Daily Expiry") {
            Date date = this.getDailyExpiryTime();
            classDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new DailyCacheInvalidationPolicy(date.getHours(), date.getMinutes(), date.getSeconds(), 0));
        } else if (this.getExpiryType() == "Time to Live Expiry") {
            classDescriptor.setCacheInvalidationPolicy((CacheInvalidationPolicy)new TimeToLiveCacheInvalidationPolicy(this.getTimeToLiveExpiry().longValue()));
        }
    }

    public MWCacheExpiry getPersistedPolicy() {
        return this;
    }
}

