/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.descriptors.InheritancePolicy;
import org.eclipse.persistence.mappings.DatabaseMapping;
import org.eclipse.persistence.oxm.XMLDescriptor;
import org.eclipse.persistence.oxm.mappings.XMLCompositeObjectMapping;
import org.eclipse.persistence.oxm.mappings.XMLDirectMapping;
import org.eclipse.persistence.tools.workbench.mappingsmodel.db.MWTable;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWAbstractDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorExtractionMethodPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorFieldPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWClassIndicatorValue;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWDescriptorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWMappingDescriptor;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.MWNullClassIndicatorPolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.relational.MWRelationalDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWEisDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.descriptor.xml.MWOXDescriptorInheritancePolicy;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWDescriptorHandle;
import org.eclipse.persistence.tools.workbench.mappingsmodel.handles.MWHandle;
import org.eclipse.persistence.tools.workbench.utility.CollectionTools;
import org.eclipse.persistence.tools.workbench.utility.iterators.ChainIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.FilteringIterator;
import org.eclipse.persistence.tools.workbench.utility.iterators.TreeIterator;
import org.eclipse.persistence.tools.workbench.utility.node.Node;

public abstract class MWDescriptorInheritancePolicy
extends MWAbstractDescriptorPolicy
implements MWInheritancePolicy {
    private volatile boolean isRoot;
    public static final String IS_ROOT_PROPERTY = "isRoot";
    private MWDescriptorHandle parentDescriptorHandle;
    public static final String PARENT_DESCRIPTOR_PROPERTY = "parentDescriptor";
    private volatile MWClassIndicatorPolicy classIndicatorPolicy;
    public static final String CLASS_INDICATOR_POLICY_PROPERTY = "classIndicatorPolicy";

    protected MWDescriptorInheritancePolicy() {
    }

    protected MWDescriptorInheritancePolicy(MWMappingDescriptor mWMappingDescriptor) {
        super(mWMappingDescriptor);
    }

    protected void initialize(Node node) {
        super.initialize(node);
        this.parentDescriptorHandle = new MWDescriptorHandle(this, this.buildParentDescriptorScrubber());
        this.isRoot = false;
        this.classIndicatorPolicy = new MWNullClassIndicatorPolicy(this);
    }

    void initializeParentDescriptor() {
        MWDescriptor mWDescriptor = this.getProject().descriptorForType(this.getOwningDescriptor().getMWClass().getSuperclass());
        if (mWDescriptor != null && mWDescriptor.isActive()) {
            this.setParentDescriptor(mWDescriptor);
        }
    }

    protected void addChildrenTo(List list) {
        super.addChildrenTo(list);
        list.add(this.classIndicatorPolicy);
        list.add(this.parentDescriptorHandle);
    }

    private MWHandle.NodeReferenceScrubber buildParentDescriptorScrubber() {
        return new MWHandle.NodeReferenceScrubber(){

            public void nodeReferenceRemoved(Node node, MWHandle mWHandle) {
                MWDescriptorInheritancePolicy.this.setParentDescriptor(null);
            }

            public String toString() {
                return "MWDescriptorInheritancePolicy.buildParentDescriptorScrubber()";
            }
        };
    }

    public void descriptorInheritanceChanged() {
        Iterator iterator = this.childDescriptors();
        while (iterator.hasNext()) {
            ((MWDescriptor)iterator.next()).inheritanceChanged();
        }
    }

    public void parentDescriptorMorphedToAggregate() {
        this.getClassIndicatorPolicy().parentDescriptorMorphedToAggregate();
    }

    public MWDescriptor getParentDescriptor() {
        return this.parentDescriptorHandle.getDescriptor();
    }

    public void setParentDescriptor(MWDescriptor mWDescriptor) {
        if (mWDescriptor != null && this.isRoot()) {
            throw new IllegalStateException("Unable to set a parent descriptor on a root descriptor");
        }
        MWDescriptor mWDescriptor2 = this.getParentDescriptor();
        if (mWDescriptor2 != mWDescriptor) {
            MWInheritancePolicy mWInheritancePolicy = null;
            mWInheritancePolicy = this.getRootDescriptor().getInheritancePolicy();
            this.parentDescriptorHandle.setDescriptor(mWDescriptor);
            mWInheritancePolicy.buildClassIndicatorValues();
            this.firePropertyChanged(PARENT_DESCRIPTOR_PROPERTY, mWDescriptor2, mWDescriptor);
            this.getRootDescriptor().getInheritancePolicy().buildClassIndicatorValues();
            this.getOwningDescriptor().inheritanceChanged();
        }
    }

    public Iterator candidateParentDescriptors() {
        final Set set = CollectionTools.set(this.descendentDescriptors());
        final MWMappingDescriptor mWMappingDescriptor = this.getOwningDescriptor();
        return new FilteringIterator(this.getProject().descriptors()){

            protected boolean accept(Object object) {
                MWDescriptor mWDescriptor = (MWDescriptor)object;
                return mWDescriptor.canHaveInheritance() && mWDescriptor != mWMappingDescriptor && !set.contains(object);
            }
        };
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public void setIsRoot(boolean bl) {
        MWInheritancePolicy mWInheritancePolicy = this.getRootDescriptor().getInheritancePolicy();
        boolean bl2 = this.isRoot;
        this.isRoot = bl;
        if (bl2 != bl) {
            if (this.isRoot) {
                this.setParentDescriptor(null);
                this.useClassIndicatorFieldPolicy();
                this.buildClassIndicatorValues();
            } else {
                this.setClassIndicatorPolicy(new MWNullClassIndicatorPolicy(this));
                this.initializeParentDescriptor();
                mWInheritancePolicy.buildClassIndicatorValues();
                mWInheritancePolicy = this.getRootDescriptor().getInheritancePolicy();
            }
            mWInheritancePolicy.buildClassIndicatorValues();
            this.firePropertyChanged(IS_ROOT_PROPERTY, bl2, bl);
        }
    }

    public MWClassIndicatorPolicy getClassIndicatorPolicy() {
        return this.classIndicatorPolicy;
    }

    public void useClassExtractionMethodIndicatorPolicy() {
        if (this.getClassIndicatorPolicy().getType() == "classExtractionMethodClassIndicatorPolicy") {
            return;
        }
        this.setClassIndicatorPolicy(new MWClassIndicatorExtractionMethodPolicy(this));
    }

    public void useClassIndicatorFieldPolicy() {
        if (this.getClassIndicatorPolicy().getType() == "fieldClassIndicatorPolicy") {
            return;
        }
        this.setClassIndicatorPolicy(this.buildClassIndicatorFieldPolicy());
    }

    protected abstract MWClassIndicatorFieldPolicy buildClassIndicatorFieldPolicy();

    protected void setClassIndicatorPolicy(MWClassIndicatorPolicy mWClassIndicatorPolicy) {
        MWClassIndicatorPolicy mWClassIndicatorPolicy2 = this.getClassIndicatorPolicy();
        this.classIndicatorPolicy = mWClassIndicatorPolicy;
        this.firePropertyChanged(CLASS_INDICATOR_POLICY_PROPERTY, mWClassIndicatorPolicy2, mWClassIndicatorPolicy);
    }

    public HashSet getAllDescriptorsAvailableForIndicatorDictionary() {
        HashSet<MWMappingDescriptor> hashSet = new HashSet<MWMappingDescriptor>();
        hashSet.add(this.getOwningDescriptor());
        CollectionTools.addAll(hashSet, this.descendentDescriptors());
        return hashSet;
    }

    public Iterator descendentDescriptors() {
        return new TreeIterator(this.childDescriptors()){

            protected Iterator children(Object object) {
                return ((MWDescriptor)object).getInheritancePolicy().childDescriptors();
            }
        };
    }

    public boolean hasDescendentDescriptors() {
        return this.descendentDescriptors().hasNext();
    }

    public Iterator childDescriptors() {
        return new FilteringIterator(this.getProject().mappingDescriptors()){

            protected boolean accept(Object object) {
                return ((MWDescriptor)object).getInheritancePolicy().getParentDescriptor() == MWDescriptorInheritancePolicy.this.getOwningDescriptor();
            }
        };
    }

    public boolean hasChildDescriptors() {
        return this.childDescriptors().hasNext();
    }

    public Iterator descriptorLineage() {
        return new ChainIterator(this.getOwningDescriptor()){

            protected Object nextLink(Object object) {
                return ((MWDescriptor)object).getInheritancePolicy().getParentDescriptor();
            }
        };
    }

    public MWDescriptor getRootDescriptor() {
        MWDescriptor mWDescriptor = null;
        Iterator iterator = this.descriptorLineage();
        while (iterator.hasNext()) {
            mWDescriptor = (MWDescriptor)iterator.next();
        }
        return mWDescriptor;
    }

    public void descriptorReplaced(MWDescriptor mWDescriptor, MWDescriptor mWDescriptor2) {
        super.descriptorReplaced(mWDescriptor, mWDescriptor2);
        if (this.getParentDescriptor() == mWDescriptor) {
            this.setParentDescriptor(mWDescriptor2);
        }
    }

    public MWTable getReadAllSubclassesView() {
        return null;
    }

    public void buildClassIndicatorValues() {
        this.getClassIndicatorPolicy().rebuildClassIndicatorValues(this.getAllDescriptorsAvailableForIndicatorDictionary());
    }

    public MWMappingDescriptor getContainingDescriptor() {
        return this.getOwningDescriptor();
    }

    protected void addProblemsTo(List list) {
        super.addProblemsTo(list);
        if (this.isRoot()) {
            this.checkClassIndicatorValues(list);
            this.descriptorTypeInheritanceMismatchTest(list);
        } else {
            this.checkParentDescriptor(list);
        }
        this.checkRootClassIndicatorFieldPolicy(list);
    }

    private void checkClassIndicatorValues(List list) {
        MWClassIndicatorPolicy mWClassIndicatorPolicy = this.getClassIndicatorPolicy();
        if (mWClassIndicatorPolicy.getType() != "fieldClassIndicatorPolicy") {
            return;
        }
        MWClassIndicatorFieldPolicy mWClassIndicatorFieldPolicy = (MWClassIndicatorFieldPolicy)this.getClassIndicatorPolicy();
        if (mWClassIndicatorFieldPolicy.classNameIsIndicator()) {
            return;
        }
        Iterator iterator = mWClassIndicatorFieldPolicy.includedClassIndicatorValues();
        while (iterator.hasNext()) {
            MWClassIndicatorValue mWClassIndicatorValue = (MWClassIndicatorValue)iterator.next();
            if (mWClassIndicatorValue.getDescriptorValue().getMWClass().isAbstract() && mWClassIndicatorValue.getIndicatorValue() != null) {
                list.add(this.buildProblem("0013", mWClassIndicatorValue.getDescriptorValue().getMWClass().shortName()));
            }
            if (mWClassIndicatorValue.getDescriptorValue().isActive()) continue;
            list.add(this.buildProblem("0355", mWClassIndicatorValue.getDescriptorValue().getMWClass().shortName()));
        }
        if (mWClassIndicatorFieldPolicy.classIndicatorValuesSize() == 0 && this.hasDescendentDescriptors()) {
            list.add(this.buildProblem("0123"));
        }
    }

    private void checkParentDescriptor(List list) {
        if (this.getParentDescriptor() == null) {
            list.add(this.buildProblem("0357"));
        } else {
            if (!this.getParentDescriptor().isActive()) {
                list.add(this.buildProblem("0356"));
            }
            if (!this.getParentDescriptor().getInheritancePolicy().isActive()) {
                list.add(this.buildProblem("0118"));
            }
        }
    }

    private void checkRootClassIndicatorFieldPolicy(List list) {
        if (this.getOwningDescriptor().getMWClass().isAbstract()) {
            return;
        }
        if (this.getParentDescriptor() == null) {
            return;
        }
        MWInheritancePolicy mWInheritancePolicy = this.getRootDescriptor().getInheritancePolicy();
        if (!mWInheritancePolicy.isActive()) {
            return;
        }
        MWDescriptorInheritancePolicy mWDescriptorInheritancePolicy = (MWDescriptorInheritancePolicy)mWInheritancePolicy;
        if (mWDescriptorInheritancePolicy.getClassIndicatorPolicy().getType() != "fieldClassIndicatorPolicy") {
            return;
        }
        MWClassIndicatorFieldPolicy mWClassIndicatorFieldPolicy = (MWClassIndicatorFieldPolicy)mWDescriptorInheritancePolicy.getClassIndicatorPolicy();
        if (mWClassIndicatorFieldPolicy.classNameIsIndicator()) {
            return;
        }
        MWClassIndicatorValue mWClassIndicatorValue = mWClassIndicatorFieldPolicy.getClassIndicatorValueForDescriptor(this.getOwningDescriptor());
        if (mWClassIndicatorValue == null || mWClassIndicatorValue.getIndicatorValue() == null || mWClassIndicatorValue.getIndicatorValue().toString().length() == 0) {
            list.add(this.buildProblem("0089"));
        }
    }

    private void descriptorTypeInheritanceMismatchTest(List list) {
        if (this.checkDescendantsForDescriptorTypeMismatch()) {
            list.add(this.buildProblem(this.descendantDescriptorTypeMismatchProblemString()));
        }
    }

    protected abstract boolean checkDescendantsForDescriptorTypeMismatch();

    protected abstract String descendantDescriptorTypeMismatchProblemString();

    public void automap() {
    }

    public void adjustRuntimeDescriptor(ClassDescriptor classDescriptor) {
        InheritancePolicy inheritancePolicy = classDescriptor.getInheritancePolicy();
        if (this.getParentDescriptor() != null) {
            inheritancePolicy.setParentClassName(this.getParentDescriptor().getMWClass().fullName());
        }
        this.classIndicatorPolicy.adjustRuntimeInheritancePolicy(inheritancePolicy);
    }

    public void toString(StringBuffer stringBuffer) {
        if (this.getParentDescriptor() != null) {
            stringBuffer.append("Parent = " + this.getParentDescriptor().getMWClass().shortName() + " ");
        } else if (this.getClassIndicatorPolicy() != null) {
            stringBuffer.append("Root");
        }
    }

    public boolean isActive() {
        return true;
    }

    public MWDescriptorPolicy getPersistedPolicy() {
        return this;
    }

    public static XMLDescriptor buildDescriptor() {
        XMLDescriptor xMLDescriptor = new XMLDescriptor();
        xMLDescriptor.setJavaClass(MWDescriptorInheritancePolicy.class);
        InheritancePolicy inheritancePolicy = xMLDescriptor.getInheritancePolicy();
        inheritancePolicy.setClassIndicatorFieldName("@type");
        inheritancePolicy.addClassIndicator(MWRelationalDescriptorInheritancePolicy.class, (Object)"relational");
        inheritancePolicy.addClassIndicator(MWOXDescriptorInheritancePolicy.class, (Object)"o-x");
        inheritancePolicy.addClassIndicator(MWEisDescriptorInheritancePolicy.class, (Object)"eis");
        XMLDirectMapping xMLDirectMapping = (XMLDirectMapping)xMLDescriptor.addDirectMapping(IS_ROOT_PROPERTY, "is-root/text()");
        xMLDirectMapping.setNullValue((Object)Boolean.TRUE);
        XMLCompositeObjectMapping xMLCompositeObjectMapping = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping.setAttributeName("parentDescriptorHandle");
        xMLCompositeObjectMapping.setGetMethodName("getParentDescriptorForTopLink");
        xMLCompositeObjectMapping.setSetMethodName("setParentDescriptorForTopLink");
        xMLCompositeObjectMapping.setReferenceClass(MWDescriptorHandle.class);
        xMLCompositeObjectMapping.setXPath("parent-descriptor-handle");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping);
        XMLCompositeObjectMapping xMLCompositeObjectMapping2 = new XMLCompositeObjectMapping();
        xMLCompositeObjectMapping2.setAttributeName(CLASS_INDICATOR_POLICY_PROPERTY);
        xMLCompositeObjectMapping2.setGetMethodName("getClassIndicatorPolicyForTopLink");
        xMLCompositeObjectMapping2.setSetMethodName("setClassIndicatorPolicyForTopLink");
        xMLCompositeObjectMapping2.setReferenceClass(MWAbstractClassIndicatorPolicy.class);
        xMLCompositeObjectMapping2.setXPath("class-indicator-policy");
        xMLDescriptor.addMapping((DatabaseMapping)xMLCompositeObjectMapping2);
        return xMLDescriptor;
    }

    private MWDescriptorHandle getParentDescriptorForTopLink() {
        return this.parentDescriptorHandle.getDescriptor() == null ? null : this.parentDescriptorHandle;
    }

    private void setParentDescriptorForTopLink(MWDescriptorHandle mWDescriptorHandle) {
        MWHandle.NodeReferenceScrubber nodeReferenceScrubber = this.buildParentDescriptorScrubber();
        this.parentDescriptorHandle = mWDescriptorHandle == null ? new MWDescriptorHandle(this, nodeReferenceScrubber) : mWDescriptorHandle.setScrubber(nodeReferenceScrubber);
    }

    private MWAbstractClassIndicatorPolicy getClassIndicatorPolicyForTopLink() {
        return this.classIndicatorPolicy.getValueForTopLink() == null ? null : this.classIndicatorPolicy.getValueForTopLink();
    }

    private void setClassIndicatorPolicyForTopLink(MWAbstractClassIndicatorPolicy mWAbstractClassIndicatorPolicy) {
        this.classIndicatorPolicy = mWAbstractClassIndicatorPolicy == null ? new MWNullClassIndicatorPolicy(this) : mWAbstractClassIndicatorPolicy;
    }

    public void postProjectBuild() {
        super.postProjectBuild();
        if (this.isRoot()) {
            this.getClassIndicatorPolicy().setDescriptorsAvailableForIndicatorDictionaryForTopLink(this.getAllDescriptorsAvailableForIndicatorDictionary().iterator());
        }
    }
}

